<?php
include_once("include/main.inc.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
$userId = $_SESSION['USER_ID'] ?? null;
$cart   = new Cart($dbconn, $userId);

try {
    switch ($_POST['action']) {

        case 'add':
            $result = $cart->add($_POST);
            break;

        case 'update':
            $key = $_POST['key'];   // example: 10|2|5
            $qty = (int)$_POST['qty'];

            $result = $cart->update($key, $qty);
             echo json_encode($result);
             exit;
            break;

        case 'remove':
            $result = $cart->remove($_POST['product_id'],$_POST['color'],$_POST['size']);
            break;

        case 'apply_coupon':
            $result = $cart->applyCoupon($_POST['code']);
            break;

        case 'remove_coupon':
            $result = $cart->removeCoupon();
            break;

        default:
            $result = $cart->summary();
    }

    echo json_encode(['status' => 'success', 'data' => $result]);

} catch (Exception $e) {
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}