<?php
include_once("include/main.inc.php");
$page_metatitle = "Shopping Checkout - " . $admin_res['companyName'];
$page_metakey = "Shopping Checkout - " . $admin_res['companyName'];
$page_metadesc = "Shopping Checkout - " . $admin_res['companyName'];
// echo "<pre>";
// print_r($cartData);
// echo "</pre>";

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php include "app_top.php"; ?>
</head>

<body>
    <?php include "app_header.php"; ?>
    <section class="heading_banner" style="background-image: url(<?= site_url; ?>/designer/images/sitemap-banner.jpg)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">My Shopping Bag</h1>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </section>
    <!-- Breadcrumb -->
    <div class="inner_breadcrumb hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <ul class="breadcrumb">
                        <li><a href="<?= site_url; ?>" title="Home">Home</a></li>
                        <li class="active">My Shopping Bag</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Home About -->

    <?php if(count($cartData['items'])>0){ ?>
    <div class="w-100 float-start pb-0"
        style="background-image:url(<?=site_url;?>/designer/images/cart.jpg);background-repeat:repeat">
        <div class="columns-container py-5 w-100 float-start">
            <div class="container" id="columns">
                <div class="row">
                    <div class="col-lg-9 col-md-9 col-sm-9">
                        <div class="page-content page-order">
                            <div class="heading-counter bg-light border px-3 py-2 fs-6 fw-bold text-start mb-2">Your
                                shopping
                                cart contains:
                                <span><?=count($cartData['items']);?> Product</span>
                            </div>
                            <div class="order-detail-content bg-white">
                                <form action="" name="cart_frm" id="cart_frm" method="post" accept-charset="utf-8">
                                    <div class="responsive-table">
                                        <table class="responsive-stacked-table cart-table" border="1" width="100%">
                                            <thead>
                                                <tr>
                                                    <th colspan="1">Product</th>
                                                    <th colspan="4">Details</th>
                                                    <th>Price</th>
                                                    <th>Qty</th>
                                                    <th>Total</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach($cartData['items'] as $item){ 
                                                    $sizeRes= mysqli_fetch_assoc(mysqli_query($dbconn,"SELECT size_name from size_tbl Where size_id='".$item['size']."'"));
                                                     $colorRes= mysqli_fetch_assoc(mysqli_query($dbconn,"SELECT color_name from color_tbl Where color_id='".$item['color']."'"));
                                                    ?>
                                                <tr data-price="<?= $item['price'] ?>"
                                                    data-key="<?= $item['product_id'] ?>|<?=$item['color'];?>|<?=$item['size'];?>">
                                                    <td>
                                                        <img src="<?=getImage($item['image'], 68, 68, $item['name'] . $item['product_id'], '/uploaded-files/product-images/');?>"
                                                            width="80">
                                                    </td>
                                                    <td colspan="4">
                                                        <p><strong><?= $item['name'] ?></strong></p>
                                                        <?php
                                                        if($item['embroidery']=='1'){
                                                        echo "<small>+ Name Embroidery (₹150)</small><br>";
                                                        }
                                                        if($item['symbol1']=='1'){
                                                        echo "<small>+ Stethoscope Symbol (₹100)</small><br>";
                                                        }
                                                         if($item['symbol2']=='1'){
                                                        echo "<small>+ Medical Symbol (₹100)</small><br>";
                                                        }
                                                        ?>
                                                        <small>SKU : <?= $item['product_code'] ?></small><br>
                                                        <small>Size : <?= $sizeRes['size_name'] ?></small><br>
                                                        <small>Color : <?= $colorRes['color_name'] ?></small>
                                                    </td>
                                                    <td class="unit-price">₹<?= $item['price'] ?></td>
                                                    <td align="center">
                                                        <div class="quantity1   rounded d-flex align-items-center">
                                                            <div class="button-plus-minus">
                                                                <div
                                                                    class="input-group quantity_input justify-content-end">
                                                                    <div
                                                                        class="input-group1 d-flex w-auto justify-content-end align-items-center">
                                                                        <input type="button" value="-"
                                                                            class="button-minus border rounded-circle quantity-left-minus icon-shape icon-sm mx-1 "
                                                                            data-field="quantity">
                                                                        <input type="text" step="1" max="10"
                                                                            name="quantity" value="<?= $item['qty'] ?>"
                                                                            class="quantity quantity-field border-0 text-center w-25"
                                                                            data-key="<?= $item['product_id'] ?>|<?=$item['color'];?>|<?=$item['size'];?>"
                                                                            readonly>
                                                                        <input type="button" value="+"
                                                                            class="button-plus border rounded-circle quantity-right-plus icon-shape icon-sm lh-0"
                                                                            data-field="quantity">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- <div class="input-group w-auto">
                                                    <button class="button-minus">−</button>
                                                    <input type="text" class="quantity" value="1" readonly>
                                                    <button class="button-plus">+</button>
                                                </div> -->
                                                    </td>
                                                    <td class="row-total">₹<?= ($item['price']*$item['qty']) ?></td>
                                                    <td>
                                                        <a href="javascript:void();" class="delete-item text-danger"
                                                            onclick="removeCart('<?=$item['product_id'];?>','<?=$item['color'];?>','<?=$item['size'];?>')">Delete</a>
                                                    </td>
                                                </tr>
                                                <?php } ?>

                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th colspan="6" align="right">Grand Total :</th>
                                                    <th id="grandTotal">₹<?=$totalprice;?></th>
                                                    <th></th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </form>
                                <div class="cart_navigation mt-3">
                                    <a href="<?=site_url;?>"
                                        class="theme-btn btn-style-one text-capitalize moreBtn float-start w-auto text-white bg-dark"><span
                                            class="btn-title"><svg width="30px" height="30px" viewBox="0 0 24 24"
                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M6.3508 12.7499L11.2096 17.4615L10.1654 18.5383L3.42264 11.9999L10.1654 5.46148L11.2096 6.53833L6.3508 11.2499L21 11.2499L21 12.7499L6.3508 12.7499Z"
                                                    fill="currentColor">
                                            </svg> Continue shopping</span></a>
                                    <!-- 
                                        <a href="checkout.php"
                                            class="theme-btn btn-style-one text-capitalize moreBtn float-end w-auto text-white bg-primary"><span
                                                class="btn-title">Proceed to checkout</span></a> -->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-3 col-sm-4 col-12">
                        <div class="cart_right_title">Price Details</div>
                        <div class="cart_right">
                            <?php if (!empty($cartData['discount']) && $cartData['discount'] > 0) { ?>
                            <div style="color:green; font-weight:600; margin-top:8px;">
                                🎉 You are eligible for ₹<?= number_format($cartData['discount']); ?> extra discount!
                            </div>
                            <?php  } ?>
                            <table class="table table-totals">
                                <tbody>
                                    <tr>
                                        <td>Price (<span id="total-items"><?=count($cartData['items']);?></span> items)
                                        </td>
                                        <td>&#8377 <span id="total-mrp"><?=$totalmrpprice;?></span></td>
                                    </tr>
                                    <tr>
                                        <td>Discount Price</td>
                                        <td>- &#8377 <span
                                                id="discount-amount"><?=($totalmrpprice-$totalprice)+$cartData['discount'];?></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Delivery Charges</td>
                                        <td class="free">Free</td>
                                    </tr>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td>Amount Payable</td>
                                        <td>
                                            <div class="payable">
                                                &#8377
                                                <span id="amount-payable"><?=$cartData['total'];?></span>
                                            </div>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                            <a class="order_btn" href="<?=site_url;?>/checkout.htm" title="Place Order">Place
                                Order</a>
                            <p class="safe_info"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                    fill="currentColor" viewBox="0 0 16 16">
                                    <path
                                        d="M5.338 1.59a61.44 61.44 0 0 0-2.837.856.481.481 0 0 0-.328.39c-.554 4.157.726 7.19 2.253 9.188a10.725 10.725 0 0 0 2.287 2.233c.346.244.652.42.893.533.12.057.218.095.293.118a.55.55 0 0 0 .101.025.615.615 0 0 0 .1-.025c.076-.023.174-.061.294-.118.24-.113.547-.29.893-.533a10.726 10.726 0 0 0 2.287-2.233c1.527-1.997 2.807-5.031 2.253-9.188a.48.48 0 0 0-.328-.39c-.651-.213-1.75-.56-2.837-.855C9.552 1.29 8.531 1.067 8 1.067c-.53 0-1.552.223-2.662.524zM5.072.56C6.157.265 7.31 0 8 0s1.843.265 2.928.56c1.11.3 2.229.655 2.887.87a1.54 1.54 0 0 1 1.044 1.262c.596 4.477-.787 7.795-2.465 9.99a11.775 11.775 0 0 1-2.517 2.453 7.159 7.159 0 0 1-1.048.625c-.28.132-.581.24-.829.24s-.548-.108-.829-.24a7.158 7.158 0 0 1-1.048-.625 11.777 11.777 0 0 1-2.517-2.453C1.928 10.487.545 7.169 1.141 2.692A1.54 1.54 0 0 1 2.185 1.43 62.456 62.456 0 0 1 5.072.56z">
                                    </path>
                                    <path
                                        d="M10.854 5.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 7.793l2.646-2.647a.5.5 0 0 1 .708 0z">
                                    </path>
                                </svg> Safe and Secure Payments. Easy returns. 100% Authentic products.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="w-100 float-start">
        <div class="container text-center py-5">
            <div class="container my-4">
                <div class="row g-3">
                    <!-- Card 1 -->
                    <div class="col-md-6">
                        <div class="discount-card">
                            <div
                                class="box-span bg-success1 position-absolute translate-middle start-50 top-0 text-white rounded-pill py-1 px-3">
                                10%</div>
                            <!-- <span class="info-icon">i</span> -->
                            <h3><span>10% Discount</span></h3>
                            <p>On order above ₹10000</p>
                        </div>
                    </div>

                    <!-- Card 2 -->
                    <div class="col-md-6">
                        <div class="discount-card discount-card2">
                            <div
                                class="box-span bg-success1 position-absolute translate-middle start-50 top-0 text-white rounded-pill py-1 px-3">
                                5%</div>

                            <!-- <span class="info-icon">i</span> -->
                            <h3><span>Flat 5% Discount</span></h3>
                            <p>On order above ₹2500</p>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <?php }else{ ?>

    <div class="empty_cart_section w-100 float-start bg-light">
        <div class="container text-center py-5">
            <div class="row">
                <div class="col-lg-8 mx-auto">
                    <div class="shadow1 px-4 py-5 border bg-white rounded rounded-5">
                        <img src="https://www.lnuniform.com/designer/images/empity.webp" alt="Empty Cart"
                            class="img-fluid mb-3" style="max-width:200px;">
                        <h3>Your Cart is Empty</h3>
                        <p>Looks like you haven't added anything to your cart yet.</p>
                        <a href="https://www.lnuniform.com" title="Continue Shopping"
                            class="theme-btn btn-style-one text-capitalize moreBtn border-0 mx-1 w-auto text-white bg-dar bg-primary  px-3 py-2 mt-0 d-inline-block">Continue
                            Shopping</a>
                    </div>
                </div>
            </div>


        </div>
    </div>
    <?php } ?>
    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
    <!-- <script>
        function incrementValue(e) {
    e.preventDefault();
    var fieldName = $(e.target).data('field');
    var parent = $(e.target).closest('div');
    var currentVal = parseInt(parent.find('input[name=' + fieldName + ']').val(), 10);
    if (!isNaN(currentVal)) {
        parent.find('input[name=' + fieldName + ']').val(currentVal + 1);
    } else {
        parent.find('input[name=' + fieldName + ']').val(0);
    }
}

function decrementValue(e) {
    e.preventDefault();
    var fieldName = $(e.target).data('field');
    var parent = $(e.target).closest('div');
    var currentVal = parseInt(parent.find('input[name=' + fieldName + ']').val(), 10);
    if (!isNaN(currentVal) && currentVal > 0) {
        parent.find('input[name=' + fieldName + ']').val(currentVal - 1);
    } else {
        parent.find('input[name=' + fieldName + ']').val(0);
    }
}
$('.input-group').on('click', '.button-plus', function(e) {
    incrementValue(e);
});
$('.input-group').on('click', '.button-minus', function(e) {
    decrementValue(e);
});
        $(document).on('click', '.price', function(e) {
          e.preventDefault();
         $(this).parent('tr').hide();
        //  $(this).parent().parent().parent().parent().parent().hide();
          //console.log($(this).parent(tr).parent().parent().parent().parent());
      });
    </script> -->
    <script>
    function updateTotals() {
        let grandTotal = 0;
        $('.cart-table tbody tr').each(function() {
            let price = parseInt($(this).data('price'));
            let qty = parseInt($(this).find('.quantity').val());
            let total = price * qty;
            $(this).find('.row-total').text('₹' + total);
            grandTotal += total;
        });
        $('#grandTotal').text('₹' + grandTotal);
    }
    // PLUS
    $(document).on('click', '.button-plus', function() {

        let qtyInput = $(this).siblings('.quantity');
        let qty = parseInt(qtyInput.val()) + 1;

        qtyInput.val(qty);

        let key = qtyInput.data('key');
        updateCart(key, qty, function() {
            location.reload(); // reload AFTER update
        });
    });

    // MINUS
    $(document).on('click', '.button-minus', function() {

        let qtyInput = $(this).siblings('.quantity');
        let qty = parseInt(qtyInput.val());

        if (qty > 1) {
            qty--;
            qtyInput.val(qty);

            let key = qtyInput.data('key');
            updateCart(key, qty, function() {
                location.reload();
            });
        }
    });
    // DELETE ROW
    $(document).on('click', '.delete-item', function(e) {
        e.preventDefault();

        const $row = $(this).closest('tr');
        const rowCount = $row.closest('tbody').find('tr').length;

        if (rowCount === 1) {
            // remove the last row and reload the page
            $row.remove();
            location.reload();
        } else {
            // just remove the row
            $row.remove();
            updateTotals();
        }
    });
    // INITIAL LOAD
    updateTotals();
    </script>
</body>

</html>