<?php
include_once("include/main.inc.php");

$limit = 6;
$page = isset($_POST['page']) ? (int)$_POST['page'] : 1;
$offset = ($page - 1) * $limit;

$where = "WHERE product_status='1'";

if (!empty($_POST['keyword'])) {
    $keyword = mysqli_real_escape_string($dbconn, $_POST['keyword']);
    $where .= " AND (
        product_name LIKE '%$keyword%' 
        OR product_title LIKE '%$keyword%' 
        OR product_specfi LIKE '%$keyword%'
        OR product_code LIKE '%$keyword%'
    )";
}

if (!empty($_POST['categories'])) {
    $cat_query = [];
    foreach ($_POST['categories'] as $c) {
        $cat_query[] = "FIND_IN_SET('".mysqli_real_escape_string($dbconn, $c)."', product_cat)";
    }
    $where .= " AND (" . implode(' OR ', $cat_query) . ")";
}

// Filter by Color
if (!empty($_POST['colors'])) {
    $color_query = [];
    foreach ($_POST['colors'] as $clr) {
        $color_query[] = "FIND_IN_SET('".intval($clr)."', color_ids)";
    }
    $where .= " AND (" . implode(' OR ', $color_query) . ")";
}

// Filter by Size
if (!empty($_POST['sizes'])) {
    $size_query = [];
    foreach ($_POST['sizes'] as $sz) {
        $size_query[] = "FIND_IN_SET('".intval($sz)."', size_ids)";
    }
    $where .= " AND (" . implode(' OR ', $size_query) . ")";
}

// Price
if(!empty($_POST['price'])){
    $price_query = [];
    foreach($_POST['price'] as $p){
        if($p == 1) $price_query[] = "(selling_price <= 1000)";
        if($p == 2) $price_query[] = "(selling_price BETWEEN 1000 AND 5000)";
        if($p == 3) $price_query[] = "(selling_price BETWEEN 5000 AND 10000)";
    }
    $where .= " AND (".implode(' OR ', $price_query).")";
}


// Sorting
$sort = "ORDER BY product_id DESC";

if (!empty($_POST['sort'])) {

    if ($_POST['sort'] == 'Price Low to High') {
        $sort = "ORDER BY selling_price ASC";
    }

    if ($_POST['sort'] == 'Price High to Low') {
        $sort = "ORDER BY selling_price DESC";
    }

    if ($_POST['sort'] == 'New Arrivals') {
        $sort = "ORDER BY product_id DESC";
    }

    if ($_POST['sort'] == 'Biggest Saving') {
        $sort = "ORDER BY (mrp_price - selling_price) DESC";
    }

    if ($_POST['sort'] == 'Best Sellers') {
        $where .= " AND is_best_seller = '1'";
    }

    if ($_POST['sort'] == 'Trending Products') {
        $where .= " AND is_trending = '1'";
    }

    if ($_POST['sort'] == 'Most Viewed') {
        $sort = "ORDER BY view_count DESC";
    }

    if ($_POST['sort'] == 'Now in Wishlists') {
        $sort = "ORDER BY wishlist_count DESC";
    }
}



// // Sorting
// $sort = "ORDER BY product_id DESC";
// if(!empty($_POST['sort'])){
//     if($_POST['sort'] == 'Price Low to High') $sort = "ORDER BY selling_price ASC";
//     if($_POST['sort'] == 'Price High to Low') $sort = "ORDER BY selling_price DESC";
// }

// Get Products
$sql = "SELECT * FROM product_tbl $where $sort LIMIT $offset, $limit";
$query = mysqli_query($dbconn, $sql);

$html = '';
if(mysqli_num_rows($query) > 0) {
    while($prod = mysqli_fetch_assoc($query)) {

          $badge = '';
    if (!empty($prod['is_best_seller'])) {
        $badge = '<span class="new" style="background:#28a745;">Best Seller</span>';
    } elseif (!empty($prod['is_trending'])) {
        $badge = '<span class="new" style="background:#ff9800;">Trending</span>';
    } elseif (!empty($prod['is_new_arrival'])) {
        $badge = '<span class="new">New</span>';
    } elseif (!empty($prod['is_sale'])) {
        $badge = '<span class="new" style="background:#f44336;">On Sale</span>';
    }
        // Prepare variables exactly like main page
        $images = explode(',', $prod['product_image']);
        $img = !empty($images[0]) ? $images[0] : 'noimage.jpg';
        $mrp = $prod['mrp_price'];
        $sell = $prod['selling_price'];
        $discount = ($mrp > 0 && $sell > 0) ? round((($mrp - $sell) / $mrp) * 100) : 0;
        $product_url = site_url.'/'.getValidFileName($prod['product_name']).'-'.$prod['product_id'].'.htm';
        $img_src = getImage($img, 310, 470, $prod['product_title'], '/uploaded-files/product-images/');
        // $targetLoc = isset($admin_res['targetlocation']) ? $admin_res['targetlocation'] : '';
if (!empty($_POST['targetLoc'])) {
    // User came from category_sub page
    $targetLoc = mysqli_real_escape_string($dbconn, $_POST['targetLoc']);
} else {
    // Default location
    $targetLoc = $admin_res['targetlocation'];
}
        // Exact original HTML structure
        $html .= '
        <div class="col-lg-4 col-md-6">
            <div class="single-product">
                <div class="product-img">
                    <a href="'.$product_url.'" title="'.$prod['product_title'].'">
                        <div class="product-carousel">
                            <div class="main-image">
                                <img loading="lazy" src="'.$img_src.'" alt="'.$prod['product_title'].' Manufacturers, Suppliers in '.$targetLoc.'" title="'.$prod['product_title'].' Manufacturers, Suppliers in '.$targetLoc.'">
                            </div>
                        </div>
                        '.$badge.'
                    </a>
                </div>
                <div class="product-content">
                    <div class="title4 text-center">
                        <a href="'.$product_url.'" class="tt text-center" title="'.$prod['product_title'].'">'.$prod['product_title'].'</a>
                    </div>
                    <div class="d-block align-items-center justify-content-between">
                        <div class="d-flex align-items-center justify-content-center text-center">';
                             if ($sell > 0) {
                            $html .= ' <div class="product-price">
                                <span class="currencyChange" data-inr="'.number_format(round($sell), 2).'">
                                    <b>₹</b>'.number_format(round($sell), 2).' </span>';
                                    if($mrp > $sell){
                                        $html .= '<del class="currencyChange" data-inr="'.number_format($mrp, 2).'" style="padding-left: 1%;">
                                            <b>₹</b>'.number_format($mrp, 2).' </del>';
                                    }
                $html .= '  </div>';
                            if($discount > 0){
                                $html .= '<p class="text-success mb-0 ms-2 fs-6">'.$discount.'% off</p>';
                            }
    }
                $html .= '</div>
                        <div class="d-flex border-top align-items-center gap-2 pt-2 mt-1 justify-content-center">
                            <a href="'.$product_url.'" class="read_more_1 bg_btn_1 px-2" title="View Detail">View Detail
                                <span></span><span></span><span></span><span></span>
                            </a>';
                             if ($sell > 0) {

    $html .= '
                            <a href="'.$product_url.'" class="read_more_1 bg_btn_1 px-2 addtocart" data-id="'.$prod['product_id'].'" title="Add To Cart">Add To Cart
                                <b class="svg-icon" data-type="cart">
                                    <svg class="icon-default" width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6.29977 5H21L19 12H7.37671M20 16H8L6 3H3M9 20C9 20.5523 8.55228 21 8 21C7.44772 21 7 20.5523 7 20C7 19.4477 7.44772 19 8 19C8.5523 19 9 19.4477 9 20ZM20 20C20 20.5523 19.5523 21 19 21C18.4477 21 18 20.5523 18 20C18 19.4477 18.4477 19 19 19C19.5523 19 20 19.4477 20 20Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </b>
                                <span></span><span></span><span></span><span></span>
                            </a>';
                            }
                        $html .= ' </div>
                    </div>
                </div>
            </div>
        </div>';
    }
} else {
    $html = '<div class="col-12 text-center py-5"><h3>No products found matching your filters.</h3></div>';
}

// Get Total for Pagination
$total_sql = mysqli_query($dbconn, "SELECT COUNT(*) as total FROM product_tbl $where");
$total_row = mysqli_fetch_assoc($total_sql);
$total_products = (int)$total_row['total'];
$total_pages = ceil($total_products / $limit);

// Generate Pagination Exactly as main page
$pagination = '';
if ($total_pages > 1) {
    $pagination .= '<ul class="pagination justify-content-start mt-3">';
    
    // Previous Link
    $prevDisabled = ($page <= 1) ? 'disabled' : '';
    $pagination .= '<li class="page-item '.$prevDisabled.'">
                        <a class="page-link" href="javascript:void();" data-page="'.($page - 1).'">Previous</a>
                    </li>';

    for ($i = 1; $i <= $total_pages; $i++) {
        $active = ($i == $page) ? 'active' : '';
        $pagination .= '<li class="page-item '.$active.'">
                            <a class="page-link" href="javascript:void();" data-page="'.$i.'">'.$i.'</a>
                        </li>';
    }

    // Next Link
    $nextDisabled = ($page >= $total_pages) ? 'disabled' : '';
    $pagination .= '<li class="page-item '.$nextDisabled.'">
                        <a class="page-link" href="javascript:void();" data-page="'.($page + 1).'">Next</a>
                    </li>';
    
    $pagination .= '</ul>';
}

echo json_encode(['products' => $html, 'pagination' => $pagination, 'count' => $total_products]);