<?php

// ini_set('log_errors', 1);

// ini_set('error_log', 'error_log.txt');  // Logs errors to a file

// error_reporting(E_ALL);

class SitemapGenerator {
    private $domain;
    private $urls = [];
    private $sitemapDir = "sitemap/";
    private $sitemapIndex = "sitemap.xml";
    private $maxUrlsPerFile = 50000;
    public function __construct($domain) {
        $this->domain = rtrim($domain, '/');
    }
    public function fetchUrls($url) {
        $visited = [];
    $queue = [$url];
    $count = 0;
        while (!empty($queue)) {
            $currentUrl = array_shift($queue);
            if (isset($visited[$currentUrl])) {
                continue;
            }
            $visited[$currentUrl] = true;
            $this->urls[] = $currentUrl;
             $count++;
            $html = @file_get_contents($currentUrl);
            if (!$html) continue;
            preg_match_all('/<a\s+href=["\']?([^"\' >]+)["\']?/i', $html, $matches);
            foreach ($matches[1] as $link) {
                if (strpos($link, 'http') === false) {
                    $link = $this->domain . '/' . ltrim($link, '/');
                }
                if (
                    strpos($link, $this->domain) === 0 && 
                 !isset($visited[$link]) && 
 
                    (preg_match('/\.htm$/', $link) || substr($link, -1) === '/') && !in_array($link, $this->urls) 
                ) {
                    $queue[] = $link;
                    $visited[] = $link;
                    $this->urls[] = $link;
                }
            }
        }
    }
    private function generateSitemapFiles() {
        if (!file_exists($this->sitemapDir)) {
            mkdir($this->sitemapDir, 0777, true);
        }
        if (count($this->urls) <= $this->maxUrlsPerFile) {
            $filename = "sitemap.xml";
            $sitemapIndexContent = "";
        } else {
        $sitemapFiles = [];
        $sitemapIndexContent = "<?xml version='1.0' encoding='UTF-8'?>\n<sitemapindex xmlns='http://www.sitemaps.org/schemas/sitemap/0.9' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/siteindex.xsd'>\n";
        }
        $chunks = array_chunk($this->urls, $this->maxUrlsPerFile);
        foreach ($chunks as $i => $chunk) {
            $filename = count($this->urls) <= $this->maxUrlsPerFile ? "sitemap.xml" : "sitemap" . ($i + 1) . ".xml";
            if (count($this->urls) > $this->maxUrlsPerFile) {
            $sitemapFiles[] = $filename;
            $sitemapIndexContent .= "<sitemap><loc>{$this->domain}/{$this->sitemapDir}{$filename}</loc></sitemap>\n";
            }
            $content = "<?xml version='1.0' encoding='UTF-8'?>\n<urlset xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:xhtml='http://www.w3.org/1999/xhtml' xmlns='http://www.sitemaps.org/schemas/sitemap/0.9' xsi:schemaLocation='http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd'>\n";
            foreach ($chunk as $url) {
                $priority = ($url === $this->domain) ? "1.0000" : "0.8000";
                $content .= "<url><loc>{$url}</loc><lastmod>" . date('Y-m-d\TH:i:sP') . "</lastmod><changefreq>daily</changefreq><priority>{$priority}</priority></url>\n";
            }
            $content .= "</urlset>";
            file_put_contents($this->sitemapDir . $filename, $content);
        }
        if (count($this->urls) > $this->maxUrlsPerFile) {
        $sitemapIndexContent .= "</sitemapindex>";
        file_put_contents($this->sitemapDir . $this->sitemapIndex, $sitemapIndexContent);
        }
    }
    public function detectBrokenLinks() {
        $brokenLinks = [];
        foreach ($this->urls as $url) {
            $headers = @get_headers($url);
            if (!$headers || strpos($headers[0], '404') !== false) {
                $brokenLinks[] = $url;
            }
        }
        if (!empty($brokenLinks)) {
            file_put_contents($this->sitemapDir . "broken_links.txt", implode("\n", $brokenLinks));
        }
    }
    // public function pingSearchEngines() {
    //     $sitemapUrl = $this->domain . '/' . $this->sitemapDir . $this->sitemapIndex;
    //     $pingUrls = [
    //         "https://www.google.com/ping?sitemap={$sitemapUrl}",
    //         "https://www.bing.com/ping?sitemap={$sitemapUrl}"
    //     ];
    //     foreach ($pingUrls as $pingUrl) {
    //         file_get_contents($pingUrl);
    //     }
    // }
    public function run() {
        $this->fetchUrls($this->domain);
        $this->generateSitemapFiles();
        $this->detectBrokenLinks();
        // $this->pingSearchEngines();
    }
}
$domain = "https://www.lnuniform.com";
$sitemap = new SitemapGenerator($domain);
$sitemap->run();



echo "Sitemap generation completed.";
?>
