<?php

class Payment extends Public_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->helper(array('cart/cart', 'file'));
    $this->load->model(array('order/order_model', 'payment/payment_model'));
    $this->load->library(array('Dmailer', 'safe_encrypt'));
    $this->page_section_ct = 'common';
  }

  public function index() {
    $payMode = str_replace('.html', '', $this->input->get_post('pay_method'));
    //print_r($payMode);
    if ($payMode == "Payu") {
      $working_order_id = $this->session->userdata('working_order_id');
      $order_res = $this->order_model->get_order_master($working_order_id);
      //trace($_POST);
      payuForm($order_res);
    } elseif ($payMode == "COD") {
      $this->pay_by_check();
    } else {
      $working_order_id = $this->session->userdata('working_order_id');
      $order_res = $this->order_model->get_order_master($working_order_id);
      //trace($_POST);
      payuForm($order_res);
    }
  }


 public function pay_by_check() {
    $data = array('payment_method' => 'Cash', 'payment_status' => 'Unpaid');
    $ordId = $this->session->userdata('working_order_id');
    $where = "order_id = '" . $ordId . "' ";
    $this->payment_model->safe_update('wps_order', $data, $where, FALSE);
    $condition = "&& order_id='" . $ordId . "'";
    $cupn = $this->order_model->get_orders(0, 1, $condition);
    $cupn = $cupn[0];
    $ordId = md5($ordId);
    $res = get_db_field_value('wps_order', 'order_id', array('MD5(order_id)' => $ordId));
    $ordmaster = $this->order_model->get_order_master($res);
    $orddetail = $this->order_model->get_order_detail($res);
    if (is_array($ordmaster) && !empty($ordmaster)) {
      ob_start();
      $mail_subject = $this->config->item('site_name') . " Order Oerview";
      $from_email = $this->admin_info->admin_email;
      $from_name = $this->config->item('site_name');
      $mail_to = $ordmaster['email'];
      $body = invoice_content_print($ordmaster, $orddetail);
      $msg = ob_get_contents();
      $mail_conf = array(
          'subject' => $this->config->item('site_name') . " Order overview",
          'to_email' => $mail_to,
          'from_email' => $from_email,
          'from_name' => $this->config->item('site_name'),
          'body_part' => $msg
      );
      //trace($mail_conf); die;
      $this->dmailer->mail_notify($mail_conf);
  if($this->admin_info->website_mode=='Live'){
      $mail_conf2 = array(
          'subject' => $this->config->item('site_name') . " Order overview",
          'to_email' => $this->admin_info->admin_email,
          'from_email' => $from_email,
          'from_name' => $this->config->item('site_name'),
          'body_part' => $msg
      );
      //trace($mail_conf); die;
      $this->dmailer->mail_notify($mail_conf2);
      $mail_conf4 = array(
          'subject' => $this->config->item('site_name') . " Order overview",
          'to_email' => "webpulseindia@gmail.com",
          'from_email' => $from_email,
          'from_name' => $this->config->item('site_name'),
          'body_part' => $msg
      );
      $this->dmailer->mail_notify($mail_conf4);
    }else{
      $mail_conf4 = array(
                  'subject' => $this->config->item('site_name') . " Order overview",
                  'to_email' => 'test.webpulse@gmail.com', //
                  'from_email' => $from_email,
                  'from_name' => $this->config->item('site_name'),
                  'body_part' => $msg,
              );
              $this->dmailer->mail_notify($mail_conf4);
    }
    }
    redirect('payment/thanks/' . $ordId, '');
  }
  
  public function order_success() {
    $ordId = $this->uri->segment(3);
    $this->session->unset_userdata(array('discount_amount' => 0));
    //update payment status
    $responses = json_encode($_REQUEST);

    if($_REQUEST['status']=='success'){
        $data = array('payment_method' => 'Payu', 'payment_status' => 'Paid', 'paymentResponse' => $responses);
        //$where = "MD5(order_id) = '$ordId' ";
        $where = "order_id = '$ordId' ";
        $this->payment_model->safe_update('wps_order', $data, $where, FALSE);
        //echo_sql();
        //exit;
        // $res = get_db_field_value('wps_order', 'order_id', array('MD5(order_id)' => $ordId));
        $res = get_db_field_value('wps_order', 'order_id', array('order_id' => $ordId));
        $ordmaster = $this->order_model->get_order_master($res);
        $orddetail = $this->order_model->get_order_detail($res);
        $this->update_stocks($ordId);
        if (is_array($ordmaster) && !empty($ordmaster)) {
          ob_start();
          $mail_subject = $this->config->item('site_name') . " Order Oerview";
          $from_email = $this->admin_info->admin_email;
          $from_name = $this->config->item('site_name');
          $mail_to = $ordmaster['email'];
          $body = invoice_content_print($ordmaster, $orddetail);
          $msg = ob_get_contents();

          $mail_conf = array(
              'subject' => $this->config->item('site_name') . " Order overview",
              'to_email' => $mail_to,
              'from_email' => $from_email,
              'from_name' => $this->config->item('site_name'),
              'body_part' => $msg
          );
          //trace($mail_conf); die;
          $this->dmailer->mail_notify($mail_conf);
            if($this->admin_info->website_mode=='Live'){
                $mail_conf2 = array(
                    'subject' => $this->config->item('site_name') . " Order overview",
                    'to_email' => $this->admin_info->admin_email,
                    'from_email' => $from_email,
                    'from_name' => $this->config->item('site_name'),
                    'body_part' => $msg
                );
                //trace($mail_conf); die;
                $this->dmailer->mail_notify($mail_conf2);
                $mail_conf4 = array(
                    'subject' => $this->config->item('site_name') . " Order overview",
                    'to_email' => "webpulseindia@gmail.com",
                    'from_email' => $from_email,
                    'from_name' => $this->config->item('site_name'),
                    'body_part' => $msg
                );
                $this->dmailer->mail_notify($mail_conf4);
            }else{
              $mail_conf4 = array(
                          'subject' => $this->config->item('site_name') . " Order overview",
                          'to_email' => 'test.webpulse@gmail.com', //
                          'from_email' => $from_email,
                          'from_name' => $this->config->item('site_name'),
                          'body_part' => $msg,
                      );
                      $this->dmailer->mail_notify($mail_conf4);
            }
        }
        $this->session->set_flashdata('msg', $this->config->item('payment_success'));
    }else{
      $data = array('payment_method' => 'Payu', 'payment_status' => 'Unpaid', 'paymentResponse' => $responses);
      $where = "order_id = '$ordId' ";
      $this->payment_model->safe_update('wps_order', $data, $where, FALSE);
      $this->session->set_flashdata('msg', $this->config->item('payment_failed'));
    }
    $this->session->unset_userdata(array('working_order_id' => 0));
    redirect('payment/thanks/'.md5($ordId));
  }

  

  public function order_cancle() {
    $ordId = $this->uri->segment(3);
    $responses = json_encode($_REQUEST);
    $data = array('order_status' => '5', 'paymentResponse' => $responses);
    // $where = "MD5(order_id) = '$ordId' ";
    $where = "order_id = '$ordId' ";
    $this->payment_model->safe_update('wps_order', $data, $where, FALSE);
    $this->session->unset_userdata(array('working_order_id' => 0));
    $this->session->set_flashdata('msg', $this->config->item('payment_failed'));
    redirect('payment/thanks/'.md5($ordId));
  }

  public function thanks() {
    $order_id = str_replace('.html', '', $this->uri->segment(3));
    $res = get_db_field_value('wps_order', 'order_id', array('md5(order_id)' => $order_id));
    if ($res > 0) {
      $data['title'] = "Invoice Print";
      $order_res = $this->order_model->get_order_master($res);
      //trace($order_res);
      $order_details_res = $this->order_model->get_order_detail($res);
      $data['orddetail'] = $order_details_res;
      $data['ordmaster'] = $order_res;
      $this->load->view('payment/pay_thanks', $data);
    }
  }

  public function update_stocks($order_id) {
    $order_id = (int) $order_id;
    $condtion = array('field' => "products_id,quantity,color_id,size_id", 'condition' => "order_id ='$order_id'", 'index' => 'products_id');
    $orders_res = $this->order_model->findAll('wps_orders_products', $condtion);
    if (is_array($orders_res) && !empty($orders_res)) {
      foreach ($orders_res as $v) {
          $qty = $v['quantity'];
          $sql = "UPDATE wps_products SET product_qty = product_qty-$qty WHERE products_id = '" . $v['products_id'] . "'";
          $this->db->query($sql);

          if($v['color_id']>0 && $v['size_id']>0){
            $qty = $v['quantity'];
            $sql = "UPDATE wps_product_attributes SET quantity = quantity-$qty WHERE product_id = '" . $v['products_id'] . "' and color_id = '" . $v['color_id'] . "' and size_id = '" . $v['size_id'] . "'";
            $this->db->query($sql);
          }elseif($v['color_id']>0 && $v['size_id']=='0'){
            $qty = $v['quantity'];
            $sql = "UPDATE wps_product_attributes SET quantity = quantity-$qty WHERE product_id = '" . $v['products_id'] . "' and color_id = '" . $v['color_id'] . "' and size_id = '0'";
            $this->db->query($sql);
          }elseif($v['color_id']=='0' && $v['size_id']>0){
            $qty = $v['quantity'];
            $sql = "UPDATE wps_product_attributes SET quantity = quantity-$qty WHERE product_id = '" . $v['products_id'] . "' and color_id = '0' and size_id = '" . $v['size_id'] . "'";
            $this->db->query($sql);
          }
      }
    }
  }

  

}

/* End of file member.php */

/* Location: .application/modules/products/controllers/cart.php */