<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/*
  | -------------------------------------------------------------------------
  | URI ROUTING
  | -------------------------------------------------------------------------
  | This file lets you re-map URI requests to specific controller functions.
  |
  | Typically there is a one-to-one relationship between a URL string
  | and its corresponding controller class/method. The segments in a
  | URL normally follow this pattern:
  |
  |	example.com/class/method/id/
  |
  | In some instances, however, you may want to remap this relationship
  | so that a different class/function is called than the one
  | corresponding to the URL.
  |
  | Please see the user guide for complete details:
  |
  |	https://codeigniter.com/user_guide/general/routing.html
  |
  | -------------------------------------------------------------------------
  | RESERVED ROUTES
  | -------------------------------------------------------------------------
  |
  | There are three reserved routes:
  |
  |	$route['default_controller'] = 'welcome';
  |
  | This route indicates which controller class should be loaded if the
  | URI contains no data. In the above example, the "welcome" class
  | would be loaded.
  |
  |	$route['404_override'] = 'errors/page_missing';
  |
  | This route will tell the Router which controller/method to use if those
  | provided in the URL cannot be matched to a valid route.
  |
  |	$route['translate_uri_dashes'] = FALSE;
  |
  | This is not exactly a route, but allows you to automatically route
  | controller and method names that contain dashes. '-' isn't a valid
  | class or method name character, so it requires translation.
  | When you set this option to TRUE, it will replace ALL dashes in the
  | controller and method URI segments.
  |
  | Examples:	my-controller/index	-> my_controller/index
  |		my-controller/my-method	-> my_controller/my_method
 */
$route['default_controller'] = 'home';

//Routes for Admin Folder
$route['wps-admin'] = "admin";
$route['wps-admin/forgot-password'] = "admin/forgotten_password";
$route['wps-admin/dashboard/(:any)'] = "admin/dashboard/$1";

$route['wps-admin/category/(:any)'] = "admin/category/$1";
$route['wps-admin/category/(:any)/(:any)'] = "admin/category/$1/$2";

$route['wps-admin/subadmin/(:any)'] = "admin/subadmin/$1";
$route['wps-admin/subadmin/(:any)/(:any)'] = "admin/subadmin/$1/$2";

$route['wps-admin/enquiry/(:any)'] = "admin/enquiry/$1";
$route['wps-admin/enquiry/(:any)/(:any)'] = "admin/enquiry/$1/$2";

$route['wps-admin/staticpages/(:any)/(:any)'] = "admin/staticpages/$1/$2";

$route['wps-admin/products/(:any)'] = "admin/products/$1";
$route['wps-admin/products/(:any)/(:any)'] = "admin/products/$1/$2";

$route['wps-admin/discountcoupon/(:any)'] = "admin/discountcoupon/$1";
$route['wps-admin/discountcoupon/(:any)/(:any)'] = "admin/discountcoupon/$1/$2";

$route['wps-admin/banners/(:any)'] = "admin/banners/$1";
$route['wps-admin/banners/(:any)/(:any)'] = "admin/banners/$1/$2";

$route['wps-admin/meta/(:any)/(:any)'] = "admin/meta/$1/$2";

$route['wps-admin/location/(:any)'] = "admin/location/$1";
$route['wps-admin/location/(:any)/(:any)'] = "admin/location/$1/$2";

$route['wps-admin/subloccontent/(:any)'] = "admin/subloccontent/$1";
$route['wps-admin/subloccontent/(:any)/(:any)'] = "admin/subloccontent/$1/$2";

$route['wps-admin/subcontent/(:any)'] = "admin/subcontent/$1";
$route['wps-admin/subcontent/(:any)/(:any)'] = "admin/subcontent/$1/$2";

$route['wps-admin/size/(:any)'] = "admin/size/$1";
$route['wps-admin/size/(:any)/(:any)'] = "admin/size/$1/$2";

$route['wps-admin/resources/(:any)'] = "admin/resources/$1";
$route['wps-admin/resources/(:any)/(:any)'] = "admin/resources/$1/$2";

$route['wps-admin/color/(:any)'] = "admin/color/$1";
$route['wps-admin/color/(:any)/(:any)'] = "admin/color/$1/$2";

$route['wps-admin/orders/(:any)'] = "admin/orders/$1";
$route['wps-admin/orders/(:any)/(:any)'] = "admin/orders/$1/$2";

$route['wps-admin/brands/(:any)'] = "admin/brands/$1";
$route['wps-admin/brands/(:any)/(:any)'] = "admin/brands/$1/$2";

$route['wps-admin/styles/(:any)'] = "admin/styles/$1";
$route['wps-admin/styles/(:any)/(:any)'] = "admin/styles/$1/$2";

$route['wps-admin/rooms/(:any)'] = "admin/rooms/$1";
$route['wps-admin/rooms/(:any)/(:any)'] = "admin/rooms/$1/$2";

$route['wps-admin/blog/(:any)'] = "admin/blog/$1";
$route['wps-admin/blog/(:any)/(:any)'] = "admin/blog/$1/$2";

$route['wps-admin/faq/(:any)'] = "admin/faq/$1";
$route['wps-admin/faq/(:any)/(:any)'] = "admin/faq/$1/$2";

$route['wps-admin/testimonial/(:any)'] = "admin/testimonial/$1";
$route['wps-admin/testimonial/(:any)/(:any)'] = "admin/testimonial/$1/$2";

$route['wps-admin/gallery/(:any)'] = "admin/gallery/$1";
$route['wps-admin/gallery/(:any)/(:any)'] = "admin/gallery/$1/$2";

$route['wps-admin/gallery_category/(:any)'] = "admin/gallery_category/$1";
$route['wps-admin/gallery_category/(:any)/(:any)'] = "admin/gallery_category/$1/$2";

$route['wps-admin/videos/(:any)'] = "admin/videos/$1";
$route['wps-admin/videos/(:any)/(:any)'] = "admin/videos/$1/$2";

$route['wps-admin/(:any)'] = "admin/$1";
//End here


//$route['404_override'] = 'home';
$route['translate_uri_dashes'] = FALSE;
