<?php
$this->load->view("top");
$QryStringArr = array();  // To store all Query Variables so to move to other view;
$QryStringArr = array_unique($QryStringArr);
if (isset($this->meta_info['entity_id']) && $this->meta_info['entity_id'] != '') {
  $QryStringArr['category_id'] = $this->meta_info['entity_id'];
}
if ($this->input->get_post('keyword') != '') {
  $QryStringArr['keyword'] = $this->input->get_post('keyword');
}
if ($this->input->get_post('sort') != '') {
  $QryStringArr['sort'] = $this->input->get_post('sort');
}

if ($page_title == "Compression Therapy System") {
  $dimage = theme_url() . 'images/listing/Compression-Therapy-System.jpg';
} else if ($page_title == "X-ray Protection Products") {
  $dimage = theme_url() . 'images/listing/X-ray-Protection-Products.jpg';
} else if ($page_title == "Patient Identification Solutions") {
  $dimage = theme_url() . 'images/listing/Patient-Identification-Solutions.jpg';
} else if ($page_title == "Neonatal Care Products") {
  $dimage = theme_url() . 'images/listing/Neonatal-Care-Products.jpg';
} else if ($page_title == "High Flow Oxygen Therapy Devices") {
  $dimage = theme_url() . 'images/listing/High-Flow-Oxygen-Therapy-Devices.jpg';
} else {
  $dimage = theme_url() . 'images/listing/listing-banner6.jpg';
}


?>
<section class="banner_category" style="background-image: url('<?php echo $dimage; ?>');">
  <div class="container">
    <!-- <h2 class="banner_subtitle">check out over <span>200+</span></h2> -->
    <h1 class="banner_title"><?php echo $page_title; ?></h1>
  </div>
</section>
<div class="page_breadcrumbs">
  <div class="container">
    <ul>
      <li><a href="<?php echo site_url(); ?>" title="Home">Home</a>
      </li>
      <?php
      if (isset($parentres['category_id'])) {
        echo category_breadcrumbs($parentres['category_id']);
      } else {
      ?>
        <li><?php echo $page_title; ?></li>
      <?php } ?>
    </ul>
  </div>
</div>


<section class="service_page">
  <div class="container">
    <div class="row">
      <div class="col-lg-9 col-md-9">
        <?php if ($parentres['category_id'] == 32) { ?>
          <h2 class="title_2"><?php echo $parentres['category_name']; ?></h2>

        <?php } else { ?>
          <h2 class="title_2"><?php echo imagealtTitle('', $parentres['category_name'], ' '); ?></h2>
        <?php } ?>

        <div class="service_details">
          <div class="service_details_image ">
            <a href="javascript:void();" data-toggle="modal" data-target="#getquote" title="<?php echo imagealtTitle2('', $parentres['category_name'], ''); ?>" class="getQuote" data-friendly_url="<?php echo site_url($parentres['friendly_url']); ?>" data-ProductID="<?php echo $parentres['category_id']; ?>" data-ProductName="<?php echo $parentres['category_name']; ?>" data-ProductImage="<?php echo get_image('category', $parentres['category_image'], '', '', 'AR'); ?>" data-id="<?php echo $parentres['category_id']; ?>">
              <div class="service_details_image_thumb">
                <img src="<?php echo get_image('category', $parentres['category_image'], '400', '320', 'R'); ?>" alt="<?php echo imagealtTitle2('', $parentres['category_name'], ''); ?>" title="<?php echo imagealtTitle2('', $parentres['category_name'], ''); ?>">
              </div>
              <span class="details_btn hover_btn">Send Enquiry</span>
            </a>
          </div>
          <?php echo html_entity_decode($parentres['category_description']); ?>

        </div>
        <div class="clearfix"></div>
        <?php if (is_array($res) && !empty($res)) { ?>
          <div class="title_2">You may also like:</div>
          <?php
          $uri_path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
          $uri_segments = explode('/', $uri_path);
          $st = $uri_segments[1];
          if (strstr($st, '.html')) {
            $st = substr($st, 0, -5);
          }
          $loca_id = get_db_field_value("wps_meta_tags", "meta_id", "WHERE page_url = '" . $st . "'");
          // echo $st;die;
          foreach ($res as $val) {
            $link_url = site_url($val['friendly_url']);
            // echo $link_url;
            $category_id = $val['category_id'];
            $details_sub = $this->db->query("SELECT short_description FROM wps_subcontent WHERE status = '1' AND FIND_IN_SET($category_id,category_id) AND FIND_IN_SET($loca_id,location_id)")->row();
            if(is_object($details_sub) && !empty($details_sub)){
              $short_description = str_replace("{location}",ucwords(locationName($st)), $details_sub->short_description);
              $pr_title= $val['category_name']. " Suppliers in ".ucwords(locationName($st));
            }else{
              $short_description = $val['short_description'];
              $pr_title= $val['category_name']. " Suppliers in Delhi";
            }
          ?>
           <div class="service_listing">
        <a href="<?= $link_url; ?>" title="<?php echo imagealtTitle2('', $val['category_name'], ''); ?>">
          <div class="service_thumb">
            <img src="<?php echo get_image('category', $val['category_image'], '289', '220', 'R'); ?>" alt="<?php echo imagealtTitle2('', $val['category_name'], ''); ?>" title="<?php echo imagealtTitle2('', $val['category_name'], ''); ?>">
          </div>
        </a>
        <div class="service_content">
          <h4 class="title_small">
            <a href="<?= $link_url; ?>" title="<?php echo $pr_title; ?>">
              <span><?php echo $val['category_name']; ?></span>
            </a>
          </h4><p><?php echo html_entity_decode($short_description); ?></p>
          <div class="clearfix"></div>
          <br>
          <a href="<?= $link_url; ?>" class="service_read_more_btn hover_btn" title="Read More">Read More</a>
          <a href="javascript:void(0);" data-toggle="modal" data-target="#getquote" class="service_read_more_btn hover_btn getQuote" data-friendly_url="<?php echo site_url($val['friendly_url']); ?>" data-ProductID="<?php echo $val['category_id']; ?>" data-ProductName="<?php echo $val['category_name']; ?>" data-ProductImage="<?php echo get_image('category', $val['category_image'], '', '', 'AR'); ?>" data-id="<?php echo $val['category_id']; ?>">Send Enquiry</a>
        </div>
      </div>
    <?php } ?>
  <?php } ?>
      </div>
    <div class="col-md-3">
      <div class="sidebar">
        <h5 class="sidebar_title1">Our Products List</h5>
        <div class="sidebar_body">
          <div class="sidebar_group">
            <div class="sidebar_inner">
              <ul>
                <?php
                $category_ids = $parentres['category_id'];
                $cat_listing = $this->db->query("SELECT * FROM wps_categories where status='1' and category_id!='$category_ids' and category_id!='32' order by category_name ASC")->result_array();

                foreach ($cat_listing as $value) {
                ?>
                  <li><a href="<?php echo site_url($value['friendly_url']); ?>" title="<?php echo imagealtTitle('', $value['category_name'], ''); ?>"><?php echo $value['category_name']; ?></a></li>
                <?php } ?>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  </div>
</section>
<?php $this->load->view("bottom"); ?>
<script>
  var page = 1;
  var triggeredPaging = 0;

  $(window).scroll(function() {
    $('#loadingdiv').hide();
    var scrollTop = $(window).scrollTop();
    var scrollBottom = (scrollTop + $(window).height());
    var containerTop = $('#prodListingContainer').offset().top;
    var containerHeight = $('#prodListingContainer').height();
    var containerBottom = Math.floor(containerTop + containerHeight);
    var scrollBuffer = 0;
    if ((containerBottom - scrollBuffer) <= scrollBottom) {
      page = $('.listpager').length;
      var queryString = '?stOffSet=' + page;
      <?php
      if (count($QryStringArr)) {
        foreach ($QryStringArr as $qrykey => $qryval) {
      ?>
          queryString += "&<?php echo $qrykey; ?>=<?php echo $qryval; ?>";
      <?php
        }
      }
      ?>
      var actual_count = <?php echo $total_rows; ?>;

      if (!triggeredPaging && page < actual_count) {
        triggeredPaging = 1;
        $.ajax({
          type: "POST",
          url: "<?php echo base_url(); ?>category/ajax_load_category_view" + queryString,
          error: function(res) {
            //alert('Error');
            triggeredPaging = 0;
            $('#loadingdiv').hide();
            //console.log(arguments);
          },
          beforeSend: function(jqXHR, settings) {
            $('#loadingdiv').show();

          },
          success: function(res) {
            $('#loadingdiv').hide();
            $("#prodListingContainer").append(res);
            triggeredPaging = 0;
            //console.log(res);
            $('.listpager').fadeTo(1000, 0.5, function() {
              $(this).fadeTo(1000, 1.0);
            });
          }
        });
      }
    }
  });
</script>