<?php

class Gallery_category extends Admin_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('gallery_category/gallery_category_model'));
    $this->config->set_item('menu_highlight', 'gallery');
  }

  public function index() {
    $condition = array();

    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $parent_id = (int) $this->uri->segment(4, 0);
    


     if($parent_id > 0 ){
      $condition['parent_id'] = $parent_id;
    }else{
      $condition['parent_id'] = 0;
    }


    $res_array = $this->gallery_category_model->get_gallery_cat($config['limit'], $offset, $condition);

    $total_record = get_found_rows();
    $config['total_rows'] = $total_record;
    //$data['page_links'] = admin_pagination($base_url, $config['total_rows'], $config['limit'], $offset);
    $data['res'] = $res_array;

    if ($this->input->post('status_action') != '') {
      $this->update_status('wps_gallery_category', 'category_id');
    }
     
     $data['parent_id'] = $parent_id;

    $data['heading_title'] = ( $parent_id > 0 ) ? 'Manage gallery\'s Subcategory' : 'Manage gallery\'s Category';
    
    $data['pagelist'] = $res_array;
    $this->load->view('gallery/view_gallery_cat_list', $data);
  }

  public function add() {
    $parent_id = (int) $this->uri->segment(4, 0);
    $data['parent_id'] = $parent_id;
   
    $data['ckeditor'] = set_ck_config(array('textarea_id' => 'gallery_answer'));
     if ($parent_id != '' && $parent_id > 0) {
      $data['heading_title'] = 'Add gallery Sub Category';
     }else{
      $data['heading_title'] = 'Add gallery Category';
    }
    $this->form_validation->set_rules('gallery_category', 'Category Name', 'trim|required|max_length[250]');
    //$this->form_validation->set_rules('details', 'Details', 'trim|required');

    $posted_friendly_url = $this->input->post('friendly_url');
    $this->cbk_friendly_url = seo_url_title($posted_friendly_url);


    if ($this->form_validation->run() == TRUE) {

      $posted_data = array(
          'name' => $this->input->post('gallery_category', TRUE),
          'friendly_url' => $this->cbk_friendly_url,
          'parent_id' => $parent_id,
          'details' => $this->input->post('details', TRUE),
      );
      
      $insertId = $this->gallery_category_model->safe_insert('wps_gallery_category', $posted_data, FALSE);

      if ($insertId > 0) {
        $redirect_url = "gallery/index";
        $meta_description = $this->input->post('gallery_name');
        $meta_keyword = $this->input->post('gallery_name');
        $meta_array = array(
            'entity_type' => $redirect_url,
            'entity_id' => $insertId,
            'page_url' => $this->cbk_friendly_url,
            'meta_title' => get_text($this->input->post('gallery_name'), 80),
            'meta_description' => get_text($meta_description),
            'meta_keyword' => get_keywords($meta_keyword)
        );
        create_meta($meta_array);
      }

      
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', lang('success'));
      redirect('wps-admin/gallery_category', '');
    }

    $this->load->view('gallery/view_gallery_cat_add', $data);
  }

  public function edit() {
     $galleryId = (int) $this->uri->segment(4);
    $data['heading_title'] = 'Edit gallery Category';
    $Id = (int) $this->uri->segment(4);
    $res = $this->gallery_category_model->get_gallery_cat(1, 0, array('id' => $Id));


    if (is_array($res) && !empty($res)) {
      $this->form_validation->set_rules('gallery_category', 'Category Name', 'trim|required|max_length[250]');
       $posted_friendly_url = $this->input->post('friendly_url');
    $this->cbk_friendly_url = seo_url_title($posted_friendly_url);
      //$this->form_validation->set_rules('details', 'Details', 'trim|required');

      if ($this->form_validation->run() == TRUE) {

        $posted_data = array(
            'name' => $this->input->post('gallery_category', TRUE),
            'friendly_url' => $this->cbk_friendly_url,
            'details' => $this->input->post('details', TRUE),
        );
         update_meta_page_url('gallery/index', $galleryId, $this->cbk_friendly_url);

        $where = "category_id = '" . $res['category_id'] . "'";
        $this->gallery_category_model->safe_update('wps_gallery_category', $posted_data, $where, FALSE);
        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', lang('successupdate'));

        redirect('wps-admin/gallery_category/' . query_string(), '');
      }

      $data['res'] = $res;
      $this->load->view('gallery/view_gallery_cat_edit', $data);
    } else {

      redirect('wps-admin/gallery_category', '');
    }
  }

}

//controllet end