<?php

class Pages extends Public_Controller {

  public function __construct() {

    parent::__construct();
    $this->load->helper(array('file', 'currency','category/category'));
    $this->load->library(array('Dmailer', 'safe_encrypt'));
    $this->load->model(array('pages/pages_model', 'members/members_model','category/category_model','products/product_model','blog/blog_model'));
    $this->lang->load('portuguese', 'portuguese');
    $this->form_validation->set_error_delimiters("<div class='required red'>", "</div>");
    $this->page_section_ct = 'static';
  }

  public function index() {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $this->load->view('pages/cms_page_view', $data);
  }
  
  public function member_data() { 

    $numRows=(int) $this->uri->segment(3);
    $offset=(int) $this->uri->segment(4);
    //echo '<pre>';print_r($this->uri->rsegments); print_r($this->uri->segments);exit();


    //$mres = $this->db2->query("SELECt * FROM member_tbl WHERE 1 and status='Y' order by memberID desc  limit 0,9")->result_array();
    $mres = $this->db->query("SELECt * FROM member_tbl WHERE 1 order by memberID asc limit $offset,$numRows")->result_array();
    //
    //trace($mres); exit();
    $member_id=0;
    if (is_array($mres) && !empty($mres)) {

      foreach ($mres as $mem) {
      
        $uploaded_file = $mem['companyLogo'];
        $infra_uploaded_file1 = "";
        $infra_uploaded_file2 = "";
        $infra_uploaded_file3 = "";
        $infra_uploaded_file4 = "";
      
        $business_nature_array = array("1" => "Buyer", "2" => "Supplier", "3" => "Buyer/Supplier");
      
        //$city = get_db_field_value("wps_cities_list", "id", "WHERE LOWER(city) = '" . strtolower($mem['city']) . "'");
        //$state = get_db_field_value("wps_states_list", "id", "WHERE LOWER(name) = '" . strtolower($mem['state']) . "'");
        $city = get_db_field_value("wps_cities_list", "id", "WHERE LOWER(TRIM(city)) = '".strtolower(trim(mysql_real_escape_string($mem['city'])))."'");
        //$state = get_db_field_value("wps_states_list", "id", "WHERE LOWER(TRIM(new_name)) = '".strtolower(trim(mysql_real_escape_string($mem['state'])))."'");
        $state = get_db_field_value("wps_states_list", "id", "WHERE LOWER(TRIM(name)) = '".strtolower(trim(mysql_real_escape_string($mem['state'])))."'");

        //$data['state'] = $this->db->query("SELECT id, name, country_id, temp_title, status FROM wps_states_list WHERE status ='1'")->result_array();

        $name = explode(' ', $mem['memberName']);
      
        if($mem['status']=='Y'){
          $status='1';
        }else if($mem['status']=='N'){
          $status='0';
        }else{
          $status='2';
        }
        if($mem['verifiedMember']=='Y'){
          $is_verified='1';
        }else{
          $is_verified='0';
        }

        //$countpro = count_record("wps_customers", "customers_id = '" . @$mem['memberID'] . "'");
        $countpro = count_record("wps_customers", "old_customers_id = '" . @$mem['memberID'] . "'");
        if ($countpro == 0) {
          $posted_data_customers = array(
            'old_customers_id' => @$mem['memberID'],
            'title' => @$mem['nameTitle'],
            'user_name' => @$mem['mobileNo'],
            'user_email' => @$mem['email'],
            'alt_email' => @$mem['alternateEmail'],
            'profile_picture' => @$mem['companyLogo'],//companyLogo //officeImage
            'password' => $this->safe_encrypt->encode(@$mem['pwd']),
            'first_name' => @$name[0],
            'last_name' => @$name[1],
            //'gender' => '',
            //'birth_date' => '',
            'mobile_number' => @$mem['mobileNo'],
            'alt_mobile' => @$mem['mobileNo2'],
            'phone_number' => @$mem['phone'],
            'company_name' => @$mem['companyName'],
            'designation' => '',
            'user_location' => '',
            'address' => @$mem['address'],
            'state' => $state,
            'city' => $city,
            'country' => @$mem['country'],
            'landmark' => '',
            'locality' => '',
            'website' => @$mem['website'],
            'website_activation' => '',
            'website_url' => '',
            'zipcode' => @$mem['zipcode'],
            'actkey' => md5($this->input->post('email')),
            'status' =>$status , //'1' 
            'is_verified' =>'1' , //$is_verified
            'is_self_verified' => '1',//0,1,2
            'is_manufacturer' => '1',//0,1,2
            'membershipType' => @$mem['membershipType'], //ownershipType//4
            'membershipStartDate' =>@$mem['activationDate'],
            'membershipEndDate' => @$mem['expiryDate'],
            'login_type' => 'normal', //enum('normal', 'facebook', 'twitter')
            'account_created_date' => @$mem['recvDate'],
            'current_login' => @$mem['lastlogin'],
            'last_login_date' => @$mem['lastlogin'],
            'ip_address' =>  @$mem['ipTrack'], //$this->input->ip_address(),
            //'is_blocked' => '',
           // 'is_featured' => '',
            //'block_time' => '',
            //'number_of_login_try' => '',
  
          );
          $customerID = $this->pages_model->safe_insert('wps_customers', $posted_data_customers, FALSE);
          $posted_customer_factsheet = array(
            'customers_id' => $customerID,
            'business_nature' => ($mem['businessNature']==1) ? '0' : '3', //'1'
            'business_nature_alt' => '',
            'ceo_name' => $mem['ownerName'],
            'registered_address' => $mem['address'],
            'about_company' => $mem['aboutUs'],
            'youtube_id' => $mem['companyVideo'],
            'employee_count' => $mem['companySize'], //1
            'establishment_year' => $mem['yoe'],
            'legal_firm_status' => '1',
            'promoter_name' => '',
            'turnover' => $mem['annualTurnover'],
            'building_infrastructure' => '',
            "infra_img" => '',
            "infra_img2" => '',
            "infra_img3" => '',
            "infra_img4" => '',
            'premises_size' => '',
            'premises_unit' => '',
            'competitive_advantage' => '',
            'contract_manufacturing' => '',
            'testing_facilities' => '',
            'ie_code' => '',
            'banker' => '',
            'gst_no' => '',
            'customized_packaging' => '',
            'payment_mode' => '',
            'shipment_mode' => '',
          ); 
    
          //trace($posted_customer_factsheet);
          $this->pages_model->safe_insert('wps_customers_factsheet', $posted_customer_factsheet, FALSE);
    
          $member_id=$customerID;


    
        }
      
      }
      echo $member_id.' load done';
      } 
      
  }

  public function category_data_old_to_new() { 
    //$mres = $this->db->query("select * FROM category_tbl where 1 and catgType!='2'")->result_array();
    //SELECT * FROM `category_tbl` WHERE `parentID` = 0
    //$mres = $this->db->query("select * FROM category_tbl WHERE parentID = 0 order by catID asc")->result_array();
    $mres = $this->db->query("select * FROM category_tbl where parentID != 0 order by catID asc")->result_array();
    $category_id=0;
    
    if (is_array($mres) && !empty($mres)) {
      //trace($mres); exit();

      $redirect_url = "category/index";
      foreach ($mres as $mem) {

        $friendly_url = seo_url_title($mem['catName']);

        $posted_data = array(
          'old_category_id' => $mem['catID'],
          'category_name' => $mem['catName'],
          'catType'=>$mem['catgType'],
          'category_alt' => $mem['catName'],
          'category_description' => $mem['catDesc1'],
          'coupon_code' => '',
          'coupon_value' => '',
          'parent_id' => $mem['parentID'],
          'friendly_url' => $friendly_url,
          'category_image' => $mem['catImage'],
          'category_icon' => $mem['catImage1'],
          'date_added' => $this->config->item('config.date.time'),
          'status' => ($mem['status']=='Y')? '1':'0'
        );

        $insertId = $this->category_model->safe_insert('wps_categories', $posted_data, FALSE);

        if ($insertId > 0) {

          if($mem['pageTitle']!=""){
            $meta_title=$mem['pageTitle'];
          }else{
            $meta_title=$mem['catName'];
          }

          if($mem['pageKeywords']!=""){
            $meta_keyword=$mem['pageKeywords'];
          }else{
            $meta_keyword=$mem['catName'];
          }

          if($mem['pageDescription']!=""){
            $meta_description=$mem['pageDescription'];
          }else{
            $meta_description=$mem['catDesc1'];
          }

          $meta_array = array(
              'entity_type' => $redirect_url,
              'entity_id' => $insertId,
              'page_url' => $friendly_url,
              'meta_title' => get_text($meta_title),
              'meta_description' => get_text($meta_description),
              'meta_keyword' => get_keywords($meta_keyword) 
          );
          //echo '<pre>';
          //print_r($posted_data);
          //print_r($meta_array);
          create_meta($meta_array);

        }
  
      $category_id=$insertId ;
      }
      echo $category_id.' category data upload with friendly url done';
    }
  }

  public function category_data_update_parentid() { 
    //$mres = $this->db->query("select parent_id,category_id FROM wps_categories where 1 and catType!='2'")->result_array();
    $mres = $this->db->query("select parent_id,category_id FROM wps_categories where 1 and parent_id != 0 order by category_id asc")->result_array();
    $category_id=0;
    if (is_array($mres) && !empty($mres)) {
      //trace($mres); exit();
      foreach ($mres as $mem) {
        $parent_id=(int) get_db_field_value("wps_categories", "category_id", "WHERE old_category_id = '" .$mem['parent_id'] . "'");
        $posted_data = array(
          'parent_id'=>$parent_id 
        );
        $where = "category_id = '" .$mem['category_id'] . "'";
        $this->category_model->safe_update('wps_categories', $posted_data, $where, FALSE);
        $category_id=$mem['category_id'];
      }
      echo $category_id.' category data update parent done';
    }
  }
  public function category_image_update() { 
    //$mres = $this->db->query("select parent_id,category_id FROM wps_categories where 1 and catType!='2'")->result_array();
    $mres = $this->db->query("select parent_id,category_id,category_image,category_icon,old_category_id FROM wps_categories where 1 order by category_id asc")->result_array();
    $category_id=0;
    if (is_array($mres) && !empty($mres)) {
      //trace($mres); exit();
      foreach ($mres as $mem) {
        $catImage= get_db_field_value("wps_categories_21_10", "category_image", "WHERE old_category_id = '" .$mem['old_category_id'] . "'");
        $catImage1= get_db_field_value("wps_categories_21_10", "category_icon", "WHERE old_category_id = '" .$mem['old_category_id'] . "'");
        $posted_data = array(
          'category_image' => $catImage,
          'category_icon' => $catImage1,
        );
        $where = "old_category_id = '" .$mem['old_category_id'] . "'";
        $this->category_model->safe_update('wps_categories', $posted_data, $where, FALSE);
        $category_id=$mem['category_id'];
      }
      echo $category_id.' category data update parent done';
    }
  }
  public function category_meta_metatags_tbls_metas() { 

    // $data['unq_section'] = "data";
    //$this->db2 = $this->load->database('nti', TRUE);
    $prods = $this->db->query("SELECt * FROM wps_meta_tags_21 WHERE entity_type='category/index' order by meta_id ASC")->result_array();
    //trace($prods); exit();
    //'entity_type' => $redirect_url,
    //'entity_id' => $insertId,
    //'page_url' => $friendly_url,
    //'meta_title' => get_text($meta_title),
    //'meta_description' => get_text($meta_description),
    //'meta_keyword' => get_keywords($meta_keyword) 
    $products_id=0;
       if (is_array($prods) && !empty($prods)) {
         
         foreach ($prods as $pro){
              $products_id++;

             $countpro = count_record("wps_meta_tags", "page_url = '" . $pro['page_url'] . "' and entity_type='category/index' ");
             if ($countpro) {
                   //update Meta
                 $posted_data = array(
                     'meta_title' => $pro['meta_title'],
                     'meta_description' => $pro['meta_description'],
                     'meta_keyword' => $pro['meta_keyword']
                 );
                 $where = "page_url = '" .$pro['page_url'] . "' and entity_type='category/index' ";
                 $this->pages_model->safe_update('wps_meta_tags', $posted_data, $where, FALSE);
              }
          }
           
      }
         echo 'total metas'. $products_id.' load done';
  }


  public function saveServerImage() {
    $encoded_file = $_POST['file'];
    $folder = $_POST['folder'];
    $filename = $_POST['filename'];
    //$oldfile = $_POST['oldfile'];
 
    if ($encoded_file != '0') {
      //add image to the server
      $dataImg = base64_decode($encoded_file);
      $success = file_put_contents(UPLOAD_DIR . '/' . $folder . '/' . $filename, $dataImg);
    }
 
    /* //delete old file
    if ($oldfile) {
      $unlink_image = array('source_dir' => $folder, 'source_file' => $oldfile);
      removeImage($unlink_image);
    }
    $path = IMG_CACH_DIR;
    $this->load->helper("file");
    delete_files($path);*/
  }
 
  public function blogs_data(){ 

    $blogsres = $this->db->query("select * FROM blog_tbl where 1 order by catID asc ")->result_array();
    $blog_id=0;
    
    if (is_array($blogsres) && !empty($blogsres)) {
      //trace($mres); exit();

      $redirect_url = "blog/details";

      foreach ($blogsres as $blog) {
        $bcounts = $this->db->query("SELECt article_id FROM wps_blog WHERE old_article_id='".$blog['catID']."' order by article_id ASC");
        $insertId=0;
        if($bcounts->num_rows()==0){
            $friendly_url = seo_url_title($blog['catName']);

            $posted_data = array(
              'old_article_id' => $blog['catID'],
              'article_title' => $blog['catName'],
              'friendly_url' => $friendly_url,
              'blog_author' => $blog['author'],
              'short_desc' => char_limiter(strip_tags(html_entity_decode($blog['catDesc1'])),440),
              'article_desc' => html_entity_decode($blog['catDesc1']).html_entity_decode($blog['catDesc2']).html_entity_decode($blog['catDesc3']),
              'article_image' =>trim($blog['catImage']),
              'display_order' => $blog['catOrder'],
              'post_date' => date('Y-m-d h:i:s',strtotime($blog['bdate'])),
              'status' => ($blog['status']=='Y')? '1':'0'
            );

            $insertId = $this->blog_model->safe_insert('wps_blog', $posted_data, FALSE);

            if ($insertId > 0) {

              //$org_image=UPLOAD_DIR."\blog_images\\".$blog['catImage'];
              //$destination=UPLOAD_DIR."\blog";
              //$img_name=basename($org_image);
             // $img_name=$blog['catImage'];
             // @rename( $org_image , $destination.'/'.$img_name );

              if($blog['pageTitle']!=""){
                $meta_title=$blog['pageTitle'];
              }else{
                $meta_title=$blog['catName'];
              }

              if($blog['pageKeywords']!=""){
                $meta_keyword=$blog['pageKeywords'];
              }else{
                $meta_keyword=$blog['catName'];
              }

              if($blog['pageDescription']!=""){
                $meta_description=$blog['pageDescription'];
              }else{
                $meta_description=$blog['catDesc1'];
              }
              $meta_array = array(
                  'entity_type' => $redirect_url,
                  'entity_id' => $insertId,
                  'page_url' => $friendly_url,
                  'meta_title' => get_text($meta_title),
                  'meta_description' => get_text($meta_description),
                  'meta_keyword' => get_keywords($meta_keyword) 
              );
              //echo '<pre>';
              //print_r($posted_data);
              //print_r($meta_array);
              create_meta($meta_array);
            }
          }
    
        $blog_id=$insertId ;
      }
      echo $blog_id.' blog data upload with friendly url done';
    }
  }

  public function products_data_old_16() { 

    $numRows=(int) $this->uri->segment(3);
    $offset=(int) $this->uri->segment(4);

    //echo '<pre>';print_r($this->uri->rsegments); print_r($this->uri->segments);exit();

    //$data['unq_section'] = "data";
   // $this->db2 = $this->load->database('nti', TRUE);

    //$prods = $this->db2->query("SELECt * FROM product_tbl WHERE 1 and mainCategory in (SELECT old_category_id FROM wps_categories WHERE old_category_id !=0) order by productID ASC limit $offset,$numRows")->result_array();
    //FIND_IN_SET("q", "s,q,l") //REPLACE(column name,'a','b')
    //SELECT * FROM `wps_categories` WHERE 1 `old_category_id``category_id``category_name``category_name`
    $check_cat_id=0;
    $cats = $this->db->query("SELECt old_category_id,category_id FROM wps_categories WHERE 1 and parent_id=0 and old_category_id>0 order by category_id asc limit $offset,$numRows ")->result_array();

    //$cats = $this->db->query("SELECt old_category_id,category_id FROM wps_categories WHERE 1 order by category_id asc limit $offset,$numRows ")->result_array();
    if (is_array($cats) && !empty($cats)) {

                // trace($cats); exit();
                $products_id=0;

      foreach ($cats as $cid) {
        $check_cat_id=$cid['category_id'];

          $ocid=$cid['old_category_id'];
   
          $prods = $this->db->query("SELECt * FROM product_tbl WHERE 1 and FIND_IN_SET($ocid,REPLACE(allCategories,'^',',')) order by productID ASC")->result_array();
         // $prods = $this->db->query("SELECt * FROM product_tbl WHERE 1 and mainCategory='".$ocid."' order by productID ASC")->result_array();
           //trace($prods); exit();

          
          if (is_array($prods) && !empty($prods)) {
            foreach ($prods as $pro) {


              $lastnode_ids=explode("^", $pro['industryType']);
              $cat_ids=array();
              $category_id='';
              $cat_id_val=0;
              if(is_array($lastnode_ids) && !empty($lastnode_ids)){
                  foreach($lastnode_ids as $catid){
                      if($catid){
                        $cat_id_val=(int) get_db_field_value("wps_categories", "category_id", "WHERE old_category_id = '" .$catid . "'");
                        if($cat_id_val){
                          $cat_ids[] =$cat_id_val;
                        }
                      }
                  }
                  $cat_ids=array_unique($cat_ids);
                  $category_id=implode(",",$cat_ids);
              }
 
              $allCategories_ids=explode("^", $pro['allCategories']);
              $allcat_ids=array();
              $category_links='';
              $cat_id_val=0;
              if(is_array($allCategories_ids) && !empty($allCategories_ids)){
                  foreach($allCategories_ids as $catid){
                      if($catid){
                        $cat_id_val=(int) get_db_field_value("wps_categories", "category_id", "WHERE old_category_id = '" .$catid . "'");
                        if($cat_id_val){
                          $allcat_ids[] =$cat_id_val;
                        }
                      }
                  }
                  //$allcat_ids=array_unique($allcat_ids);
                  $category_links=implode(",",$allcat_ids);
              }
              if($category_id==''){
                $category_id=$check_cat_id;
              }
              if($category_id==''){
                $category_links=$check_cat_id;
              }
            
          
              //$category_id =(int) get_db_field_value("wps_categories", "category_id", "WHERE old_category_id = '" .$pro['mainCategory'] . "'");
              $customers_id =(int) get_db_field_value("wps_customers", "customers_id", "WHERE old_customers_id = '" . $pro['memberID'] . "'");
            
              if($pro['status']=='Y'){
                $status='1';
              }else if($pro['status']=='N'){
                $status='0';
              }else{
                $status='2';
              }

              $productType='0';

              if($pro['prostatus']=='2'){  // in old 2 is service
                $productType='1';   //1 it means service
              }
              if($pro['prostatus']=='1'){  // in old 1 is product
                $productType='0'; //0 it means product in new product table  0 = Products, 1 = Services
              }
              if($pro['prostatus']=='3'){  // in old 3 is courses product
                $productType='2'; //0 it means product in new product table  0 = Products, 1 = Services
              }

              $sql_num_pro=$this->db->query("select product_name from wps_products where old_products_id = '".@$pro['productID']."' ");
              $countpro=$sql_num_pro->num_rows();

              //$countpro = count_record("wps_products", "old_products_id = '".@$pro['productID']."'");

              if ($countpro == 0) {
          
                  //$postCategory[] = $cat_ids ;
                  //$category_links = "";
                  //$catlink = $ctl = "";
                  /* foreach ($postCategory as $ctv) {
                    $catlink = get_parent_categories($ctv, "AND status='1'", "category_id,parent_id");
                    $ctl = array_keys($catlink);
                    $category_links .= implode(",", $ctl) . ',';
                  }
                  $category_links = substr($category_links, 0, -1); */

                  $posted_data = array( 
                      'customers_id' => $customers_id,
                      'productType'=>$productType,
                      'old_products_id'=>$pro['productID'],
                      'category_id' => $category_id,
                      'category_links' => $category_links,
                      'product_name' => $pro['productName'],
                      'product_code' => $pro['productCode'],
                      'moq' => '',
                      'product_price' => ($pro['discountedPrice']>0)?$pro['discountedPrice']:$pro['productPrice'],
                      'unit_value' => '',
                      'unit_measurement' =>  '',
                      'product_alt' => $pro['productName'],
                      'attribute_name' => '',
                      'attribute_value' => '',
                      'dispatch_port' => '',
                      'delivery_time' => $pro['deliveryTime'],
                      'packaging_details' => '',
                      'dashkeyword' => $pro['keyword'],
                      'products_description' => $pro['completeDescription'],
                      'youtube_id' => '',
                      'product_added_date' => $pro['recvDate'],
                      'status'=>$status
                      //	
                  );

                  $productId = $this->product_model->safe_insert('wps_products', $posted_data, FALSE);
                  if ($productId > 0) {
                    $this->cbk_friendly_url = seo_url_title($pro['productName'] . ' ' . $productId);

                    //update friendly_url
                    $this->db->query("UPDATE wps_products SET friendly_url = '" . $this->cbk_friendly_url . "' WHERE products_id = '" . $productId . "'");

                    //add images to table
                    $pic1=$pro['image1'];
                    $is_default = 'Y';
                    if ($pic1) {
                      $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic1 . "', products_id = '" . $productId . "', media_date_added = '" . $pro['recvDate'] . "', is_default = '" . $is_default . "'");
                      $is_default = 'N';
                    }
                    //End
                    //Create Meta
                    $redirect_url = "products/detail";
                    $meta_array = array(
                        'entity_type' => $redirect_url,
                        'entity_id' => $productId,
                        'page_url' => $this->cbk_friendly_url,
                        'meta_title' => get_text($pro['productName'], 80),
                        'meta_description' => get_text($pro['completeDescription']),
                        'meta_keyword' => get_keywords($pro['productName'])
                    );
                    create_meta($meta_array);
                  }
          
              }
            
            }
            
          }
      }
      echo 'category_id'.$check_cat_id.'total products'. $productId.' load done';
    }else{ echo 'no records';}
  }
  public function products_data() { 

    $numRows=(int) $this->uri->segment(3);
    $offset=(int) $this->uri->segment(4);

    //echo '<pre>';print_r($this->uri->rsegments); print_r($this->uri->segments);exit();

    //$data['unq_section'] = "data";
   // $this->db2 = $this->load->database('nti', TRUE);

    //$prods = $this->db2->query("SELECt * FROM product_tbl WHERE 1 and mainCategory in (SELECT old_category_id FROM wps_categories WHERE old_category_id !=0) order by productID ASC limit $offset,$numRows")->result_array();
    //FIND_IN_SET("q", "s,q,l") //REPLACE(column name,'a','b')
    //SELECT * FROM `wps_categories` WHERE 1 `old_category_id``category_id``category_name``category_name`
    $check_cat_id=0;
    ///$cats = $this->db->query("SELECt old_category_id,category_id FROM wps_categories WHERE 1 and parent_id=0 and old_category_id>0 order by category_id asc limit $offset,$numRows ")->result_array();

    //$cats = $this->db->query("SELECt old_category_id,category_id FROM wps_categories WHERE 1 order by category_id asc limit $offset,$numRows ")->result_array();
    ///if (is_array($cats) && !empty($cats)) {

                // trace($cats); exit();
                $products_id=0;

      ///foreach ($cats as $cid) {
        //$check_cat_id=$cid['category_id'];

          //$ocid=$cid['old_category_id'];
   
          //$prods = $this->db->query("SELECt * FROM product_tbl WHERE 1 and FIND_IN_SET($ocid,REPLACE(allCategories,'^',',')) order by productID ASC")->result_array();
          $prods = $this->db->query("SELECt * FROM product_tbl WHERE 1  order by productID ASC limit $offset,$numRows")->result_array();
         // $prods = $this->db->query("SELECt * FROM product_tbl WHERE 1 and mainCategory='".$ocid."' order by productID ASC")->result_array();
           //trace($prods); exit();

          
          if (is_array($prods) && !empty($prods)) {
            foreach ($prods as $pro) {

              //$pro['mainCategory']

              $lastnode_ids=explode("^", $pro['industryType']);
              $cat_ids=array();
              $category_id='';
              $cat_id_val=0;
              if(is_array($lastnode_ids) && !empty($lastnode_ids)){
                  foreach($lastnode_ids as $catid){
                      if($catid){
                        $cat_id_val=(int) get_db_field_value("wps_categories", "category_id", "WHERE old_category_id = '" .$catid . "'");
                        if($cat_id_val){
                          $cat_ids[] =$cat_id_val;
                        }
                      }
                  }
                  $cat_ids=array_unique($cat_ids);
                  $category_id=implode(",",$cat_ids);
              }
              
              /*
              $allCategories_ids=explode("^", $pro['allCategories']);
              $allcat_ids=array();
              $category_links='';
              $cat_id_val=0;
              if(is_array($allCategories_ids) && !empty($allCategories_ids)){
                  foreach($allCategories_ids as $catid){
                      if($catid){
                        $cat_id_val=(int) get_db_field_value("wps_categories", "category_id", "WHERE old_category_id = '" .$catid . "'");
                        if($cat_id_val){
                          $allcat_ids[] =$cat_id_val;
                        }
                      }
                  }
                  $allcat_ids=array_unique($allcat_ids);
                  $category_links=implode(",",$allcat_ids);
              }*/

              $category_links = "";
              if($category_id){
              $postCategory = explode(",",$category_id);
              $category_links = "";
              $catlink = $ctl = "";
              foreach ($postCategory as $ctv) {
                $catlink = get_parent_categories($ctv, "AND status='1'", "category_id,parent_id");
                $ctl = array_keys($catlink);
                $category_links .= implode(",", $ctl) . ',';
              }
              $category_links = substr($category_links, 0, -1);
              }
  
              if($category_id=='' && $pro['mainCategory']!=""){
                $category_id=$pro['mainCategory'];
                $category_links=$pro['mainCategory'];
              }

              /*  
              if($category_id==''){
                $category_id=$check_cat_id;
              }
              if($category_id==''){
                $category_links=$check_cat_id;
              }*/
            
          
              //$category_id =(int) get_db_field_value("wps_categories", "category_id", "WHERE old_category_id = '" .$pro['mainCategory'] . "'");
              $customers_id =(int) get_db_field_value("wps_customers", "customers_id", "WHERE old_customers_id = '" . $pro['memberID'] . "'");
            
              if($pro['status']=='Y'){
                $status='1';
              }else if($pro['status']=='N'){
                $status='0';
              }else{
                $status='2';
              }

              $productType='0';

              if($pro['prostatus']=='2'){  // in old 2 is service
                $productType='1';   //1 it means service
              }
              if($pro['prostatus']=='1'){  // in old 1 is product
                $productType='0'; //0 it means product in new product table  0 = Products, 1 = Services
              }
              if($pro['prostatus']=='3'){  // in old 3 is courses product
                $productType='2'; //0 it means product in new product table  0 = Products, 1 = Services
              }

              $sql_num_pro=$this->db->query("select product_name from wps_products where old_products_id = '".@$pro['productID']."' ");
              $countpro=$sql_num_pro->num_rows();

              //$countpro = count_record("wps_products", "old_products_id = '".@$pro['productID']."'");

              if ($countpro == 0) {
          
                  //$postCategory[] = $cat_ids ;
                  //$category_links = "";
                  //$catlink = $ctl = "";
                  /* foreach ($postCategory as $ctv) {
                    $catlink = get_parent_categories($ctv, "AND status='1'", "category_id,parent_id");
                    $ctl = array_keys($catlink);
                    $category_links .= implode(",", $ctl) . ',';
                  }
                  $category_links = substr($category_links, 0, -1); */

                  $posted_data = array( 
                      'customers_id' => $customers_id,
                      'productType'=>$productType,
                      'old_products_id'=>$pro['productID'],
                      'category_id' => $category_id,
                      'category_links' => $category_links,
                      'product_name' => $pro['productName'],
                      'product_code' => $pro['productCode'],
                      'moq' => '',
                      'product_price' => ($pro['discountedPrice']>0)?$pro['discountedPrice']:$pro['productPrice'],
                      'unit_value' => '',
                      'unit_measurement' =>  '',
                      'product_alt' => $pro['productName'],
                      'attribute_name' => '',
                      'attribute_value' => '',
                      'dispatch_port' => '',
                      'delivery_time' => $pro['deliveryTime'],
                      'packaging_details' => '',
                      'dashkeyword' => $pro['keyword'],
                      'products_description' => $pro['completeDescription'],
                      'youtube_id' => '',
                      'product_added_date' => $pro['recvDate'],
                      'status'=>$status
                      //	
                  );

                  $productId = $this->product_model->safe_insert('wps_products', $posted_data, FALSE);
                  if ($productId > 0) {
                    $this->cbk_friendly_url = seo_url_title($pro['productName'] . ' ' . $productId);

                    //update friendly_url
                    $this->db->query("UPDATE wps_products SET friendly_url = '" . $this->cbk_friendly_url . "' WHERE products_id = '" . $productId . "'");

                    //add images to table
                    $pic1=$pro['image1'];
                    $is_default = 'Y';
                    if ($pic1) {
                      $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic1 . "', products_id = '" . $productId . "', media_date_added = '" . $pro['recvDate'] . "', is_default = '" . $is_default . "'");
                      $is_default = 'N';
                    }
                    //End
                    //Create Meta
                    $redirect_url = "products/detail";
                    $meta_array = array(
                        'entity_type' => $redirect_url,
                        'entity_id' => $productId,
                        'page_url' => $this->cbk_friendly_url,
                        'meta_title' => get_text($pro['productName'], 80),
                        'meta_description' => get_text($pro['completeDescription']),
                        'meta_keyword' => get_keywords($pro['productName'])
                    );
                    create_meta($meta_array);
                  }
          
              }
            
            }
            echo 'category_id'.$category_id.'total products'. $productId.' load done';

          }else{ echo 'no records';}
      ///}
      ///echo 'category_id'.$check_cat_id.'total products'. $productId.' load done';
    ///}else{ echo 'no records';}
  }

  public function products_data_update_category_list_final() { 
    $numRows=(int) $this->uri->segment(3);
    $offset=(int) $this->uri->segment(4); //SELECT * FROM `product_tbl_21_10_2020`
    //echo "SELECT productID,mainCategory,industryType FROM product_tbl WHERE 1 order by productID ASC limit $offset,$numRows ";
    //exit();
    $prods = $this->db->query("SELECT productID,mainCategory,industryType FROM product_tbl_21_10_2020 WHERE 1 order by productID ASC limit $offset,$numRows")->result_array();
    //$prods = $this->db->query("SELECt * FROM wps_products WHERE 1  order by products_id ASC limit $offset,$numRows")->result_array();
      $cids=''; $countp=0;
        if (is_array($prods) && !empty($prods)) {
          foreach ($prods as $pro) {
            $countp++;
            //$pro['mainCategory'] category_id wps_categories

            $lastnode_ids=explode("^", $pro['industryType']);
            $cat_ids=array();
            $category_id='';
            $cat_id_val=0;
            if(is_array($lastnode_ids) && !empty($lastnode_ids)){
                foreach($lastnode_ids as $catid){
                    if($catid){
                      $cat_id_val=(int) get_db_field_value("wps_categories", "category_id", "WHERE old_category_id = '" .$catid . "'");
                      if($cat_id_val){
                        $cat_ids[] =$cat_id_val;
                      }
                    }
                }
                $cat_ids=array_unique($cat_ids);
                $category_id=implode(",",$cat_ids);
            }
                $category_links = "";
 
              if($category_id){
                  //$cids=$pro['category_id'];
                  $postCategory = explode(",",$category_id);
                  $category_links = "";
                  $catlink = $ctl = "";
                  foreach ($postCategory as $ctv) {
                    $catlink = get_parent_categories($ctv, "AND status='1'", "category_id,parent_id");
                    $ctl = array_keys($catlink);
                    $category_links .= implode(",", $ctl) . ',';
                  }
                  $category_links = substr($category_links, 0, -1);
              }
                
              if($category_id=='' && $pro['mainCategory']!=""){
                $category_id=$pro['mainCategory'];
                $category_links=$pro['mainCategory'];
              }

              //$this->db->query("UPDATE wps_products SET category_links = '" . $category_links . "' WHERE products_id = '" . $pro['products_id'] . "'");
              $this->db->query("UPDATE wps_products SET category_id='".$category_id."',category_links = '" . $category_links . "' WHERE old_products_id = '" . $pro['productID'] . "'");
              
          }
            echo 'category_id'.$category_id.'total products'. $pro['productID'].' load done';

        }else{ echo 'no records';}
  }

  public function products_data_update_category_list() { 
    $numRows=(int) $this->uri->segment(3);
    $offset=(int) $this->uri->segment(4);
      $prods = $this->db->query("SELECt * FROM wps_products WHERE 1  order by products_id ASC limit $offset,$numRows")->result_array();
      $cids=''; 
        if (is_array($prods) && !empty($prods)) {
          foreach ($prods as $pro) {
                //$pro['mainCategory'] category_id wps_categories
                $cids=$pro['category_id'];
            $postCategory = explode(",",$pro['category_id']);
            $category_links = "";
            $catlink = $ctl = "";
            foreach ($postCategory as $ctv) {
              $catlink = get_parent_categories($ctv, "AND status='1'", "category_id,parent_id");
              $ctl = array_keys($catlink);
              $category_links .= implode(",", $ctl) . ',';
            }
            $category_links = substr($category_links, 0, -1);
            $this->db->query("UPDATE wps_products SET category_links = '" . $category_links . "' WHERE products_id = '" . $pro['products_id'] . "'");
              
          }
            echo 'category_id'.$pro['category_id'].'total products'. $pro['products_id'].' load done';

        }else{ echo 'no records';}
  }

  public function products_metas() { 

       // $data['unq_section'] = "data";
        //$this->db2 = $this->load->database('nti', TRUE);

          $prods = $this->db->query("SELECt * FROM wps_products WHERE 1 order by products_id ASC")->result_array();
           //trace($prods); exit();
           $products_id=0;
          if (is_array($prods) && !empty($prods)) {
            
            foreach ($prods as $pro){
                $countpro = count_record("wps_meta_tags", "page_url = '" . $pro['friendly_url'] . "' and entity_id='".$pro['products_id']."'");
                if ($countpro == 0) {
                      //Create Meta
                    $redirect_url = "products/detail";
                    $meta_array = array(
                        'entity_type' => $redirect_url,
                        'entity_id' => $pro['products_id'],
                        'page_url' => $pro['friendly_url'],
                        'meta_title' => get_text($pro['product_name'], 80),
                        'meta_description' => get_text($pro['products_description']),
                        'meta_keyword' => get_keywords($pro['product_name'])
                    );
                    create_meta($meta_array);
                  }
              }
              $products_id= $pro['products_id'];
          }
            echo 'total products'. $products_id.' load done';
  }
  
  public function products_enquiry_data() {

    $numRows=(int) $this->uri->segment(3);
    $offset=(int) $this->uri->segment(4);

      $prods = $this->db->query("SELECt * FROM business_enquiry_tbl WHERE 1 and inquiryID='' and memberID!='' order by slno ASC limit $offset,$numRows")->result_array();
      //trace($prods); exit();
      if (is_array($prods) && !empty($prods)) {
        foreach ($prods as $pro) {
      
          //$products_id  =(int) get_db_field_value("wps_products", "products_id ", "WHERE old_products_id = '" .$pro['mainCategory'] . "'");
          $customers_id =(int) get_db_field_value("wps_customers", "customers_id", "WHERE old_customers_id = '" . $pro['memberID'] . "'");
        
          if($pro['status']=='Y'){
            $status='1';
          }else if($pro['status']=='N'){
            $status='0';
          }else{
            $status='2';
          }

          $first_name='';
          $last_name='';
          $quantity=0;
          $post_url='';
          $locArray=array();
          $location='';//address,city,state,country
          if($pro['address']!=""){
            $locArray[]=$pro['address'];
          }
          if($pro['city']!=""){
            $locArray[]=$pro['city'];
          }
          if($pro['state']!=""){
            $locArray[]=$pro['state'];
          }
          if($pro['country']!=""){
            $locArray[]=$pro['country'];
          }
          if(is_array($locArray)&& !empty($locArray)){
            $location=implode(', ',$locArray);
          }

          /*
         if($pro['personName']!=""){
            $fname=explode(" ",$pro['personName']);
            if(is_array($fname) && $fname[0]!=""){
              $first_name=$fname[0];
            }
            if(is_array($fname) && $fname[1]!=""){
              $last_name=$fname[1];
            }
         } */

         //$type=4; //1

         $type=1; //1

          $sql_num_pro=$this->db->query("select email from wps_enquiry where old_enquiry_id = '".@$pro['slno']."' ");
          $countpro=$sql_num_pro->num_rows();

          //SELECT * FROM `business_enquiry_tbl` WHERE 1`slno`, `inquiryID`, `memID`, `contactName`, `companyName`, `email`, `mobile`, `mobileNo2`, `phone`, `fax`, `subject`, `keyword`, `forwardstatus`, `comments`, `replyEmail`, `country`, `address`, `city`, `state`, `ref_id`, `source`, `memberstatus`, `memberID`, `recvDate`, `status`, `memberType`, `replyStatus`, `ipTrack`, `action`, `pageurl`, `zipcode`, `buytype`, `unit`, `qut`

          if ($countpro == 0) {
              $posted_data = array(
                'type' => $type,
                'old_enquiry_id'=>$pro['slno'],
                //'products_id'=>$products_id ,
                'customers_id'=>$customers_id,
                'first_name' => $pro['contactName'],
                'last_name' => $last_name,
                'email' => $pro['email'],
                'mobile_number' => $pro['mobile'],
                'message' => $pro['comments'],
                'quantity' => $quantity,
                'post_url' => $post_url, //pageurl
                'location' => $location,
                'receive_date' =>$pro['recvDate'],
                'ip_address'=>$pro['ipTrack']
              );
              $productId = $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);
          }
        
        }
        echo 'total enquiries'. $productId.' load done';

      }else{ echo 'no records';}

  }
  

  public function enquiry_data() {

    $numRows=(int) $this->uri->segment(3);
    $offset=(int) $this->uri->segment(4);

      $prods = $this->db->query("SELECt * FROM enquiry_tbl WHERE 1  order by slno ASC limit $offset,$numRows")->result_array();
      //trace($prods); exit();
      if (is_array($prods) && !empty($prods)) {
        foreach ($prods as $pro) {
      
          //$category_id =(int) get_db_field_value("wps_categories", "category_id", "WHERE old_category_id = '" .$pro['mainCategory'] . "'");
          //$customers_id =(int) get_db_field_value("wps_customers", "customers_id", "WHERE old_customers_id = '" . $pro['memberID'] . "'");
        
          if($pro['status']=='Y'){
            $status='1';
          }else if($pro['status']=='N'){
            $status='0';
          }else{
            $status='2';
          }

          $first_name='';
          $last_name='';
          $locArray=array();
          $location='';//address,city,state,country
          if($pro['address']!=""){
            $locArray[]=$pro['address'];
          }
          if($pro['city']!=""){
            $locArray[]=$pro['city'];
          }
          if($pro['state']!=""){
            $locArray[]=$pro['state'];
          }
          if($pro['zipcode']!=""){
            $locArray[]=$pro['zipcode'];
          }
          if($pro['country']!=""){
            $locArray[]=$pro['country'];
          }

          if(is_array($locArray)&& !empty($locArray)){
            $location=implode(', ',$locArray);
          }
          
          /*
         if($pro['personName']!=""){
            $fname=explode(" ",$pro['personName']);
            if(is_array($fname) && $fname[0]!=""){
              $first_name=$fname[0];
            }
            if(is_array($fname) && $fname[1]!=""){
              $last_name=$fname[1];
            }
         } */

         $type=1;

          $sql_num_pro=$this->db->query("select email from wps_enquiry where old_enquiry_id = '".@$pro['slno']."' ");
          $countpro=$sql_num_pro->num_rows();

          //SELECT * FROM `enquiry_tbl` WHERE 1 `slno`, `personName`, `companyName`, `email`, `phone`, `fax`, `address`, `city`, `state`, `country`, `zipcode`, `comments`, `status`, `recvDate`

          if ($countpro == 0) {
              $posted_data = array(
                'type' => $type,
                'old_enquiry_id'=>$pro['slno'],
                'first_name' => $pro['personName'],
                'last_name' => $last_name,
                'email' => $pro['email'],
                'mobile_number' => $pro['phone'],
                'message' => $pro['comments'],
                'location' => $location,
                'receive_date' =>$pro['recvDate'],
                'ip_address'=>''
              );
              $productId = $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);
          }
        
        }
        echo 'total enquiries'. $productId.' load done';

      }else{ echo 'no records';}

  }


  public function aboutus() {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $data['banner'] = get_db_field_value("wps_banners", "banner_image", "WHERE banner_page='about' ORDER BY RAND()");
    $this->load->view('pages/about', $data);
  }

  public function contactus() {
    
    //trace($_SERVER['HTTP_REFERER']);
    
    $this->form_validation->set_rules('type', 'Purpose of Contacting', 'trim|required');
    $this->form_validation->set_rules('first_name', 'First Name', 'trim|required');
    $this->form_validation->set_rules('last_name', 'Last Name', 'trim|required');
    $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
    $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required');
    $this->form_validation->set_rules('message', 'Comment', 'trim|required');

    if ($this->form_validation->run() == TRUE) {
      //Google Recaptcha validation
      $recaptchaResponse = trim($this->input->post('g-recaptcha-response'));
      $userIp = $this->input->ip_address();
      $secret = $this->config->item('google_secret');
      $url = "https://www.google.com/recaptcha/api/siteverify?secret=" . $secret . "&response=" . $recaptchaResponse . "&remoteip=" . $userIp;
      //Request
      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $url);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
      $output = curl_exec($ch);
      curl_close($ch);
      $status = json_decode($output, true);
      if ($status['success']) { // Success
        $posted_data = array(
            'type' => $this->input->post('type'),
            'first_name' => $this->input->post('first_name'),
            'last_name' => $this->input->post('last_name'),
            'email' => $this->input->post('email'),
            'mobile_number' => $this->input->post('phone'),
            'message' => $this->input->post('message'),
            'receive_date' => $this->config->item('config.date.time')
        );
        $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);

        //Mail
        $subject = 'New query have been posted on '.$this->config->item('site_name');
        $content = get_content('wps_auto_respond_mails', '5');
        $name = $this->input->post('first_name'). ' '. $this->input->post('last_name');
        $body = $content->email_content;
        $body = str_replace('{mem_name}', $name, $body);
        $body = str_replace('{email}', $this->input->post('email'), $body);
        $body = str_replace('{phone}', $this->input->post('phone'), $body);
        $body = str_replace('{comments}', $this->input->post('message'), $body);
        $body = str_replace('{site_name}', $this->config->item('site_name'), $body);
        $body = str_replace('{admin_email}', $this->config->item('site_name'), $body);
        $mail_conf = array(
            'subject' => "Enquiry from " . $name . " ",
            'to_email' => "kirpanand@webpulseindia.com",
            'from_email' => $this->input->post('email'),
            'from_name' => $name,
            'body_part' => $body
        );
        //trace($mail_conf);
        //exit;
        $this->dmailer->mail_notify($mail_conf);

        $msg = "Your request has been sent successfully ! We will get back to you shortly !";
        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', $msg);
        redirect(base_url('contact-us'));
      } else {
        $this->session->set_userdata(array('msg_type' => 'error'));
        $this->session->set_flashdata('error', "Sorry Google Recaptcha Unsuccessful!! Please try again !");
        //$this->session->set_userdata(array('error' => "Sorry Google Recaptcha Unsuccessful!!"));
      }
        
    }

    $data['title'] = "Contact Us";
    $this->load->view('contactus', $data);
  }

  public function bulk_orders() {
    $this->form_validation->set_rules('product', 'Product', 'trim|required');
    $this->form_validation->set_rules('name', 'Your Name', 'trim|required');
    $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
    $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required');
    $this->form_validation->set_rules('country', 'Country', 'trim|required');
    $this->form_validation->set_rules('message', 'Comment', 'trim|required');

    if ($this->form_validation->run() == TRUE) {

      $posted_data = array(
          'product_id' => $this->input->post('product'),
          'first_name' => $this->input->post('name'),
          'last_name' => '',
          'email' => $this->input->post('email'),
          'phone_number' => $this->input->post('phone'),
          'mobile_number' => '',
          'country' => $this->input->post('country'),
          'message' => $this->input->post('message'),
          'receive_date' => $this->config->item('config.date.time')
      );
      $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);

      //Mail
      $subject = 'New bulk order query have been posted on '.$this->config->item('site_name');
      $content = get_content('wps_auto_respond_mails', '5');
      $body = $content->email_content;
      $body = str_replace('{name}', $this->input->post('name'), $body);
      $body = str_replace('{email}', $this->input->post('email'), $body);
      $body = str_replace('{phone}', $this->input->post('phone_number'), $body);
      $body = str_replace('{country}', $this->input->post('country'), $body);
      $body = str_replace('{comment}', $this->input->post('message'), $body);
      $body = str_replace('{site_name}', $this->config->item('site_name'), $body);
      $mail_conf = array(
          'subject' => "Enquiry from " . ucwords($this->input->post('name')) . " ",
          'to_email' => " demo@gmail.com",
          'from_email' => $this->input->post('email'),
          'from_name' => $this->input->post('name'),
          'body_part' => $body
      );
      //trace($mail_conf);
      //exit;
      $this->dmailer->mail_notify($mail_conf);

      $msg = "Your request has been sent successfully ! We will get back to you shortly !";
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', $msg);
      redirect(base_url('contactus#contactusform'));
    }
    $data['products'] = $this->db->query("SELECT products_id, product_name FROM wps_products WHERE status = '1'")->result_array();
    $data['title'] = "Bulk Order";
    $this->load->view('bulk_orders', $data);
  }

  public function sitemap() {
    $data['title'] = "Site Map";
    $this->load->view('sitemap', $data);
  }

  public function connect() {
    $data = array();
    $resCrafter = array();
    $res = array();

    $strQr = $ageStart = $ageEnd = "";
    //Solo Travelers
    $condtion = array();
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : 24;
    $page_segment = find_paging_segment();
    $offset = (int) $this->uri->segment($page_segment, 0);
    $base_url = $base_url = "pages/connect/pg/";


    $status = $this->input->get_post('status', TRUE);
    if ($status != '') {
      $condtion['status'] = $status;
    }

    $country = $this->input->get_post('country', TRUE);
    if ($country != '') {
      $condtion['country'] = $country;
    }

    $state = $this->input->get_post('state', TRUE);
    if ($state != '') {
      $condtion['state'] = $state;
    }

    $category = $this->input->get_post('category', TRUE);
    if ($category != '') {
      $condtion['category'] = $category;
    }

    $age = $this->input->get_post('age', TRUE);
    if ($age != '') {
      $ageStart = date("Y", mktime(0, 0, 0, date('d'), date('m'), date('Y') - $age));
      $condtion['age'] = $ageStart;
    }

    $gender = $this->input->get_post('gender', TRUE);
    if ($gender != '') {
      $condtion['gender'] = $gender;
    }


    //Travel category
    $resultPassion = $this->user_category_model->get_usercat($opts = array());
    $data['Usercatlist'] = array();
    if (is_array($resultPassion) && !empty($resultPassion)) {
      $data['Usercatlist'] = $resultPassion;
    }

    $res_array = $this->members_model->get_members($config['limit'], $offset, $condtion);  //echo_sql();
    $total_record = get_found_rows();
    $data['total_rows'] = $total_record;
    $data['page_links'] = front_pagination($base_url, $total_record, $config['limit'], $page_segment);
    //End Here

    $data['soloRes'] = $res_array;

    $data['title'] = "Connect";
    $this->load->view('pages/connect', $data);
  }

  public function thanks() {
    $data['heading_title'] = "Thanks";
    $this->load->view('pages/thanks', $data);
  }

  public function page_not_found() {
    $this->meta_info['meta_title'] = '404 page not found';
    $this->load->view('pages/view_404'); //loading in my template 
  }

  private function subscribe_newsletter($posted_data) {
    $query = $this->db->query("SELECT subscriber_email,status FROM  wps_newsletters WHERE subscriber_email='$posted_data[subscriber_email]'");
    $subscribe_me = $posted_data['subscribe_me'];

    if ($query->num_rows() > 0) {
      $row = $query->row_array();
      if ($row['status'] == '0' && ($subscribe_me == 'Y')) {
        $where = "subscriber_email = '" . $row['subscriber_email'] . "'";
        $this->pages_model->safe_update('wps_newsletters', array('status' => '1'), $where, FALSE);
        $msg = $this->config->item('newsletter_subscribed');
        return $msg;
      } else if ($row['status'] == '0' && ($subscribe_me == 'N')) {
        $msg = $this->config->item('newsletter_not_subscribe');
        return $msg;
      } else if ($row['status'] == '1' && ($subscribe_me == 'Y')) {
        $msg = $this->config->item('newsletter_already_subscribed');
        return $msg;
      } else if ($row['status'] == '1' && ($subscribe_me == 'N')) {
        $where = "subscriber_email = '" . $row['subscriber_email'] . "'";
        $this->pages_model->safe_update('wps_newsletters', array('status' => '0'), $where, FALSE);
        $msg = $this->config->item('newsletter_unsubscribed');
        return $msg;
      }
    } else {
      if ($subscribe_me == 'N') {
        $msg = $this->config->item('newsletter_not_subscribe');
        return $msg;
      } else {
        $data = array('status' => '1', 'subscriber_name' => $posted_data['subscriber_name'], 'subscriber_email' => $posted_data['subscriber_email']);
        $this->pages_model->safe_insert('wps_newsletters', $data);
        $msg = $this->config->item('newsletter_subscribed');
        return $msg;
      }
    }
  }

  public function newsletter() {
    $data['default_email_text'] = "Email Id";
    $this->form_validation->set_rules('subscriber_name', 'Name', 'trim|required|max_length[225]');
    $this->form_validation->set_rules('subscriber_email', 'Email', 'trim|required|valid_email|max_length[255]');
    $this->form_validation->set_rules('subscribe_me', 'Status', 'trim|required');
    $this->form_validation->set_rules('verification_code', 'Verification Code', 'trim|required|valid_captcha_code');
    if ($this->form_validation->run() == TRUE) {
      $res = $this->pages_model->add_newsletter_member();
      $this->session->set_userdata('msg_type', $res['error_type']);
      $this->session->set_flashdata($res['error_type'], $res['error_msg']);
      redirect('pages/newsletter', '');
    }
    $this->load->view('view_subscribe_newsletter', $data);
  }

  public function join_newsletter() {
    $subscriber_name = $this->input->post('newsletter_name', TRUE);
    $subscriber_email = $this->input->post('newsletter_email', TRUE);

    $this->form_validation->set_rules('newsletter_name', 'Name', "trim|required|alpha|max_lenght[200]");
    $this->form_validation->set_rules('newsletter_email', 'Email ID', "trim|required|valid_email|max_lenght[80]");
    $this->form_validation->set_rules('newsletter_captcha', 'Verification code', 'trim|required|valid_captcha_code');

    if ($this->form_validation->run() == TRUE) {
      $subscribe_me = $this->input->post('subscribe_me', TRUE);

      $posted_data = array('subscriber_name' => $subscriber_name, 'subscriber_email' => $subscriber_email, 'subscribe_me' => $subscribe_me);
      $result = $this->subscribe_newsletter($posted_data);
      if ($result) {
        //echo '<div style="color:#009900">'.$result.'</div>';
        $res = array('error_type' => 'sucess', 'error_msg' => '<div style="color:#009900">' . $result . '</div>');
      }
    } else {
      //echo '<p style="color:#009900">'.validation_errors().'</p>';
      $res = array('error_type' => 'error', 'error_msg' => validation_errors());
    }

    echo json_encode($res);
    exit;
  }

  public function get_country() {
    $country = $this->db->query("SELECT id, country_name, status FROM wps_country WHERE status ='1'")->result_array();
    //trace($country);
    $selVal = $this->input->get_post('selVal');
    $option = '<option value="">Select Country</option>';
    if (is_array($country) && !empty($country)) {
      foreach ($country as $key => $val) {
        $sel = ($selVal == $val['id']) ? 'selected="selected"' : '';
        $option .= '<option value="' . $val["id"] . '" ' . $sel . '>' . $val["country_name"] . '</option>';
      }
    }
    echo $option;
  }

  public function get_state() {
    $count_id = (int) $this->input->get_post('country_id');
    $selVal = $this->input->get_post('selVal');
    $strQry = ($count_id > 0) ? " AND country_id ='" . $count_id . "'" : '';
    $state = $this->db->query("SELECT id, country_id, title, status FROM wps_states WHERE status ='1' $strQry")->result_array();
    $option = '<option value="">Choose State</option>';

    if (is_array($state) && !empty($state)) {
      $result = array();
      foreach ($state as $key => $val) {
        $sel = ($selVal == $val['id']) ? 'selected="selected"' : '';
        $option .= '<option value="' . $val["id"] . '" ' . $sel . '>' . $val["title"] . '</option>';
      }
    }
    echo $option;
  }

  public function get_city() {
    $selVal = $this->input->get_post('selVal');
    $state_id = (int) $this->input->get_post('state_id');
    $strQry = ($state_id > 0) ? " AND state_id  ='" . $state_id . "'" : '';
    $city = $this->db->query("SELECT id, state_id, country_id, title, status FROM wps_city WHERE status ='1' $strQry")->result_array();
    $option = '<option value="">Choose City</option>';

    if (is_array($city) && !empty($city)) {
      $result = array();
      foreach ($city as $key => $val) {
        $sel = ($selVal == $val['id']) ? 'selected="selected"' : '';
        $option .= '<option value="' . $val["id"] . '" ' . $sel . '>' . $val["title"] . '</option>';
      }
    }
    echo $option;
  }

  public function verify_otp() {
    $sent_otp_id = $this->input->post('sent_otp_id');
    $user_otp = $this->input->post('user_otp');

    if (($user_otp != "") && ($sent_otp_id != "")) {
      $match_otp = $this->db->get_where('wps_sent_otp', array('otp_id' => $sent_otp_id, 'otp' => $user_otp))->row_array();
      if (count($match_otp) > 0) {
        echo 'success';
      } else {
        echo 'failed';
      }
    } else {
      echo "wrong";
    }
  }

  public function marketarea() {
    $data = array();

    $data['country'] = $this->db->query("SELECT id, name, country_temp_name, status FROM wps_countries_list WHERE status ='1'")->result_array();

    $data['state'] = $this->db->query("SELECT id, name, country_id, temp_title, status FROM wps_states_list WHERE status ='1'")->result_array();
    $this->load->view('marketarea', $data);
  }

}

/* End of file pages.php */