<?php

class Packages extends Public_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->helper(array('packages/packages'));
    $this->load->model(array('packages/packages_model'));
  }

  public function index() {
    $data = array();
    $condtion = array();
    $pagesize = 3;
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $status = $this->input->get_post('status', TRUE);
    if ($status != '') {
      $condtion['status'] = $status;
    }
    $res_array = $this->packages_model->get_packages($config['limit'], 0, $condtion);
    $config['total_rows'] = get_found_rows();
    $data['package1'] = $res_array[0];
    $data['feature1'] = $this->db->query("select * from wps_package_features WHERE package_id = '" . $res_array[0]['package_id'] . "'")->result_array();
    $data['package2'] = $res_array[1];
    $data['feature2'] = $this->db->query("select * from wps_package_features WHERE package_id = '" . $res_array[1]['package_id'] . "'")->result_array();
    $data['package3'] = $res_array[2];
    $data['feature3'] = $this->db->query("select * from wps_package_features WHERE package_id = '" . $res_array[2]['package_id'] . "'")->result_array();

    //Content
    $data['content'] = get_db_field_value('wps_cms_pages', 'page_description', "WHERE friendly_url = 'packages'");

    $this->load->view('packages/view_packages', $data);
  }

  public function details() {
    $data = array();
    $packageId = $this->uri->segment(3);
    $mres = $this->db->query("select * from wps_customers WHERE customers_id = '" . $this->session->userdata('user_id') . "'")->row_array();
    $data['mres'] = $mres;
    $data['package'] = $this->db->query("select * from wps_packages WHERE package_id = '" . $packageId . "'")->row_array();
    //trace($data['package']);


    $this->form_validation->set_error_delimiters("<div class='required red'>", "</div>");

    $this->form_validation->set_rules('package_name', 'Package Name', 'trim|required');
    $this->form_validation->set_rules('amount', 'Amount', 'trim|required');
    $this->form_validation->set_rules('first_name', 'First Name', 'trim|required');
    $this->form_validation->set_rules('last_name', 'Last Name', 'trim|required');
    $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
    $this->form_validation->set_rules('mobile', 'Mobile Number', 'trim|required');
    $this->form_validation->set_rules('company', 'Company Name', 'trim');


    if ($this->form_validation->run() == TRUE) {
      
      //updated customers table
      if(empty($mres['user_email']) || $mres['user_email'] == '0'){
        $this->db->query("UPDATE wps_customers SET user_email = '".$this->input->post('email')."' WHERE customers_id = '".$mres['customers_id']."'");
      }
      if(empty($mres['first_name']) && empty($mres['last_name'])){
        $this->db->query("UPDATE wps_customers SET first_name = '".$this->input->post('first_name')."', last_name = '".$this->input->post('last_name')."' WHERE customers_id = '".$mres['customers_id']."'");
      }
      if(empty($mres['mobile_number'])){
        $this->db->query("UPDATE wps_customers SET mobile_number = '".$this->input->post('mobile')."' WHERE customers_id = '".$mres['customers_id']."'");
      }
      if(empty($mres['company_name'])){
        $this->db->query("UPDATE wps_customers SET company_name = '".$this->input->post('company')."' WHERE customers_id = '".$mres['customers_id']."'");
      }
      

      $invoice_number = "GM_PCK_" . get_auto_increment('wps_order');
      $userId = $this->session->userdata('user_id');
      $customers_id = ( $userId != '') ? $userId : 0;
      $currency_code = $this->session->userdata('currency_code');
      $name = $this->input->post('first_name').' '.$this->input->post('last_name');
      $data_order = array(
          'customers_id' => $customers_id,
          'invoice_number' => $invoice_number,
          'first_name' => $this->input->post('first_name'),
          'last_name' => $this->input->post('last_name'),
          'email' => $this->input->post('email'),
          'billing_title' => '',
          'billing_name' => $name,
          'billing_phone' => $this->input->post('mobile'),
          'billing_address' => '',
          'billing_landmark' => '',
          'billing_zipcode' => '',
          'billing_country' => '',
          'billing_city' => '',
          'billing_state' => '',
          'shipping_title' => '',
          'shipping_name' => $name,
          'shipping_phone' => $this->input->post('mobile'),
          'shipping_address' => '',
          'shipping_landmark' => '',
          'shipping_zipcode' => '',
          'shipping_country' => '',
          'shipping_state' => '',
          'shipping_city' => '',
          'last_shopping_comment' => '',
          'shipping_method' => '',
          'discount_coupon_id' => '',
          'coupon_discount_amount' => '',
          'shipping_amount' => '0',
          'cod_amount' => '',
          'total_amount' => $this->input->post('amount'),
          'vat_amount' => '0',
          'vat_applied_cent' => '',
          'currency_code' => $this->input->post('currency'),
          'currency_value' => '',
          'order_status' => 'Pending',
          'order_received_date' => $this->config->item('config.date.time'),
          'payment_method' => 'PayuMoney',
          'payment_status' => 'Unpaid'
      );
      //trace($data_order);
      //exit;
      $orderId = $this->packages_model->safe_insert('wps_order', $data_order, FALSE);
      $this->session->set_userdata(array('working_order_id' => $orderId));
      $this->session->set_userdata(array('pakage_id' => $packageId));
      if ($orderId > 0) {
        $data = array(
            'order_id' => $orderId,
            'products_id' => '0',
            'product_name' => $this->input->post('package_name'),
            'product_code' => "",
            'product_image' => '',
            'product_price' => $this->input->post('amount'),
            'quantity' => '1',
        );
        $this->packages_model->safe_insert('wps_orders_products', $data, FALSE);
        redirect('payment/?pay_method=payu');
      }
    }



    $data['businessNature'] = $this->config->item('businessNature');
    $this->load->view('packages/view_details', $data);
  }

}

/* End of file member.php */
/* Location: .application/modules/products/controllers/products.php */