<?php

class Members extends Private_Controller {

  private $mId;

  public function __construct() {
    parent::__construct();
    $this->load->model(array('members/members_model', 'order/order_model', 'products/product_model', 'sitepanel/enquiry_model', 'category/category_model', 'blog/blog_model', 'sitepanel/clients_model', 'sitepanel/career_model', 'sitepanel/banner_model'));
    $this->load->helper(array('cart/cart', 'ckeditor', 'category/category', 'query_string'));
    $this->load->library(array('safe_encrypt', 'Dmailer', 'cart'));
    $this->form_validation->set_error_delimiters("<div class='required red'>", "</div>");
    $this->page_section_ct = 'common';
    $this->comp_contact = comp_settings();
  }

  public function index() {
    redirect('members/myaccount', '');
  }

  public function myaccount() {
    $config['per_page'] = $this->config->item('per_page');
    $offset = $this->uri->segment(3, 0);
    $condtion = "AND customers_id = '" . $this->userId . "' ";

    $data['page_content'] = get_db_field_value('wps_cms_pages', 'page_description', array('friendly_url' => 'my-account', 'status' => 1));
    $data['member_account'] = $this->members_model->get_member_row($this->session->userdata('user_id'));

    //total Enquiry and listing  //  AND status != '0'
    $data['enq'] = count_record("wps_enquiry", "FIND_IN_SET('" . $this->userId . "',customers_id) AND is_verified = '1'");
    $data['productlisting'] = count_record("wps_products", "customers_id = '" . $this->userId . "' and productType='0'");
     $data['servicelisting'] = count_record("wps_products", "customers_id = '" . $this->userId . "' and productType='1'");

    //Product Listing
    $condtionList = array();
    $config['per_page'] = 3;
    $offset = 0;
    $condtionList['customers_id'] = $this->userId;
    $res_array = $this->product_model->get_products($config['per_page'], $offset, $condtionList);
    $data['res'] = $res_array;

    $data['businessNature'] = $this->config->item('businessNature');
    $data['businessNatureAll'] = $this->config->item('businessNatureAll');

    $data['unq_section'] = "My Account";
    $data['title'] = "My Account";
    $business_nature_Arr=array(1);
    //Self Verification
    if ($this->input->post('action') == 'Self Verification') {

      //$additionalArr = ($this->input->post('additional_business_nature')) ? $this->input->post('additional_business_nature') : array();
      $business_nature_Arr = ($this->input->post('business_nature')) ? $this->input->post('business_nature') : array();

      $this->form_validation->set_rules('disclaimer', 'Disclaimer', 'trim|required');
      $this->form_validation->set_rules('business_nature[]', 'Business Nature', 'trim|required');
      /*
      if (!$this->input->post('additional_business_nature')) {
        $this->form_validation->set_rules('additional_business_nature', 'Additional Business Nature', '');
        // $this->form_validation->set_rules('additional_business_nature', 'Additional Business Nature', 'required');
      }*/

      if (in_array('3', $business_nature_Arr)) {
        //$this->form_validation->set_rules('gstin', 'GSTIN No.', 'trim|required');
      }
      if (in_array('2', $business_nature_Arr)) {
        $this->form_validation->set_rules('iec_code', 'IEC Code', 'trim|required');
      }
      if (in_array('4', $business_nature_Arr)) {
        $this->form_validation->set_rules('service_product_name[]', 'Service Provider Product Name', 'required');
      }
      if (in_array('1', $business_nature_Arr) || in_array('2', $business_nature_Arr) || in_array('3', $business_nature_Arr)) {
        $this->form_validation->set_rules('product_name[]', 'Product Name', 'required');
      }
      

      if ($this->form_validation->run() == TRUE) {
        //exit;
        $factRes = $this->members_model->get_member_factsheet($this->session->userdata('user_id'));
        //Update Business Nature
        if (is_array($factRes) && !empty($factRes)) {
          //$this->db->query("UPDATE wps_customers_factsheet SET business_nature = '" . $this->input->post('business_nature') . "', business_nature_alt = '" . implode(',', $this->input->post('additional_business_nature')) . "', gst_no= '" . $this->input->post('gstin') . "', ie_code = '" . $this->input->post('iec_code') . "' WHERE customers_id = '" . $this->session->userdata('user_id') . "'");
          $this->db->query("UPDATE wps_customers_factsheet SET business_nature = '" .implode(',', $this->input->post('business_nature')). "', gst_no= '" . $this->input->post('gstin') . "', ie_code = '" . $this->input->post('iec_code') . "' WHERE customers_id = '" . $this->session->userdata('user_id') . "'");
        } else {
          //$this->db->query("INSERT INTO wps_customers_factsheet SET business_nature = '" . $this->input->post('business_nature') . "', business_nature_alt = '" . implode(',', $this->input->post('additional_business_nature')) . "', customers_id = '" . $this->session->userdata('user_id') . "', gst_no= '" . $this->input->post('gstin') . "', ie_code = '" . $this->input->post('iec_code') . "'");
          $this->db->query("INSERT INTO wps_customers_factsheet SET business_nature = '" .implode(',', $this->input->post('business_nature')). "', customers_id = '" . $this->session->userdata('user_id') . "', gst_no= '" . $this->input->post('gstin') . "', ie_code = '" . $this->input->post('iec_code') . "'");
        }
        //End Here
        //Update self Verification
        $this->db->query("UPDATE wps_customers SET is_self_verified = '" . $this->input->post('disclaimer') . "' WHERE customers_id = '" . $this->session->userdata('user_id') . "'");
        //End Here
        
        //Add Products
        $productArray = $this->input->post('product_name');
        if (is_array($productArray) && !empty($productArray)) {
          foreach ($productArray as $productVal) {
            $posted_data = array(
                'customers_id' => $this->session->userdata('user_id'),
                'category_id' => '',
                'category_links' => '',
                'product_name' => $productVal,
                'status' => '0',
                'product_added_date' => $this->config->item('config.date.time')
            );
            //trace($posted_data); exit;
            $productId = $this->product_model->safe_insert('wps_products', $posted_data, FALSE);

            if ($productId > 0) {
              $this->cbk_friendly_url = seo_url_title($productVal . ' ' . $productId);
              //update friendly_url
              $this->db->query("UPDATE wps_products SET friendly_url = '" . $this->cbk_friendly_url . "' WHERE products_id = '" . $productId . "'");

              //Create Meta
              $redirect_url = "products/detail";
              $meta_array = array(
                  'entity_type' => $redirect_url,
                  'entity_id' => $productId,
                  'page_url' => $this->cbk_friendly_url,
                  'meta_title' => '',
                  'meta_description' => '',
                  'meta_keyword' => ''
              );
              create_meta($meta_array);
            }
          }
        }
        //End Here  

        //Add Service Products
        $serviceProductArray = $this->input->post('service_product_name');
        if (is_array($serviceProductArray) && !empty($serviceProductArray)) {
          foreach ($serviceProductArray as $productVal) {
            $posted_data = array(
                'customers_id' => $this->session->userdata('user_id'),
                'category_id' => '',
                'category_links' => '',
                'product_name' => $productVal,
                'status' => '0',
                'productType' => '1',
                'product_added_date' => $this->config->item('config.date.time')
            );
            //trace($posted_data); exit;
            $productId = $this->product_model->safe_insert('wps_products', $posted_data, FALSE);

            if ($productId > 0) {
              $this->cbk_friendly_url = seo_url_title($productVal . ' ' . $productId);
              //update friendly_url
              $this->db->query("UPDATE wps_products SET friendly_url = '" . $this->cbk_friendly_url . "' WHERE products_id = '" . $productId . "'");

              //Create Meta
              $redirect_url = "products/detail";
              $meta_array = array(
                  'entity_type' => $redirect_url,
                  'entity_id' => $productId,
                  'page_url' => $this->cbk_friendly_url,
                  'meta_title' => '',
                  'meta_description' => '',
                  'meta_keyword' => ''
              );
              create_meta($meta_array);
            }
          }
        }
        //End Here  
        
        redirect('members/update-contact', '');
        exit;
      }
    }

    $data['business_nature_Arr'] = $business_nature_Arr;
    //Call of View
    $this->load->view('view_member_myaccount', $data);
  }

  public function update_contact() {
    $data['unq_section'] = "Myaccount";
    $data['title'] = "Edit Contact Details";
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    //trace($mres);

    if (is_array($mres) && !empty($mres)) {
      $this->form_validation->set_rules('mtitle', 'Title', 'trim|required|');
      $this->form_validation->set_rules('first_name', 'First Name', 'trim|required|max_length[80]');
      $this->form_validation->set_rules('last_name', 'Last Name.', 'trim|required|max_length[80]');
      $this->form_validation->set_rules('company_name', 'Company Name', 'trim|required|max_length[220]');
      $this->form_validation->set_rules('picture', 'Profile Picture', 'file_allowed_type[image]');
      $this->form_validation->set_rules('designation', 'Designation', 'trim|required');
      $this->form_validation->set_rules('address', 'Address', 'trim|required|max_length[220]');
      $this->form_validation->set_rules('state', 'State', 'trim|required|max_length[220]');
      $this->form_validation->set_rules('city', 'City', 'trim|required|max_length[220]');
      $this->form_validation->set_rules('locality', 'Locality', 'trim|max_length[220]');
      $this->form_validation->set_rules('landmark', 'Landmark', 'trim|max_length[220]');
      $this->form_validation->set_rules('zipcode', 'Pincode', 'trim|required|max_length[20]');
      $this->form_validation->set_rules('alt_mobile', 'Alternate Mobile No.', 'trim|max_length[15]');
      $this->form_validation->set_rules('email', 'Email Address', 'trim|required|valid_email');
      $this->form_validation->set_rules('alt_email', 'Alt. Email Address', 'trim|valid_email');
      $this->form_validation->set_rules('website', 'Website', 'trim|max_length[220]');

      if ($this->form_validation->run() == TRUE) {

        $uploaded_file = $mres['profile_picture'];
        $unlink_image = array('source_dir' => "user", 'source_file' => $mres['profile_picture']);
        if (!empty($_FILES) && $_FILES['picture']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('picture', 'user');
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $uploaded_file = $uploaded_data['upload_data']['file_name'];
            removeImage($unlink_image);
          }
        }
        $posted_user_data = array(
            'title' => $this->input->post('mtitle'),
            'first_name' => $this->input->post('first_name'),
            'last_name' => $this->input->post('last_name'),
            'company_name' => $this->input->post('company_name'),
            'profile_picture' => $uploaded_file,
            'designation' => $this->input->post('designation'),
            'address' => $this->input->post('address'),
            'state' => $this->input->post('state'),
            'city' => $this->input->post('city'),
            'country' => 'India',
            'landmark' => $this->input->post('landmark'),
            'locality' => $this->input->post('locality'),
            'zipcode' => $this->input->post('zipcode'),
            'alt_mobile' => $this->input->post('alt_mobile'),
            'user_email' => $this->input->post('email'),
            'alt_email' => $this->input->post('alt_email'),
            'website' => $this->input->post('website'),
        );
        //trace($posted_user_data);
        //exit;
        $where_ship = "customers_id = '" . $mres['customers_id'] . "'";
        $this->members_model->safe_update('wps_customers', $posted_user_data, $where_ship, FALSE);

        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', 'Contact Details have been updated successfully!!!');
        redirect('members/update-profile', '');
      }
    } else {
      redirect('members', '');
    }

    $data['state'] = $this->db->query("select * from wps_states_list where country_id='105'")->result_array();
    $data['city'] = $this->db->query("select * from wps_cities_list where state_id='" . $mres['state'] . "'")->result_array();
    $data['mres'] = $mres;
    $this->load->view('view_contact_edit', $data);
  }

  public function update_profile() {
    $data['unq_section'] = "Myaccount";
    $data['title'] = "Edit Company Details";
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    //trace($mres);

    if (is_array($mres) && !empty($mres)) {
      $factRes = $this->members_model->get_member_factsheet($this->session->userdata('user_id'));
      $this->form_validation->set_rules('business_nature[]', 'Nature of business', 'required');
      //$this->form_validation->set_rules('business_nature_alt', 'Alt. Nature of Business', '');
      $this->form_validation->set_rules('ceo_name', 'CEO Name.', 'trim|required|max_length[220]');
      $this->form_validation->set_rules('registered_address', 'Registered Address', 'trim|required');
      $this->form_validation->set_rules('about_company', 'About Company', 'trim');
      $this->form_validation->set_rules('youtube_id', 'Youtube Video Link', 'trim');

      $this->form_validation->set_rules('employee_count', 'No. of Employees', 'trim');
      $this->form_validation->set_rules('establishment_year', 'Establishment Year', 'trim|');
      $this->form_validation->set_rules('legal_firm_status', 'Legal Status of Firm', 'trim|');
      $this->form_validation->set_rules('promoter_name', 'Promoter Name', 'trim|max_length[220]');
      $this->form_validation->set_rules('turnover', 'Company Turnover', 'trim|required');
      $this->form_validation->set_rules('building_infrastructure', 'Building Infrastructure', 'trim|max_length[220]');
      $this->form_validation->set_rules('premises_size', 'Company Premises Size', 'trim|max_length[160]');
      $this->form_validation->set_rules('competitive_advantage', 'Company USP', 'trim');
      $this->form_validation->set_rules('contract_manufacturing', 'Contract Manufaturing', 'trim||max_length[220]');
      $this->form_validation->set_rules('testing_facilities', 'Quality/Testing Facility', 'trim');
      $this->form_validation->set_rules('ie_code', 'IE CODE', 'trim|max_length[160]');

      $this->form_validation->set_rules('banker', 'Banker', 'trim|max_length[220]');
      $this->form_validation->set_rules('gst_no', 'GST No.', 'trim|max_length[15]');
      $this->form_validation->set_rules('customized_packaging', 'Customized Packaging', 'trim|');
      $this->form_validation->set_rules('payment_mode', 'Payment Mode', '');
      $this->form_validation->set_rules('shipment_mode', 'Shipment Mode', 'trim|max_length[220]');


      if ($this->form_validation->run() == TRUE) {

        $uploaded_file = "";
        $unlink_image = array();
        if (isset($factRes['infra_img1'])) {
          $uploaded_file = $factRes['infra_img1'];
          $unlink_image = array('source_dir' => "infra", 'source_file' => $factRes['infra_img1']);
        }
        if (!empty($_FILES) && $_FILES['infra_img1']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('infra_img1', 'infra');
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $uploaded_file = $uploaded_data['upload_data']['file_name'];
            @removeImage($unlink_image);
          }
        }


        $uploaded_file2 = "";
        $unlink_image2 = array();
        if (isset($factRes['infra_img2'])) {
          $uploaded_file2 = $factRes['infra_img2'];
          $unlink_image2 = array('source_dir' => "infra", 'source_file' => $factRes['infra_img2']);
        }
        if (!empty($_FILES) && $_FILES['infra_img2']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('infra_img2', 'infra');
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $uploaded_file2 = $uploaded_data['upload_data']['file_name'];
            @removeImage($unlink_image2);
          }
        }

        $uploaded_file3 = "";
        $unlink_image3 = array();
        if (isset($factRes['infra_img3'])) {
          $uploaded_file3 = $factRes['infra_img3'];
          $unlink_image3 = array('source_dir' => "infra", 'source_file' => $factRes['infra_img3']);
        }
        if (!empty($_FILES) && $_FILES['infra_img3']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('infra_img3', 'infra');
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $uploaded_file3 = $uploaded_data['upload_data']['file_name'];
            @removeImage($unlink_image3);
          }
        }

        $uploaded_file4 = "";
        $unlink_image4 = array();
        if (isset($factRes['infra_img4'])) {
          $uploaded_file4 = $factRes['infra_img4'];
          $unlink_image4 = array('source_dir' => "infra", 'source_file' => $factRes['infra_img4']);
        }
        if (!empty($_FILES) && $_FILES['infra_img4']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('infra_img4', 'infra');
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $uploaded_file4 = $uploaded_data['upload_data']['file_name'];
            @removeImage($unlink_image4);
          }
        }


        $posted_user_data = array(
            'customers_id' => $mres['customers_id'],
            'business_nature' => implode(',', $this->input->post('business_nature')),
            //'business_nature_alt' => implode(',', $this->input->post('business_nature_alt')),
            'ceo_name' => $this->input->post('ceo_name'),
            'registered_address' => $this->input->post('registered_address'),
            'about_company' => $this->input->post('about_company'),
            'youtube_id' => $this->input->post('youtube_id'),
            'employee_count' => $this->input->post('employee_count'),
            'establishment_year' => $this->input->post('establishment_year'),
            'legal_firm_status' => $this->input->post('legal_firm_status'),
            'promoter_name' => $this->input->post('promoter_name'),
            'turnover' => $this->input->post('turnover'),
            'building_infrastructure' => $this->input->post('building_infrastructure'),
            "infra_img" => $uploaded_file,
            "infra_img2" => $uploaded_file2,
            "infra_img3" => $uploaded_file3,
            "infra_img4" => $uploaded_file4,
            'premises_size' => $this->input->post('premises_size'),
            'premises_unit' => $this->input->post('premises_unit'),
            'competitive_advantage' => $this->input->post('competitive_advantage'),
            'contract_manufacturing' => $this->input->post('contract_manufacturing'),
            'testing_facilities' => $this->input->post('testing_facilities'),
            'ie_code' => $this->input->post('ie_code'),
            'banker' => $this->input->post('banker'),
            'gst_no' => $this->input->post('gst_no'),
            'customized_packaging' => $this->input->post('customized_packaging'),
            'payment_mode' => @implode(',', $this->input->post('payment_mode')),
            'shipment_mode' => $this->input->post('shipment_mode'),
        );
        //trace($posted_user_data);
        //exit;
        if (is_array($factRes) && !empty($factRes)) {
          $where_ship = "customers_id = '" . $factRes['customers_id'] . "'";
          $this->members_model->safe_update('wps_customers_factsheet', $posted_user_data, $where_ship, FALSE);
        } else {
          $this->members_model->safe_insert('wps_customers_factsheet', $posted_user_data, FALSE);
        }

        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', 'Company Factsheet Details have been updated successfully!!!');
        redirect('members/update_profile', 'refresh');
      }
    } else {
      redirect('members', '');
    }
    if (is_array($factRes) && !empty($factRes)) {
      $data['factRes'] = $factRes;
    } else {
      $data['factRes'] = array(
          'business_nature' => $this->input->post('business_nature'),
          //'business_nature_alt' => $this->input->post('business_nature_alt'),
          'ceo_name' => $this->input->post('ceo_name'),
          'registered_address' => $this->input->post('registered_address'),
          'about_company' => $this->input->post('about_company'),
          'employee_count' => $this->input->post('employee_count'),
          'establishment_year' => $this->input->post('establishment_year'),
          'legal_firm_status' => $this->input->post('legal_firm_status'),
          'promoter_name' => $this->input->post('promoter_name'),
          'turnover' => $this->input->post('turnover'),
          'building_infrastructure' => $this->input->post('building_infrastructure'),
          'premises_size' => $this->input->post('premises_size'),
          'premises_unit' => $this->input->post('premises_unit'),
          'competitive_advantage' => $this->input->post('competitive_advantage'),
          'contract_manufacturing' => $this->input->post('contract_manufacturing'),
          'testing_facilities' => $this->input->post('testing_facilities'),
          'ie_code' => $this->input->post('ie_code'),
          'banker' => $this->input->post('banker'),
          'gst_no' => $this->input->post('gst_no'),
          'customized_packaging' => $this->input->post('customized_packaging'),
          'payment_mode' => $this->input->post('payment_mode'),
          'shipment_mode' => $this->input->post('shipment_mode')
      );
    }

    $data['mres'] = $mres;

    /* Global Variables */
    $data['paymentMode'] = $this->config->item('paymentMode');
    $data['customizedPackaging'] = $this->config->item('customizedPackaging');
    $data['testingFacilities'] = $this->config->item('testingFacilities');
    $data['turnover'] = $this->config->item('turnover');
    $data['firmStatus'] = $this->config->item('firmStatus');
    $data['employeeCount'] = $this->config->item('employeeCount');
    $data['businessNature'] = $this->config->item('businessNature');
    $data['businessNatureAll'] = $this->config->item('businessNatureAll');
    $data['premises_unit'] = $this->config->item('premises_unit');
    //End

    $this->load->view('view_company_edit', $data);
  }

  public function change_password() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;
    $this->form_validation->set_rules('old_password', 'Old Password', 'trim|required');
    $this->form_validation->set_rules('new_password', 'New Password', 'trim|required|valid_password');
    $this->form_validation->set_rules('confirm_password', 'Confirm Password', 'trim|required|matches[new_password]');

    if ($this->form_validation->run() == TRUE) {
      $password_old = $this->safe_encrypt->encode($this->input->post('old_password', TRUE));
      $mres = $this->members_model->get_member_row($this->userId, " AND password='$password_old' ");
      if (is_array($mres) && !empty($mres)) {
        $password = $this->safe_encrypt->encode($this->input->post('new_password', TRUE));
        $data = array('password' => $password);
        $where = "customers_id=" . $this->session->userdata('user_id') . " ";
        $this->members_model->safe_update('wps_customers', $data, $where, FALSE);
        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', $this->config->item('myaccount_password_changed'));
      } else {
        $this->session->set_userdata(array('msg_type' => 'error'));
        $this->session->set_flashdata('error', $this->config->item('myaccount_password_not_match'));
      }
      redirect('members/change_password', '');
    }
    /* End  member change password  */
    $data['unq_section'] = "Myaccount";
    $data['heading_title'] = "Account Settings";
    $this->load->view('members/view_member_change_password', $data);
  }

  public function change_website_url() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;
    $memId = $mres['customers_id'];
    $this->form_validation->set_rules('website_url', 'Website URL', 'trim|required');

    if ($this->form_validation->run() == TRUE) {
      //echo "sss"; die;
      createTemplateUrlsComp($memId);
      //End here
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'Website Url has been changed successfully.');
      redirect('members/change_website_url', '');
    }
    /* End  member change password  */
    $data['unq_section'] = "Myaccount";
    $data['heading_title'] = "Account Settings";
    $this->load->view('members/view_update_url', $data);
  }

  public function website_setting() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $settingRes = $this->db->query("SELECt * FROM wps_website_settings WHERE customers_id = '" . $this->session->userdata('user_id') . "'")->row_array();
    $data['mres'] = $mres;
    $memId = $mres['customers_id'];

    //Validation
    $this->form_validation->set_rules('website_logo', 'Website Logo', 'file_allowed_type[image]');
    $this->form_validation->set_rules('website_video', 'Website Video', 'trim');
    $this->form_validation->set_rules('facebook_link', 'Facebook Link', 'trim');
    $this->form_validation->set_rules('twitter_link', 'Twitter Link', 'trim');
    $this->form_validation->set_rules('linkedin_link', 'Linkedin Link', 'trim');
    $this->form_validation->set_rules('youtube_link', 'Youtube Link', 'trim');

    $this->form_validation->set_rules('whyus_title1', 'Title 1', 'trim|required|max_length[20]');
    $this->form_validation->set_rules('whyus_desc1', 'Details 1', 'trim|required|max_length[100]');
    $this->form_validation->set_rules('whyus_title2', 'Title 2', 'trim|required|max_length[20]');
    $this->form_validation->set_rules('whyus_desc2', 'Details 2', 'trim|required|max_length[100]');
    $this->form_validation->set_rules('whyus_title3', 'Title 3', 'trim|required|max_length[20]');
    $this->form_validation->set_rules('whyus_desc3', 'Details 3', 'trim|required|max_length[100]');
    $this->form_validation->set_rules('whyus_title4', 'Title 4', 'trim|required|max_length[25]');
    $this->form_validation->set_rules('whyus_desc4', 'Details 4', 'trim|required|max_length[100]');

    $this->form_validation->set_rules('webiste_map', 'Company Google Map', 'trim|required');

    $this->form_validation->set_rules('about_serviceability', 'Write about your Service & Delivery', 'trim|required|max_length[1500]');
    $this->form_validation->set_rules('location_serve', 'Location You Serve', 'trim|required|max_length[160]');

    if ($this->form_validation->run() == TRUE) {

      $uploaded_file = $settingRes['website_logo'];
      $unlink_image = array('source_dir' => "clients/logo", 'source_file' => $settingRes['website_logo']);
      if (!empty($_FILES) && $_FILES['website_logo']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('website_logo', 'clients/logo');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
          @removeImage($unlink_image);
        }
      }

      $posted_user_data = array(
          'customers_id' => $mres['customers_id'],
          'website_logo' => $uploaded_file,
          'website_video' => $this->input->post('website_video'),
          'facebook_link' => $this->input->post('facebook_link'),
          'twitter_link' => $this->input->post('twitter_link'),
          'linkedin_link' => $this->input->post('linkedin_link'),
          'youtube_link' => $this->input->post('youtube_link'),
          'whyus_title1' => $this->input->post('whyus_title1'),
          'whyus_desc1' => $this->input->post('whyus_desc1'),
          'whyus_title2' => $this->input->post('whyus_title2'),
          'whyus_desc2' => $this->input->post('whyus_desc2'),
          'whyus_title3' => $this->input->post('whyus_title3'),
          'whyus_desc3' => $this->input->post('whyus_desc3'),
          'whyus_title4' => $this->input->post('whyus_title4'),
          'whyus_desc4' => $this->input->post('whyus_desc4'),
          'webiste_map' => $this->input->post('webiste_map'),
          'about_serviceability' => $this->input->post('about_serviceability'),
          'location_serve' => $this->input->post('location_serve'),
      );
      //exit;
      if (is_array($settingRes) && !empty($settingRes)) {
        $where_settings = "customers_id = '" . $mres['customers_id'] . "'";
        $this->members_model->safe_update('wps_website_settings', $posted_user_data, $where_settings, FALSE);
      } else {
        $this->members_model->safe_insert('wps_website_settings', $posted_user_data, FALSE);
      }

      //End here
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'Website Settings have been updated successfully.');
      redirect('members/website_setting', '');
    }

    if (is_array($settingRes) && empty($settingRes)) {
      $settingRes['website_logo'] = "";
      $settingRes['website_video'] = "";
      $settingRes['facebook_link'] = "";
      $settingRes['twitter_link'] = "";
      $settingRes['youtube_link'] = "";
      $settingRes['linkedin_link'] = "";
      $settingRes['whyus_title1'] = "";
      $settingRes['whyus_desc1'] = "";
      $settingRes['whyus_title2'] = "";
      $settingRes['whyus_desc2'] = "";
      $settingRes['whyus_title3'] = "";
      $settingRes['whyus_desc3'] = "";
      $settingRes['whyus_title4'] = "";
      $settingRes['whyus_desc4'] = "";
      $settingRes['webiste_map'] = "";
      $settingRes['about_serviceability'] = "";
      $settingRes['location_serve'] = "";
    }

    $data['settingRes'] = $settingRes;
    /* End  member change password  */
    $data['unq_section'] = "Myaccount";
    $data['heading_title'] = "Account Settings";
    $this->load->view('members/view_website_setting', $data);
  }

  public function manage_website_category() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;
    $companyId = $mres['customers_id'];
    //get listing
    $condtion = "";
    $condtion = "AND companyId = '" . $this->session->userdata('user_id') . "' AND status = '1' AND categoryType='0'";
    $condtion_array = array(
        'field' => "*,( SELECT COUNT(category_id) FROM wps_categories AS b WHERE b.parent_id=a.category_id AND categoryType='0') AS total_subcategories",
        'condition' => $condtion,
        //'limit' => $config['limit'],
        //'offset' => $offset,
        'debug' => FALSE
    );
    $res_array = $this->category_model->get_company_category($condtion_array);
    //trace($res_array);
    $data['res'] = $res_array;
    if ($this->input->post('status_action') != '') {
      $this->session->set_flashdata('success', lang('deleted'));
      $this->update_status('wps_company_categories', 'category_id');
    }
    //Call of view
    $this->load->view('view_website_category', $data);
  }
  public function manage_website_category_services() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;
    $companyId = $mres['customers_id'];
    //get listing
    $condtion = "";
    $condtion = "AND companyId = '" . $this->session->userdata('user_id') . "' AND status = '1' AND categoryType='1'";
    $condtion_array = array(
        'field' => "*,( SELECT COUNT(category_id) FROM wps_categories AS b WHERE b.parent_id=a.category_id AND categoryType='1') AS total_subcategories",
        'condition' => $condtion,
        //'limit' => $config['limit'],
        //'offset' => $offset,
        'debug' => FALSE
    );
    $res_array = $this->category_model->get_company_category($condtion_array);
    //trace($res_array);
    $data['res'] = $res_array;
    if ($this->input->post('status_action') != '') {
      $this->session->set_flashdata('success', lang('deleted'));
      $this->update_status('wps_company_categories', 'category_id');
    }
    //Call of view
    $this->load->view('view_website_category_services', $data);
  }

  public function add_website_category() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;
    $data['parentData'] = '';
    $data['heading_title'] = 'Manage Wesite Category';

    $img_allow_size = $this->config->item('allow.file.size');
    $img_allow_dim = $this->config->item('allow.imgage.dimension');

    $category_name = $this->db->escape_str($this->input->post('category_name'));
    $posted_friendly_url = seo_url_title($this->input->post('category_name'));
    $this->cbk_friendly_url = seo_url_title($posted_friendly_url);
    $seo_url_length = $this->config->item('seo_url_length');

    $this->form_validation->set_rules('category_name', 'Category Name', "trim|required|max_length[100]|xss_clean|unique[wps_company_categories.category_name ='" . $category_name . "' AND status!='2' AND companyId='" . $mres['customers_id'] . "']");
    $this->form_validation->set_rules('category_image', 'Image', "file_allowed_type[image]|file_size_max[$img_allow_size]|check_dimension[$img_allow_dim]");

    $this->form_validation->set_rules('category_description', 'Description', "trim");
    $this->form_validation->set_rules('category_alt', 'Alt', "trim|max_length[100]");


    if ($this->form_validation->run() === TRUE) {

      $uploaded_file = "";
      if (!empty($_FILES) && $_FILES['category_image']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('category_image', 'category');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
        }
      }

      $redirect_url = "wpstemplate/category/index";
      $category_alt = ($this->input->post('category_alt')) ? $this->input->post('category_alt') : $this->input->post('category_name');

      $category_description = $this->input->post('category_description');
      $category_description = $category_description != '' ? $category_description : null;

      $posted_data = array(
          'companyId' => $mres['customers_id'],
          'category_name' => $this->input->post('category_name'),
          'category_alt' => $category_alt,
          'category_description' => $category_description,
          'parent_id' => 0,
          'friendly_url' => $mres['website_url'] . '/' . $this->cbk_friendly_url,
          'date_added' => $this->config->item('config.date.time'),
          'category_image' => $uploaded_file,
      );
      $insertId = $this->category_model->safe_insert('wps_company_categories', $posted_data, FALSE);

      if ($insertId > 0) {
        //create meta
        if (!is_null($category_description)) {
          $meta_description = $category_description;
          $meta_keyword = $category_description;
        } else {
          $meta_description = $this->input->post('category_name');
          $meta_keyword = $this->input->post('category_name');
        }
        /* $meta_array = array(
          'entity_type' => $redirect_url,
          'entity_id' => $insertId,
          'companyId' => $mres['customers_id'],
          'page_url' => $this->cbk_friendly_url,
          'meta_title' => get_text($this->input->post('category_name'), 80),
          'meta_description' => get_text($meta_description),
          'meta_keyword' => get_keywords($meta_keyword)
          ); */
        $meta_array = array(
            'entity_type' => $redirect_url,
            'entity_id' => $insertId,
            'companyId' => $mres['customers_id'],
            'page_url' => $mres['website_url'] . '/' . $this->cbk_friendly_url,
            'meta_title' => '',
            'meta_description' => '',
            'meta_keyword' => ''
        );
        create_meta_company($meta_array);
        //end
      }

      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'New Category has been Added Successfully.');
      $redirect_path = 'manage-website-category';
      redirect('members/' . $redirect_path, '');
    }
    $this->load->view('view_company_category_add', $data);
  }
  public function add_website_category_service() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;
    $data['parentData'] = '';
    $data['heading_title'] = 'Manage Wesite Service Category';

    $img_allow_size = $this->config->item('allow.file.size');
    $img_allow_dim = $this->config->item('allow.imgage.dimension');

    $category_name = $this->db->escape_str($this->input->post('category_name'));
    $posted_friendly_url = seo_url_title($this->input->post('category_name'));
    $this->cbk_friendly_url = seo_url_title($posted_friendly_url);
    $seo_url_length = $this->config->item('seo_url_length');

    $this->form_validation->set_rules('category_name', 'Category Name', "trim|required|max_length[100]|xss_clean|unique[wps_company_categories.category_name ='" . $category_name . "' AND status!='2' AND companyId='" . $mres['customers_id'] . "']");
    $this->form_validation->set_rules('category_image', 'Image', "file_allowed_type[image]|file_size_max[$img_allow_size]|check_dimension[$img_allow_dim]");

    $this->form_validation->set_rules('category_description', 'Description', "trim");
    $this->form_validation->set_rules('category_alt', 'Alt', "trim|max_length[100]");


    if ($this->form_validation->run() === TRUE) {

      $uploaded_file = "";
      if (!empty($_FILES) && $_FILES['category_image']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('category_image', 'category');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
        }
      }

      $redirect_url = "wpstemplate/category/index";
      $category_alt = ($this->input->post('category_alt')) ? $this->input->post('category_alt') : $this->input->post('category_name');

      $category_description = $this->input->post('category_description');
      $category_description = $category_description != '' ? $category_description : null;

      $posted_data = array(
          'companyId' => $mres['customers_id'],
          'category_name' => $this->input->post('category_name'),
          'category_alt' => $category_alt,
          'category_description' => $category_description,
          'parent_id' => 0,
          'categoryType' => '1',
          'friendly_url' => $mres['website_url'] . '/' . $this->cbk_friendly_url,
          'date_added' => $this->config->item('config.date.time'),
          'category_image' => $uploaded_file,
      );
      $insertId = $this->category_model->safe_insert('wps_company_categories', $posted_data, FALSE);

      if ($insertId > 0) {
        //create meta
        if (!is_null($category_description)) {
          $meta_description = $category_description;
          $meta_keyword = $category_description;
        } else {
          $meta_description = $this->input->post('category_name');
          $meta_keyword = $this->input->post('category_name');
        }
        /* $meta_array = array(
          'entity_type' => $redirect_url,
          'entity_id' => $insertId,
          'companyId' => $mres['customers_id'],
          'page_url' => $this->cbk_friendly_url,
          'meta_title' => get_text($this->input->post('category_name'), 80),
          'meta_description' => get_text($meta_description),
          'meta_keyword' => get_keywords($meta_keyword)
          ); */
        $meta_array = array(
            'entity_type' => $redirect_url,
            'entity_id' => $insertId,
            'companyId' => $mres['customers_id'],
            'page_url' => $mres['website_url'] . '/' . $this->cbk_friendly_url,
            'meta_title' => '',
            'meta_description' => '',
            'meta_keyword' => ''
        );
        create_meta_company($meta_array);
        //end
      }

      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'New Category has been Added Successfully.');
      $redirect_path = 'manage-website-service-category';
      redirect('members/' . $redirect_path, '');
    }
    $this->load->view('view_company_category_add_service', $data);
  }

  public function edit_website_category() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    $catId = (int) $this->uri->segment(3);
    $rowdata = $this->category_model->get_company_category_by_id($catId);
    $data['heading_title'] = 'Category';

    $img_allow_size = $this->config->item('allow.file.size');
    $img_allow_dim = $this->config->item('allow.imgage.dimension');

    if (!is_array($rowdata)) {
      $this->session->set_flashdata('message', lang('idmissing'));
      redirect('members/manage-website-category', '');
    }

    $categoryId = $rowdata['category_id'];
    $this->cbk_friendly_url = seo_url_title($this->input->post('category_name'));
    $seo_url_length = $this->config->item('seo_url_length');

    $this->form_validation->set_rules('category_name', 'Category Name', "trim|required|max_length[100]|xss_clean|unique[wps_company_categories.category_name ='" . $this->db->escape_str($this->input->post('category_name')) . "' AND status!='2' AND companyId='" . $rowdata['companyId'] . "' AND category_id!='" . $categoryId . "']");

    $this->form_validation->set_rules('category_description', 'Description', "trim");
    $this->form_validation->set_rules('category_image', 'Image', "file_allowed_type[image]|file_size_max[$img_allow_size]|check_dimension[$img_allow_dim]");
    $this->form_validation->set_rules('category_alt', 'Alt', "trim|max_length[100]");

    if ($this->form_validation->run() == TRUE) {

      $uploaded_file = $rowdata['category_image'];
      $unlink_image = array('source_dir' => "category", 'source_file' => $rowdata['category_image']);
      if (!empty($_FILES) && $_FILES['category_image']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('category_image', 'category');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
          removeImage($unlink_image);
        }
      }

      $category_alt = ($this->input->post('category_alt')) ? $this->input->post('category_alt') : $this->input->post('category_name');
      $category_description = $this->input->post('category_description');
      $category_description = $category_description != '' ? $category_description : null;

      $posted_data = array(
          'category_name' => $this->input->post('category_name'),
          'friendly_url' => $mres['website_url'] . '/' . $this->cbk_friendly_url,
          'category_alt' => $category_alt,
          'category_description' => $category_description,
          'category_image' => $uploaded_file,
      );

      $where = "category_id = '" . $categoryId . "'";
      $this->category_model->safe_update('wps_company_categories', $posted_data, $where, FALSE);

      //Update Meta Tags
      $posted_data_meta = array(
          'page_url' => $mres['website_url'] . '/' . $this->cbk_friendly_url,
      );
      $where_meta = "entity_type = 'wpstemplate/category/index' AND entity_id = '" . $categoryId . "' AND companyId = '" . $rowdata['companyId'] . "'";
      $this->category_model->safe_update('wps_meta_tags_company', $posted_data_meta, $where_meta, FALSE);
      //End here

      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'Category Edited Successfully.');
      $redirect_path = 'manage-website-category';
      redirect('members/' . $redirect_path . '/' . query_string(), '');
    }

    //call o view
    $data['res'] = $rowdata;
    $this->load->view('view_company_category_edit', $data);
  }

  public function manage_service_listing() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    //get listing
    $condtion = array();
    $config['per_page'] = $this->config->item('per_page');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $condtion['customers_id'] = $mres['customers_id'];
    $condtion['where'] = "wlp.productType = '1'";
    $res_array = $this->product_model->get_products($config['per_page'], $offset, $condtion);
    $data['total_rows'] = $config['total_rows'] = get_found_rows();
    $data['page_links'] = dashboard_pagination($base_url, $config['total_rows'], $config['per_page'], $offset);
    $data['res'] = $res_array;
    $data['heading'] = 'Services';
    //End here
    //Updating Status
    if ($this->input->post('status_action') != '') {
      //if ($this->input->post('status_action') == 'Delete') {
      //$prod_id = $this->input->post('arr_ids');
      //foreach ($prod_id as $v) {
      //$where = array('entity_type' => 'products/details', 'entity_id' => $v);
      //$this->product_model->safe_delete('wps_meta_tags', $where, TRUE);
      //}
      //}
      $this->session->set_flashdata('success', lang('deleted'));
      $this->update_status('wps_products', 'products_id');
    }

    //Call of view
    $this->load->view('view_listing', $data);
  }

  public function manage_listing() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    //get listing
    $condtion = array();
    $config['per_page'] = $this->config->item('per_page');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $condtion['customers_id'] = $mres['customers_id'];
    $condtion['where'] = "wlp.productType = '0'";
    $res_array = $this->product_model->get_products($config['per_page'], $offset, $condtion);
    //echo_sql();
    $data['total_rows'] = $config['total_rows'] = get_found_rows();
    $data['page_links'] = dashboard_pagination($base_url, $config['total_rows'], $config['per_page'], $offset);
    $data['res'] = $res_array;
    $data['heading'] = 'Products';
    //End here
    //Updating Status
    if ($this->input->post('status_action') != '') {
      //if ($this->input->post('status_action') == 'Delete') {
      //$prod_id = $this->input->post('arr_ids');
      //foreach ($prod_id as $v) {
      //$where = array('entity_type' => 'products/details', 'entity_id' => $v);
      //$this->product_model->safe_delete('wps_meta_tags', $where, TRUE);
      //}
      //}
      $this->session->set_flashdata('success', lang('deleted'));
      $this->update_status('wps_products', 'products_id');
    }

    //Call of view
    $this->load->view('view_listing', $data);
  }

  public function add_listing() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    if (is_array($mres) && !empty($mres)) {

      $category_name = $this->db->escape_str($this->input->post('category_name'));
      if($category_name!=""){
        $this->form_validation->set_rules('category_name', 'New Category Name', "trim|max_length[100]|xss_clean|unique[wps_company_categories.category_name ='" . $category_name . "' AND status!='2' AND companyId='" . $mres['customers_id'] . "']");
      }
      
      $this->form_validation->set_rules('product_name', 'Product Name', 'required');

      $this->form_validation->set_rules('img1', 'Product Main Image', 'file_allowed_type[image]');
      $this->form_validation->set_rules('img2', 'Product Additional Image', 'file_allowed_type[image]');
      $this->form_validation->set_rules('img3', 'Product Additional Image', 'file_allowed_type[image]');
      $this->form_validation->set_rules('img4', 'Product Additional Image', 'file_allowed_type[image]');
      $this->form_validation->set_rules('youtube_id', 'Youtube Link', 'trim|max_length[220]');

      $this->form_validation->set_rules('product_price', 'Price', 'trim|valid_amount');
      $this->form_validation->set_rules('unit_value', 'Unit Value', 'trim');
      $this->form_validation->set_rules('unit_measurement', 'Unit Measurement', 'trim');

      $this->form_validation->set_rules('description', 'Product Description', 'trim');
      //$this->form_validation->set_rules('dashkeyword', 'Category ID', 'trim|required');
      $this->form_validation->set_rules('category_id', 'Product Category', 'trim|required');
      $this->form_validation->set_rules('website_category_id', 'Product Category', 'trim');
      $this->form_validation->set_rules('attribute_name[]', 'Attribute Name', 'trim');
      $this->form_validation->set_rules('attribute_value[]', 'Attribute Value', 'trim');
      $this->form_validation->set_rules('moq', 'Minimum Order Quantity', 'trim');

      $this->form_validation->set_rules('product_code', 'Product Code', 'trim|');
      $this->form_validation->set_rules('dispatch_port', 'Dispatch Port', 'trim|');
      $this->form_validation->set_rules('delivery_time', 'Delivery Time', 'trim|');
      $this->form_validation->set_rules('packaging_details', 'Packaging Details', 'trim|max_length[220]');
      if ($this->form_validation->run() == TRUE) {
        if($category_name!=""){

          $category_posted_friendly_url = seo_url_title($category_name);
          $redirect_url = "wpstemplate/category/index";
          $category_alt = $category_name;
          $category_description = NULL;
          $uploaded_file = NULL;
          
          $posted_data = array(
              'companyId' => $mres['customers_id'],
              'category_name' => $category_name,
              'category_alt' => $category_alt,
              'category_description' => $category_description,
              'parent_id' => 0,
              'categoryType' =>'0',
              'friendly_url' => $mres['website_url'] . '/' . $category_posted_friendly_url,
              'date_added' => $this->config->item('config.date.time'),
              'category_image' => $uploaded_file,
          );
          $website_category_id = $this->category_model->safe_insert('wps_company_categories', $posted_data, FALSE);
  
          if ($website_category_id > 0) {
            //create meta
              $meta_description = $category_name;
              $meta_keyword = $category_name;
              $meta_title = $category_name;
              $meta_array = array(
                  'entity_type' => $redirect_url,
                  'entity_id' => $website_category_id,
                  'companyId' => $mres['customers_id'],
                  'page_url' => $mres['website_url'] . '/' . $category_posted_friendly_url,
                  'meta_title' =>$meta_title,
                  'meta_description' =>$meta_description,
                  'meta_keyword' =>$meta_keyword
              );
              create_meta_company($meta_array);
              //end
          }

        }else{
          $website_category_id = $this->input->post('website_category_id');
        }
  

        $pic1 = '';
        if (!empty($_FILES) && $_FILES['img1']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('img1', 'product_images', seo_url_title($this->input->post('product_name') . '-1'));
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $pic1 = $uploaded_data['upload_data']['file_name'];
            compressImage(FCROOT . 'uploaded_files/product_images/' . $pic1, FCROOT . 'uploaded_files/product_images/' . $pic1, 50);
          }
        }

        $pic2 = '';
        if (!empty($_FILES) && $_FILES['img2']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('img2', 'product_images', seo_url_title($this->input->post('product_name') . '-2'));
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $pic2 = $uploaded_data['upload_data']['file_name'];
            compressImage(FCROOT . 'uploaded_files/product_images/' . $pic2, FCROOT . 'uploaded_files/product_images/' . $pic2, 50);
          }
        }

        $pic3 = '';
        if (!empty($_FILES) && $_FILES['img3']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('img3', 'product_images', seo_url_title($this->input->post('product_name') . '-3'));
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $pic3 = $uploaded_data['upload_data']['file_name'];
            compressImage(FCROOT . 'uploaded_files/product_images/' . $pic3, FCROOT . 'uploaded_files/product_images/' . $pic3, 50);
          }
        }

        $pic4 = '';
        if (!empty($_FILES) && $_FILES['img4']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('img4', 'product_images', seo_url_title($this->input->post('product_name') . '-4'));
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $pic4 = $uploaded_data['upload_data']['file_name'];
            compressImage(FCROOT . 'uploaded_files/product_images/' . $pic4, FCROOT . 'uploaded_files/product_images/' . $pic4, 50);
          }
        }

        //cat links
        $postCategory = $this->input->post('category_id');
        $category_links = "";
        $catlink = $ctl = "";
        foreach ($postCategory as $ctv) {
          $catlink = get_parent_categories($ctv, "AND status='1'", "category_id,parent_id");
          $ctl = array_keys($catlink);
          $category_links .= implode(",", $ctl) . ',';
        }
        $category_links = substr($category_links, 0, -1);

        $posted_data = array(
            'customers_id' => $mres['customers_id'],
            //'category_id' => implode(',', $this->input->post('category_id')),
            'category_id' => $this->input->post('category_id'),
            'category_links' => $category_links,
            'website_category_id' => $website_category_id,
            'product_name' => $this->input->post('product_name', TRUE),
            'product_code' => $this->input->post('product_code', TRUE),
            'moq' => $this->input->post('moq', TRUE),
            'product_price' => $this->input->post('product_price', TRUE),
            'unit_value' => $this->input->post('unit_value'),
            'unit_measurement' => $this->input->post('unit_measurement'),
            'product_alt' => $this->input->post('product_name'),
            'attribute_name' => implode(',', $this->input->post('attribute_name')),
            'attribute_value' => implode(',', $this->input->post('attribute_value')),
            'dispatch_port' => $this->input->post('dispatch_port'),
            'delivery_time' => $this->input->post('delivery_time'),
            'packaging_details' => $this->input->post('packaging_details'),
            'dashkeyword' => $this->input->post('dashkeyword'),
            'youtube_id' => $this->input->post('youtube_id'),
            'products_description' => $this->input->post('description'),
            'status' => '0',
            'productType' => '0',
            'product_added_date' => $this->config->item('config.date.time')
        );
        //trace($posted_data); exit;
        $productId = $this->product_model->safe_insert('wps_products', $posted_data, FALSE);
        if ($productId > 0) {
          $this->cbk_friendly_url = seo_url_title($this->input->post('product_name') . ' ' . $productId);

          //update friendly_url
          $this->db->query("UPDATE wps_products SET friendly_url = '" . $this->cbk_friendly_url . "' WHERE products_id = '" . $productId . "'");

          //add images to table
          $is_default = 'Y';
          if ($pic1) {
            $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic1 . "', products_id = '" . $productId . "', media_date_added = '" . $this->config->item('config.date.time') . "', is_default = '" . $is_default . "'");
            $is_default = 'N';
          }
          if ($pic2) {
            $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic2 . "', products_id = '" . $productId . "', media_date_added = '" . $this->config->item('config.date.time') . "', is_default = '" . $is_default . "'");
            $is_default = 'N';
          }
          if ($pic3) {
            $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic3 . "', products_id = '" . $productId . "', media_date_added = '" . $this->config->item('config.date.time') . "', is_default = '" . $is_default . "'");
            $is_default = 'N';
          }
          if ($pic4) {
            $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic4 . "', products_id = '" . $productId . "', media_date_added = '" . $this->config->item('config.date.time') . "', is_default = '" . $is_default . "'");
            $is_default = 'N';
          }
          //End
          //Create Meta
          $redirect_url = "products/detail";
          $meta_array = array(
              'entity_type' => $redirect_url,
              'entity_id' => $productId,
              'page_url' => $this->cbk_friendly_url,
              'meta_title' => get_text($this->input->post('product_name'), 80),
              'meta_description' => get_text($this->input->post('description')),
              'meta_keyword' => get_keywords($this->input->post('description'))
          );
          create_meta($meta_array);
          //for company
          $meta_array = array(
              'entity_type' => "products/detail_comp",
              'entity_id' => $productId,
              'companyId' => $mres['customers_id'],
              'page_url' => $mres['website_url'] . '/' . $this->cbk_friendly_url,
              'meta_title' => get_text($this->input->post('product_name'), 80),
              'meta_description' => get_text($this->input->post('description')),
              'meta_keyword' => get_keywords($this->input->post('description'))
          );
          create_meta_company($meta_array_comp);
        }

        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', 'Product has been added successfully!!!');
        redirect('members/manage_listing', 'refresh');
      }
    } else {
      redirect('manage_listing', '');
    }

    //Global Variables
    $data['websiteCategory'] = $this->db->query("SELECT category_id, category_name FROM wps_company_categories WHERE status = '1' AND companyId = '".$mres['customers_id']."' and categoryType='0'")->result_array();
    $data['catList'] = $this->db->query("SELECT category_id, category_name FROM wps_categories WHERE status = '1' and parent_id=0 and catType='0' ")->result_array(); 

    $data['unit_measurement'] = $this->config->item('unit_measurement');
    $data['ckeditor'] = set_ck_config(array('textarea_id' => 'description', 'type' => 'basic'));

    //View
    $this->load->view('view_add_listing', $data);
  }

  public function add_listing_service() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    if (is_array($mres) && !empty($mres)) {

      $category_name = $this->db->escape_str($this->input->post('category_name'));
      if($category_name!=""){
        $this->form_validation->set_rules('category_name', 'New Category Name', "trim|max_length[100]|xss_clean|unique[wps_company_categories.category_name ='" . $category_name . "' AND status!='2' AND companyId='" . $mres['customers_id'] . "']");
      }

      $this->form_validation->set_rules('product_name', 'Product Name', 'required');

      $this->form_validation->set_rules('img1', 'Product Main Image', 'file_allowed_type[image]');
      $this->form_validation->set_rules('img2', 'Product Additional Image', 'file_allowed_type[image]');
      $this->form_validation->set_rules('img3', 'Product Additional Image', 'file_allowed_type[image]');
      $this->form_validation->set_rules('img4', 'Product Additional Image', 'file_allowed_type[image]');
      $this->form_validation->set_rules('youtube_id', 'Youtube Link', 'trim|max_length[220]');

      $this->form_validation->set_rules('product_price', 'Price', 'trim|valid_amount');
      $this->form_validation->set_rules('unit_value', 'Unit Value', 'trim');
      $this->form_validation->set_rules('unit_measurement', 'Unit Measurement', 'trim');

      $this->form_validation->set_rules('description', 'Product Description', 'trim');
      //$this->form_validation->set_rules('dashkeyword', 'Category ID', 'trim|required');
      $this->form_validation->set_rules('category_id', 'Product Category', 'trim|required');
      $this->form_validation->set_rules('website_category_id', 'Product Category', 'trim');
      $this->form_validation->set_rules('attribute_name[]', 'Attribute Name', 'trim');
      $this->form_validation->set_rules('attribute_value[]', 'Attribute Value', 'trim');
      $this->form_validation->set_rules('moq', 'Minimum Order Quantity', 'trim');

      $this->form_validation->set_rules('product_code', 'Product Code', 'trim|');
      $this->form_validation->set_rules('dispatch_port', 'Dispatch Port', 'trim|');
      $this->form_validation->set_rules('delivery_time', 'Delivery Time', 'trim|');
      $this->form_validation->set_rules('packaging_details', 'Packaging Details', 'trim|max_length[220]');
      if ($this->form_validation->run() == TRUE) {

        if($category_name!=""){

          $category_posted_friendly_url = seo_url_title($category_name);
          $redirect_url = "wpstemplate/category/index";
          $category_alt = $category_name;
          $category_description = NULL;
          $uploaded_file = NULL;

          $posted_data = array(
              'companyId' => $mres['customers_id'],
              'category_name' => $category_name,
              'category_alt' => $category_alt,
              'category_description' => $category_description,
              'parent_id' => 0,
              'categoryType' =>'1',
              'friendly_url' => $mres['website_url'] . '/' . $category_posted_friendly_url,
              'date_added' => $this->config->item('config.date.time'),
              'category_image' => $uploaded_file,
          );
          $website_category_id = $this->category_model->safe_insert('wps_company_categories', $posted_data, FALSE);
  
          if ($website_category_id > 0) {
            //create meta
              $meta_description = $category_name;
              $meta_keyword = $category_name;
              $meta_title = $category_name;
              $meta_array = array(
                  'entity_type' => $redirect_url,
                  'entity_id' => $website_category_id,
                  'companyId' => $mres['customers_id'],
                  'page_url' => $mres['website_url'] . '/' . $category_posted_friendly_url,
                  'meta_title' =>$meta_title,
                  'meta_description' =>$meta_description,
                  'meta_keyword' =>$meta_keyword
              );
              create_meta_company($meta_array);
              //end
          }

        }else{
          $website_category_id = $this->input->post('website_category_id');
        }

        $pic1 = '';
        if (!empty($_FILES) && $_FILES['img1']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('img1', 'product_images', seo_url_title($this->input->post('product_name') . '-1'));
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $pic1 = $uploaded_data['upload_data']['file_name'];
            compressImage(FCROOT . 'uploaded_files/product_images/' . $pic1, FCROOT . 'uploaded_files/product_images/' . $pic1, 50);
          }
        }

        $pic2 = '';
        if (!empty($_FILES) && $_FILES['img2']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('img2', 'product_images', seo_url_title($this->input->post('product_name') . '-2'));
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $pic2 = $uploaded_data['upload_data']['file_name'];
            compressImage(FCROOT . 'uploaded_files/product_images/' . $pic2, FCROOT . 'uploaded_files/product_images/' . $pic2, 50);
          }
        }

        $pic3 = '';
        if (!empty($_FILES) && $_FILES['img3']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('img3', 'product_images', seo_url_title($this->input->post('product_name') . '-3'));
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $pic3 = $uploaded_data['upload_data']['file_name'];
            compressImage(FCROOT . 'uploaded_files/product_images/' . $pic3, FCROOT . 'uploaded_files/product_images/' . $pic3, 50);
          }
        }

        $pic4 = '';
        if (!empty($_FILES) && $_FILES['img4']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('img4', 'product_images', seo_url_title($this->input->post('product_name') . '-4'));
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $pic4 = $uploaded_data['upload_data']['file_name'];
            compressImage(FCROOT . 'uploaded_files/product_images/' . $pic4, FCROOT . 'uploaded_files/product_images/' . $pic4, 50);
          }
        }

        //cat links
        $postCategory = $this->input->post('category_id');
        $category_links = "";
        $catlink = $ctl = "";
        foreach ($postCategory as $ctv) {
          $catlink = get_parent_categories($ctv, "AND status='1'", "category_id,parent_id");
          $ctl = array_keys($catlink);
          $category_links .= implode(",", $ctl) . ',';
        }
        $category_links = substr($category_links, 0, -1);

        $posted_data = array(
            'customers_id' => $mres['customers_id'],
            //'category_id' => implode(',', $this->input->post('category_id')),
            'category_id' => $this->input->post('category_id'),
            'category_links' => $category_links,
            'website_category_id' => $website_category_id,
            'product_name' => $this->input->post('product_name', TRUE),
            'product_code' => $this->input->post('product_code', TRUE),
            'moq' => $this->input->post('moq', TRUE),
            'product_price' => $this->input->post('product_price', TRUE),
            'unit_value' => $this->input->post('unit_value'),
            'unit_measurement' => $this->input->post('unit_measurement'),
            'product_alt' => $this->input->post('product_name'),
            'attribute_name' => implode(',', $this->input->post('attribute_name')),
            'attribute_value' => implode(',', $this->input->post('attribute_value')),
            'dispatch_port' => $this->input->post('dispatch_port'),
            'delivery_time' => $this->input->post('delivery_time'),
            'packaging_details' => $this->input->post('packaging_details'),
            'dashkeyword' => $this->input->post('dashkeyword'),
            'youtube_id' => $this->input->post('youtube_id'),
            'products_description' => $this->input->post('description'),
            'status' => '0',
            'productType' => '1',
            'product_added_date' => $this->config->item('config.date.time')
        );
        //trace($posted_data); exit;
        $productId = $this->product_model->safe_insert('wps_products', $posted_data, FALSE);
        if ($productId > 0) {
          $this->cbk_friendly_url = seo_url_title($this->input->post('product_name') . ' ' . $productId);

          //update friendly_url
          $this->db->query("UPDATE wps_products SET friendly_url = '" . $this->cbk_friendly_url . "' WHERE products_id = '" . $productId . "'");

          //add images to table
          $is_default = 'Y';
          if ($pic1) {
            $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic1 . "', products_id = '" . $productId . "', media_date_added = '" . $this->config->item('config.date.time') . "', is_default = '" . $is_default . "'");
            $is_default = 'N';
          }
          if ($pic2) {
            $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic2 . "', products_id = '" . $productId . "', media_date_added = '" . $this->config->item('config.date.time') . "', is_default = '" . $is_default . "'");
            $is_default = 'N';
          }
          if ($pic3) {
            $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic3 . "', products_id = '" . $productId . "', media_date_added = '" . $this->config->item('config.date.time') . "', is_default = '" . $is_default . "'");
            $is_default = 'N';
          }
          if ($pic4) {
            $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic4 . "', products_id = '" . $productId . "', media_date_added = '" . $this->config->item('config.date.time') . "', is_default = '" . $is_default . "'");
            $is_default = 'N';
          }
          //End
          //Create Meta
          $redirect_url = "products/detail";
          $meta_array = array(
              'entity_type' => $redirect_url,
              'entity_id' => $productId,
              'page_url' => $this->cbk_friendly_url,
              'meta_title' => get_text($this->input->post('product_name'), 80),
              'meta_description' => get_text($this->input->post('description')),
              'meta_keyword' => get_keywords($this->input->post('description'))
          );
          create_meta($meta_array);
          //for company
          $meta_array = array(
              'entity_type' => "products/detail_comp",
              'entity_id' => $productId,
              'companyId' => $mres['customers_id'],
              'page_url' => $mres['website_url'] . '/' . $this->cbk_friendly_url,
              'meta_title' => get_text($this->input->post('product_name'), 80),
              'meta_description' => get_text($this->input->post('description')),
              'meta_keyword' => get_keywords($this->input->post('description'))
          );
          create_meta_company($meta_array_comp);
        }

        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', 'Product has been added successfully!!!');
        redirect('members/manage_listing', 'refresh');
      }
    } else {
      redirect('manage_listing', '');
    }

    //Global Variables
    $data['websiteCategory'] = $this->db->query("SELECT category_id, category_name FROM wps_company_categories WHERE status = '1' AND companyId = '".$mres['customers_id']."' and categoryType='1' ")->result_array();
    $data['catList'] = $this->db->query("SELECT category_id, category_name FROM wps_categories WHERE status = '1' and parent_id=0 and catType='1' ")->result_array(); 

    $data['unit_measurement'] = $this->config->item('unit_measurement');
    $data['ckeditor'] = set_ck_config(array('textarea_id' => 'description', 'type' => 'basic'));

    //View
    $this->load->view('view_add_listing_service', $data);
  }

  public function edit_listing() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    //product details
    $productId = (int) $this->uri->segment(3);
    $option = array('productid' => $productId);
    $res = $this->product_model->get_products(1, 0, $option);
    $res = $res[0];
    $data['res'] = $res;
    //media
    $media = $this->product_model->get_product_media(4, 0, array('productid' => $res['products_id']));
    $data['media_res'] = $media;
    //trace($media);

    if (is_array($res) && !empty($res)) {
      $this->form_validation->set_rules('product_name', 'Product Name', 'required');

      $this->form_validation->set_rules('img1', 'Product Main Image', 'file_allowed_type[image]');
      $this->form_validation->set_rules('img2', 'Product Additional Image', 'file_allowed_type[image]');
      $this->form_validation->set_rules('img3', 'Product Additional Image', 'file_allowed_type[image]');
      $this->form_validation->set_rules('img4', 'Product Additional Image', 'file_allowed_type[image]');
      $this->form_validation->set_rules('youtube_id', 'Youtube Link', 'trim|max_length[220]');

      $this->form_validation->set_rules('product_price', 'Price', 'trim|required|valid_amount');
      $this->form_validation->set_rules('unit_value', 'Unit Value', 'trim|required');
      $this->form_validation->set_rules('unit_measurement', 'Unit Measurement', 'trim|required');

      $this->form_validation->set_rules('description', 'Product Description', 'trim');
      //$this->form_validation->set_rules('dashkeyword', 'Category ID', 'trim|required');
      //$this->form_validation->set_rules('category_id[]', 'Product Category', 'trim|required');
      $this->form_validation->set_rules('website_category_id', 'Product Category', 'trim');
      $this->form_validation->set_rules('attribute_name[]', 'Attribute Name', 'trim');
      $this->form_validation->set_rules('attribute_value[]', 'Attribute Value', 'trim');
      $this->form_validation->set_rules('moq', 'Minimum Order Quantity', 'trim|required');

      $this->form_validation->set_rules('product_code', 'Product Code', 'trim|');
      $this->form_validation->set_rules('dispatch_port', 'Dispatch Port', 'trim|');
      $this->form_validation->set_rules('delivery_time', 'Delivery Time', 'trim|');
      $this->form_validation->set_rules('packaging_details', 'Packaging Details', 'trim|max_length[220]');
      if ($this->form_validation->run() == TRUE) {

        $media1 = (isset($media[0]['media'])) ? $media[0]['id'] : '';
        $media2 = (isset($media[1]['media'])) ? $media[1]['id'] : '';
        $media3 = (isset($media[2]['media'])) ? $media[2]['id'] : '';
        $media4 = (isset($media[3]['media'])) ? $media[3]['id'] : '';

        $mediaFile1 = (isset($media[0]['media'])) ? $media[0]['media'] : '';
        $mediaFile2 = (isset($media[1]['media'])) ? $media[1]['media'] : '';
        $mediaFile3 = (isset($media[2]['media'])) ? $media[2]['media'] : '';
        $mediaFile4 = (isset($media[3]['media'])) ? $media[3]['media'] : '';

        $pic1 = $mediaFile1;
        $unlink_image1 = array('source_dir' => "product_images", 'source_file' => $mediaFile1);
        if (!empty($_FILES) && $_FILES['img1']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('img1', 'product_images', seo_url_title($this->input->post('product_name') . '-1'));
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $pic1 = $uploaded_data['upload_data']['file_name'];
            compressImage(FCROOT . 'uploaded_files/product_images/' . $pic1, FCROOT . 'uploaded_files/product_images/' . $pic1, 50);
            clear_cache();
            removeImage($unlink_image1);
            if ($mediaFile1) {
              $this->db->query("UPDATE wps_products_media SET media = '" . $pic1 . "' WHERE products_id = '" . $productId . "' AND id = '" . $media1 . "'");
            } else {
              $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic1 . "', products_id = '" . $productId . "'");
            }
          }
        }

        $pic2 = $mediaFile2;
        $unlink_image2 = array('source_dir' => "product_images", 'source_file' => $mediaFile2);
        if (!empty($_FILES) && $_FILES['img2']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('img2', 'product_images', seo_url_title($this->input->post('product_name') . '-2'));
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $pic2 = $uploaded_data['upload_data']['file_name'];
            compressImage(FCROOT . 'uploaded_files/product_images/' . $pic2, FCROOT . 'uploaded_files/product_images/' . $pic2, 50);
            clear_cache();
            removeImage($unlink_image2);
            if ($mediaFile2) {
              $this->db->query("UPDATE wps_products_media SET media = '" . $pic2 . "' WHERE products_id = '" . $productId . "' AND id = '" . $media2 . "'");
            } else {
              $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic2 . "', products_id = '" . $productId . "'");
            }
          }
        }

        $pic3 = $mediaFile3;
        $unlink_image3 = array('source_dir' => "product_images", 'source_file' => $mediaFile3);
        if (!empty($_FILES) && $_FILES['img3']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('img3', 'product_images', seo_url_title($this->input->post('product_name') . '-3'));
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $pic3 = $uploaded_data['upload_data']['file_name'];
            compressImage(FCROOT . 'uploaded_files/product_images/' . $pic3, FCROOT . 'uploaded_files/product_images/' . $pic3, 50);
            clear_cache();
            removeImage($unlink_image3);
            if ($mediaFile3) {
              $this->db->query("UPDATE wps_products_media SET media = '" . $pic3 . "' WHERE products_id = '" . $productId . "' AND id = '" . $media3 . "'");
            } else {
              $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic3 . "', products_id = '" . $productId . "'");
            }
          }
        }

        $pic4 = $mediaFile4;
        $unlink_image4 = array('source_dir' => "product_images", 'source_file' => $mediaFile4);
        if (!empty($_FILES) && $_FILES['img4']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('img4', 'product_images', seo_url_title($this->input->post('product_name') . '-4'));
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $pic4 = $uploaded_data['upload_data']['file_name'];
            compressImage(FCROOT . 'uploaded_files/product_images/' . $pic4, FCROOT . 'uploaded_files/product_images/' . $pic4, 50);
            clear_cache();
            removeImage($unlink_image4);
            if ($mediaFile4) {
              $this->db->query("UPDATE wps_products_media SET media = '" . $pic4 . "' WHERE products_id = '" . $productId . "' AND id = '" . $media4 . "'");
            } else {
              $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic4 . "', products_id = '" . $productId . "'");
            }
          }
        }

        //cat links
        $postCategory = $this->input->post('category_id');
        $category_links = "";
        $catlink = $ctl = "";
        foreach ($postCategory as $ctv) {
          $catlink = get_parent_categories($ctv, "AND status='1'", "category_id,parent_id");
          $ctl = array_keys($catlink);
          $category_links .= implode(",", $ctl) . ',';
        }
        $category_links = substr($category_links, 0, -1);

        $posted_data = array(
           // 'category_id' => implode(',', $this->input->post('category_id')),
            //'category_links' => $category_links,
            'website_category_id' => $this->input->post('website_category_id'),
            'product_name' => $this->input->post('product_name', TRUE),
            'product_code' => $this->input->post('product_code', TRUE),
            'moq' => $this->input->post('moq', TRUE),
            'product_price' => $this->input->post('product_price', TRUE),
            'unit_value' => $this->input->post('unit_value'),
            'unit_measurement' => $this->input->post('unit_measurement'),
            'product_alt' => $this->input->post('product_name'),
            'attribute_name' => implode(',', $this->input->post('attribute_name')),
            'attribute_value' => implode(',', $this->input->post('attribute_value')),
            'dispatch_port' => $this->input->post('dispatch_port'),
            'delivery_time' => $this->input->post('delivery_time'),
            'packaging_details' => $this->input->post('packaging_details'),
            'dashkeyword' => $this->input->post('dashkeyword'),
            'youtube_id' => $this->input->post('youtube_id'),
            'products_description' => $this->input->post('description'),
            'product_added_date' => $this->config->item('config.date.time')
        );
        //trace($posted_data); exit;
        $where = "products_id = '" . $res['products_id'] . "'";
        $this->product_model->safe_update('wps_products', $posted_data, $where, FALSE);

        //check if it not added then add in meta table of company
        if ($this->input->post('website_category_id') > 0) {
          $metaCount = count_record("wps_meta_tags_company", "entity_id = '" . $res['products_id'] . "' AND entity_type = 'products/detail_comp'");
          if ($metaCount == 0) {
            //for company
            $meta_array_comp = array(
                'entity_type' => 'products/detail_comp',
                'entity_id' => $res['products_id'],
                'companyId' => $mres['customers_id'],
                'page_url' => $mres['website_url'] . '/' . $res['friendly_url'],
                'meta_title' => get_text($this->input->post('product_name'), 80),
                'meta_description' => get_text($this->input->post('description')),
                'meta_keyword' => get_keywords($this->input->post('description'))
            );
            create_meta_company($meta_array_comp);
          }
        }

        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', 'Product has been updated successfully!!!');
        redirect('members/manage_listing', 'refresh');
      }
    } else {
      redirect('manage_listing', '');
    }

    //Global Variables
    $data['websiteCategory'] = $this->db->query("SELECT category_id, category_name FROM wps_company_categories WHERE status = '1' AND companyId = '".$mres['customers_id']."'")->result_array();
    $data['unit_measurement'] = $this->config->item('unit_measurement');
    $data['ckeditor'] = set_ck_config(array('textarea_id' => 'description', 'type' => 'basic'));

    //View
    $this->load->view('view_edit_listing', $data);
  }

  public function manage_enquiries() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));

    $condition = "venq.customers_id = '" . $this->userId . "' AND venq.status = '1' ORDER BY e.id DESC";
    $res_array = $this->enquiry_model->get_customers_enquiry($offset, $config['limit'], $condition);
    //echo_sql();
    //die;
    $data['total_rec'] = get_found_rows();

    $config['total_rows'] = $this->enquiry_model->total_rec_found;
    $data['page_links'] = front_pagination($base_url, $config['total_rows'], $config['limit'], $offset);

    $data['res'] = $res_array;

    //trace($res_array);
    $data['heading_title'] = "My Enquiries";
    $this->load->view('list_enq_my_view', $data);
  }

  public function manage_website_enquiries() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = 10;
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));

    $condition = "customers_id = '" . $this->userId . "'";
    $res_array = $this->enquiry_model->get_company_enquiry($offset, $config['limit'], $condition);
    //echo $this->db->last_query();
    //die;
    $data['total_rec'] = get_found_rows();

    //echo $config['total_rows'] = $this->enquiry_model->total_rec_found;
    $data['page_links'] = dashboard_pagination($base_url, $data['total_rec'], $config['limit'], $offset);

    $data['res'] = $res_array;


    //get listing
    $condtion = array();
    $config['per_page'] = $this->config->item('per_page');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $condtion['customers_id'] = $mres['customers_id'];
    $res_array = $this->enquiry_model->get_company_enquiry($offset, $config['per_page'], $condtion);
    $data['total_rows'] = $config['total_rows'] = $this->enquiry_model->total_rec_found;
    $data['page_links'] = dashboard_pagination($base_url, $config['total_rows'], $config['per_page'], $offset);
    $data['res'] = $res_array;
    //End here
    //trace($res_array);
    $data['heading_title'] = "My Enquiries";
    $this->load->view('list_enq_comp_view', $data);
  }

  public function add_vendor_comment() {

    $enqId = $this->input->post('enqId');
    $vendId = $this->input->post('vendId');
    $customersId = $this->session->userdata('user_id');
    $conversation_ty = $this->input->post('conversation_ty');
    $comment = $this->input->post('comment');
    $follow_up_date = $this->input->post('follow_up_date');
    $follow_up_time = $this->input->post('follow_up_time');
    $stage = $this->input->post('stage');

    $posted_data = array(
        'customers_id' => $customersId,
        'id' => $vendId,
        'enqId' => $enqId,
        'activity_stage' => $stage,
        'activity_comment' => $comment,
        'activity_ndate' => $follow_up_date,
        'activity_ntime' => $follow_up_time,
        'conversation_ty' => $conversation_ty,
        'activity_date' => $this->config->item('config.date.time'),
        'activity_time' => date("H:i"),
    );

    //Finally insert data into the table.
    $result = $this->members_model->safe_insert('wps_vendor_activity', $posted_data, false);
    $this->db->query("UPDATE wps_vendor_enquiry SET nextContactDate = '" . $follow_up_date . "', follow_up_time = '" . $follow_up_time . "', stage = '" . $stage . "' WHERE enqId = '" . $enqId . "'");

    if ($result) {
      echo json_encode(['msg' => 'Comment added successfully.']);
    } else {
      echo json_encode(['msg' => 'Error! Something went wrong.']);
    }
  }

  public function get_req_cvs($param = array()) {
    $result = $this->db->query("SELECT * FROM wps_vendor_activity WHERE enqId = '" . $param['enqId'] . "' ORDER BY activity_date DESC, activity_id DESC")->result_array();
    // print_r($result);
    $result1 = array();
    $i = 0;
    foreach ($result as $rkey => $rval):
      $res = $this->db->query("SELECT activity_stage, activity_comment, conversation_ty, activity_date FROM wps_vendor_activity WHERE activity_id = '" . $rval['activity_id'] . "'")->row_array();
      // print_r($rval);
      // print_r($res);
      if ($res['conversation_ty'] == 1) {
        $text = '<a href="javascript:void(0)" style="margin-right:10px; cursor: default;" class="btn btn-success btn-xs">Conversation: </a>';
      } elseif ($res['conversation_ty'] == 2) {
        $text = '<a href="javascript:void(0)" style="margin-right:10px; cursor: default;" class="btn btn-warning btn-xs">Chat: </a>';
      } else {
        $text = '<a href="javascript:void(0)" style="margin-right:10px; cursor: default;" class="btn btn-danger btn-xs">Others: </a>';
      }
      $result1[$i] = $rval;
      $result1[$i]['cv_stage'] = $res['activity_stage'];
      $result1[$i]['cv_comment'] = $text . $res['activity_comment'];
      $result1[$i]['added_date'] = getDateFormat($res['activity_date'], 3);
      $i++;
    endforeach;
    $var = "";
    if (is_array($result1) && !empty($result1)) {
      foreach ($result1 as $res) {
        $stage = '';
        if ($res['cv_stage'] == '1') {
          $stage = 'Follow Up';
        }
        if ($res['cv_stage'] == '2') {
          $stage = 'Interested';
        }
        if ($res['cv_stage'] == '3') {
          $stage = 'Not Interested';
        }
        if ($res['cv_stage'] == '4') {
          $stage = 'Paid';
        }
        $var .= '<tr>
                <td>' . $res['activity_id'] . '</td>
                <td>' . $res['cv_comment'] . '</td>
                <td>' . $stage . '</td>
                <td>' . $res['added_date'] . '</td>
                </tr>';
      }
    } else {
      $var = "<tr><td colspan='4'>No Records Found!</td></tr>";
    }
    echo $var;
  }

  public function view_addedcomments() {
    $enqId = $this->input->post('enqId');
    $param = array(
        'enqId' => $enqId
    );
    $result = $this->get_req_cvs($param);
    if (is_array($result) && !empty($result)) {
      echo json_encode(['status' => true, 'rows' => $result]);
    } else {
      echo json_encode(['status' => FALSE]);
    }
  }

  function alpha_dash_space($str) {
    return (!preg_match("/^([-a-z0-9])+$/i", $str)) ? FALSE : TRUE;
  }

  //Manage Company Modules
  public function company_blog($page = NULL) {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;
    $companyId = $mres['customers_id'];
    $condtion = array();
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = 10;
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $status = $this->input->get_post('status', TRUE);
    if ($status != '') {
      $condtion['status'] = $status;
    }
    $condtion['companyId'] = $companyId;
    $res_array = $this->blog_model->get_company_blog($config['limit'], $offset, $condtion);
    //echo_sql(); die;
    $config['total_rows'] = get_found_rows();
    $data['heading_title'] = 'Blog Lists';
    $data['res'] = $res_array;
    $data['page_links'] = dashboard_pagination($base_url, $config['total_rows'], $config['limit'], $offset);

    if ($this->input->post('status_action') != '') {
      $this->update_status('wps_company_blog', 'article_id');
    }
    /* End product set as a */
    $data['category_result_found'] = "Total " . $config['total_rows'] . " result(s) found ";
    $this->load->view('members/view_comp_blog_list', $data);
  }

  public function add_blog() {
    $seo_url_length = $this->config->item('seo_url_length');
    $data['heading_title'] = 'Add Blog';
    $data['ckeditor'] = set_ck_config(array('textarea_id' => 'article_desc'));

    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    $this->form_validation->set_rules('article_title', 'Title', "trim|required|max_length[200]");
    $this->form_validation->set_rules('article_desc', 'Description', "required|max_length[8500]");
    $this->form_validation->set_rules('image1', 'Image', "required|file_allowed_type[image]");
    if ($this->form_validation->run() === TRUE) {

      $posted_friendly_url = $this->input->post('article_title');
      $this->cbk_friendly_url = seo_url_title($posted_friendly_url);

      $uploaded_file = "";
      if (!empty($_FILES) && $_FILES['image1']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('image1', 'blog');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
        }
      }

      $posted_data = array(
          'article_title' => $this->input->post('article_title', TRUE),
          'friendly_url' => $mres['website_url'] . '/' . $this->cbk_friendly_url,
          'article_desc' => $this->input->post('article_desc'),
          'article_image' => $uploaded_file,
          'companyId' => $mres['customers_id'],
          'post_date' => $this->config->item('config.date.time')
      );
      $blogId = $this->blog_model->safe_insert('wps_company_blog', $posted_data, FALSE);
      if ($blogId) {
        $redirect_url = "wpstemplate/blog_details";
        $meta_array = array(
            'entity_type' => $redirect_url,
            'entity_id' => $blogId,
            'page_url' => $mres['website_url'] . '/' . $this->cbk_friendly_url,
            'companyId' => $mres['customers_id'],
            'meta_title' => get_text($this->input->post('article_title'), 80),
            'meta_description' => get_text($this->input->post('article_desc')),
            'meta_keyword' => get_keywords($this->input->post('article_desc'))
        );
        create_meta_company($meta_array);
      }
      //$this->add_product_media($productId);	
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', lang('success'));
      redirect('members/company_blog/', '');
    }
    $this->load->view('members/view_comp_blog_add', $data);
  }

  public function edit_blog() {

    $data['heading_title'] = 'Edit Blog';
    $blogId = (int) $this->uri->segment(3);
    $option = array('productid' => $blogId);
    $res = $this->blog_model->get_company_blog(1, 0, $option);
    $data['res'] = $res;

    $seo_url_length = $this->config->item('seo_url_length');
    $data['ckeditor'] = set_ck_config(array('textarea_id' => 'article_desc'));

    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    $this->form_validation->set_rules('article_title', 'Title', "trim|required|max_length[200]");
    $this->form_validation->set_rules('article_desc', 'Description', "required|max_length[8500]");
    $this->form_validation->set_rules('image1', 'Image', "file_allowed_type[image]");

    if (is_array($res) && !empty($res)) {

      $posted_friendly_url = $this->input->post('article_title');
      $this->cbk_friendly_url = seo_url_title($posted_friendly_url);
      $redirect_url = "wpstemplate/blog_details";

      if ($this->form_validation->run() == TRUE) {

        $uploaded_file = $res['article_image'];
        $unlink_image = array('source_dir' => "blog", 'source_file' => $res['article_image']);
        if (!empty($_FILES) && $_FILES['image1']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('image1', 'blog');
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $uploaded_file = $uploaded_data['upload_data']['file_name'];
            removeImage($unlink_image);
          }
        }

        $posted_data = array(
            'article_title' => $this->input->post('article_title'),
            'friendly_url' => $mres['website_url'] . '/' . $this->cbk_friendly_url,
            'article_desc' => $this->input->post('article_desc'),
            'article_image' => $uploaded_file
        );
        //trace($posted_data); die;
        $where = "article_id = '" . $blogId . "'";
        $this->blog_model->safe_update('wps_company_blog', $posted_data, $where, FALSE);

        //update meta
        update_comp_meta_page_url($redirect_url, $res['article_id'], $mres['website_url'] . '/' . $this->cbk_friendly_url, $mres['customers_id']);
        //End here

        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', lang('successupdate'));
        redirect('members/company_blog/', '');
      }
      $this->load->view('members/view_comp_blog_edit', $data);
    } else {
      redirect('members/company_blog', '');
    }
  }

  //Clients management
  public function clients() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;
    $companyId = $mres['customers_id'];

    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = 10;
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $condtion = " AND companyId = '" . $mres['customers_id'] . "'";

    $condtion_array = array(
        'field' => "*",
        'index' => 'client_id',
        'condition' => $condtion,
        'limit' => $config['limit'],
        'offset' => $offset,
        'debug' => FALSE
    );
    $res_array = $this->clients_model->getclients($condtion_array);
    $count = count_record("wps_clients", "companyId = '" . $mres['customers_id'] . "'");
    //echo_sql(); die;
    $config['total_rows'] = $count;
    $data['heading_title'] = 'Clients Lists';
    $data['res'] = $res_array;
    $data['page_links'] = dashboard_pagination($base_url, $config['total_rows'], $config['limit'], $offset);

    if ($this->input->post('status_action') != '') {
      $this->update_status('wps_clients', 'client_id');
    }
    /* End product set as a */
    $data['category_result_found'] = "Total " . $config['total_rows'] . " result(s) found ";
    $this->load->view('members/view_comp_client_list', $data);
  }

  public function add_client() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    $data['heading_title'] = 'Add Client';
    $this->form_validation->set_rules('client_name', 'Client Name', "trim|required|max_length[32]|xss_clean");
    $this->form_validation->set_rules('client_logo', 'Client Logo', "required|file_allowed_type[image]");

    if ($this->form_validation->run() === TRUE) {
      $uploaded_file = "";
      if (!empty($_FILES) && $_FILES['client_logo']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('client_logo', 'clients/clients');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
        }
      }
      $posted_data = array(
          'companyId' => $mres['customers_id'],
          'client_name' => $this->input->post('client_name', true),
          'client_logo' => $uploaded_file,
          'friendly_url' => seo_url_title($this->input->post('client_name', true)),
          'added_date' => $this->config->item('config.date.time')
      );
      $this->clients_model->safe_insert('wps_clients', $posted_data, FALSE);

      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'New Client Added Successfully.');
      redirect('members/clients', '');
    }
    $this->load->view('members/view_client_add', $data);
  }

  public function edit_client() {
    $client_id = $this->uri->segment(3);
    if (empty($client_id)) {
      redirect('members/clients');
    }
    $client_data = $this->clients_model->get_client_by_id($client_id);
    $data['heading_title'] = 'Edit Client';
    $this->form_validation->set_rules('client_name', 'Client Name', "trim|required|max_length[100]|xss_clean");
    $this->form_validation->set_rules('client_logo', 'Client Logo', "file_allowed_type[image]");

    if ($this->form_validation->run() === TRUE) {
      $uploaded_file = $client_data['client_logo'];
      $unlink_image = array('source_dir' => "clients/clients", 'source_file' => $client_data['client_logo']);
      if (!empty($_FILES) && $_FILES['client_logo']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('client_logo', 'clients/clients');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
          removeImage($unlink_image);
        }
      }
      $posted_data = array(
          'client_name' => $this->input->post('client_name'),
          'friendly_url' => seo_url_title($this->input->post('client_name', true)),
          'client_logo' => $uploaded_file,
      );
      $where = "client_id = $client_id";
      $this->clients_model->safe_update('wps_clients', $posted_data, $where, FALSE);

      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'Client details have been updated successfully.');
      redirect('members/clients', '');
    }
    $data['res'] = $client_data;
    $this->load->view('members/view_client_edit', $data);
  }

  public function career($page = NULL) {

    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    $condtion = array();
    $condtion['customers_id'] = $mres['customers_id'];

    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));

    $status = $this->input->get_post('status', TRUE);
    if ($status != '') {
      $condtion['status'] = $status;
    }

    $res_array = $this->career_model->get_career($config['limit'], $offset, $condtion);
    //echo_sql();
    $config['total_rows'] = get_found_rows();
    $data['heading_title'] = 'Career Lists';
    $data['res'] = $res_array;
    $data['page_links'] = dashboard_pagination($base_url, $config['total_rows'], $config['limit'], $offset);

    if ($this->input->post('status_action') != '') {
      $this->update_status('wps_career', 'career_id');
    }

    $data['category_result_found'] = "Total " . $config['total_rows'] . " result(s) found ";
    $this->load->view('members/view_career_list', $data);
  }

  public function add_job() {

    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    $seo_url_length = $this->config->item('seo_url_length');
    $data['heading_title'] = 'Add Job';
    $data['ckeditor'] = set_ck_config(array('textarea_id' => 'description'));
    $posted_friendly_url = $this->input->post('friendly_url');
    $this->cbk_friendly_url = seo_url_title($posted_friendly_url);

    $this->form_validation->set_rules('career_title', 'Title', "trim|required|max_length[200]");
    $this->form_validation->set_rules('designation', 'Designation', "trim|required|max_length[80]");
    $this->form_validation->set_rules('short_desc', 'Short Description', "trim|required|max_length[450]");
    $this->form_validation->set_rules('description', 'Description', "required|max_length[8500]");


    if ($this->form_validation->run() === TRUE) {
      $posted_data = array(
          'companyId' => $mres['customers_id'],
          'career_title' => $this->input->post('career_title', TRUE),
          'friendly_url' => $mres['website_url'] . '/' . seo_url_title($this->input->post('career_title')) . '-' . $mres['customers_id'],
          'designation' => $this->input->post('designation'),
          'short_desc' => $this->input->post('short_desc'),
          'description' => $this->input->post('description'),
          'post_date' => $this->config->item('config.date.time')
      );
      $jobId = $this->career_model->safe_insert('wps_career', $posted_data, FALSE);

      if ($jobId) {
        $redirect_url = "wpstemplate/career_details";
        $meta_array = array(
            'entity_type' => $redirect_url,
            'entity_id' => $jobId,
            'companyId' => $mres['customers_id'],
            'page_url' => $mres['website_url'] . '/' . seo_url_title($this->input->post('career_title')) . '-' . $mres['customers_id'],
            'meta_title' => get_text($this->input->post('career_title'), 80),
            'meta_description' => get_text($this->input->post('description')),
            'meta_keyword' => get_keywords($this->input->post('description'))
        );
        create_meta_company($meta_array);
      }
      //$this->add_product_media($productId);	
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'New Job has been posted.');
      redirect('members/career', '');
    }
    $this->load->view('members/view_career_add', $data);
  }

  public function edit_job() {

    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;


    $data['heading_title'] = 'Edit Job';
    $careerId = (int) $this->uri->segment(3);
    $option = array('career_id' => $careerId);
    $res = $this->career_model->get_career(1, 0, $option);
    $data['res'] = $res;

    $data['ckeditor'] = set_ck_config(array('textarea_id' => 'description'));



    $this->form_validation->set_rules('career_title', 'Title', "trim|required|max_length[200]");
    $this->form_validation->set_rules('designation', 'Designation', "trim|required|max_length[80]");
    $this->form_validation->set_rules('short_desc', 'Short Description', "trim|required|max_length[450]");
    $this->form_validation->set_rules('description', 'Description', "required|max_length[8500]");

    if (is_array($res) && !empty($res)) {
      if ($this->form_validation->run() == TRUE) {

        $posted_data = array(
            'career_title' => $this->input->post('career_title'),
            'designation' => $this->input->post('designation'),
            'short_desc' => $this->input->post('short_desc'),
        );
        $where = "career_id = '" . $careerId . "'";
        $this->career_model->safe_update('wps_career', $posted_data, $where, FALSE);

        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', 'Job Updated Successfully.');
        redirect('members/career', '');
      }
      $this->load->view('members/view_career_edit', $data);
    } else {
      redirect('members/career', '');
    }
  }

  public function applications() {

    $ref_article_id = (int) $this->uri->segment(3);
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : 25;
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $keyword = trim($this->input->get_post('keyword', TRUE));
    $keyword = $this->db->escape_str($keyword);
    $condtion = "";
    if ($ref_article_id != '') {
      $condtion = "&& career_id = '" . $ref_article_id . "'";
    }
    $status = $this->input->get_post('status', TRUE);
    $keyword = $this->input->get_post('keyword', TRUE);
    if ($status != '') {
      $condtion['status'] = $status;
    }
    if ($keyword != '') {
      $condtion['keyword'] = $keyword;
    }
    $condtion_array = array(
        'field' => "*",
        'condition' => $condtion,
        'ref_career_id' => $ref_article_id,
        'type' => 'A',
        'debug' => FALSE
    );
    $res_array = $this->career_model->get_review_comment($config['limit'], $offset, $condtion_array);
    $data['title'] = 'Job Applications';
    $config['total_rows'] = $this->career_model->total_rec_found;
    $data['page_links'] = dashboard_pagination($base_url, $config['total_rows'], $config['limit'], $offset);
    $data['heading_title'] = 'Job Applications';
    $data['ref_article_id'] = $ref_article_id;
    $data['res'] = $res_array;

    $this->load->view('members/view_application_list', $data);
  }

  public function banners($page = NULL) {

    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    $data['heading_title'] = 'Banners Lists';
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = 10; //( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $res_array = $this->banner_model->get_company_banner($config['limit'], $offset, array('customers_id' => $mres['customers_id']));
    $config['total_rows'] = get_found_rows();
    $data['res'] = $res_array;
    //echo_sql(); die;
    //$config['total_rows'] = $this->banner_model->total_rec_found;
    $data['page_links'] = dashboard_pagination($base_url, $config['total_rows'], $config['limit'], $offset);


    if ($this->input->post('status_action') != '') {
      $this->update_status('wps_company_banners', 'banner_id');
    }
    $this->load->view('members/view_banner_list', $data);
  }

  public function add_banner() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    $data['heading_title'] = 'Add Client';

    $this->form_validation->set_rules('banner_image', 'Banner Image', "required|file_allowed_type[image]");
    $this->form_validation->set_rules('banner_text', 'Banner Text', "trim|required|max_length[80]");

    if ($this->form_validation->run() === TRUE) {
      $uploaded_file = "";
      if (!empty($_FILES) && $_FILES['banner_image']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('banner_image', 'clients/banners');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
        }
      }
      $posted_data = array(
          'companyId' => $mres['customers_id'],
          'banner_image' => $uploaded_file,
          'banner_text' => $this->input->post('banner_text'),
          'banner_added_date' => $this->config->item('config.date.time')
      );
      $this->banner_model->safe_insert('wps_company_banners', $posted_data, FALSE);

      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'New banner Added Successfully.');
      redirect('members/banners', '');
    }
    $this->load->view('members/view_banner_add', $data);
  }

  public function edit_banner() {
    $banner_id = $this->uri->segment(3);
    if (empty($banner_id)) {
      redirect('members/banners');
    }
    $client_data = $this->banner_model->get_company_banner_by_id($banner_id);
    //trace($client_data);
    $data['heading_title'] = 'Edit Banner';
    $this->form_validation->set_rules('banner_image', 'Banner Image', "file_allowed_type[image]");
    $this->form_validation->set_rules('banner_text', 'Banner Text', "trim|required|max_length[80]");

    if ($this->form_validation->run() === TRUE) {
      $uploaded_file = $client_data->banner_image;
      $unlink_image = array('source_dir' => "clients/banners", 'source_file' => $client_data->banner_image);
      if (!empty($_FILES) && $_FILES['banner_image']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('banner_image', 'clients/banners');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
          removeImage($unlink_image);
        }
      }
      $posted_data = array(
          'banner_image' => $uploaded_file,
          'banner_text' => $this->input->post('banner_text'),
      );
      $where = "banner_id = $banner_id";
      $this->banner_model->safe_update('wps_company_banners', $posted_data, $where, FALSE);

      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'Banner has been updated successfully.');
      redirect('members/banners', '');
    }
    $data['res'] = $client_data;
    $this->load->view('members/view_banner_edit', $data);
  }

  public function photo_gallery($page = NULL) {

    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    $data['heading_title'] = 'Photo Lists';
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = 10; //( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $res_array = $this->banner_model->get_company_photo($config['limit'], $offset, array('customers_id' => $mres['customers_id']));
    $config['total_rows'] = get_found_rows();
    $data['res'] = $res_array;
    //echo_sql(); die;
    //$config['total_rows'] = $this->banner_model->total_rec_found;
    $data['page_links'] = dashboard_pagination($base_url, $config['total_rows'], $config['limit'], $offset);


    if ($this->input->post('status_action') != '') {
      $this->update_status('wps_company_photos', 'photo_id');
    }
    $this->load->view('members/view_photo_list', $data);
  }

  public function add_photo() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    $data['heading_title'] = 'Add Photo';

    $this->form_validation->set_rules('photo_image', 'Image', "required|file_allowed_type[image]");
    $this->form_validation->set_rules('photo_text', 'Photo Text', "trim|required|max_length[80]");

    if ($this->form_validation->run() === TRUE) {
      $uploaded_file = "";
      if (!empty($_FILES) && $_FILES['photo_image']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('photo_image', 'clients/photos');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
        }
      }
      $posted_data = array(
          'companyId' => $mres['customers_id'],
          'photo_image' => $uploaded_file,
          'photo_text' => $this->input->post('photo_text'),
          'added_date' => $this->config->item('config.date.time')
      );
      $this->banner_model->safe_insert('wps_company_photos', $posted_data, FALSE);
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'New Photo Added Successfully.');
      redirect('members/photo_gallery', '');
    }
    $this->load->view('members/view_photo_add', $data);
  }

  public function edit_photo() {
    $photo_id = $this->uri->segment(3);
    if (empty($photo_id)) {
      redirect('members/photo_gallery');
    }
    $client_data = $this->banner_model->get_company_photo_by_id($photo_id);
    //trace($client_data);
    $data['heading_title'] = 'Edit Photo';
    $this->form_validation->set_rules('photo_image', 'Photo Image', "file_allowed_type[image]");
    $this->form_validation->set_rules('photo_text', 'Photo Text', "trim|required|max_length[80]");

    if ($this->form_validation->run() === TRUE) {
      $uploaded_file = $client_data->photo_image;
      $unlink_image = array('source_dir' => "clients/photos", 'source_file' => $client_data->photo_image);
      if (!empty($_FILES) && $_FILES['photo_image']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('photo_image', 'clients/photos');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
          removeImage($unlink_image);
        }
      }
      $posted_data = array(
          'photo_image' => $uploaded_file,
          'photo_text' => $this->input->post('photo_text'),
      );
      $where = "photo_id = $photo_id";
      $this->banner_model->safe_update('wps_company_photos', $posted_data, $where, FALSE);

      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'Photo has been updated successfully.');
      redirect('members/photo_gallery', '');
    }
    $data['res'] = $client_data;
    $this->load->view('members/view_photo_edit', $data);
  }

  public function video_gallery($page = NULL) {

    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    $data['heading_title'] = 'Video Lists';
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = 10; //( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $res_array = $this->banner_model->get_company_video($config['limit'], $offset, array('customers_id' => $mres['customers_id']));
    $config['total_rows'] = get_found_rows();
    $data['res'] = $res_array;
    //echo_sql(); die;
    //$config['total_rows'] = $this->banner_model->total_rec_found;
    $data['page_links'] = dashboard_pagination($base_url, $config['total_rows'], $config['limit'], $offset);


    if ($this->input->post('status_action') != '') {
      $this->update_status('wps_company_videos', 'video_id');
    }
    $this->load->view('members/view_video_list', $data);
  }

  public function add_video() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $data['mres'] = $mres;

    $data['heading_title'] = 'Add Video';

    $this->form_validation->set_rules('video_image', 'Video Embed Link', "trim|required");
    $this->form_validation->set_rules('video_text', 'Video Caption', "trim|required|max_length[80]");

    if ($this->form_validation->run() === TRUE) {
      $posted_data = array(
          'companyId' => $mres['customers_id'],
          'video_image' => $this->input->post('video_image'),
          'video_text' => $this->input->post('video_text'),
          'added_date' => $this->config->item('config.date.time')
      );
      $this->banner_model->safe_insert('wps_company_videos', $posted_data, FALSE);
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'New Video Added Successfully.');
      redirect('members/video_gallery', '');
    }
    $this->load->view('members/view_video_add', $data);
  }

  public function edit_video() {
    $video_id = $this->uri->segment(3);
    if (empty($video_id)) {
      redirect('members/photo_gallery');
    }
    $client_data = $this->banner_model->get_company_video_by_id($video_id);
    //trace($client_data);
    $data['heading_title'] = 'Edit Video';
    $this->form_validation->set_rules('video_image', 'Video Embed Link', "trim|required");
    $this->form_validation->set_rules('video_text', 'Video Caption', "trim|required|max_length[80]");

    if ($this->form_validation->run() === TRUE) {

      $posted_data = array(
          'video_image' => $this->input->post('video_image'),
          'video_text' => $this->input->post('video_text'),
      );
      $where = "video_id = $video_id";
      $this->banner_model->safe_update('wps_company_videos', $posted_data, $where, FALSE);

      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'Video has been updated successfully.');
      redirect('members/video_gallery', '');
    }
    $data['res'] = $client_data;
    $this->load->view('members/view_video_edit', $data);
  }

  public function aboutus() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $settingRes = $this->db->query("SELECt * FROM wps_website_about WHERE customers_id = '" . $this->session->userdata('user_id') . "'")->row_array();
    $data['mres'] = $mres;
    $memId = $mres['customers_id'];

    //Validation
   // $this->form_validation->set_rules('about_us', 'About Us Content', 'trim|required|max_length[450]');
    $this->form_validation->set_rules('about_image', 'About Us Image', 'file_allowed_type[image]');
    $this->form_validation->set_rules('why_choose_content', 'Why Choose Main Content', 'trim|required');

    $this->form_validation->set_rules('whyus_title1', 'Why Us Title 1', 'trim|required|max_length[20]');
    $this->form_validation->set_rules('whyus_desc1', 'Why Us Details 1', 'trim|required|max_length[100]');
    $this->form_validation->set_rules('whyus_image_1', 'Why Us Image 1', 'file_allowed_type[image]');

    $this->form_validation->set_rules('whyus_title2', 'Why Us Title 2', 'trim|required|max_length[20]');
    $this->form_validation->set_rules('whyus_desc2', 'Why Us Details 2', 'trim|required|max_length[100]');
    $this->form_validation->set_rules('whyus_image_2', 'Why Us Image 2', 'file_allowed_type[image]');

    $this->form_validation->set_rules('whyus_title3', 'Why Us Title 3', 'trim|required|max_length[20]');
    $this->form_validation->set_rules('whyus_desc3', 'Why Us Details 3', 'trim|required|max_length[100]');
    $this->form_validation->set_rules('whyus_image_3', 'Why Us Image 3', 'file_allowed_type[image]');


    if ($this->form_validation->run() == TRUE) {

      $uploaded_file = @$settingRes['about_image'];
      $unlink_image = array('source_dir' => "user", 'source_file' => @$settingRes['about_image']);
      if (!empty($_FILES) && $_FILES['about_image']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('about_image', 'user');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
          @removeImage($unlink_image);
        }
      }

      $whyus_image_1 = @$settingRes['whyus_image_1'];
      $unlink_image1 = array('source_dir' => "user", 'source_file' => @$settingRes['whyus_image_1']);
      if (!empty($_FILES) && $_FILES['whyus_image_1']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('whyus_image_1', 'user');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $whyus_image_1 = $uploaded_data['upload_data']['file_name'];
          @removeImage($unlink_image1);
        }
      }

      $whyus_image_2 = @$settingRes['whyus_image_2'];
      $unlink_image2 = array('source_dir' => "user", 'source_file' => @$settingRes['whyus_image_2']);
      if (!empty($_FILES) && $_FILES['whyus_image_2']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('whyus_image_2', 'user');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $whyus_image_2 = $uploaded_data['upload_data']['file_name'];
          @removeImage($unlink_image2);
        }
      }

      $whyus_image_3 = @$settingRes['whyus_image_3'];
      $unlink_image3 = array('source_dir' => "user", 'source_file' => @$settingRes['whyus_image_3']);
      if (!empty($_FILES) && $_FILES['whyus_image_3']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('whyus_image_3', 'user');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $whyus_image_3 = $uploaded_data['upload_data']['file_name'];
          @removeImage($unlink_image3);
        }
      }

      $posted_user_data = array(
          'customers_id' => $mres['customers_id'],
          'about_image' => $uploaded_file,
          'about_us' => $this->input->post('about_us'),
          'why_choose_content' => $this->input->post('why_choose_content'),
          'whyus_title1' => $this->input->post('whyus_title1'),
          'whyus_desc1' => $this->input->post('whyus_desc1'),
          'whyus_image_1' => $whyus_image_1,
          'whyus_title2' => $this->input->post('whyus_title2'),
          'whyus_desc2' => $this->input->post('whyus_desc2'),
          'whyus_image_2' => $whyus_image_2,
          'whyus_title3' => $this->input->post('whyus_title3'),
          'whyus_desc3' => $this->input->post('whyus_desc3'),
          'whyus_image_3' => $whyus_image_3,
      );
      //exit;
      if (is_array($settingRes) && !empty($settingRes)) {
        $where_settings = "customers_id = '" . $mres['customers_id'] . "'";
        $this->members_model->safe_update('wps_website_about', $posted_user_data, $where_settings, FALSE);
      } else {
        $this->members_model->safe_insert('wps_website_about', $posted_user_data, FALSE);
      }

      //End here
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'Website Settings have been updated successfully.');
      redirect('members/aboutus', '');
    }

    if (is_array($settingRes) && empty($settingRes)) {
      $settingRes['website_logo'] = "";
      $settingRes['website_video'] = "";
      $settingRes['facebook_link'] = "";
      $settingRes['twitter_link'] = "";
      $settingRes['youtube_link'] = "";
      $settingRes['linkedin_link'] = "";
      $settingRes['whyus_title1'] = "";
      $settingRes['whyus_desc1'] = "";
      $settingRes['whyus_title2'] = "";
      $settingRes['whyus_desc2'] = "";
      $settingRes['whyus_title3'] = "";
      $settingRes['whyus_desc3'] = "";
      $settingRes['whyus_title4'] = "";
      $settingRes['whyus_desc4'] = "";
      $settingRes['webiste_map'] = "";
      $settingRes['about_serviceability'] = "";
      $settingRes['location_serve'] = "";
    }

    $data['settingRes'] = $settingRes;
    /* End  member change password  */
    $data['unq_section'] = "Myaccount";
    $data['heading_title'] = "Account Settings";
    $this->load->view('members/view_website_about', $data);
  }

  public function website_config() {
    $mres = $this->members_model->get_member_row($this->session->userdata('user_id'));
    $settingRes = $this->db->query("SELECt theme_id FROM wps_website_settings WHERE customers_id = '" . $this->session->userdata('user_id') . "'")->row_array();

    $this->form_validation->set_rules('theme', 'Color Theme', 'trim|required');
    if ($this->form_validation->run() == TRUE) {
      $posted_user_data = array(
          'customers_id' => $mres['customers_id'],
          'theme_id' => $this->input->post('theme'),
      );
      //exit;
      if (is_array($settingRes) && !empty($settingRes)) {
        $where_settings = "customers_id = '" . $mres['customers_id'] . "'";
        $this->members_model->safe_update('wps_website_settings', $posted_user_data, $where_settings, FALSE);
      } else {
        $this->members_model->safe_insert('wps_website_settings', $posted_user_data, FALSE);
      }
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'Website configuration have been updated successfully.');
      redirect('members/website-config', '');
    }
    $data['settingRes'] = $settingRes;
    $data['page_title'] = 'Page Configuration';
    $this->load->view('members/view_website_config', $data);
  }

}

/* End of file member.php */
/* Location: .application/modules/member/member.php */