<?php

class Category extends Public_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->helper(array('category/category', 'products/product', 'query_string'));
    $this->load->model(array('category/category_model', 'products/product_model', 'color/color_model', 'size/size_model', 'testimonials/testimonial_model'));
    $this->lang->load('portuguese', 'portuguese');
  }

  public function index() {
    //trace($this->meta_info);
    //check if sub-domain
    $keyword = $this->input->get_post('keyword', TRUE);

    $uri_path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    $uri_segments = explode('/', $uri_path);
    $st = $uri_segments[1];
    if (strstr($st, '.html')) {
      $st = substr($st, 0, -5);
    }
    $stArray = $this->db->query("SELECT page_url FROM wps_meta_tags WHERE is_fixed='L' AND page_url='" . $st . "'")->row_array();
    //End Here
    if (is_array($stArray) & !empty($stArray) && !isset($uri_segments[2])) {
      $category_id = 0;
    } else {
      $category_id = (int) @$this->meta_info['entity_id'];
    }

    $have_sub_cat = get_db_field_value('wps_categories', 'parent_id', "WHERE parent_id = '$category_id' ");

    if ($category_id > 0) {
      if ($have_sub_cat > 0) {
        //echo '1';
        $this->category_listing($category_id);
      } else {
        //echo '2';
        //$this->products_listing($category_id);
        $this->category_listing($category_id);
      }
    } else {
      //echo '3';
      $this->category_listing($category_id, $keyword);
    }
  }

  public function category_listing($category_id, $keyword = '') {
    $data['unq_section'] = "Category";
    $data['title'] = "Category";

    $ReqUrl = $this->uri->segment(1);
    $catName = "";

    //Check if it is subdomain
    $uri_path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    $uri_segments = explode('/', $uri_path);
    $st = $uri_segments[1];
    if (strstr($st, '.html')) {
      $st = substr($st, 0, -5);
    }
    $stArray = $this->db->query("SELECT page_url FROM wps_meta_tags WHERE is_fixed='L' AND page_url='" . $st . "'")->row_array();
    //End Here

    if ($this->input->get_post('keyword') != '') {
      $data['heading_title'] = 'Your Results for "'.ucwords($this->input->get_post('keyword')).'"';
    } else {
      if ($ReqUrl == 'directory') {
        $data['heading_title'] = 'Companies Directory';
      } elseif ($category_id <= 0) {
         $isService = get_db_field_value('wps_categories', "catType", "WHERE category_id = '" . $category_id . "'");
        if($isService=='1'){
          if (is_array($stArray) & !empty($stArray)) {
            $data['heading_title'] = locationName($st) . ' Directory';
          } else {
            $data['heading_title'] = 'Companies Directory';
          }
        }else{
          if (is_array($stArray) & !empty($stArray)) {
            $data['heading_title'] = locationName($st) . ' Manufaturers Directory';
          } else {
            $data['heading_title'] = 'Companies Directory';
          }
        }
        
      } else {
        $catName = get_db_field_value('wps_categories', "category_name", "WHERE category_id = '" . $category_id . "'");
        $isService = get_db_field_value('wps_categories', "catType", "WHERE category_id = '" . $category_id . "'");
        if($isService=='1'){
          $data['heading_title'] = $catName;
        }else{
          $data['heading_title'] = $catName . ' Manufacturers';
        }
        
        $data['title'] = $catName;
      }
    }
    //catName for H1
    $page_title = @$catName;
    if ($keyword != '') {
      $condtion_array_cat = array('field' => "*", 'condition' => " AND status='1'", 'debug' => FALSE, 'keyword' => $keyword);
    } else {
      $condtion_array_cat = array('field' => "*,( SELECT COUNT(category_id) FROM wps_categories AS b WHERE b.parent_id=a.category_id ) AS total_subcategories", 'condition' => "AND category_id = '$category_id' AND status='1' ", 'debug' => FALSE);
    }

    //Category Result

    $category_result = $this->category_model->getcategory($condtion_array_cat);
    $category_result = $category_result[0];
    //trace($category_result);
    //For paging & Sub-Category List 
    $record_per_page = (int) $this->input->post('per_page');
    if (@array_key_exists('entity_id', $this->meta_info) && $this->meta_info['entity_id'] > 0) {
      $parent_segment = (int) $this->meta_info['entity_id'];
    } else {
      $parent_segment = (int) $this->uri->segment(3);
    }
    $page_segment = find_paging_segment();
    $config['per_page'] = ( $record_per_page > 0 ) ? $record_per_page : $this->config->item('per_page');
    $offset = (int) $this->uri->segment($page_segment, 0);
    $parent_id = ( $parent_segment > 0 ) ? $parent_segment : '0';
    $base_url = ( $parent_segment > 0 ) ? "category/category_listing/$parent_id/pg/" : "category/category_listing/pg/";

    //Sub-Category List
    //, 'limit' => $config['per_page'], 'offset' => $offset

    if ($keyword != '') {
      $condtion_array = array('field' => "*,( SELECT COUNT(category_id) FROM wps_categories AS b WHERE b.parent_id=a.category_id ) AS total_subcategories", 'condition' => " AND status='1'", 'debug' => FALSE, 'keyword' => $keyword);
    } else {
      $condtion_array = array('field' => "*,( SELECT COUNT(category_id) FROM wps_categories AS b WHERE b.parent_id=a.category_id ) AS total_subcategories", 'condition' => "AND parent_id = '$category_id' AND status='1' ", 'debug' => FALSE);
    }

    $res_array = $this->category_model->getcategory($condtion_array);
    $data['total_rows'] = $config['total_rows'] = $this->category_model->total_rec_found;
    //$data['page_links'] = front_pagination($base_url, $config['total_rows'], $config['per_page'], $page_segment);
    $data['catList'] = $res_array;
    //End of Sub-category and Paging Here


    if ($category_id > 0) {
      if (is_array($category_result) && !empty($category_result)) {

        $data['categoryId'] = $category_id;

        $businessNaturePosted = $this->input->post('business_nature');

        //Manage View
        if ($category_result['parent_id'] == 0) {
//echo "1";
          //Check if in Subdomain
          if (is_array($stArray) & !empty($stArray)) {
            $resprosub = $this->db->query("SELECT * FROM wps_subcontent WHERE status = '1' AND FIND_IN_SET($parent_id,category_id)")->row();
            //echo_sql();
            if (is_object($resprosub) && !empty($resprosub)) {

              //With location and category
              $locId = get_db_field_value("wps_meta_tags", "meta_id", "WHERE page_url = '" . $st . "'");
              $resprosubloc = $this->db->query("SELECT * FROM wps_subcontent WHERE status = '1' AND FIND_IN_SET($parent_id,category_id) AND FIND_IN_SET($locId,location_id)")->row();
              if (is_object($resprosubloc) && !empty($resprosubloc)) {//With location and category
                $key1 = $resprosubloc->meta_key1;
                $key2 = $resprosubloc->meta_key2;
                $key3 = $resprosubloc->meta_key3;
                $category_result['category_description'] = str_replace('{catname}', $page_title, str_replace('{location}', ucwords(locationName($st)), str_replace('{key3}', $key3, str_replace('{key2}', $key2, str_replace('{key1}', $key1, $resprosubloc->description)))));
                if ($resprosubloc->page_heading != '') {
                  $data['heading_title'] = str_replace('{catname}', $page_title, str_replace('{location}', ucwords(locationName($st)), str_replace('{key3}', $key3, str_replace('{key2}', $key2, str_replace('{key1}', $key1, $resprosubloc->page_heading)))));
                } else {
                  $data['heading_title'] .= ' In ' . ucwords(locationName($st));
                }
              } else {
                $data['heading_title'] .= ' In ' . ucwords(locationName($st));
              }
            } else {
              $data['heading_title'] .= ' In ' . ucwords(locationName($st));
            }
          }
          $data['category_result'] = $category_result;
          if($category_result['total_subcategories']>0){
 //Main category List View
            $this->load->view('category/view_category', $data);
          }else{
             $locationId = "";
             
                  //get product List
            $condtion = array();
            $per_page = 2; //$this->config->item('per_page');
            $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
            $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
            //$condtion['customers_id'] = $mres['customers_id'];
            $condtion['status'] = '1';
            $condtion['city'] = $locationId;
            $condtion['category_id'] = $category_id;
            $condtion['groupby'] = "wlp.customers_id";
            $condtion['orderby'] = "RAND()";
            $condtion['businessNaturePosted'] = $businessNaturePosted;
            $res_array = $this->product_model->get_products($per_page, $offset, $condtion);
            if(count($res_array)<1){
              $this->load->view('category/view_category', $data);
            }else{
            //echo_sql(); //die;
            $data['total_list_rows'] = $total_rows = get_found_rows();
            $data['page_list_links'] = front_pagination($base_url, $total_rows, $per_page, $offset);
            //trace($res_array);
            $data['listRes'] = $res_array;

            //Call of view - Subcategory and Products if Any
            $data['unit_measurement'] = $this->config->item('unit_measurement');

            //Cousin Category List
            $parentId = get_db_field_value('wps_categories', 'parent_id', "WHERE category_id = '" . $category_id . "'");
            //Category Cousin Result
            $condtion_cousin = array('field' => "*,( SELECT COUNT(category_id) FROM wps_categories AS b WHERE b.parent_id=a.category_id ) AS total_subcategories", 'condition' => "AND parent_id = '" . $parentId . "' AND category_id != '" . $category_id . "' AND status='1'", 'limit' => '5', 'debug' => FALSE);
            $result_cousin = $this->category_model->getcategory($condtion_cousin);
            $data['result_cousin'] = $result_cousin;

            //category Cousing after 5 results
            $result_cousin_1 = $this->db->query("SELECT * FROM wps_categories WHERE parent_id = '" . $parentId . "' AND category_id != '" . $category_id . "' AND status='1' LIMIT 5,100")->result_array();
            $data['result_cousin_1'] = $result_cousin_1;


            //category banner
            $category_banner = $this->db->query("SELECT * FROM wps_banners WHERE status = '1' AND FIND_IN_SET(" . $category_id . ",banner_category_id) ORDER BY RAND()")->result_array();
            //trace($category_banner);
            $data['category_banner'] = $category_banner;
            $data['category_result'] = $category_result;
            $this->load->view('category/view_subcategory', $data);
          }
          }
         
        } else {
          //echo "2";
          //Check if in Subdomain
          $locationId = "";
          if (is_array($stArray) & !empty($stArray)) {

            $locationId = locationId($st);
            $resprosub = $this->db->query("SELECT * FROM wps_subcontent WHERE status = '1' AND FIND_IN_SET($parent_id,category_id)")->row();
            //trace($resprosub);
            if (is_object($resprosub) && !empty($resprosub)) {

              //With location and category
              $locId = get_db_field_value("wps_meta_tags", "meta_id", "WHERE page_url = '" . $st . "'");
              $resprosubloc = $this->db->query("SELECT * FROM wps_subcontent WHERE status = '1' AND FIND_IN_SET($parent_id,category_id) AND FIND_IN_SET($locId,location_id)")->row();
              //trace($resprosubloc);
              if (is_object($resprosubloc) && !empty($resprosubloc)) {//With location and category
                $key1 = $resprosubloc->meta_key1;
                $key2 = $resprosubloc->meta_key2;
                $key3 = $resprosubloc->meta_key3;
                $category_result['category_description'] = str_replace('{catname}', $page_title, str_replace('{location}', ucwords(locationName($st)), str_replace('{key3}', $key3, str_replace('{key2}', $key2, str_replace('{key1}', $key1, $resprosubloc->description)))));
                if ($resprosubloc->page_heading != '') {
                  $data['heading_title'] = str_replace('{catname}', $page_title, str_replace('{location}', ucwords(locationName($st)), str_replace('{key3}', $key3, str_replace('{key2}', $key2, str_replace('{key1}', $key1, $resprosubloc->page_heading)))));
                } else {
                  $data['heading_title'] .= ' In ' . ucwords(locationName($st));
                }
              } else {
                $category_result['category_description'] = "";
                $data['heading_title'] .= ' In ' . ucwords(locationName($st));
              }
            } else {
              $category_result['category_description'] = "";
              $data['heading_title'] .= ' In ' . ucwords(locationName($st));
            }
          }

          //get product List
          $condtion = array();
          $per_page = 2; //$this->config->item('per_page');
          $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
          $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
          //$condtion['customers_id'] = $mres['customers_id'];
          $condtion['status'] = '1';
          $condtion['city'] = $locationId;
          $condtion['category_id'] = $category_id;
          $condtion['groupby'] = "wlp.customers_id";
          $condtion['orderby'] = "RAND()";
          $condtion['businessNaturePosted'] = $businessNaturePosted;
          $res_array = $this->product_model->get_products($per_page, $offset, $condtion);
          //echo_sql(); //die;
          $data['total_list_rows'] = $total_rows = get_found_rows();
          $data['page_list_links'] = front_pagination($base_url, $total_rows, $per_page, $offset);
          //trace($res_array);
          $data['listRes'] = $res_array;

          //Call of view - Subcategory and Products if Any
          $data['unit_measurement'] = $this->config->item('unit_measurement');

          //Cousin Category List
          $parentId = get_db_field_value('wps_categories', 'parent_id', "WHERE category_id = '" . $category_id . "'");
          //Category Cousin Result
          $condtion_cousin = array('field' => "*,( SELECT COUNT(category_id) FROM wps_categories AS b WHERE b.parent_id=a.category_id ) AS total_subcategories", 'condition' => "AND parent_id = '" . $parentId . "' AND category_id != '" . $category_id . "' AND status='1'", 'limit' => '5', 'debug' => FALSE);
          $result_cousin = $this->category_model->getcategory($condtion_cousin);
          $data['result_cousin'] = $result_cousin;

          //category Cousing after 5 results
          $result_cousin_1 = $this->db->query("SELECT * FROM wps_categories WHERE parent_id = '" . $parentId . "' AND category_id != '" . $category_id . "' AND status='1' LIMIT 5,100")->result_array();
          $data['result_cousin_1'] = $result_cousin_1;


          //category banner
          $category_banner = $this->db->query("SELECT * FROM wps_banners WHERE status = '1' AND FIND_IN_SET(" . $category_id . ",banner_category_id) ORDER BY RAND()")->result_array();
          //trace($category_banner);
          $data['category_banner'] = $category_banner;
          $data['category_result'] = $category_result;
          $this->load->view('category/view_subcategory', $data);
        }
      } else {
        redirect(site_url('directory'), 'refersh');
        exit;
      }
    } else {
      //View Main category
      $data['categoryId'] = $category_id;
      $data['resleft'] = array();
      $this->load->view('category/view_category', $data);
    }
  }

  public function ajax_load_category_view() {
    $data['title'] = 'Ajax Load Category';
    //For Paging
    $config['per_page'] = $this->config->item('per_page');
    $offset = $this->input->get_post('stOffSet');
    if (array_key_exists('entity_id', $this->meta_info) && $this->meta_info['entity_id'] > 0) {
      $parent_segment = (int) $this->meta_info['entity_id'];
    } else {
      $parent_segment = (int) $this->input->get_post('category_id');
    }
    $page_segment = find_paging_segment();
    $parent_id = ( $parent_segment > 0 ) ? $parent_segment : '0';

    //cat result
    $condtion_array = array('field' => "*,( SELECT COUNT(category_id) FROM wps_categories AS b WHERE b.parent_id=a.category_id ) AS total_subcategories", 'condition' => "AND parent_id = '$parent_id' AND status='1' ", 'limit' => $config['per_page'], 'offset' => $offset, 'debug' => FALSE);
    $res_array = $this->category_model->getcategory($condtion_array);
    $config['total_rows'] = $this->category_model->total_rec_found;
    $data['res'] = $res_array;
    $this->load->view('category/ajax_load_category', $data);
  }

 public function products_listing($category_id, $keyword = '') {

    $data['unq_section'] = "Category";
    $data['title'] = "Category";
   $locationId = "";
    $ReqUrl = $this->uri->segment(1);
    $catName = "";
     $data['categoryId'] = $category_id;
$businessNaturePosted = $this->input->post('business_nature');
    //Check if it is subdomain
    $uri_path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    $uri_segments = explode('/', $uri_path);
    $st = $uri_segments[1];
    if (strstr($st, '.html')) {
      $st = substr($st, 0, -5);
    }
    $stArray = $this->db->query("SELECT page_url FROM wps_meta_tags WHERE is_fixed='L' AND page_url='" . $st . "'")->row_array();
    //End Here

    if ($this->input->get_post('keyword') != '') {
      $data['heading_title'] = 'Your Results for "'.ucwords($this->input->get_post('keyword')).'"';
    } else {
      if ($ReqUrl == 'directory') {
        $data['heading_title'] = 'Companies Directory';
      } elseif ($category_id <= 0) {
         $isService = get_db_field_value('wps_categories', "catType", "WHERE category_id = '" . $category_id . "'");
        if($isService=='1'){
          if (is_array($stArray) & !empty($stArray)) {
            $data['heading_title'] = locationName($st) . ' Directory';
          } else {
            $data['heading_title'] = 'Companies Directory';
          }
        }else{
          if (is_array($stArray) & !empty($stArray)) {
            $data['heading_title'] = locationName($st) . ' Manufaturers Directory';
          } else {
            $data['heading_title'] = 'Companies Directory';
          }
        }
        
      } else {
        $catName = get_db_field_value('wps_categories', "category_name", "WHERE category_id = '" . $category_id . "'");
        $isService = get_db_field_value('wps_categories', "catType", "WHERE category_id = '" . $category_id . "'");
        if($isService=='1'){
          $data['heading_title'] = $catName;
        }else{
          $data['heading_title'] = $catName . ' Manufacturers';
        }
        
        $data['title'] = $catName;
      }
    }
    //catName for H1
    $page_title = @$catName;
    if ($keyword != '') {
      $condtion_array_cat = array('field' => "*", 'condition' => " AND status='1'", 'debug' => FALSE, 'keyword' => $keyword);
    } else {
      $condtion_array_cat = array('field' => "*,( SELECT COUNT(category_id) FROM wps_categories AS b WHERE b.parent_id=a.category_id ) AS total_subcategories", 'condition' => "AND category_id = '$category_id' AND status='1' ", 'debug' => FALSE);
    }

    //Category Result

    $category_result = $this->category_model->getcategory($condtion_array_cat);
    $category_result = $category_result[0];
    //trace($category_result);
    //For paging & Sub-Category List 
    $record_per_page = (int) $this->input->post('per_page');
    if (@array_key_exists('entity_id', $this->meta_info) && $this->meta_info['entity_id'] > 0) {
      $parent_segment = (int) $this->meta_info['entity_id'];
    } else {
      $parent_segment = (int) $this->uri->segment(3);
    }
    $page_segment = find_paging_segment();
    $config['per_page'] = ( $record_per_page > 0 ) ? $record_per_page : $this->config->item('per_page');
    $offset = (int) $this->uri->segment($page_segment, 0);
    $parent_id = ( $parent_segment > 0 ) ? $parent_segment : '0';
    $base_url = ( $parent_segment > 0 ) ? "category/category_listing/$parent_id/pg/" : "category/category_listing/pg/";

    //Sub-Category List
    //, 'limit' => $config['per_page'], 'offset' => $offset

    if ($keyword != '') {
      $condtion_array = array('field' => "*,( SELECT COUNT(category_id) FROM wps_categories AS b WHERE b.parent_id=a.category_id ) AS total_subcategories", 'condition' => " AND status='1'", 'debug' => FALSE, 'keyword' => $keyword);
    } else {
      $condtion_array = array('field' => "*,( SELECT COUNT(category_id) FROM wps_categories AS b WHERE b.parent_id=a.category_id ) AS total_subcategories", 'condition' => "AND parent_id = '$category_id' AND status='1' ", 'debug' => FALSE);
    }

    $res_array = $this->category_model->getcategory($condtion_array);
    $data['total_rows'] = $config['total_rows'] = $this->category_model->total_rec_found;
    //$data['page_links'] = front_pagination($base_url, $config['total_rows'], $config['per_page'], $page_segment);
    $data['catList'] = $res_array;
          if (is_array($stArray) & !empty($stArray)) {

            $locationId = locationId($st);
            $resprosub = $this->db->query("SELECT * FROM wps_subcontent WHERE status = '1' AND FIND_IN_SET($parent_id,category_id)")->row();
            //trace($resprosub);
            if (is_object($resprosub) && !empty($resprosub)) {

              //With location and category
              $locId = get_db_field_value("wps_meta_tags", "meta_id", "WHERE page_url = '" . $st . "'");
              $resprosubloc = $this->db->query("SELECT * FROM wps_subcontent WHERE status = '1' AND FIND_IN_SET($parent_id,category_id) AND FIND_IN_SET($locId,location_id)")->row();
              //trace($resprosubloc);
              if (is_object($resprosubloc) && !empty($resprosubloc)) {//With location and category
                $key1 = $resprosubloc->meta_key1;
                $key2 = $resprosubloc->meta_key2;
                $key3 = $resprosubloc->meta_key3;
                $category_result['category_description'] = str_replace('{catname}', $page_title, str_replace('{location}', ucwords(locationName($st)), str_replace('{key3}', $key3, str_replace('{key2}', $key2, str_replace('{key1}', $key1, $resprosubloc->description)))));
                if ($resprosubloc->page_heading != '') {
                  $data['heading_title'] = str_replace('{catname}', $page_title, str_replace('{location}', ucwords(locationName($st)), str_replace('{key3}', $key3, str_replace('{key2}', $key2, str_replace('{key1}', $key1, $resprosubloc->page_heading)))));
                } else {
                  $data['heading_title'] .= ' In ' . ucwords(locationName($st));
                }
              } else {
                $category_result['category_description'] = "";
                $data['heading_title'] .= ' In ' . ucwords(locationName($st));
              }
            } else {
              $category_result['category_description'] = "";
              $data['heading_title'] .= ' In ' . ucwords(locationName($st));
            }
          }

  //get product List
          $condtion = array();
          $per_page = 2; //$this->config->item('per_page');
          $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
          $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
          //$condtion['customers_id'] = $mres['customers_id'];
          $condtion['status'] = '1';
          $condtion['city'] = $locationId;
          $condtion['category_id'] = $category_id;
          $condtion['groupby'] = "wlp.customers_id";
          $condtion['orderby'] = "RAND()";
          $condtion['businessNaturePosted'] = $businessNaturePosted;
          $res_array = $this->product_model->get_products($per_page, $offset, $condtion);
          //echo_sql(); //die;
          $data['total_list_rows'] = $total_rows = get_found_rows();
          $data['page_list_links'] = front_pagination($base_url, $total_rows, $per_page, $offset);
          //trace($res_array);
          $data['listRes'] = $res_array;

          //Call of view - Subcategory and Products if Any
          $data['unit_measurement'] = $this->config->item('unit_measurement');

          //Cousin Category List
          $parentId = get_db_field_value('wps_categories', 'parent_id', "WHERE category_id = '" . $category_id . "'");
          //Category Cousin Result
          $condtion_cousin = array('field' => "*,( SELECT COUNT(category_id) FROM wps_categories AS b WHERE b.parent_id=a.category_id ) AS total_subcategories", 'condition' => "AND parent_id = '" . $parentId . "' AND category_id != '" . $category_id . "' AND status='1'", 'limit' => '5', 'debug' => FALSE);
          $result_cousin = $this->category_model->getcategory($condtion_cousin);
          $data['result_cousin'] = $result_cousin;

          //category Cousing after 5 results
          $result_cousin_1 = $this->db->query("SELECT * FROM wps_categories WHERE parent_id = '" . $parentId . "' AND category_id != '" . $category_id . "' AND status='1' LIMIT 5,100")->result_array();
          $data['result_cousin_1'] = $result_cousin_1;


          //category banner
          $category_banner = $this->db->query("SELECT * FROM wps_banners WHERE status = '1' AND FIND_IN_SET(" . $category_id . ",banner_category_id) ORDER BY RAND()")->result_array();
          //trace($category_banner);
          $data['category_banner'] = $category_banner;
          $data['category_result'] = $category_result;
          $this->load->view('category/view_subcategory', $data);
 }

  public function products_listing_old($category_id) {

    $this->page_section_ct = 'product';
    $condtion = array();
    $cat_res = '';
    $record_per_page = (int) $this->input->post('per_page');
    $category_id = (int) $category_id;
    $page_segment = find_paging_segment();
    $config['per_page'] = ( $record_per_page > 0 ) ? $record_per_page : $this->config->item('per_page');
    //$config['per_page']			= 1;	
    $offset = (int) $this->uri->segment($page_segment, 0);
    $base_url = ( $category_id != '' ) ? "category/products_listing/$category_id/pg/" : "category/products_listing/pg/";
    $condtion['status'] = '1';

    //Sorting
    $sort = $this->input->get_post('sort');
    if ($sort > 0) {
      if ($sort == 1) {
        $condtion['orderby'] = 'newarrival_product DESC';
      }
      if ($sort == 2) {
        $condtion['orderby'] = 'popular_product DESC';
      }
      if ($sort == 3) {
        $condtion['orderby'] = 'products_id DESC';
      }
      if ($sort == 4) {
        $condtion['orderby'] = 'product_price ASC';
      }
      if ($sort == 5) {
        $condtion['orderby'] = 'product_price DESC';
      }
    } else {
      //$condtion['orderby'] = 'products_id asc';
    }


    $page_title = "Product Lists";
    $color = $this->input->post('color');
    $size = $this->input->post('size');
    $price = $this->input->post('price');
    $catIds = $this->input->post('categoryId');

    if (!empty($color)) {
      $colors = implode(',', $color);
      $condtion['color'] = $colors;
    }
    if (!empty($size)) {
      $sizes = implode(',', $size);
      $condtion['size'] = $sizes;
    }
    if (!empty($catIds)) {
      $catIds = implode(',', $catIds);
      $condtion['catIds'] = $catIds;
    }
    if (!empty($price)) {
      $condtion['price'] = $price;
    }
    if (!empty($this->input->get_post('min-price')) && !empty($this->input->get_post('max-price'))) {
      $min = $this->input->get_post('min-price');
      $max = $this->input->get_post('max-price');
      $condtion['price'] = $min . '-' . $max;
    }
    $srtQry = "AND parent_id = '1'";
    $data['catid'] = "";
    if ($category_id > 0) {
      $condtion['category_id'] = $category_id;
      $cat_res = get_db_single_row('wps_categories', '*', " category_id='$category_id'");
      $page_title = $cat_res['category_name'];
      $srtQry = "AND parent_id = '" . $cat_res['parent_id'] . "'";
      $data['catid'] = $category_id;
    }
    $res_array = $this->product_model->get_products($config['per_page'], $offset, $condtion);
    trace($res_array);
    //echo_sql();
    $data['total_rows'] = $config['total_rows'] = get_found_rows();
    $data['page_links'] = front_pagination("$base_url", $config['total_rows'], $config['per_page'], $page_segment);
    $data['heading_title'] = $page_title;
    $data['res'] = $res_array;
    $data['cat_res'] = $cat_res;
    $data['brand_id'] = "";

    /* Global array */
    //Brands
    $data['brands'] = $this->db->query("SELECT * FROM wps_brands WHERE status = '1'")->result_array();

    //special products
    $condPro = array();
    $condPro = array("popular" => 1);
    $proRes = $this->product_model->get_products(1, 0, $condPro);
    //echo_sql();
    $data['proRes'] = $proRes;

    //Category
    $data['catleftRes'] = $this->db->query("SELECT category_id, category_name, friendly_url FROM wps_categories WHERE status='1' GROUP BY category_id")->result_array();

    //banner
    $data['banner'] = get_db_field_value("wps_banners", "banner_image", "WHERE banner_page='product' AND banner_position='Top Banner' ORDER BY RAND()");
    $this->load->view('products/view_product_listing', $data);
  }

  public function category_search() {
    $keyword = $this->input->post('keyword');
    $selval = $this->input->post('selvel');
    $selval = explode(',', $selval);
    $var = '';
    if (strlen($keyword) >= 3) {
      $res = $this->db->query("SELECT * FROM wps_categories WHERE category_name LIKE '%" . $keyword . "%'")->result_array();
      //echo_sql();
      if (is_array($res) && !empty($res)) {
        foreach ($res as $k => $val) {
          $sel = (in_array($val['category_id'], $selval)) ? 'checked' : '';
          $var .= '<div class="input-field col s4" style="margin-bottom:20px;"><label style="left:0px!important;" class="containerdash">' . $val['category_name'] . '<input type="checkbox" value="' . $val['category_id'] . '" ' . $sel . '  name="category_id[]" class="dashcheckbox"></label></div>';
        }
      }
    }
    echo $var;
  }

  public function category_search_banner() {
    $keyword = $this->input->post('keyword');
    $selval = $this->input->post('selvel');
    $selval = explode(',', $selval);
    $var = '<div class="row">';
    if (strlen($keyword) >= 3) {
      $res = $this->db->query("SELECT * FROM wps_categories WHERE category_name LIKE '%" . $keyword . "%'")->result_array();
      //echo_sql();
      if (is_array($res) && !empty($res)) {
        foreach ($res as $k => $val) {
          $sel = (in_array($val['category_id'], $selval)) ? 'checked' : '';
          $var .= '<div class="col-md-4" style="margin:10px 0px 5px 0px;"><input type="checkbox" value="' . $val['category_id'] . '" ' . $sel . '  name="category_id[]"> ' . $val['category_name'] . '</div>';
        }
      }
    }
    $var .= '</div>';
    echo $var;
  }

}

/* End of file member.php */
/* Location: .application/modules/products/controllers/products.php */