<?php
$this->load->view("top_application");
$curr_symbol = display_symbol();
$discount_amount = $this->session->userdata('discount_amount');
?>
<div class="breadcrumb clearfix">
  <div class="container" >
    <!-- breadcrumb -->
    <a class="home" href="<?php echo site_url(); ?>" title="Return to Home">Home</a>
    <span class="navigation-pipe">&nbsp;</span>
    <span class="navigation_page">My Shopping Bag</span>
  </div>
</div>
<!-- ./breadcrumb -->
<!-- page heading-->
<div id="columns">
  <div class="container">

    <h1 class="page-heading">
      <span class="page-heading-title2">My Shopping Bag</span>
    </h1>
  </div>
  <!-- ../page heading-->
  <div class="container">

    <div class="page-content page-order">
      <div class="heading-counter">Your shopping cart contains:
        <span><?php echo count($this->cart->contents()); ?> Product</span>
      </div>
      <div class="order-detail-content">
        <?php
        error_message();
        validation_message();

        $cart = $this->cart->contents();
        //trace($cart);
        if (is_array($cart) && !empty($cart)) {
          ?>
          <?php echo form_open('cart/', 'name="cart_frm" id="cart_frm" '); ?>
          <table class="table table-bordered table-responsive cart_summary">
            <thead>
              <tr>
                <th class="cart_product"><?php echo ($this->session->userdata('lang') == 'p') ? $this->lang->line('product') : 'Product'; ?></th>
                <th>Product</th>
                <th>Unit price</th>
                <th>Qty</th>
                <th>Total</th>
                <th  class="action"><i class="fa fa-trash-o"></i></th>
              </tr>
            </thead>
            <tbody>
              <?php
              $totalAmount = $origAmount = $discountAmt = $sellingAmount = 0;
              $i = 1;
              foreach ($cart as $items) {
                //trace($items);
                $size = "";
                $sizeName = $this->config->item('sizeName');
                $link = ($this->session->userdata('user_id') > 0) ? 'href="' . site_url() . 'cart/add_to_wishlist/' . $items['pid'] . '"' : 'href="#" data-toggle="modal" data-target="#log-modal"';
                $pprice = $items['price'];
                $totalAmount += $pprice * $items['qty'];
                $origAmount += $items['product_price'] * $items['qty'];
                $sellingAmount += $items['product_price'] * $items['qty'];

                $stock = get_db_field_value("wps_products", "product_qty", "WHERE products_id = '" . $items['pid'] . "'");
                if (is_array($items['options']['Size']) && !empty($items['options']['Size'])) {
                  $size = "Custom";
                }
                ?>
                <tr>
                  <td class="cart_product">
                    <a href="<?php echo site_url($items['name']); ?>">
                      <img src="<?php echo get_image('product_images', $items['img'], '100', '100', 'R'); ?>" />
                    </a>
                  </td>
                  <td class="cart_description">
                    <p class="product-name">
                      <a href="#"><?php echo $items['origname']; ?> </a>
                    </p>
                    <?php
                    if (is_array($items['options']['Size']) && !empty($items['options']['Size'])) {
                      ?>
                      <br />
                      <small>Size : 
                        <span class="custom_size">
                          <?php
                          echo '<span style="color:blue">' . $size . '</span>';
                          if (is_array($items['options']['Size'])) {
                            ?>
                            <div class="custom-hover">
                              <?php
                              foreach ($sizeName as $key => $vals) {
                                ?>
                                <p><strong><?php echo $vals; ?>: </strong><?php echo $items['options']['Size'][$key]; ?></p>
                                <?php
                              }
                              ?>
                            </div>
                            <?php
                          }
                          ?>
                        </span>
                        <?php
                        if (is_array($items['options']['Size'])) {
                          ?>
                          <span><a  style="color:#d11010" href="<?php echo site_url('products/customized/' . $items['pid'] . "?cfn=et"); ?>">Edit</a></span>
                          <?php
                        }
                        ?>
                      </small>
                      <?php
                    }
                    ?>
                    </p>
                    <small class="cart_ref">SKU : #<?php echo $items['code']; ?></small><br>


                  </td>
                  <td >
                    <h5 class="cost"><?php echo display_price($items['price']); ?></h5>
                  </td>
                  <td align="center">
                    <div class="quantity">
                      <a href="javascript:void(0)" onclick="return incDnc(2, <?php echo $i; ?>, '<?php echo $stock; ?>');" id="minus1" class="minus"><i class="fa fa-minus-square"></i></a>
                      <input readonly="readonly" name="<?php echo $i; ?>[qty]" id="qty_<?php echo $i; ?>" type="text" value="<?php echo $items['qty']; ?>" class="input-text qty" />
                      <a href="javascript:void(0)" onclick="return incDnc(1, <?php echo $i; ?>, '<?php echo $stock; ?>');" id="add1" class="plus"><i class="fa fa-plus-square"></i></a>
                      <input type="hidden" name="<?php echo $i; ?>[rowid]" id='cart_rowid_<?php echo $i; ?>' value="<?php echo $items['rowid']; ?>" />
                    </div>


                  </td>
                  <td class="price">
                    <?php echo display_price($items['price'] * $items['qty']); ?>
                  </td>
                  <td class="price text-center">
                    <a href="<?php echo site_url(); ?>cart/remove_item/<?php echo $items['rowid']; ?>">Delete Item</a>
                  </td>
                </tr>
                <?php
                $i++;
              }
              ?>
            </tbody>
            <tfoot>
              <tr>
                <td colspan="2" rowspan="3">
                  <div class="row">
                    <div class="col-md-4 col-sm-4">
                      Have a Coupon? 
                    </div>
                    <div class="col-md-5 col-sm-4">

                      <input type="text" id="cCode" class="form-control" name="discount_code" placeholder="Enter coupon code" value="" />
                    </div>
                    <div class="col-md-3 col-sm-4">
                      <a type="button" class="btn btn-danger couponCode" href="javascript:void(0);" />Apply</a>
                    </div>
                  </div>
                </td>

                <td colspan="3">Total products</td>

                <td colspan="2"><?php echo display_price($totalAmount); ?></td>
              </tr>
              <?php
              if ($discount_amount > 0) {
                ?>
                <tr>
                  <td colspan="3"><strong>Discount</strong></td>
                  <td colspan="2"><strong> <?php echo display_price($discount_amount); ?> </strong></td>
                </tr>
                <tr>
                  <td colspan="3"><strong>Amount After Discount</strong></td>
                  <td colspan="2"><strong> <?php echo display_price($totalAmount - $discount_amount); ?> </strong></td>
                </tr>
                <?php
              }
              ?>
            </tfoot>
          </table>
          <div class = "cart_navigation">
            <a class = "prev-btn" href = "<?php echo site_url('products'); ?>"> Continue shopping</a>

            <a class="next-btn" href="<?php echo site_url('cart/checkout'); ?>">Proceed to checkout  </a>

          </div>

          <?php
          echo form_close();
        } else {
          ?>
          <div class="row">
            <div class="col-md-4 col-sm-4 col-md-offset-4">
              <div class="text-center">
                <img src="<?php echo theme_url(); ?>images/shopping_cart_empty.jpg" alt="Cart Empty" title="Cart Empty">
              </div>
              <div class="cart_navigation" style="text-align:center;">              
                <a href="<?php echo site_url(); ?>products" class="btn-1 shadow-0 sm">Continue shopping</a>
              </div>
            </div>
          </div>
          <?php
        }
        ?>
      </div>
    </div>
  </div>
</div>


<?php $this->load->view("bottom_application"); ?>
<script type="text/javascript" language="javascript">
  jQuery(document).ready(function (e) {
    jQuery('.couponCode').click(function () {
      var coupon_code = $('#cCode').val();
      if (coupon_code) {
        $.post('<?php echo site_url(); ?>cart/apply_coupon/', {"c_code": coupon_code, 'amt': '<?php echo $totalAmount; ?>'}, function (data) {
          if (data == '1') {
            alert('Coupon Applied!');
            window.location.reload();
          }
          else {
            alert('Invalid or Expired Coupon Code!');
            return false;
          }
        });
      } else {
        alert('Please enter Coupon Code!');
      }
    });
  });
</script>
<script type="text/javascript" src="<?php echo site_url(); ?>assets/developers/js/common.js"></script>