<?php



class Category extends Public_Controller {



  public function __construct() {

    parent::__construct();

    $this->load->helper(array('category/category', 'products/product', 'query_string'));

    $this->load->model(array('category/category_model', 'products/product_model', 'color/color_model', 'size/size_model', 'testimonials/testimonial_model'));

    $this->lang->load('portuguese', 'portuguese');

    $this->comp_contact = comp_contact();

  }



  public function index() {

   // trace($this->meta_info);
  $page_url = $this->meta_info['page_url'];
  $URL = explode('/', $page_url);
  $catURL = $URL['1'];

   $category_id = (int) @$this->meta_info['entity_id'];
   // if($catURL == 'product-listing'){
   //     $this->category_listing($category_id);
   // }if($catURL == 'service-listing'){
   //     $this->category_listing($category_id);
   // }else
   if ($category_id > 0) {
      //echo '1';
      $this->products_listing($category_id);
    } else {
      //echo '2';
      $this->category_listing($category_id, $catURL);
    }
  }



  public function category_listing($cid,$catURL) {
    if($catURL=='product-listing'){
      $data['active_page'] = 'Product Listing';
      $data['page_title'] = "Product";
      $data['heading_title'] = 'Our Products';
      $where = 'AND categoryType = "0"';
    }elseif($catURL=='service-listing'){
      $data['active_page'] = 'Service Listing';
      $data['page_title'] = "Service";
      $data['heading_title'] = 'Our Services';
      $where = 'AND categoryType = "1"';
    }
    
    //fetch company id
    $companyID = $this->comp_contact['customers_id'];
    $parent_id = 0;
    if ($cid > 0) {
      $qry = $this->db->query("select * from wps_categories where category_id =$cid ")->row();
      $parent_id = $qry->parent_id;
      $data['active_page'] = $qry->category_name;
    }
    $config['per_page'] = $this->config->item('per_page');
    $offset = 0;
    $condtion_array = array(
        'field' => "*,( SELECT COUNT(category_id) FROM wps_company_categories AS b
        WHERE b.parent_id=a.category_id ) AS total_subcategories",
        'condition' => "AND parent_id = '" . $parent_id . "' AND companyId = '" . $companyID . "' AND status='1' $where",
        'limit' => $config['per_page'],
        'offset' => $offset,
        'debug' => FALSE
    );

    $res_array = $this->category_model->get_company_category($condtion_array);
    //echo_sql();
    $config['total_rows'] = $data['total_rows'] = $this->category_model->total_rec_found;
    $data['res'] = $res_array;
    //trace($res_array);
    //exit;
    //Parent Result
    $parentdata = $this->category_model->get_company_category_by_id($parent_id);
    $data['parentres'] = isset($parentdata) && is_array($parentdata) ? $parentdata : "";
    $this->load->view('product-listing', $data);

  }



  public function ajax_load_category_view() {

    $data['title'] = 'Ajax Load Category';

    //For Paging

    $config['per_page'] = $this->config->item('per_page');

    $offset = $this->input->get_post('stOffSet');

    if (array_key_exists('entity_id', $this->meta_info) && $this->meta_info['entity_id'] > 0) {

      $parent_segment = (int) $this->meta_info['entity_id'];

    } else {

      $parent_segment = (int) $this->input->get_post('category_id');

    }

    $page_segment = find_paging_segment();

    $parent_id = ( $parent_segment > 0 ) ? $parent_segment : '0';



    //cat result

    $condtion_array = array('field' => "*,( SELECT COUNT(category_id) FROM wps_categories AS b WHERE b.parent_id=a.category_id ) AS total_subcategories", 'condition' => "AND parent_id = '$parent_id' AND status='1' ", 'limit' => $config['per_page'], 'offset' => $offset, 'debug' => FALSE);

    $res_array = $this->category_model->getcategory($condtion_array);

    $config['total_rows'] = $this->category_model->total_rec_found;

    $data['res'] = $res_array;

    $this->load->view('category/ajax_load_category', $data);

  }



  public function products_listing($category_id) {

    $companyId = $this->comp_contact['customers_id'];
    // print_r($companyId);

    $this->page_section_ct = 'product';

    $condtion = array();



    $record_per_page = (int) $this->input->post('per_page');

    $category_id = (int) $category_id;

    $page_segment = find_paging_segment();

    $config['per_page'] = ( $record_per_page > 0 ) ? $record_per_page : $this->config->item('per_page');

    //$config['per_page']			= 1;	

    $offset = (int) $this->uri->segment($page_segment, 0);

    $base_url = ( $category_id != '' ) ? "category/products_listing/$category_id/pg/" : "category/products_listing/pg/";

    $condtion['status'] = '1';



    $page_title = "Product Lists";

    $data['catid'] = "";

    $cat_res = '';



    $condtion['is_template'] = '1';

    if ($category_id > 0) {

      $condtion['category_id'] = $category_id;

      $cat_res = get_db_single_row('wps_company_categories', '*', " category_id='$category_id'");
      // echo_sql();

      $page_title = $cat_res['category_name'] . ' - Products';

      $data['catid'] = $category_id;

      $data['cat_res'] = $cat_res;

    }

    $condtion['customers_id'] = $companyId;

    $res_array = $this->product_model->get_products($config['per_page'], $offset, $condtion);

    $data['total_rows'] = $config['total_rows'] = get_found_rows();

    $data['page_links'] = front_pagination("$base_url", $config['total_rows'], $config['per_page'], $page_segment);

    $data['resLeft'] = $this->db->query("SELECT * FROM wps_company_categories WHERE status='1'")->result_array();

    $data['heading_title'] = $page_title;

    $data['res'] = $res_array;

    /* Global array */
    $this->load->view('wpstemplate/product-sub-listing', $data);

  }



  public function search() {

    $category_id = '';

    $companyId = $this->comp_contact['customers_id'];

    $this->page_section_ct = 'product';

    $condtion = array();



    $record_per_page = (int) $this->input->post('per_page');

    $category_id = (int) $category_id;

    $page_segment = find_paging_segment();

    $config['per_page'] = ( $record_per_page > 0 ) ? $record_per_page : $this->config->item('per_page');

    //$config['per_page']			= 1;	

    $offset = (int) $this->uri->segment($page_segment, 0);

    $base_url = ( $category_id != '' ) ? "category/products_listing/$category_id/pg/" : "category/products_listing/pg/";

    $condtion['status'] = '1';



    $page_title = "Product Lists";

    $data['catid'] = "";

    

    $cat_res = '';

    $data['cat_res'] = $cat_res;

    $condtion['is_template'] = '1';

    

    $condtion['customers_id'] = $companyId;

    $res_array = $this->product_model->get_products($config['per_page'], $offset, $condtion);

    $data['total_rows'] = $config['total_rows'] = get_found_rows();

    $data['page_links'] = front_pagination("$base_url", $config['total_rows'], $config['per_page'], $page_segment);

    $data['resLeft'] = $this->db->query("SELECT * FROM wps_company_categories WHERE status='1'")->result_array();

    $data['heading_title'] = $page_title;

    $data['res'] = $res_array;



    /* Global array */

    $this->load->view('wpstemplate/product-search-listing', $data);

  }

  

  public function category_search() {

    $keyword = $this->input->post('keyword');

    $selval = $this->input->post('selvel');

    $selval = explode(',', $selval);

    $var = '';

    if (strlen($keyword) >= 3) {

      $res = $this->db->query("SELECT * FROM wps_categories WHERE category_name LIKE '%" . $keyword . "%'")->result_array();

      //echo_sql();

      if (is_array($res) && !empty($res)) {

        foreach ($res as $k => $val) {

          $sel = (in_array($val['category_id'], $selval)) ? 'checked' : '';

          $var .= '<div class="input-field col s4" style="margin-bottom:20px;"><label style="left:0px!important;" class="containerdash">' . $val['category_name'] . '<input type="checkbox" value="' . $val['category_id'] . '" ' . $sel . '  name="category_id[]" class="dashcheckbox"></label></div>';

        }

      }

    }

    echo $var;

  }



  public function category_search_banner() {

    $keyword = $this->input->post('keyword');

    $selval = $this->input->post('selvel');

    $selval = explode(',', $selval);

    $var = '<div class="row">';

    if (strlen($keyword) >= 3) {

      $res = $this->db->query("SELECT * FROM wps_categories WHERE category_name LIKE '%" . $keyword . "%'")->result_array();

      //echo_sql();

      if (is_array($res) && !empty($res)) {

        foreach ($res as $k => $val) {

          $sel = (in_array($val['category_id'], $selval)) ? 'checked' : '';

          $var .= '<div class="col-md-4" style="margin:10px 0px 5px 0px;"><input type="checkbox" value="' . $val['category_id'] . '" ' . $sel . '  name="category_id[]"> ' . $val['category_name'] . '</div>';

        }

      }

    }

    $var .= '</div>';

    echo $var;

  }



}



/* End of file member.php */

/* Location: .application/modules/products/controllers/products.php */