<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

class Packages_model extends MY_Model {

  public function __construct() {
    parent::__construct();
  }

  public function get_packages($limit = '10', $offset = '0', $param = array()) {

    $where = @$param['where'];
    $order_by = @$param['order_by'];

    $keyword = trim($this->input->get_post('keyword', TRUE));
    $keyword = $this->db->escape_str($keyword);

    if ($where != '') {
      $this->db->where($where);
    }
    if ($order_by != '') {
      $this->db->order_by($order_by);
    } else {
      $this->db->order_by('added_date', 'desc');
    }
    if ($limit > 0) {
      if (applyFilter('NUMERIC_WT_ZERO', $offset) == -1) {
        $offset = 0;
      }
      $this->db->limit($limit, $offset);
    }
    $this->db->group_by("wlv.package_id");
    $this->db->select('SQL_CALC_FOUND_ROWS wlv.*', FALSE);
    $this->db->from('wps_packages as wlv');
    $this->db->where('wlv.status !=', '2');
    $q = $this->db->get();

    $result = $q->result_array();
    return $result;
  }

  public function get_package_by_id($id) {
    $id = applyFilter('NUMERIC_GT_ZERO', $id);
    if ($id > 0) {
      $condtion = "status !='2' AND package_id=$id";
      $fetch_config = array(
          'condition' => $condtion,
          'debug' => FALSE,
          'return_type' => "array"
      );
      $result = $this->find('wps_packages', $fetch_config);
      return $result;
    }
  }

}

// model end here