<?php

class Location extends Public_Controller {

  public function __construct() {
    parent::__construct();



    $this->load->model(array('location_model'));
    //$this->load->helper(array('download'));
    $this->config->set_item('menu_highlight', 'location management');
    $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");
  }

  //Country 
  public function index() {

    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $keyword = trim($this->input->get_post('keyword', TRUE));
    $keyword = $this->db->escape_str($keyword);
    $condtion = " ";
    if ($keyword != '') {
      $condtion = "AND name like '%" . $keyword . "%'";
    }
    $condtion_array = array(
    );
    $res_array = $this->location_model->get_record();
    $config['total_rows'] = $this->location_model->total_rec_found;
    //$data['page_links'] = admin_pagination($base_url, $config['total_rows'], $config['limit'], $offset);
    $data['heading_title'] = "Manage Countries";
    $data['res'] = $res_array;


    if ($this->input->post('status_action') != '') {
      if($this->input->post('status_action')=='Delete'){
        $arr_ids = $this->input->post('arr_ids');
          if(is_array($arr_ids) && !empty($arr_ids)){
            foreach ($arr_ids as $k => $v) {
              $data = array(
                'status' => '2'
              );
              $where = "id ='".$v."'";
              $this->location_model->safe_update('wps_countries_list', $data, $where, FALSE);
            }

            $this->session->set_userdata(array(
              'msg_type' => 'success'
            ));
            $this->session->set_flashdata('success', lang('deleted'));
            redirect(base_url('location'));
        }
      }else{
        $this->update_status('wps_countries_list', 'id');
      }

    }

    $this->load->view('location/list_view', $data);
  }



  //ajax state calling

  public function ajax_state() {
    $country_id = $this->input->post('country_id');
    $sel_id = $this->input->post('sel');

    $states = $this->db->query("SELECT * FROM wps_states_list WHERE country_id=$country_id AND status='1'")->result_array();
    echo '<option value="">--Select State--</option>';
    foreach ($states as $state) {
      if ($state['id'] == $sel_id) {
        $sel = 'selected="selected"';
      } else {
        $sel = '';
      }
      echo '<option value="'. $state['id'].'"'.$sel.'>'. $state['name'] . '</option>';
    }
  }

  //ajax city calling
  public function ajax_city() {
    $country_id = $this->input->post('country_id');
    $state_id = $this->input->post('state_id');
    $sel_id = $this->input->post('sel');
 
    $cities = $this->db->query("SELECT * FROM wps_cities_list WHERE country_id='".$country_id."' AND state_id='".$state_id."' AND status='1'")->result_array();
    echo '<option value="">--Select District--</option>';
    foreach ($cities as $city) {
      if ($city['id'] == $sel_id) {
        $sel = 'selected';
      } else {
        $sel = '';
      }
      echo '<option value="'.$city['id'].'"'.$sel.'>'.$city['city'].'</option>';
    }
  }



  //ajax block calling
  public function ajax_block() {
    $country_id = $this->input->post('country_id');
    $state_id = $this->input->post('state_id');
    $city_id = $this->input->post('city_id');
    $sel_id = $this->input->post('sel');

    $blocks = $this->db->query("SELECT * FROM wps_blocks_list WHERE country_id='".$country_id."' AND state_id='".$state_id."' AND city_id='".$city_id."' AND status='1'")->result_array();
    echo '<option value="">--Select Block--</option>';
    foreach ($blocks as $block) {
      if ($block['id'] == $sel_id) {
        $sel = 'selected';
      } else {
        $sel = '';
      }
      echo '<option value="'.$block['id'].'"'.$sel.'>'.$block['name'].'</option>';
    }
  }


  //ajax panchayat calling
  public function ajax_panchayat() {
    $country_id = $this->input->post('country_id');
    $state_id = $this->input->post('state_id');
    $city_id = $this->input->post('city_id');
    $block_id = $this->input->post('block_id');
    $sel_id = $this->input->post('sel');
    $panchayats = $this->db->query("SELECT * FROM wps_panchayats_list WHERE country_id='".$country_id."' AND state_id='".$state_id."' AND city_id='".$city_id."' AND block_id='".$block_id."' AND status='1'")->result_array();
    echo '<option value="">--Select Panchayat--</option>';
    foreach ($panchayats as $panchayat) {
      if ($panchayat['id'] == $sel_id) {
        $sel = 'selected';
      } else {
        $sel = '';
      }
      echo '<option value="'.$panchayat['id'].'"'.$sel.'>'.$panchayat['name'].'</option>';
    }
  }

  //ajax village calling
  public function ajax_village() {
    $country_id = $this->input->post('country_id');
    $state_id = $this->input->post('state_id');
    $city_id = $this->input->post('city_id');
    $block_id = $this->input->post('block_id');
    $panchayat_id = $this->input->post('panchayat_id');
    $sel_id = $this->input->post('sel');
    $villages = $this->db->query("SELECT * FROM wps_villages_list WHERE country_id='".$country_id."' AND state_id='".$state_id."' AND city_id='".$city_id."' AND block_id='".$block_id."' AND panchayat_id='".$panchayat_id."' AND status='1'")->result_array();
    echo '<option value="">--Select Village--</option>';
    foreach ($villages as $village) {
      if ($village['id'] == $sel_id) {
        $sel = 'selected';
      } else {
        $sel = '';
      }
      echo '<option value="'.$village['id'].'"'.$sel.'>'.$village['name'].'</option>';
    }
  }
  

  public function check_meta_unique_url() {

    $entity_id = $this->uri->segment(4, 0);
    if($entity_id){
      $entities=" AND entity_id!='".$entity_id."'";
    }else{
      $entities="";
    }

    $url_title=''; //

    if($this->input->post('country')){
      $url_title = seo_url_title($this->input->post('country')); //country_id
    }
    if($this->input->post('state')){
      $url_title = seo_url_title($this->input->post('state')); //country_id
    }
    if($this->input->post('city')){
      $url_title = seo_url_title($this->input->post('city')); //country_id,state_id
    }
    if($this->input->post('name')){
      $url_title = seo_url_title($this->input->post('name')); ////country_id,state_id,city_id or block_id,panchayat_id,village_id
    }

    if($url_title){
      $metasCount = $this->db->query("SELECT page_url FROM wps_meta_tags WHERE page_url='".$url_title."' $entities ")->num_rows();
      if ($metasCount) {
        $this->form_validation->set_message('check_meta_unique_url', 'This url already exists in metatag table.');
        return FALSE;
      }else{
        return TRUE;
      }
    }else{
      return TRUE;
    }

  }


}

// End of controller