<?php
$this->load->view('top_header');
$compSetting = comp_settings();
$compContact = comp_contact();

?>
<!-- Heading Banner--->
<section class="heading_banner" style="background-image: url(<?php echo theme_url(); ?>designer/images/careers/careers.jpg)">
  <div class="container">
    <div class="row">
      <div class="col-lg-12 text-center">
        <div class="cat_title">Careers</div>
        <div class="clearfix"></div>
      </div>
    </div>
  </div>
</section>
<!-- Breadcrumb--->
<section class="inner_breadcrumb hidden-xs">
  <div class="container">
    <div class="row">
      <div class="col-lg-12">
        <ul class="breadcrumb">
          <li><a href="<?php echo comp_url(); ?>" title="Home">Home</a></li>
          <li class="active">Careers</li>
        </ul>
      </div>
    </div>
  </div>
</section>
<!-- Home About--->
<section class="careers_page">
  <div class="container">
    <div class="row">
      <div class="col-md-9 col-md-push-3">
        <div class="careers_right">
            <h1>Careers</h1>
            <?php
              if (is_array($res) && !empty($res)) {
                  foreach ($res as $job) {
                    ?>
                    <div class="career_list">
                      <h2><a href="<?php echo site_url() . $job['friendly_url']; ?>"><?php echo $job['career_title']; ?></a></h2>
                      <div class="detail01">
                        <?php echo nl2br($job['short_desc']); ?>                  
                      </div>
                      <div class="detail01"><a href="<?php echo site_url() . $job['friendly_url']; ?>" class="read_more_product" title="">View Details <i class="fa fa-long-arrow-right fa-1x"></i></a></div>
                    </div>
                    <?php
                  }
              } else {
            ?>
                <div class="alert alert-danger text-center" role="alert">
                  <strong>Oh snap!</strong> No Career(s) Found.
                </div>
            <?php
            }
            ?>

        </div>
      </div>
      <div class="col-md-3 col-md-pull-9">
        <div class="left_sidebar">
          <div class="left_title">Quick Contact</div>
          <div class="alert alert-warning cEmessageBox1" style="display: none;">
            <span class="cEmessage1"></span>
          </div>
          <div class="alert alert-success cSmessageBox1" style="display: none;">
            <span class="cSmessage1"></span>
          </div>
          <form role="form" name="contact-form" method="post" id="quick_form_left">
            <div class="form-group">
              <input tabindex="101" class="form-control" type="text" name="name" id="name" placeholder="Your Name*" value="" pattern="[a-z A-Z]+" required />
            </div>

            <div class="form-group">
              <input tabindex="102" class="form-control" type="email"  name="email" id="email" placeholder="Your Email ID*" value="" required />
            </div>

            <div class="form-group">
              <input tabindex="103" class="form-control" type="tel" name="mobile" id="mobile" placeholder="Your Phone No*"  maxlength="20" minilength="10" value="" required />
            </div>

            <div class="form-group">
              <input tabindex="104" class="form-control locationLeft" type="text"  name="location" placeholder="Your Location*" id="autocomplete" onfocus="geolocate()" value="" pattern="[a-z A-Z]+" autocomplete="off" required />
            </div>

            <div class="form-group">
              <textarea tabindex="105" class="form-control" name="message" id="message" placeholder="Your Message*" required></textarea>
            </div>

            <div class="form-group" style="margin-bottom: 0;">

            </div>

            <div class="form-group">
              <input type="hidden" name="productId" id="proId" value="" />
              <input type="hidden" name="productCompID" id="compId" value="<?php echo $compContact['customers_id']; ?>" />
              <input type="hidden" name="type" id="typeId" value="category" />
              <input type="hidden" name="post_url" id="postedUrl" value="<?php echo current_url(); ?>" />
              <button tabindex="107" class="modal_btn" type="submit" name="submit" value="Submit" data-submit="...Sending">Submit</button>
            </div>
          </form>                
        </div>
        <?php
        if (is_array($catRes) && !empty($catRes)) {
          ?>
          <div class="left_sidebar">
            <div class="left_title">Popular Category</div>
            <ul>
              <?php
              foreach ($catRes as $catVal) {
                ?>
                <li><a href="<?php echo site_url() . $catVal['friendly_url']; ?>" title="<?php echo $catVal['category_name']; ?>"><?php echo $catVal['category_name']; ?></a></li>
                <?php
              }
              ?>
            </ul>
          </div>
        </div>
        <?php
      }
      ?>
    </div>

  </div>
</div>
</section>
<?php if(is_array($compSetting) && !empty($compSetting)){?>
<!-- Webpulse Why Choose Us --->
<section class="web-pulse-choose">
  <div class="container">
    <div class="row">
      <div class="col-lg-5 col-md-5 hidden-sm hidden-xs wow fadeInLeft animated" data-wow-delay=".3s">
        <img class="ming" src="<?php echo theme_url(); ?>designer/images/home/left-image.png" alt="Why Choose Us">
      </div>
      <div class="col-lg-7 col-md-7">
        <div class="red-sec-heading wow fadeInLeft animated" data-wow-delay=".3s">
          <h5>Why Choose Us</h5>
        </div>
        <!--<p class="why_choose_p">We have been offering unparalled expertise to all our clients and their utmost satisfaction is our ultimate goal.</p>-->
        <div class="clearfix"></div>
        <div class="row">
          <div class="col-lg-6 col-md-6 col-sm-6 wow fadeInRight animated" data-wow-delay=".4s">
            <div class="icon_box"> 
              <a class="media-left pull-left"><img src="<?php echo theme_url(); ?>designer/images/home/choose/phone.png" alt="24/7 Availability"></a>
              <div class="media-body">
                <h4 class="media-heading heading"><?php echo $compSetting['whyus_title1']; ?></h4>
                <p><?php echo $compSetting['whyus_desc1']; ?></p>
              </div>
            </div>
          </div>
          <div class="col-lg-6 col-md-6 col-sm-6 wow fadeInRight animated" data-wow-delay=".4s">
            <div class="icon_box"> 
              <a class="media-left pull-left"><img src="<?php echo theme_url(); ?>designer/images/home/choose/icon2.png" alt="Certified Mechanics"></a>
              <div class="media-body">
                <h4 class="media-heading heading"><?php echo $compSetting['whyus_title2']; ?></h4>
                <p><?php echo $compSetting['whyus_desc2']; ?></p>
              </div>
            </div>
          </div>
          <div class="col-lg-6 col-md-6 col-sm-6 wow fadeInRight animated" data-wow-delay=".4s">
            <div class="icon_box"> 
              <a class="media-left pull-left"><img src="<?php echo theme_url(); ?>designer/images/home/choose/icon.png" alt="No Hidden Cost"></a>
              <div class="media-body">
                <h4 class="media-heading heading"><?php echo $compSetting['whyus_title3']; ?></h4>
                <p><?php echo $compSetting['whyus_desc3']; ?></p>
              </div>
            </div>
          </div>
          <div class="col-lg-6 col-md-6 col-sm-6 wow fadeInRight animated" data-wow-delay=".4s">
            <div class="icon_box"> 
              <a class="media-left pull-left"><img src="<?php echo theme_url(); ?>designer/images/home/choose/hand.png" alt="Affordable Prices"></a>
              <div class="media-body">
                <h4 class="media-heading heading"><?php echo $compSetting['whyus_title4']; ?></h4>
                <p><?php echo $compSetting['whyus_desc4']; ?></p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<?php } ?>
<!-- Home Clients -->
<?php echo comp_clients(); ?>
<!-- Footer--->
<?php $this->load->view('bottom_footer'); ?>