<?php
$this->load->view('top_application');
$meta = $this->meta_info;
$pagename = ucwords($meta['page_url']);

$QryStringArr = array();  // To store all Query Variables so to move to other view;
$QryStringArr = array_unique($QryStringArr);
if (isset($this->meta_info['entity_id']) && $this->meta_info['entity_id'] != '') {
  $QryStringArr['category_id'] = $this->meta_info['entity_id'];
}
if ($this->input->get_post('keyword') != '') {
  $QryStringArr['keyword'] = $this->input->get_post('keyword');
}
if ($this->input->get_post('sort') != '') {
  $QryStringArr['sort'] = $this->input->get_post('sort');
}
?>
<section class="dir-pa-sp-top">
  <div class="container com-padd dir-hom-pre-tit">
    <div class="com-title">
      <h2><?php echo $pagename; ?><span> Business Directory</span></h2>
    </div>
    <div class="row span-none">

      <div class="col-md-12 dir-alp-con-right list-grid-rig-pad">
        <div class="dir-alp-con-right-1">
          <div class="row">
            <!--LISTINGS-->
            <?php
            if (is_array($catList) && !empty($catList)) {
              ?>
              <div class="row span-none" id="prodListingContainer">
                <?php
                foreach ($catList as $val) {
                  //trace($val);
                  $link_url = base_url() . $val['friendly_url'];
                  $catCount = count_category(" AND parent_id = '" . $val['category_id'] . "' ");
                  $proCount = count_products(" AND category_id = '" . $val['category_id'] . "' ");
                  if ($proCount > 0) {
                    $count = $proCount;
                    $catRes = array();
                  } else {
                    $count = $catCount;
                    $catRes = $this->db->query("SELECT * FROM wps_categories WHERE parent_id = '" . $val['category_id'] . "' AND status = '1' LIMIT 0, 3")->result_array();
                  }
                  ?>
                  <div class="col-md-3 listpager">                                        
                    <div class="listing-area com-mar-bot-30">
                      <div class="details-img-custom">
                        <div class="single-product-image">
                          <div class="blur-img">
                            <img src="<?php echo get_image('category', $val['category_image'], '200', '200', 'R'); ?>">
                          </div>
                          <div class="main-img">
                            <a href="<?php echo site_url($val['friendly_url']); ?>">
                              <img src="<?php echo get_image('category', $val['category_image'], '400', '250', 'R'); ?>" class="img-responsive"></a>
                          </div>
                        </div>
                      </div>
                      <p class="list-area-title"><a href="<?php echo site_url($val['friendly_url']); ?>"><?php echo $val['category_name']; ?> <small>(<?php echo $count; ?>)</small></a></p>
                      <ul class="list-area-type" >
                        <?php
                        foreach ($catRes as $subCat) {
                          $catCount = count_category(" AND parent_id = '" . $subCat['category_id'] . "' ");
                          $proCount = count_products(" AND category_id = '" . $subCat['category_id'] . "' ");
                          if ($proCount > 0) {
                            $subcount = $proCount;
                          } else {
                            $subcount = $catCount;
                          }
                          ?>
                          <li><a href="<?php echo site_url($subCat['friendly_url']); ?>"><?php echo $subCat['category_name']; ?> (<?php echo $subcount; ?>)</a></li>
                          <?php
                        }
                        ?>
                      </ul>
                    </div>                                    
                  </div>
                  <?php
                }
                ?>

              </div>
              <div class="clearfix"></div>
              <!--<div class="row">
                <ul class="pagination list-pagenat">
                  <li class="disabled"><a href="#!"><i class="material-icons">chevron_left</i></a> </li>
                  <li class="active"><a href="#!">1</a> </li>
                  <li class="waves-effect"><a href="#!">2</a> </li>
                  <li class="waves-effect"><a href="#!">3</a> </li>
                  <li class="waves-effect"><a href="#!">4</a> </li>
                  <li class="waves-effect"><a href="#!">5</a> </li>
                  <li class="waves-effect"><a href="#!">6</a> </li>
                  <li class="waves-effect"><a href="#!">7</a> </li>
                  <li class="waves-effect"><a href="#!">8</a> </li>
                  <li class="waves-effect"><a href="#!"><i class="material-icons">chevron_right</i></a> </li>
                </ul>
              </div>-->
              <!--LISTINGS END-->
              <?php
            }
            ?>
          </div>
        </div>
      </div>

    </div>
  </div>
</section>
<!--MOBILE APP-->
<section class="web-app com-padd">
  <div class="container">
    <div class="row">
      <div class="col-md-6 web-app-img"> <img src="<?php echo theme_url(); ?>images/mobile.png" alt="" /> </div>
      <div class="col-md-6 web-app-con">
        <h2>Looking for the Best Service Provider? <span>Get the App!</span></h2>
        <ul>
          <li><i class="fa fa-check" aria-hidden="true"></i> Find nearby listings</li>
          <li><i class="fa fa-check" aria-hidden="true"></i> Easy service enquiry</li>
          <li><i class="fa fa-check" aria-hidden="true"></i> Listing reviews and ratings</li>
          <li><i class="fa fa-check" aria-hidden="true"></i> Manage your listing, enquiry and reviews</li>
        </ul> <span>We'll send you a link, open it on your phone to download the app</span>
        <form>
          <ul>
            <li>
              <input type="text" placeholder="+01" /> </li>
            <li>
              <input type="number" placeholder="Enter mobile number" /> </li>
            <li>
              <input type="submit" value="Get App Link" /> </li>
          </ul>
        </form>
        <a href="#"><img src="images/android.png" alt="" /> </a>
        <a href="#"><img src="images/apple.png" alt="" /> </a>
      </div>
    </div>
  </div>
</section>
<!--FOOTER SECTION-->
<script type="text/javascript">
  var page = 1;
  var triggeredPaging = 0;

  $(window).scroll(function () {
    $('#loadingdiv').hide();
    var scrollTop = $(window).scrollTop();
    var scrollBottom = (scrollTop + $(window).height());
    var containerTop = $('#prodListingContainer').offset().top;
    var containerHeight = $('#prodListingContainer').height();
    var containerBottom = Math.floor(containerTop + containerHeight);
    var scrollBuffer = 0;
    if ((containerBottom - scrollBuffer) <= scrollBottom) {
      page = $('.listpager').length;
      var queryString = '?stOffSet=' + page;
<?php
if (count($QryStringArr)) {
  foreach ($QryStringArr as $qrykey => $qryval) {
    ?>
          queryString += "&<?php echo $qrykey; ?>=<?php echo $qryval; ?>";
    <?php
  }
}
?>
      var actual_count = <?php echo $total_rows; ?>;

      if (!triggeredPaging && page < actual_count) {
        triggeredPaging = 1;
        $.ajax({
          type: "POST",
          url: "<?php echo base_url(); ?>category/ajax_load_category_view" + queryString,
          error: function (res) {
            //alert('Error');
            triggeredPaging = 0;
            $('#loadingdiv').hide();
            //console.log(arguments);
          },
          beforeSend: function (jqXHR, settings) {
            $('#loadingdiv').show();

          },
          success: function (res) {
            $('#loadingdiv').hide();
            $("#prodListingContainer").append(res);
            triggeredPaging = 0;
            //console.log(res);
            $('.listpager').fadeTo(1000, 0.5, function () {
              $(this).fadeTo(1000, 1.0);
            });
          }
        });
      }
    }
  });
</script>
<?php $this->load->view('bottom_application'); ?>