<?php
$this->load->view('top_header');
$compSetting = comp_settings();
?>


<!-- Heading Banner--->
<section class="heading_banner" style="background-image: url(<?php echo theme_url(); ?>designer/images/gallery/gallery.jpg)">
  <div class="container">
    <div class="row">
      <div class="col-lg-12 text-center">
        <div class="cat_title">Video <strong>Gallery</strong></div>
        <div class="clearfix"></div>
      </div>
    </div>
  </div>
</section>

<!-- Breadcrumb--->
<section class="inner_breadcrumb hidden-xs">
  <div class="container">
    <div class="row">
      <div class="col-lg-12">
        <ul class="breadcrumb">
          <li><a href="<?php echo comp_url(); ?>" title="Home">Home</a></li>
          <li class="active">Video Gallery</li>
        </ul>
      </div>
    </div>
  </div>
</section>


<!-- Home About--->
<section class="about_page">
  <div class="container">
    <div class="row">
      <div class="col-md-9 col-md-push-3">
        <div class="right_side">
          <h1>Video Gallery</h1>
          <div class="row">
            <?php
            if (is_array($res) && !empty($res)) {
              foreach ($res as $video) {
                ?>
                <div class="col-lg-6 col-md-6">
                  <div class="video_gallery">
                    <iframe src="https://www.youtube.com/embed/<?php echo $video['video_image']; ?>" frameborder="0" allowfullscreen></iframe>
                    <h3><i class="fa fa-youtube"></i> <?php echo $video['video_text']; ?></h3>
                  </div>
                </div>
                <?php
              }
            } else {
              ?>
              <div class="col-lg-12 col-md-12">
                <div class="alert alert-danger text-center" role="alert">
                  <strong>Oh snap!</strong> No Video(s) Found.
                </div>
              </div>
              <?php
            }
            ?>
  
          </div>
        </div>
      </div>
      <div class="col-md-3 col-md-pull-9">
        <div class="left_sidebar">
          <div class="left_title">Quick Contact</div>
          <form role="form" name="contact-form" method="post" id="quick_form">
            <div class="form-group">
              <input tabindex="101" class="form-control" type="text" name="name" placeholder="Your Name*" value="" pattern="[a-z A-Z]+" required>
            </div>

            <div class="form-group">
              <input tabindex="102" class="form-control" type="email"  name="email" placeholder="Your Email ID*" value="" required>
            </div>

            <div class="form-group">
              <input tabindex="103" class="form-control" type="tel" name="mobile" placeholder="Your Phone No*"  maxlength="20" minilength="10" value="" required>
            </div>

            <div class="form-group">
              <input tabindex="104" class="form-control" type="text"  name="location" placeholder="Your Location*" id="autocomplete" onfocus="geolocate()" value="" pattern="[a-z A-Z]+" autocomplete="off" required>
            </div>

            <div class="form-group">
              <textarea tabindex="105" class="form-control" name="message" placeholder="Your Message*" required></textarea>
            </div>

            <div class="form-group" style="margin-bottom: 0;">
              <div tabindex="106" class="g-recaptcha" data-sitekey="6LeIanwUAAAAAFmGKxHc8HDyiVvsJdvRc01uSMVD"></div>
            </div>

            <div class="form-group">
              <button tabindex="107" class="modal_btn" type="submit" name="submit" value="Submit" data-submit="...Sending">Submit</button>
            </div>
          </form>                
        </div>


        <?php
        if (is_array($catRes) && !empty($catRes)) {
          ?>
          <div class="left_sidebar">
            <div class="left_title">Popular Category</div>
            <ul>
              <?php
              foreach ($catRes as $catVal) {
                ?>
                <li><a href="<?php echo site_url() . $catVal['friendly_url']; ?>" title="<?php echo $catVal['category_name']; ?>"><?php echo $catVal['category_name']; ?></a></li>
                <?php
              }
              ?>
            </ul>
          </div>
        </div>
        <?php
      }
      ?>
    </div>
  </div>
</div>
</section>

<?php if(is_array($compSetting) && !empty($compSetting)){?>
<!-- Webpulse Why Choose Us --->
<section class="web-pulse-choose">
  <div class="container">
    <div class="row">
      <div class="col-lg-5 col-md-5 hidden-sm hidden-xs wow fadeInLeft animated" data-wow-delay=".3s">
        <img class="ming" src="<?php echo theme_url(); ?>designer/images/home/left-image.png" alt="Why Choose Us">
      </div>
      <div class="col-lg-7 col-md-7">
        <div class="red-sec-heading wow fadeInLeft animated" data-wow-delay=".3s">
          <h5>Why Choose Us</h5>
        </div>
        <!--<p class="why_choose_p">We have been offering unparalled expertise to all our clients and their utmost satisfaction is our ultimate goal.</p>-->
        <div class="clearfix"></div>
        <div class="row">
          <div class="col-lg-6 col-md-6 col-sm-6 wow fadeInRight animated" data-wow-delay=".4s">
            <div class="icon_box"> 
              <a class="media-left pull-left"><img src="<?php echo theme_url(); ?>designer/images/home/choose/phone.png" alt="24/7 Availability"></a>
              <div class="media-body">
                <h4 class="media-heading heading"><?php echo $compSetting['whyus_title1']; ?></h4>
                <p><?php echo $compSetting['whyus_desc1']; ?></p>
              </div>
            </div>
          </div>
          <div class="col-lg-6 col-md-6 col-sm-6 wow fadeInRight animated" data-wow-delay=".4s">
            <div class="icon_box"> 
              <a class="media-left pull-left"><img src="<?php echo theme_url(); ?>designer/images/home/choose/icon2.png" alt="Certified Mechanics"></a>
              <div class="media-body">
                <h4 class="media-heading heading"><?php echo $compSetting['whyus_title2']; ?></h4>
                <p><?php echo $compSetting['whyus_desc2']; ?></p>
              </div>
            </div>
          </div>
          <div class="col-lg-6 col-md-6 col-sm-6 wow fadeInRight animated" data-wow-delay=".4s">
            <div class="icon_box"> 
              <a class="media-left pull-left"><img src="<?php echo theme_url(); ?>designer/images/home/choose/icon.png" alt="No Hidden Cost"></a>
              <div class="media-body">
                <h4 class="media-heading heading"><?php echo $compSetting['whyus_title3']; ?></h4>
                <p><?php echo $compSetting['whyus_desc3']; ?></p>
              </div>
            </div>
          </div>
          <div class="col-lg-6 col-md-6 col-sm-6 wow fadeInRight animated" data-wow-delay=".4s">
            <div class="icon_box"> 
              <a class="media-left pull-left"><img src="<?php echo theme_url(); ?>designer/images/home/choose/hand.png" alt="Affordable Prices"></a>
              <div class="media-body">
                <h4 class="media-heading heading"><?php echo $compSetting['whyus_title4']; ?></h4>
                <p><?php echo $compSetting['whyus_desc4']; ?></p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<?php } ?>
<!-- Home Clients -->
<?php echo comp_clients(); ?>
<!-- Footer--->
<?php $this->load->view('bottom_footer'); ?>
</script><script src="<?php echo theme_url(); ?>designer/js/jquery.fancybox.pack.js"></script>
<script>
                $('.fancybox').fancybox();
</script>