<?php

class Wpstemplate extends Public_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array(
        'wpstemplate/wpstemplate_model',
        'products/product_model',
        'users/users_model',
        'members/members_model',
        'category/category_model',
        'blog/blog_model',
        'sitepanel/setting_model',
        'sitepanel/career_model',
        'sitepanel/banner_model',
    ));
    $this->load->helper(array(
        'products/product',
        'category/category',
        'query_string'
    ));
    $this->load->library(array(
        'safe_encrypt',
        'securimage_library',
        'Auth',
        'Dmailer',
        'cart'
    ));

    $this->comp_contact = comp_settings();
    $this->compInfo = comp_contact();

    if(stristr($this->compInfo['mobile_number'],"+91")){
      $this->mem_mobile_no=$this->compInfo['mobile_number'];
    }else{
      $this->mem_mobile_no='+91-'.$this->compInfo['mobile_number']; 
    };
  
  }

  public function index() {
    $data['page_title'] = "";
    $data['page_keyword'] = "";
    $data['page_description'] = "";

    //Company Info
    $compSetting = comp_settings();
    $data['compSetting'] = $compSetting;
    //trace($compSetting);

    $compContact = comp_contact();
    $data['compContact'] = $compContact;
    //trace($compContact);

    $compFacts = comp_facts();
    $data['factsheet'] = $compFacts;
    //trace($compFacts);
    //Banner
    $res_banner_array = $this->banner_model->get_company_banner(10, 0, array('orderby' => 'RAND()', 'customers_id' => $compContact['customers_id']));
    $data['banner'] = $res_banner_array;

    //category
    $condtion = "";
    $condtion = "AND companyId = '" . $compContact['customers_id'] . "' AND status = '1'";
    $condtion_array = array(
        'field' => "*,( SELECT COUNT(category_id) FROM wps_categories AS b WHERE b.parent_id=a.category_id ) AS total_subcategories",
        'condition' => $condtion,
        'limit' => 5,
        'offset' => 0,
        'debug' => FALSE
    );
    $res_array = $this->category_model->get_company_category($condtion_array);
    $data['catRes'] = $res_array;


    //Products
    $cond = array();
    $cond['customers_id'] = $compContact['customers_id'];
    $cond['orderby'] = 'RAND()';
    $res_array = $this->product_model->get_products(8, 0, $cond);
    $data['res'] = $res_array;

    //Blogs
    $condtionBlog = array();
    $condtionBlog['companyId'] = $compContact['customers_id'];
    $condtionBlog['orderby'] = 'RAND()';
    $res_array_blog = $this->blog_model->get_company_blog(3, 0, $condtionBlog);
    $data['blogs'] = $res_array_blog;

    //Call of View
    $this->load->view('index', $data);
  }

  public function about() {
    $data['page_title'] = "";
    $data['page_keyword'] = "";
    $data['page_description'] = "";

    //Company Info
    $compSetting = comp_settings();
    $data['compSetting'] = $compSetting;
    //trace($compSetting);

    $compContact = comp_contact();
    $data['compContact'] = $compContact;
    //trace($compContact);

    $compFacts = comp_facts();
    $data['factsheet'] = $compFacts;
    //trace($compFacts);
    //category
    
    $condtion = "";
    //$condtion = "AND companyId = '" . $compSetting['customers_id'] . "' AND status = '1'";
    $condtion = "AND companyId = '" . $compContact['customers_id'] . "' AND status = '1'";
    $condtion_array = array(
        'field' => "*,( SELECT COUNT(category_id) FROM wps_categories AS b WHERE b.parent_id=a.category_id ) AS total_subcategories",
        'condition' => $condtion,
        'limit' => 5,
        'offset' => 0,
        'debug' => FALSE
    );
    $res_array = $this->category_model->get_company_category($condtion_array);
    $data['catRes'] = $res_array;

    // $settingRes = $this->db->query("SELECt * FROM wps_website_about WHERE customers_id = '" . $this->session->userdata('user_id') . "'")->row_array();
    $settingRes = $this->db->query("SELECt * FROM wps_website_about WHERE customers_id = '" . $compContact['customers_id'] . "'")->row_array();
    $data['settingRes'] = $settingRes;

    $this->load->view('about', $data);
  }

  public function photo() {

    $data['page_title'] = "";
    $data['page_keyword'] = "";
    $data['page_description'] = "";
    //$compSetting = comp_settings();
    $compContact = comp_contact();
    $customers_id = $compContact['customers_id'];


    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = 10; //( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $res_array = $this->banner_model->get_company_photo($config['limit'], $offset, array('customers_id' => $customers_id));
    $config['total_rows'] = get_found_rows();
    $data['res'] = $res_array;
    //echo_sql(); die;
    //$config['total_rows'] = $this->banner_model->total_rec_found;
    $data['page_links'] = dashboard_pagination($base_url, $config['total_rows'], $config['limit'], $offset);

    //Category Left
    $data['catRes'] = $this->db->query("SELECT * FROM wps_company_categories WHERE status = '1' and companyId='".$customers_id."' ORDER By category_id ASC")->result_array();

    $this->load->view('photo-gallery-details', $data);
  }

  public function video() {
    $data['page_title'] = "";
    $data['page_keyword'] = "";
    $data['page_description'] = "";
    //$compSetting = comp_settings();
    $compContact = comp_contact();
    $customers_id = $compContact['customers_id'];


    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = 10; //( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $res_array = $this->banner_model->get_company_video($config['limit'], $offset, array('customers_id' => $customers_id));
    $config['total_rows'] = get_found_rows();
    $data['res'] = $res_array;
    //echo_sql(); die;
    //$config['total_rows'] = $this->banner_model->total_rec_found;
    $data['page_links'] = dashboard_pagination($base_url, $config['total_rows'], $config['limit'], $offset);

    //Category Left
    $data['catRes'] = $this->db->query("SELECT * FROM wps_company_categories WHERE status = '1' and companyId='".$customers_id."' ORDER By category_id ASC")->result_array();

    $this->load->view('video-gallery', $data);
  }

  public function contactus() {
    $data['page_title'] = "Contact Us";
    $data['page_keyword'] = "";
    $data['page_description'] = "";


    $this->form_validation->set_rules('name', 'Your Name', 'trim|required');
    $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
    $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required');
    $this->form_validation->set_rules('location', 'Your Location', 'trim|required');
    $this->form_validation->set_rules('message', 'Message', 'trim|required');
    $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");

    if ($this->form_validation->run() == TRUE) {
      $posted_data = array(
          'customers_id' => $this->comp_contact['customers_id'],
          'type' => '3',
          'first_name' => $this->input->post('name'),
          'last_name' => '',
          'email' => $this->input->post('email'),
          'mobile_number' => $this->input->post('phone'),
          'message' => $this->input->post('message'),
          'location' => $this->input->post('location'),
          'receive_date' => $this->config->item('config.date.time')
      );
      $this->wpstemplate_model->safe_insert('wps_company_enquiry', $posted_data, FALSE);

      //Mail
      $subject = "New enquiry Received on Your Natural Therapy India's Website";
      $content = file_get_contents(site_url() . 'mailer/comp-enquiry-received.html');
      $name = $this->input->post('name') . ' ' . $this->input->post('last_name');
      $body = $content;
      $body = str_replace('{name}', $name, $body);
      $body = str_replace('{message}', $this->input->post('message'), $body);
      $body = str_replace('{site_name}', $this->config->item('site_name'), $body);
      $body = str_replace('{admin_email}', $this->config->item('site_name'), $body);
      //"Enquiry from " . $name . " ",
      $mail_conf = array(
          'subject' => $subject,
          'to_email' => $this->input->post('email'), //"kirpanand@webpulseindia.com",
          'from_email' => $this->input->post('email'),
          'from_name' => $name,
          'body_part' => $body
      );
      //trace($mail_conf);
      //exit;
      $this->dmailer->mail_notify($mail_conf);

      $msg = "Your request has been sent successfully ! We will get back to you shortly !";
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', $msg);
      redirect(comp_url() . 'contact-us');
    }

    $this->load->view('wpstemplate/contact', $data);
  }

  //Manage Company Modules
  public function blogs($page = NULL) {
    $compContact = comp_contact();
    $companyId = $compContact['customers_id'];

    //$companyId = $this->comp_contact['customers_id'];
    $condtion = array();
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = 2;
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $condtion['companyId'] = $companyId;
    $status = $this->input->get_post('status', TRUE);
    if ($status != '') {
      $condtion['status'] = $status;
    }
    $res_array = $this->blog_model->get_company_blog($config['limit'], $offset, $condtion);
    //echo_sql(); die;
    $config['total_rows'] = get_found_rows();
    $data['heading_title'] = 'Blog Lists';
    $data['res'] = $res_array;
    $data['page_links'] = dashboard_pagination($base_url, $config['total_rows'], $config['limit'], $offset);

    if ($this->input->post('status_action') != '') {
      $this->update_status('wps_company_blog', 'article_id');
    }
    /* End product set as a */
    $condtion['orderby'] = 'RAND()';
    $leftBlogs = $this->blog_model->get_company_blog(3, 0, $condtion);
    $data['leftBlog'] = $leftBlogs;

    //Category Left
    $data['catRes'] = $this->db->query("SELECT * FROM wps_company_categories WHERE status = '1' and companyId='".$companyId."' ORDER By category_id ASC")->result_array();

    $data['category_result_found'] = "Total " . $config['total_rows'] . " result(s) found ";
    $this->load->view('wpstemplate/blog', $data);
  }

  public function blog_details() {
    $companyId = $this->comp_contact['customers_id'];
    $blogId = (int) $this->meta_info['entity_id'];
    $option = array('productid' => $blogId);
    $res = $this->blog_model->get_company_blog(1, 0, $option);
    $data['res'] = $res;

    if (is_array($res) && !empty($res)) {
      $status = $this->input->get_post('status', TRUE);
      $condtion['companyId'] = $companyId;
      if ($status != '') {
        $condtion['status'] = $status;
      }
      $condtion['orderby'] = 'RAND()';
      $leftBlogs = $this->blog_model->get_company_blog(3, 0, $condtion);
      $data['leftBlog'] = $leftBlogs;

      //Category Left
      $data['catRes'] = $this->db->query("SELECT * FROM wps_company_categories WHERE status = '1' and companyId='".$companyId."' ORDER By category_id ASC")->result_array();

      $this->load->view('wpstemplate/blog-details', $data);
    } else {
      redirect(comp_url() . 'blogs', '');
    }
  }

  public function career() {
    $compContact = comp_contact();
    $companyId = $compContact['customers_id'];

    //$companyId = $this->comp_contact['customers_id'];
    $condtion = array();
    $record_per_page = (int) $this->input->post('per_page');
    $category_id = $this->uri->segment(3);
    $page_segment = find_paging_segment();
    $config['per_page'] = 20; //( $record_per_page > 0 ) ? $record_per_page : $this->config->item('per_page');
    $offset = (int) $this->uri->segment($page_segment, 0);
    $base_url = ( $category_id != '' && $category_id != 'pg') ? "media/index/$category_id/pg/" : "media/index/pg/";
    $condtion['status'] = '1';
    $condtion['customers_id'] = $companyId;
    $page_title = "Job Lists";
    $data['heading_title'] = $page_title;


    $res_array = $this->career_model->get_career($config['per_page'], $offset, $condtion);
    $config['total_rows'] = get_found_rows();
    $data['page_links'] = dashboard_pagination("$base_url", $config['total_rows'], $config['per_page'], $page_segment);

    //Category Left
    $data['catRes'] = $this->db->query("SELECT * FROM wps_company_categories WHERE status = '1' and companyId='".$companyId."' ORDER By category_id ASC")->result_array();

    $data['res'] = $res_array;
    $this->load->view('wpstemplate/careers', $data);
  }

  public function career_details() {
    $compContact = comp_contact();
    $companyId = $compContact['customers_id'];

    $data['unq_section'] = "Media";
    $career_id = (int) $this->meta_info['entity_id']; //(int) $this->uri->segment(3);
    $option = array('career_id' => $career_id);
    $res = $this->career_model->get_career(1, 0, $option);
    if (is_array($res)) {
      $data['title'] = "Job(s)";
      $data['res'] = $res;

      //Category Left
      $data['catRes'] = $this->db->query("SELECT * FROM wps_company_categories WHERE status = '1' and companyId='".$companyId."' ORDER By category_id ASC")->result_array();

      $this->load->view('wpstemplate/careers-details', $data);
    } else {
      redirect(comp_url() . 'career', '');
    }
  }

  public function apply_job() {

    $data['unq_section'] = "Aplly for Job";
    $career_id = (int) (int) $this->uri->segment(3);
    $option = array('career_id' => $career_id);
    $res = $this->career_model->get_career(1, 0, $option);

    if (is_array($res)) {
      $data['title'] = "Job(s)";
      $data['res'] = $res;

      if ($this->input->post('action') == "post_comment") {

        $tRap = $this->input->post('tRap');
        if ($tRap == '1') {
          redirect(comp_url('career'), 'refresh');
          exit;
        }

        // Post comment Start
        $this->form_validation->set_rules('fname', 'Name', 'trim|required|xss_clean|max_length[60]');
        $this->form_validation->set_rules('email', 'Email Id', 'trim|required|valid_email|max_length[200]');
        $this->form_validation->set_rules('mobile', 'Mobile No.', 'trim|required|max_length[15]');
        $this->form_validation->set_rules('file1', 'Resume', "required|file_allowed_type[document]");
        $this->form_validation->set_rules('comment', 'Message', 'trim|required|max_length[2500]');

        //	trace($this->session->userdata);
        if ($this->form_validation->run() == TRUE) {

          $uploaded_file = "";
          if (!empty($_FILES) && $_FILES['file1']['name'] != '') {
            $config['max_size'] = '2048';
            $this->load->library('upload');
            $uploaded_data = $this->upload->my_upload('file1', 'clients/career');
            if (is_array($uploaded_data) && !empty($uploaded_data)) {
              $uploaded_file = $uploaded_data['upload_data']['file_name'];
            }
          }

          $posted_data = array(
              'career_id' => $career_id,
              'mem_name' => $this->input->post('fname'),
              'comment' => $this->input->post('comment'),
              'mem_email' => $this->input->post('email'),
              'mobile' => $this->input->post('mobile'),
              'resume' => $uploaded_file,
              'post_date' => $this->config->item('config.date.time'),
              'status' => '1'
          );
          $this->career_model->safe_insert('wps_career_application', $posted_data, FALSE);


          //Mail
          $subject = 'New Job Application Received - ' . $res['career_title'];
          $body = '<table border="0" style="width:100%">
            <tbody>
            <tr>
              <td colspan="2"><strong>Dear Admin,</strong></td>
            </tr>
            <tr>
              <td colspan="2">We have a new Job Application for ' . $res['career_title'] . '</td>
            </tr>
            <tr>
              <td colspan="2">Details of the Applicant is as follws:</td>
            </tr>
            <tr>
              <td colspan="2">&nbsp;</td>
            </tr>';
          $slno = 1;

          if ($this->input->post('fname')) {
            $body .= '<tr>
      <td style="border-bottom:1px solid #ccc; padding-bottom:5px;" width="35%">Name</td>
      <td style="border-bottom:1px solid #ccc; padding-bottom:5px;" width="65%">' . $this->input->post('fname') . '</td>
    </tr>';
          }
          if ($this->input->post('email')) {
            $body .= '<tr>
      <td style="border-bottom:1px solid #ccc; padding-bottom:5px;">Email</td>
      <td style="border-bottom:1px solid #ccc; padding-bottom:5px;">' . $this->input->post('email') . '</td>
    </tr>';
          }
          if ($this->input->post('mobile')) {
            $body .= '<tr>
      <td style="border-bottom:1px solid #ccc; padding-bottom:5px;">Mobile</td>
      <td style="border-bottom:1px solid #ccc; padding-bottom:5px;">' . $this->input->post('mobile') . '</td>
    </tr>';
          }
          if ($this->input->post('comment')) {
            $body .= '<tr>
      <td style="border-bottom:1px solid #ccc; padding-bottom:5px;">Message</td>
      <td style="border-bottom:1px solid #ccc; padding-bottom:5px;">' . $this->input->post('comment') . '</td>
    </tr>';
          }
          if ($uploaded_file) {
            $body .= '<tr>
      <td style="border-bottom:1px solid #ccc; padding-bottom:5px;">Resume</td>
      <td style="border-bottom:1px solid #ccc; padding-bottom:5px;"><a href="' . site_url() . 'uploaded-files/clients/career/' . $uploaded_file . '" target="_blank">Dowaload Resume</a></td>
    </tr>';
          }
          $body .= '<tr>
              <td colspan="4">&nbsp;</td>
              </tr>
              <tr>
              <td colspan="4">
              Thank you.<br />
              Administrator<br />
              Natural Therapy India<br />        
              </td>
              </tr>
              <tr>
              <td colspan="2" style="text-align:center">
              &copy; 2019-2020 Natural Therapy India. All right reserved.
              </td>
              </tr>
              <tr>
              <td colspan="2" style="text-align:center">
              Note: Please do not print this email unless you really need a print out.
              </td>
              </tr>
              </tbody>
              </table>';
          $mail_conf = array(
              'subject' => $subject,
              'to_email' => "kirpanand@webpulseindia.com",
              'from_email' => $this->input->post('email'),
              'from_name' => 'Admin',
              'body_part' => $body
          );
          //trace($mail_conf);
          //exit;
          $this->dmailer->mail_notify($mail_conf);

          $mail_conf_1 = array(
              'subject' => $subject,
              'to_email' => "sales@webpulseindia.com",
              'from_email' => $this->input->post('email'),
              'from_name' => 'Admin',
              'body_part' => $body
          );
          //trace($mail_conf);
          //exit;
          //$this->dmailer->mail_notify($mail_conf_1);

          $message = "Apllication posted successfully.";
          $message = str_replace('<site_name>', $this->config->item('site_name'), $message);
          $this->session->set_userdata(array('msg_type' => 'success'));
          $this->session->set_flashdata('success', $message);
          redirect($_SERVER['HTTP_REFERER']);
        }
      }
      // Post comment End
      //Category Left
      $data['catRes'] = $this->db->query("SELECT * FROM wps_company_categories WHERE status = '1' ORDER By category_id ASC")->result_array();
      $this->load->view('wpstemplate/careers-form', $data);
    } else {
      redirect(comp_url() . 'career', '');
    }
  }

  public function clients() {
    $compC = comp_contact();

    //Category Left
    $data['catRes'] = $this->db->query("SELECT * FROM wps_company_categories WHERE status = '1' ORDER By category_id ASC")->result_array();

    $clients = $this->db->query("SELECT * FROM wps_clients WHERE status='1' AND companyId = '" . $compC['customers_id'] . "'")->result_array();

    $data['clients'] = $clients;


    $this->load->view('wpstemplate/clients', $data);
  }

}
