<?php $this->load->view("includes/header"); ?>
<div class="page-title">
  <h2><span><?php echo $heading_title; ?></span></h2>
  <a href="<?php echo base_url();?>sitepanel/location/village/" class="btn btn-primary pull-right">Manage Village</a>
  <a href="javascript:void(0);" onclick="history.back();" class="btn btn-primary pull-right">Cancel</a>
</div>
<div class="page-content-wrap"> 
  <div class="fix"></div>
  <div class="row">
    <div class="col-md-12">
      <div class="panel panel-default">
        <div class="panel-body">
          <?php //echo validation_message(); ?>
          <?php //echo error_message(); ?> 
          <?php echo form_open_multipart("", 'class="form-horizontal"'); ?>
          <div class="form-group">
            <label class="col-md-3 col-xs-12 control-label"><span class="required">*</span>Country</label>
            <div class="col-md-6">  
              <?php $country_id=set_value("country_id"); ?>
              <select name="country_id" class="form-control" id="country">
                <option value="">--Select Country--</option>
                <?php 
                if ($country) {
                  foreach ($country as $cnt) {
                    if ($cnt['id'] == $country_id) {
                      $sel = "selected";
                    } else {
                      $sel = "";
                    }
                    ?>
                    <option value="<?php echo $cnt['id']; ?>" <?php echo $sel; ?>><?php echo $cnt['name']; ?></option>
                    <?php
                  }
                }
                ?>
              </select>
              <?php echo form_error("country_id");?>
            </div>
          </div>
          <div class="form-group">
            <label class="col-md-3 col-xs-12 control-label"><span class="required">*</span>State</label>
            <div class="col-md-6">
              <select name="state_id" class="form-control" id="state">
                <option value="">--Select State--</option>
              </select>
              <?php echo form_error("state_id");?>
            </div>
          </div>
          <div class="form-group">
            <label class="col-md-3 col-xs-12 control-label"><span class="required">*</span>District</label>
            <div class="col-md-6">
              <select name="city_id" class="form-control" id="city">
                <option value="">--Select District--</option>
              </select>
              <?php echo form_error("city_id");?>
            </div>
          </div>
          <div class="form-group">
            <label class="col-md-3 col-xs-12 control-label"><span class="required">*</span>Block</label>
            <div class="col-md-6">
              <select name="block_id" class="form-control" id="block">
                <option value="">--Select Block--</option>
              </select>
              <?php echo form_error("block_id");?>
            </div>
          </div>
          <div class="form-group">
            <label class="col-md-3 col-xs-12 control-label"><span class="required">*</span>Panchayat</label>
            <div class="col-md-6">
              <select name="panchayat_id" class="form-control" id="panchayat">
                <option value="">--Select Panchayat--</option>
              </select>
              <?php echo form_error("panchayat_id");?>
            </div>
          </div>
          <div class="form-group">
            <label class="col-md-3 col-xs-12 control-label"><span class="required">*</span>Village</label>
            <div class="col-md-6">                                     
              <input type="text" class="form-control" name="name" id="name" value="<?php echo set_value("name");?>">  
              <?php echo form_error("name");?>
            </div>
          </div>
          <?php /*
          <div class="form-group">
            <label class="col-md-3 col-xs-12 control-label"><span class="required">*</span>Banner Image</label>
            <div class="col-md-6 col-xs-12">
              <a class="file-input-wrapper btn btn-default  fileinput btn-primary"><span>Browse file</span><input type="file" class="fileinput btn-primary" name="image1" id="image1" title="Browse file" accept="image/*"></a>
            </div>
          </div>*/ ?>
          <div class="form-group">
            <div class="col-md-9">
              <input type="submit" class="btn bg-red pull-right" name="submit" value="Submit">
            </div>
          </div>
          <?php echo form_close(); ?>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $this->load->view("includes/footer"); ?>
<script>
  $(document).ready(function () {
    $("#country").change(function () {
      states();
    });
    $("#state").change(function () {
      cities();
    });
    $("#city").change(function () {
      blocks();
    });
    $("#block").change(function () {
      panchayats();
    });

  });
  <?php if($this->input->post()){ ?>
    states('<?php echo $this->input->post('state_id');?>','<?php echo $this->input->post('country_id');?>');
    cities('<?php echo $this->input->post('city_id');?>','<?php echo $this->input->post('state_id');?>','<?php echo $this->input->post('country_id');?>');
    blocks('<?php echo $this->input->post('block_id');?>','<?php echo $this->input->post('city_id');?>','<?php echo $this->input->post('state_id');?>','<?php echo $this->input->post('country_id');?>');
    panchayats('<?php echo $this->input->post('panchayat_id');?>','<?php echo $this->input->post('block_id');?>','<?php echo $this->input->post('city_id');?>','<?php echo $this->input->post('state_id');?>','<?php echo $this->input->post('country_id');?>');
  <?php } ?>

  function states(sel,country_id){ 
    if(country_id){
      var country =country_id
    }else{
      var country = $("#country").val();
    };
    if(country){
        $("#state").html('<option value="">--Select State--</option>');
        $("#city").html('<option value="">--Select City--</option>');
        $("#block").html('<option value="">--Select Block--</option>');
        $("#panchayat").html('<option value="">--Select Panchayat--</option>');
        $.ajax({
          url: '<?php echo base_url('sitepanel/location/ajax_state'); ?>',
          type: 'post',
          data: ({'country_id': country,'sel': sel}),
          success: function (data) {
            $("#state").html(data);
          }
        });
    }else{
      $("#state").html('<option value="">--Select State--</option>');
      $("#city").html('<option value="">--Select City--</option>');
      $("#block").html('<option value="">--Select Block--</option>');
      $("#panchayat").html('<option value="">--Select Panchayat--</option>');
    }
  }


  function cities(sel,state_id,country_id){ 
    if(country_id){
        var country_id =country_id
      }else{
        var country_id = $("#country").val()
      };
      if(state_id){
        var state_id =state_id
        }else{
          var state_id = $("#state").val()
        };
      $("#block").html('<option value="">--Select Block--</option>');
      $("#panchayat").html('<option value="">--Select Panchayat--</option>');
      $.ajax({
        url: '<?php echo base_url('sitepanel/location/ajax_city'); ?>',
        type: 'post',
        data: ({'country_id': country_id,'state_id': state_id,'sel': sel}),
        success: function (data) {
          $("#city").html(data);
        }
      });
  }

  function blocks(sel,city_id,state_id,country_id){ 
    if(country_id){
        var country_id =country_id
      }else{
        var country_id = $("#country").val()
      };
    if(city_id){
        var city_id =city_id
        }else{
          var city_id = $("#city").val()
        };
      if(state_id){
        var state_id =state_id
        }else{
          var state_id = $("#state").val()
        };
      $("#panchayat").html('<option value="">--Select Panchayat--</option>');
      $.ajax({
        url: '<?php echo base_url('sitepanel/location/ajax_block'); ?>',
        type: 'post',
        data: ({'country_id': country_id,'state_id': state_id,'city_id': city_id,'sel': sel}),
        success: function (data) {
          $("#block").html(data);
        }
      });
  }
  
  function panchayats(sel,block_id,city_id,state_id,country_id){ 
    if(country_id){
        var country_id =country_id
      }else{
        var country_id = $("#country").val()
      };
    if(block_id){
        var block_id =block_id
        }else{
          var block_id = $("#block").val()
        };
    if(city_id){
        var city_id =city_id
        }else{
          var city_id = $("#city").val()
        };
      if(state_id){
        var state_id =state_id
        }else{
          var state_id = $("#state").val()
        };
      $.ajax({
        url: '<?php echo base_url('sitepanel/location/ajax_panchayat'); ?>',
        type: 'post',
        data: ({'country_id': country_id,'state_id': state_id,'city_id': city_id,'block_id': block_id,'sel': sel}),
        success: function (data) {
          $("#panchayat").html(data);
        }
      });
  }

</script>