<?php $this->load->view("includes/header"); ?>
<div class="page-title">
  <h2><span><?php echo $heading_title; ?></span></h2>
  <a href="<?php echo base_url();?>sitepanel/location/city" class="btn btn-primary pull-right">Manage Districts</a>
  <a href="javascript:void(0);" onclick="history.back();" class="btn btn-primary pull-right">Cancel</a>
</div>
<div class="page-content-wrap"> 
  <div class="fix"></div>
  <div class="row">
    <div class="col-md-12">
      <div class="panel panel-default">
        <div class="panel-body">
          <?php echo form_open_multipart("sitepanel/location/city_edit/" . $res->id, 'class="form-horizontal"'); ?>
          <div class="form-group">
            <label class="col-md-3 col-xs-12 control-label"><span class="required">*</span>Country</label>
            <div class="col-md-6">  
            <?php $country_id=set_value("country_id",$res->country_id); ?>                                                                                                                                                        
              <select name="country_id" class="form-control" id="country">
                <option value="">--Select Country--</option>
                <?php
                if ($country) {
                  foreach ($country as $cnt) {
                    if ($cnt['id'] == $country_id) {
                      $sel = "selected";
                    } else {
                      $sel = "";
                    }
                    ?>
                    <option value="<?php echo $cnt['id']; ?>" <?php echo $sel; ?>><?php echo $cnt['name']; ?></option>
                    <?php
                  }
                }
                ?>
              </select>
              <?php echo form_error('country_id'); ?>
            </div>
          </div>
          <div class="form-group">
            <label class="col-md-3 col-xs-12 control-label"><span class="required">*</span>State</label>
            <div class="col-md-6">
              <?php $state_id=set_value("state_id",$res->state_id); ?>
              <select name="state_id" class="form-control" id="state">
              <option value="">--Select State--</option>
                <?php
                if ($states) {
                  foreach ($states as $state) {
                    if ($state['id'] == $state_id) {
                      $sel = "selected";
                    } else {
                      $sel = "";
                    }
                    ?>
                    <option value="<?php echo $state['id'] ?>" <?php echo $sel; ?>><?php echo $state['name']; ?></option>
                    <?php
                  }
                }
                ?>
              </select> 
              <?php echo form_error('state_id'); ?>
            </div>
          </div>
          <div class="form-group">
            <label class="col-md-3 col-xs-12 control-label"><span class="required">*</span>City</label>
            <div class="col-md-6">
              <input type="text" class="form-control" name="city" id="city" value="<?php echo set_value('city', $res->city); ?>"> 
              <?php echo form_error('city'); ?>
            </div>
          </div>
          <div class="form-group">
            <label class="col-md-3 col-xs-12 control-label">Location Image</label>
            <div class="col-md-3 col-xs-12">
              <a class="file-input-wrapper btn btn-default  fileinput btn-primary"><span>Browse file</span><input type="file" class="fileinput btn-primary" name="image1" id="image1" title="Browse file"></a>
            </div>
            <div class="col-md-3 col-xs-12">
              <?php $product_path = "location/" . $res->image_name; ?>                                
              <a href="#" data-toggle="modal" data-target=".image_pop">
                <img src="<?php echo base_url() . 'uploaded-files/' . $product_path; ?>" width="150" class="img-responsive img-rounded center-block" alt="">
              </a>
            </div>
          </div>
          <div class="form-group">
            <div class="col-md-9">
              <input type="submit" class="btn bg-red pull-right" name="update" value="Update">                                 </div>
          </div>
          <?php echo form_close(); ?>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $this->load->view('includes/footer'); ?>
<script>
  $(document).ready(function () {
    $("#country").change(function () {
      var country = $("#country").val();
      if(country){
        $("#state").html('<option value="">--Select State--</option>');
      $.ajax({
        url: '<?php echo base_url('sitepanel/location/ajax_state'); ?>',
        type: 'post',
        data: ({'country_id': country}),
        success: function (data) {
          $("#state").html(data);
        }
      });
    }else{
      $("#state").html('<option value="">--Select State--</option>');
    }
    });
  });
</script>

