<?php $this->load->view("includes/header"); ?>
<div class="page-title">
  <h2><span><?php echo $heading_title; ?></span></h2>
  <a href="<?php echo base_url();?>sitepanel/location/city" class="btn btn-primary pull-right">Manage Districts</a>
  <a href="javascript:void(0);" onclick="history.back();" class="btn btn-primary pull-right">Cancel</a>
</div>
<div class="page-content-wrap"> 
  <div class="fix"></div>
  <div class="row">
    <div class="col-md-12">
      <div class="panel panel-default">
        <div class="panel-body">
          <?php echo form_open_multipart("", 'class="form-horizontal"'); ?>
          <div class="form-group">
            <label class="col-md-3 col-xs-12 control-label"><span class="required">*</span>Country</label>
            <div class="col-md-6">
              <?php $country_id=set_value("country_id"); ?>                                                                                                                                                        
              <select name="country_id" class="form-control" id="country">
                <option value="">--Select Country--</option>
                <?php
                if ($country) {
                  foreach ($country as $cnt) {
                    if ($cnt['id'] == $country_id) {
                      $sel = "selected";
                    } else {
                      $sel = "";
                    }
                    ?>
                    <option value="<?php echo $cnt['id']; ?>" <?php echo $sel;?>><?php echo $cnt['name']; ?></option>
                    <?php
                  }
                }
                ?>
              </select>   
              <?php echo form_error('country_id'); ?>
            </div>
          </div>
          <div class="form-group">
            <label class="col-md-3 col-xs-12 control-label"><span class="required">*</span>State</label>
            <div class="col-md-6">
              <select name="state_id" class="form-control" id="state">
                <option value="">--Select State--</option>
              </select>
              <?php echo form_error('state_id'); ?>
            </div>
          </div>
          <div class="form-group">
            <label class="col-md-3 col-xs-12 control-label"><span class="required">*</span>City</label>
            <div class="col-md-6">                                     
              <input type="text" class="form-control" name="city" id="city" value="<?php echo set_value("city");?>"> 
              <?php echo form_error('city'); ?>
            </div>
          </div>
          <div class="form-group">
            <label class="col-md-3 col-xs-12 control-label"><span class="required">*</span>Banner Image</label>
            <div class="col-md-6 col-xs-12">
              <a class="file-input-wrapper btn btn-default  fileinput btn-primary"><span>Browse file</span><input type="file" class="fileinput btn-primary" name="image1" id="image1" title="Browse file" accept="image/*"></a>
            </div>
          </div>
          <div class="form-group">
            <div class="col-md-9">
              <input type="submit" class="btn bg-red pull-right" name="submit" value="Submit">
            </div>
          </div>
          <?php echo form_close(); ?>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $this->load->view("includes/footer"); ?>
<script>
  $(document).ready(function () {
    $("#country").change(function () {
        states();
    });
  });

  <?php if($this->input->post('state_id')){ ?>
    states('<?php echo $this->input->post('state_id');?>');
  <?php } ?>

  function states(sel){ 
    var country = $("#country").val();
    if(country){
      $("#state").html('<option value="">--Select State--</option>');
      $.ajax({
        url: '<?php echo base_url('sitepanel/location/ajax_state'); ?>',
        type: 'post',
        data: ({'country_id': country,'sel': sel}),
        success: function (data) {
          $("#state").html(data);
        }
      });
    }else{
      $("#state").html('<option value="">--Select State--</option>');
    }
  }


</script>