<?php

class Services extends Admin_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('products/product_model', 'size/size_model', 'color/color_model'));
    $this->load->helper('category/category');
    $this->config->set_item('menu_highlight', 'product management');
  }

  public function index($page = NULL) {
    $cust_id =  $this->input->get('cust_id');

    $this->load->helper(array('products/product'));
    $condtion = array();
    if($cust_id!='' && $cust_id>0){
       $condtion['where'] = 'wlp.customers_id = '.$cust_id.' and wlp.productType = "1"';
    }else{
      $condtion['where'] = 'wlp.productType = "1"';
    }
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $category_id = (int) $this->uri->segment(4, 0);
    $status = $this->input->get_post('status', TRUE);
    $cat_name = '';
    if ($category_id > 0) {
      $condtion['category_id'] = $category_id;
      $cat_name = 'in ';
      $cat_name .= get_db_field_value('wps_categories', 'category_name', "WHERE category_id='$category_id'");
    }
    if ($status != '') {
      $condtion['status'] = $status;
    }
    $res_array = $this->product_model->get_products($config['limit'], $offset, $condtion);
// echo_sql();
    $config['total_rows'] = get_found_rows();
    $data['heading_title'] = 'Services Lists';
    $data['res'] = $res_array;
    $data['page_links'] = admin_pagination($base_url, $config['total_rows'], $config['limit'], $offset);

    if ($this->input->post('status_action') != '') {
      if ($this->input->post('status_action') == 'Delete') {
        $prod_id = $this->input->post('arr_ids');
        foreach ($prod_id as $v) {
          $where = array('entity_type' => 'products/details', 'entity_id' => $v);
          $this->product_model->safe_delete('wps_meta_tags', $where, TRUE);
        }
      }
      $this->session->set_flashdata('success', lang('deleted'));
      $this->update_status('wps_products', 'products_id');
    }
    /* Product set as a */
    if ($this->input->post('set_as') != '') {
      $set_as = $this->input->post('set_as', TRUE);
      $this->set_as('wps_products', 'products_id', array($set_as => '1'));
    }
    if ($this->input->post('unset_as') != '') {
      $unset_as = $this->input->post('unset_as', TRUE);
      $this->set_as('wps_products', 'products_id', array($unset_as => '0'));
    }
    /* End product set as a */

    /* upload Bulk Excel */
    if ($this->input->post('action') == 'submit_excel') {
      $this->form_validation->set_rules('excel_file', 'Upload Excel File', 'required|callback_check_upload_excel');
      if ($this->form_validation->run() == TRUE) {
        require_once FCPATH . 'apps/third_party/Excel/reader.php';
        $data = new Spreadsheet_Excel_Reader();
        $data->setOutputEncoding('CP1251');

        //$data->setUTFEncoder('');
        chmod($_FILES["excel_file"]["tmp_name"], 0777);
        $data->read($_FILES["excel_file"]["tmp_name"]);
        $worksheet = $data->sheets[0]['cells'];

        $process_add = $this->product_model->add_bulk_upload_product_services($worksheet);
        //echo "sss";
        if ($process_add === TRUE) {
          $this->session->set_userdata(array('msg_type' => 'success'));
          $this->session->set_flashdata('success', 'Excel file inserted successfully!!!');
          redirect('sitepanel/services', '');
        } else {
          $this->form_validation->_error_array['image'] = 'Uploading Failed. Please Try Again';
        }
      }
    }

    $data['category_result_found'] = "Total " . $config['total_rows'] . " result(s) found " . strtolower($cat_name) . " ";
    
    //Call of View
    $this->load->view('catalog/view_service_list', $data);
  }

  public function add() {
    $cust_id = (int) $this->uri->segment(5);
    if($cust_id!='' && $cust_id>0){
       $cust_id = $cust_id;
    }else{
      $cust_id = 0;
    }
    $data['heading_title'] = 'Add Service';
    $categoryposted = $this->input->post('catid');
    $data['categoryposted'] = $categoryposted;
    $categoryposted = $this->input->post('catid');
    $data['ckeditor'] = set_ck_config(array('textarea_id' => 'description', 'type' => 'basic'));
    $data['unit_measurement'] = $this->config->item('unit_measurement');

    $img_allow_size = $this->config->item('allow.file.size');
    $img_allow_dim = $this->config->item('allow.imgage.dimension');

    $seo_url_length = $this->config->item('seo_url_length');
    $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");

    $this->form_validation->set_rules('product_name', 'Service Name', 'required');
    $this->form_validation->set_rules('img1', 'Service Main Image', 'file_allowed_type[image]');
    $this->form_validation->set_rules('img2', 'Service Additional Image', 'file_allowed_type[image]');
    $this->form_validation->set_rules('img3', 'Service Additional Image', 'file_allowed_type[image]');
    $this->form_validation->set_rules('img4', 'Service Additional Image', 'file_allowed_type[image]');
    $this->form_validation->set_rules('youtube_id', 'Youtube Link', 'trim|max_length[220]');
    $this->form_validation->set_rules('product_price', 'Price', 'trim|valid_amount');
    $this->form_validation->set_rules('unit_value', 'Unit Value', 'trim');
    $this->form_validation->set_rules('unit_measurement', 'Unit Measurement', 'trim');
    $this->form_validation->set_rules('description', 'Service Description', 'trim');
    $this->form_validation->set_rules('category_id[]', 'Service Category', 'trim');
    $this->form_validation->set_rules('attribute_name[]', 'Attribute Name', 'trim');
    $this->form_validation->set_rules('attribute_value[]', 'Attribute Value', 'trim');
    $this->form_validation->set_rules('moq', 'Minimum Order Quantity', 'trim');
    $this->form_validation->set_rules('product_code', 'Service Code', 'trim|');
    $this->form_validation->set_rules('dispatch_port', 'Dispatch Port', 'trim|');
    $this->form_validation->set_rules('delivery_time', 'Delivery Time', 'trim|');
    $this->form_validation->set_rules('packaging_details', 'Packaging Details', 'trim|max_length[220]');

    if ($this->form_validation->run() === TRUE) {
      $pic1 = '';
      if (!empty($_FILES) && $_FILES['img1']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('img1', 'product_images');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $pic1 = $uploaded_data['upload_data']['file_name'];
          compressImage(FCROOT . 'uploaded_files/product_images/' . $pic1, FCROOT . 'uploaded_files/product_images/' . $pic1, 50);
        }
      }

      $pic2 = '';
      if (!empty($_FILES) && $_FILES['img2']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('img2', 'product_images');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $pic2 = $uploaded_data['upload_data']['file_name'];
          compressImage(FCROOT . 'uploaded_files/product_images/' . $pic2, FCROOT . 'uploaded_files/product_images/' . $pic2, 50);
        }
      }

      $pic3 = '';
      if (!empty($_FILES) && $_FILES['img3']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('img3', 'product_images');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $pic3 = $uploaded_data['upload_data']['file_name'];
          compressImage(FCROOT . 'uploaded_files/product_images/' . $pic3, FCROOT . 'uploaded_files/product_images/' . $pic3, 50);
        }
      }

      $pic4 = '';
      if (!empty($_FILES) && $_FILES['img4']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('img4', 'product_images');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $pic4 = $uploaded_data['upload_data']['file_name'];
          compressImage(FCROOT . 'uploaded_files/product_images/' . $pic4, FCROOT . 'uploaded_files/product_images/' . $pic4, 50);
        }
      }

      //cat links
      $postCategory = $this->input->post('category_id');
      $category_links = "";
      $catlink = $ctl = "";
      foreach ($postCategory as $ctv) {
        $catlink = get_parent_categories($ctv, "AND status='1'", "category_id,parent_id");
        $ctl = array_keys($catlink);
        $category_links .= implode(",", $ctl) . ',';
      }
      $category_links = substr($category_links, 0, -1);

      $posted_data = array(
          'customers_id' => $cust_id,
          'category_id' => implode(',', $this->input->post('category_id')),
          'category_links' => $category_links,
          'product_name' => $this->input->post('product_name', TRUE),
          'product_code' => $this->input->post('product_code', TRUE),
          'moq' => $this->input->post('moq', TRUE),
          'product_price' => $this->input->post('product_price', TRUE),
          'unit_value' => $this->input->post('unit_value'),
          'unit_measurement' => $this->input->post('unit_measurement'),
          'product_alt' => $this->input->post('product_name'),
          'attribute_name' => implode(',', $this->input->post('attribute_name')),
          'attribute_value' => implode(',', $this->input->post('attribute_value')),
          'dispatch_port' => $this->input->post('dispatch_port'),
          'delivery_time' => $this->input->post('delivery_time'),
          'packaging_details' => $this->input->post('packaging_details'),
          'dashkeyword' => $this->input->post('dashkeyword'),
          'products_description' => $this->input->post('description'),
          'youtube_id' => $this->input->post('youtube_id'),
          'productType' => '1',
          'product_added_date' => $this->config->item('config.date.time')
      );
      //trace($posted_data); exit;
      $productId = $this->product_model->safe_insert('wps_products', $posted_data, FALSE);
      if ($productId > 0) {
        $this->cbk_friendly_url = seo_url_title($this->input->post('product_name') . ' ' . $productId);

        //update friendly_url
        $this->db->query("UPDATE wps_products SET friendly_url = '" . $this->cbk_friendly_url . "' WHERE products_id = '" . $productId . "'");

        //add images to table
        $is_default = 'Y';
        if ($pic1) {
          $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic1 . "', products_id = '" . $productId . "', media_date_added = '" . $this->config->item('config.date.time') . "', is_default = '" . $is_default . "'");
          $is_default = 'N';
        }
        if ($pic2) {
          $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic2 . "', products_id = '" . $productId . "', media_date_added = '" . $this->config->item('config.date.time') . "', is_default = '" . $is_default . "'");
          $is_default = 'N';
        }
        if ($pic3) {
          $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic3 . "', products_id = '" . $productId . "', media_date_added = '" . $this->config->item('config.date.time') . "', is_default = '" . $is_default . "'");
          $is_default = 'N';
        }
        if ($pic4) {
          $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic4 . "', products_id = '" . $productId . "', media_date_added = '" . $this->config->item('config.date.time') . "', is_default = '" . $is_default . "'");
          $is_default = 'N';
        }
        //End
        //Create Meta
        $redirect_url = "products/detail";
        $meta_array = array(
            'entity_type' => $redirect_url,
            'entity_id' => $productId,
            'page_url' => $this->cbk_friendly_url,
            'meta_title' => get_text($this->input->post('product_name'), 80),
            'meta_description' => get_text($this->input->post('description')),
            'meta_keyword' => get_keywords($this->input->post('description'))
        );
        create_meta($meta_array);
      }
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', lang('success'));
      if($cust_id!='' && $cust_id>0){
        redirect('sitepanel/services/?cust_id='.$cust_id, '');
      }else{
        redirect('sitepanel/services/index/' . $this->input->post('category_id'), '');
      }
    }
    /* Global Attributes */
    $data['brands'] = $this->db->query("SELECT * FROM wps_brands WHERE status = '1' order by brand_id")->result_array();
    /* Global Attributes Ends */
    $this->load->view('catalog/view_service_add', $data);
  }

  public function edit($productId) {
    if(isset($_GET['cust_id'])){
      $cust_id = $_GET['cust_id'];
      if($cust_id!='' && $cust_id>0){
         $cust_id = $cust_id;
      }
    }else{
      $cust_id = 0;
    }
    $data['heading_title'] = 'Edit Service';
    $productId = (int) $this->uri->segment(4);
    $option = array('productid' => $productId);
    $res = $this->product_model->get_products(1, 0, $option);
    $data['ckeditor'] = set_ck_config(array('textarea_id' => 'description', 'type' => 'basic'));
    $data['unit_measurement'] = $this->config->item('unit_measurement');
    //image validation
    $img_allow_size = $this->config->item('allow.file.size');
    $img_allow_dim = $this->config->item('allow.imgage.dimension');
    $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");
    $media = array();

    if (is_array($res) && !empty($res)) {
      $res = $res[0];
      $media = $this->product_model->get_product_media(4, 0, array('productid' => $res['products_id']));

      $this->form_validation->set_rules('product_name', 'Service Name', 'required');

      $this->form_validation->set_rules('img1', 'Service Main Image', 'file_allowed_type[image]');
      $this->form_validation->set_rules('img2', 'Service Additional Image', 'file_allowed_type[image]');
      $this->form_validation->set_rules('img3', 'Service Additional Image', 'file_allowed_type[image]');
      $this->form_validation->set_rules('img4', 'Service Additional Image', 'file_allowed_type[image]');
      $this->form_validation->set_rules('youtube_id', 'Youtube Link', 'trim|max_length[220]');
      $this->form_validation->set_rules('product_price', 'Price', 'trim|valid_amount');
      $this->form_validation->set_rules('unit_value', 'Unit Value', 'trim');
      $this->form_validation->set_rules('unit_measurement', 'Unit Measurement', 'trim');

      $this->form_validation->set_rules('description', 'Service Description', 'trim');
      //$this->form_validation->set_rules('dashkeyword', 'Category ID', 'trim|required');
      $this->form_validation->set_rules('category_id[]', 'Service Category', 'trim');
      $this->form_validation->set_rules('attribute_name[]', 'Attribute Name', 'trim');
      $this->form_validation->set_rules('attribute_value[]', 'Attribute Value', 'trim');
      $this->form_validation->set_rules('moq', 'Minimum Order Quantity', 'trim');

      $this->form_validation->set_rules('product_code', 'Service Code', 'trim');
      $this->form_validation->set_rules('dispatch_port', 'Dispatch Port', 'trim');
      $this->form_validation->set_rules('delivery_time', 'Delivery Time', 'trim');
      $this->form_validation->set_rules('packaging_details', 'Packaging Details', 'trim|max_length[220]');

      if ($this->form_validation->run() == TRUE) {

        $media1 = (isset($media[0]['media'])) ? $media[0]['id'] : '';
        $media2 = (isset($media[1]['media'])) ? $media[1]['id'] : '';
        $media3 = (isset($media[2]['media'])) ? $media[2]['id'] : '';
        $media4 = (isset($media[3]['media'])) ? $media[3]['id'] : '';

        $mediaFile1 = (isset($media[0]['media'])) ? $media[0]['media'] : '';
        $mediaFile2 = (isset($media[1]['media'])) ? $media[1]['media'] : '';
        $mediaFile3 = (isset($media[2]['media'])) ? $media[2]['media'] : '';
        $mediaFile4 = (isset($media[3]['media'])) ? $media[3]['media'] : '';

        $pic1 = $mediaFile1;
        $unlink_image1 = array('source_dir' => "product_images", 'source_file' => $mediaFile1);
        if (!empty($_FILES) && $_FILES['img1']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('img1', 'product_images');
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $pic1 = $uploaded_data['upload_data']['file_name'];
            compressImage(FCROOT . 'uploaded_files/product_images/' . $pic1, FCROOT . 'uploaded_files/product_images/' . $pic1, 50);
            removeImage($unlink_image1);
            if ($mediaFile1) {
              $this->db->query("UPDATE wps_products_media SET media = '" . $pic1 . "' WHERE products_id = '" . $productId . "' AND id = '" . $media1 . "'");
            } else {
              $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic1 . "', products_id = '" . $productId . "'");
            }
          }
        }

        $pic2 = $mediaFile2;
        $unlink_image2 = array('source_dir' => "product_images", 'source_file' => $mediaFile2);
        if (!empty($_FILES) && $_FILES['img2']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('img2', 'product_images');
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $pic2 = $uploaded_data['upload_data']['file_name'];
            compressImage(FCROOT . 'uploaded_files/product_images/' . $pic2, FCROOT . 'uploaded_files/product_images/' . $pic2, 50);
            removeImage($unlink_image2);
            if ($mediaFile2) {
              $this->db->query("UPDATE wps_products_media SET media = '" . $pic2 . "' WHERE products_id = '" . $productId . "' AND id = '" . $media2 . "'");
            } else {
              $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic2 . "', products_id = '" . $productId . "'");
            }
          }
        }

        $pic3 = $mediaFile3;
        $unlink_image3 = array('source_dir' => "product_images", 'source_file' => $mediaFile3);
        if (!empty($_FILES) && $_FILES['img3']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('img3', 'product_images');
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $pic3 = $uploaded_data['upload_data']['file_name'];
            compressImage(FCROOT . 'uploaded_files/product_images/' . $pic3, FCROOT . 'uploaded_files/product_images/' . $pic3, 50);
            removeImage($unlink_image3);
            if ($mediaFile3) {
              $this->db->query("UPDATE wps_products_media SET media = '" . $pic3 . "' WHERE products_id = '" . $productId . "' AND id = '" . $media3 . "'");
            } else {
              $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic3 . "', products_id = '" . $productId . "'");
            }
          }
        }

        $pic4 = $mediaFile4;
        $unlink_image4 = array('source_dir' => "product_images", 'source_file' => $mediaFile4);
        if (!empty($_FILES) && $_FILES['img4']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('img4', 'product_images');
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $pic4 = $uploaded_data['upload_data']['file_name'];
            compressImage(FCROOT . 'uploaded_files/product_images/' . $pic4, FCROOT . 'uploaded_files/product_images/' . $pic4, 50);
            removeImage($unlink_image4);
            if ($mediaFile4) {
              $this->db->query("UPDATE wps_products_media SET media = '" . $pic4 . "' WHERE products_id = '" . $productId . "' AND id = '" . $media4 . "'");
            } else {
              $this->db->query("INSERT INTO wps_products_media SET media = '" . $pic4 . "', products_id = '" . $productId . "'");
            }
          }
        }

        //cat links
        $postCategory = $this->input->post('category_id');
        $category_links = "";
        $catlink = $ctl = "";
        foreach ($postCategory as $ctv) {
          $catlink = get_parent_categories($ctv, "AND status='1'", "category_id,parent_id");
          $ctl = array_keys($catlink);
          $category_links .= implode(",", $ctl) . ',';
        }
        $category_links = substr($category_links, 0, -1);

        $posted_data = array(
            'category_id' => implode(',', $this->input->post('category_id')),
            'category_links' => $category_links,
            'product_name' => $this->input->post('product_name', TRUE),
            'product_code' => $this->input->post('product_code', TRUE),
            'moq' => $this->input->post('moq', TRUE),
            'product_price' => $this->input->post('product_price', TRUE),
            'unit_value' => $this->input->post('unit_value'),
            'unit_measurement' => $this->input->post('unit_measurement'),
            'product_alt' => $this->input->post('product_name'),
            'attribute_name' => implode(',', $this->input->post('attribute_name')),
            'attribute_value' => implode(',', $this->input->post('attribute_value')),
            'dispatch_port' => $this->input->post('dispatch_port'),
            'delivery_time' => $this->input->post('delivery_time'),
            'packaging_details' => $this->input->post('packaging_details'),
            'dashkeyword' => $this->input->post('dashkeyword'),
            'products_description' => $this->input->post('description'),
            'youtube_id' => $this->input->post('youtube_id'),
            'productType' => '1',
            'product_updated_date' => $this->config->item('config.date.time')
        );
        //trace($posted_data); exit;
        $where = "products_id = '" . $res['products_id'] . "'";
        $this->product_model->safe_update('wps_products', $posted_data, $where, FALSE);

        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', lang('successupdate'));
        if($cust_id>0 && $cust_id!='') {
          redirect('sitepanel/services?cust_id='.$cust_id, '');
        }elseif ($this->input->post('category_id') > 0) {
          redirect('sitepanel/services/index/' . $this->input->post('category_id'), '');
        }else{
          redirect('sitepanel/services/' . query_string(), '');
        }
      }

      /* Global Attributes */
      $data['media_res'] = $media;
      /* Global Attributes Ends */

      $data['res'] = $res;
      $media_option = array('productid' => $res['products_id']);
      $res_photo_media = $this->product_model->get_product_media(5, 0, $media_option);
      $data['res_photo_media'] = $res_photo_media;
      $this->load->view('catalog/view_service_edit', $data);
    } else {
      redirect('sitepanel/services', '');
    }
  }

  public function details() {
    $id = (int) $this->uri->segment(4);
    $condition = array(
        'fields' => "SQL_CALC_FOUND_ROWS wlp.*,wlc.first_name,wlc.company_name,wlcat.category_links",
        'offset' => 0,
        'limit' => 1,
        'where' => "wlp.products_id ='" . $id . "'"
    );
    $res_array = $this->product_model->get_products($condition);
    $data['heading_title'] = 'View Details';
    $data['page_title'] = 'View Details';
    $data['res'] = $res_array;
    $this->load->view('catalog/view_product_details', $data);
  }

  public function check_price() {
    $disc_price = $this->input->post('product_discounted_price');
    $price = $this->input->post('product_price');
    if ($disc_price != '' && $price != '') {
      $disc_price = floatval($disc_price);
      $price = floatval($price);
      if ($disc_price >= $price && $disc_price > 0 && $price > 0) {
        $this->form_validation->set_message('check_price', 'Discount price must be less than actual price.');
        return FALSE;
      } else {
        return TRUE;
      }
    } else {
      return TRUE;
    }
  }

  public function delete_media() {
    $id = (int) $this->input->post('id');

    if ($id > 0) {
      $res = $this->db->select('media,id')->get_where('wps_products_media', array('id' => $id))->row();
      if (is_object($res)) {
        $unlink_image = array('source_dir' => "products", 'source_file' => $res->media);
        removeImage($unlink_image);
        $this->db->query("DELETE FROM wps_products_media WHERE id='" . $res->id . "'");
        echo 'success';
      }
    }
  }

  public function get_html_category_ids() {
    $data['heading_title'] = 'Excel Category List Ids';

    set_time_limit(0);
    $file_path = $this->load->view('catalog/excel_category_ids', $data);
    ob_start();
    include_once($this->load->view('catalog/excel_category_ids', $data));

    $mess = ob_get_contents();
    $filename = "category.htm";
    ob_end_clean();

    header("Pragma: public");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("Cache-Control: public");
    header("Content-Description: File Transfer");

    //Use the switch-generated Content-Type
    header("Content-Type: application/force-download");

    //Force the download
    $header = "Content-Disposition: attachment; filename=" . $filename . ";";
    header($header);
    header("Content-Transfer-Encoding: binary");
    echo $mess;
    exit;
  }

  public function check_upload_excel() {
    $filearrext = array('xls');
    if ($_FILES['excel_file']['name'] == '') {
      $this->form_validation->set_message('check_upload_excel', 'Please upload excel file.');
      return FALSE;
    }
    if ($_FILES['excel_file']['name'] != '') {
      $extension = substr(strrchr($_FILES['excel_file']['name'], '.'), 1);
      if (!in_array($extension, $filearrext)) {
        $this->form_validation->set_message('check_upload_excel', 'Please upload (xls) file only.');
        return FALSE;
      } else {
        return TRUE;
      }
    }
  }

}

// End of controller