<?php

class Packages extends Admin_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('packages/packages_model'));
    //$this->load->helper(array('packages/category', 'feature/feature'));
    $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");
    $this->default_view = 'packages';
    $this->deletePrvg = TRUE;
  }

  public function index() {
    $data['heading_title'] = 'Manage Packages';
    $condtion = array();
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $status = $this->input->get_post('status', TRUE);
    if ($status != '') {
      $condtion['status'] = $status;
    }
    $res_array = $this->packages_model->get_packages($config['limit'], $offset, $condtion);
    //echo_sql();
    $config['total_rows'] = get_found_rows();
    $data['heading_title'] = 'Packages Lists';
    $data['res'] = $res_array;
    $data['page_links'] = admin_pagination($base_url, $config['total_rows'], $config['limit'], $offset);
    //Status Action for Activate, Deactivate and Delete
    if ($this->input->post('status_action') != '') {
      $this->session->set_flashdata('success', lang('deleted'));
      $this->update_status('wps_packages', 'package_id');
    }

    $this->load->view('packages/view_packages_list', $data);
  }

  public function add_packages() {
    $data['heading_title'] = 'Add Package';
    
    $this->form_validation->set_rules('package_name', 'Package Name', "trim|required|max_length[60]");
    $this->form_validation->set_rules('package_actual_price', 'Package Actual Price', "trim|required|valid_amount");
    $this->form_validation->set_rules('package_price', 'Package Price', "trim|required|valid_amount");
    $this->form_validation->set_rules('package_title', 'Package Title', "trim|required|max_length[250]");
    $this->form_validation->set_rules('package_icon', 'package icon', "file_allowed_type[image]");
    $this->form_validation->set_rules('category_number', 'Category Available', "trim|required|valid_amount");
    $this->form_validation->set_rules('payment_link', 'Payment URL', "trim|valid_url");
    

    if ($this->form_validation->run() === TRUE) {
      
      $uploaded_file = "";
      if (!empty($_FILES) && $_FILES['package_icon']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('package_icon', 'category');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
        }
      }
      
      //Prepare postdata
      $posted_data = array(
          'package_name' => $this->input->post('package_name'),
          'package_actual_price' => $this->input->post('package_actual_price'),
          'price' => $this->input->post('package_price'),
          'package_title' => $this->input->post('package_title'),
          'category_number' => $this->input->post('category_number'),
          'package_icon' => $uploaded_file,
          'payment_link' => $this->input->post('payment_link'),
          'added_date' => $this->config->item('config.date.time'),
      );
      //trace($posted_data); exit;
      $productId = $this->packages_model->safe_insert('wps_packages', $posted_data, FALSE);
      
      //Features
      $featuresPosted = $this->input->get_post('feature');
      foreach($featuresPosted as $feature){
        $this->db->query("INSERT INTO wps_package_features SET package_id = '".$productId."', feature = '".$feature."'");
      }
      
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', lang('success'));
      redirect('sitepanel/packages/', '');
    }
    $this->load->view('packages/view_packages_add', $data);
  }

  public function edit_packages() {
    $data['heading_title'] = 'Edit Package';
    //Get Video Data
    $packages_id = $this->uri->segment(4, 0);
    $res = $this->packages_model->get_package_by_id($packages_id);
    $features = $this->db->query("SELECT feature FROM wps_package_features WHERE package_id = '".$packages_id."'")->result_array();

    $this->form_validation->set_rules('package_name', 'Package Name', "trim|required|max_length[60]");
    $this->form_validation->set_rules('package_actual_price', 'Package Actual Price', "trim|required|valid_amount");
    $this->form_validation->set_rules('package_price', 'Package Price', "trim|required|valid_amount");
    $this->form_validation->set_rules('package_title', 'Package Title', "trim|required|max_length[250]");
    $this->form_validation->set_rules('package_icon', 'package icon', "file_allowed_type[image]");
    $this->form_validation->set_rules('category_number', 'Category Available', "trim|required|valid_amount");
    $this->form_validation->set_rules('payment_link', 'Payment URL', "trim|valid_url");

    if ($this->form_validation->run() === TRUE) {
      
      $uploaded_file = $res['package_icon'];
      $unlink_image = array('source_dir' => "category", 'source_file' => $res['package_icon']);
      if (!empty($_FILES) && $_FILES['package_icon']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('package_icon', 'category');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
          removeImage($unlink_image);
        }
      }
      
      //Prepare postdata
      $posted_data = array(
          'package_name' => $this->input->post('package_name'),
          'package_actual_price' => $this->input->post('package_actual_price'),
          'price' => $this->input->post('package_price'),
          'package_title' => $this->input->post('package_title'),
          'category_number' => $this->input->post('category_number'),
          'package_icon' => $uploaded_file,
          'payment_link' => $this->input->post('payment_link'),
          'updated_date' => $this->config->item('config.date.time'),
      );
      
      
      $this->db->query("DELETE FROM wps_package_features WHERE package_id = '".$packages_id."'");
      $featuresPosted = $this->input->get_post('feature');
      foreach($featuresPosted as $feature){
        $this->db->query("INSERT INTO wps_package_features SET package_id = '".$packages_id."', feature = '".$feature."'");
      }
      
      $where = "package_id = $packages_id";
      $productId = $this->packages_model->safe_update('wps_packages', $posted_data, $where, FALSE);
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', lang('success'));
      redirect('sitepanel/packages/' . $res['category_id'], '');
    }
    $data['res'] = $res;
    $data['features'] = $features;
    $this->load->view('packages/view_packages_edit', $data);
  }

}

// End of controller