<?php

class Location extends Admin_Controller {

  public function __construct() {
    parent::__construct();



    $this->load->model(array('location_model'));
    //$this->load->helper(array('download'));
    $this->config->set_item('menu_highlight', 'location management');
    $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");
  }

  //Country 
  public function index() {

    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $keyword = trim($this->input->get_post('keyword', TRUE));
    $keyword = $this->db->escape_str($keyword);
    $condtion = " ";
    if ($keyword != '') {
      $condtion = "AND name like '%" . $keyword . "%'";
    }
    $condtion_array = array(
    );
    $res_array = $this->location_model->get_record();
    $config['total_rows'] = $this->location_model->total_rec_found;
    //$data['page_links'] = admin_pagination($base_url, $config['total_rows'], $config['limit'], $offset);
    $data['heading_title'] = "Manage Countries";
    $data['res'] = $res_array;


    if ($this->input->post('status_action') != '') {
      if($this->input->post('status_action')=='Delete'){
        $arr_ids = $this->input->post('arr_ids');
          if(is_array($arr_ids) && !empty($arr_ids)){
            foreach ($arr_ids as $k => $v) {
              $data = array(
                'status' => '2'
              );
              $where = "id ='".$v."'";
              $this->location_model->safe_update('wps_countries_list', $data, $where, FALSE);
            }

            $this->session->set_userdata(array(
              'msg_type' => 'success'
            ));
            $this->session->set_flashdata('success', lang('deleted'));
            redirect(base_url('sitepanel/location'));
        }
      }else{
        $this->update_status('wps_countries_list', 'id');
      }

    }

    $this->load->view('location/list_view', $data);
  }

  public function add_country() {
    $data['heading_title'] = "Add Country";
    if ($this->input->post('submit')) {
      $this->form_validation->set_rules('country', "Country Name", "trim|required|unique[wps_countries_list.name ='".$this->input->post('country')."' AND status!='2']");
      if ($this->form_validation->run() == TRUE) {
        $url_title = str_replace("-", "", url_title($this->input->post('country')));
        $posted_data = array(
            'name' => $this->input->post('country'),
            'country_temp_name' => $url_title,
        );
        $this->location_model->safe_insert('wps_countries_list', $posted_data, FALSE);
        $this->session->set_flashdata('success', lang('success'));
        redirect("sitepanel/location/");
      }
    }
    $this->load->view("location/add_country", $data);
  }

  public function edit_country() {
    $country_id = $this->uri->segment(4, 0);
    $data['res'] = $this->db->query("SELECT * FROM wps_countries_list WHERE id=$country_id")->row();
    $data['country'] = $this->db->query("SELECT * FROM wps_countries_list ORDER BY name ASC")->result_array();

    $data['heading_title'] = "Edit Country";
    //print_r($data['res']);exit; 
    if ($this->input->post('update')) {
      $this->form_validation->set_rules('country', "Country Name", "trim|required|unique[wps_countries_list.name ='".$this->input->post('country')."' AND status!='2' AND id!='".$country_id."']");
      if ($this->form_validation->run() == TRUE) {
        $url_title = str_replace("-", "", url_title($this->input->post('country')));
        $posted_data = array(
            'name' => $this->input->post('country'),
            'country_temp_name' => $url_title,
        );
        $where = "id=" . $country_id;
        $this->location_model->safe_update('wps_countries_list', $posted_data, $where, FALSE);
        $this->session->set_flashdata('success', lang('successupdate'));
        redirect("sitepanel/location/");
      }
    }
    $this->load->view("location/edit_country", $data);
  }

  //State
  public function state() {
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $keyword = $this->db->escape_str(trim($this->input->get_post('keyword', TRUE)));
    $country_id = $this->db->escape_str(trim($this->input->get_post('country_id', TRUE)));
    $condtion = " ";
    if ($keyword != '') {
      $condtion .= "AND title like '%" . $keyword . "%'";
    }
    if ($country_id > 0) {
      $condtion .= "AND country_id ='" . $country_id . "'";
    }
    $condtion_array = array(
    );
    $res_array = $this->location_model->get_states($condtion_array);
    $config['total_rows'] = $this->location_model->total_rec_found;
    //$data['page_links'] = admin_pagination($base_url, $config['total_rows'], $config['limit'], $offset);
    $data['heading_title'] = "Manage States";
    $data['res'] = $res_array;
    if ($this->input->post('status_action') != '') {
      if($this->input->post('status_action')=='Delete'){
        $arr_ids = $this->input->post('arr_ids');
          if(is_array($arr_ids) && !empty($arr_ids)){
            foreach ($arr_ids as $k => $v) {
              $data = array(
                'status' => '2'
              );
              $where = "id ='".$v."'";
              $this->location_model->safe_update('wps_states_list', $data, $where, FALSE);
            }

            $this->session->set_userdata(array(
              'msg_type' => 'success'
            ));
            $this->session->set_flashdata('success', lang('deleted'));
            redirect(base_url('sitepanel/location/state'));
        }
      }else{
        $this->update_status('wps_states_list', 'id');
      }

    }
    $this->load->view('location/state_list_view', $data);
  }

  public function state_add() {

    $country = $this->db->query("SELECT * FROM wps_countries_list WHERE status='1' ORDER BY name ASC")->result_array();
    $data['country'] = $country;
    $data['heading_title'] = "Add State";

    if ($this->input->post('submit')) {
      $this->form_validation->set_rules('country_id', 'Country', "trim|required");
      //$this->form_validation->set_rules('state', 'State', "trim|required|unique[wps_states_list.name ='".$this->input->post('state')."' AND status!='2' AND country_id='".$this->input->post('country_id')."' ]|callback_check_meta_unique_url");
      $this->form_validation->set_rules('state', 'State', "trim|required|unique[wps_states_list.name ='".$this->input->post('state')."' AND status!='2' AND country_id='".$this->input->post('country_id')."' ]");
      if ($this->form_validation->run() == TRUE) {
        $url_title = seo_url_title($this->input->post('state'));
        $posted_data = array(
            'name' => $this->input->post('state'),
            'temp_title' => $url_title,
            'country_id' => $this->input->post('country_id'),
        );
        $insertId = $this->location_model->safe_insert('wps_states_list', $posted_data, FALSE);
        if ($insertId > 0) {
          $page_url = seo_url_title($this->input->post('state') . '-' . $insertId);
          //update friendly_url
          $this->db->query("UPDATE wps_states_list SET temp_title = '" . $page_url . "' WHERE id = '" . $insertId . "'");
          $posted_data_meta = array(
              'is_fixed' => 'L',
              'entity_type' => 'category',
              'entity_id' => $insertId,
              'page_url' => $page_url,
              'meta_title' => $this->input->post('state'),
              'meta_description' => $this->input->post('state'),
              'meta_keyword' => $this->input->post('state'),);
          $this->location_model->safe_insert('wps_meta_tags', $posted_data_meta, FALSE);
        }

        $this->session->set_flashdata('success', lang('success'));
        redirect(base_url("sitepanel/location/state"));
      }
    }
    $this->load->view('location/state_add', $data);
  }

  public function state_edit() {
    $id = (int) $this->uri->segment(4, 0);
    $row_data = '';
    $data['id'] = $id;
    $country = $this->db->query("SELECT * FROM wps_countries_list WHERE status='1' ORDER BY name ASC")->result_array();
    $data['country'] = $country;
    $row_data = $this->location_model->get_single_row("wps_states_list", $id);
    $data['row_data'] = $row_data;
    $page_url = $row_data->temp_title;

    //print_r($data['row_data']);exit;
    $data['heading_title'] = 'Edit State';
    if ($this->input->post('update')) {
      $this->form_validation->set_rules('country_id', 'Country Name', "trim|required");
      //$this->form_validation->set_rules('state', 'State', "trim|required|unique[wps_states_list.name ='".$this->input->post('state')."' AND status!='2' AND id!='".$id."' AND country_id='".$this->input->post('country_id')."']|callback_check_meta_unique_url");
      $this->form_validation->set_rules('state', 'State', "trim|required|unique[wps_states_list.name ='".$this->input->post('state')."' AND status!='2' AND id!='".$id."' AND country_id='".$this->input->post('country_id')."']");

      if ($this->form_validation->run() == TRUE) {
        $url_title = seo_url_title($this->input->post('state').'-'.$row_data->id);
        $posted_data = array(
            'name' => $this->input->post('state'),
            'temp_title' => $url_title,
            'country_id' => $this->input->post('country_id'),
        );
        $where = "id=" . $row_data->id;
        $this->location_model->safe_update('wps_states_list', $posted_data, $where, FALSE);

        //Update meta table
        $posted_data_meta = array(
            'page_url' => $url_title,
            'meta_title' => $this->input->post('state'),
            'meta_description' => $this->input->post('state'),
            'meta_keyword' => $this->input->post('state'),);
        $where_meta = "entity_type = 'category' AND entity_id = " . $row_data->id . " AND page_url = '" . $page_url . "'";
        $this->location_model->safe_update('wps_meta_tags', $posted_data_meta, $where_meta, FALSE);

        $this->session->set_flashdata('success', lang('successupdate'));
        redirect(base_url('sitepanel/location/state'));
      }
    }
    $this->load->view('location/state_edit_view', $data);
  }

  //City
  public function city() {
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));


    $keyword = $this->db->escape_str(trim($this->input->get_post('keyword', TRUE)));
    $country_id = $this->db->escape_str(trim($this->input->get_post('country_id', TRUE)));
    $state_id = $this->db->escape_str(trim($this->input->get_post('state_id', TRUE)));
    //$district_id = $this->db->escape_str(trim($this->input->get_post('district_id', TRUE)));


    $condtion = " ";
    if ($keyword != '') {
      $condtion .= "AND title like '%" . $keyword . "%'";
    }
    if ($state_id > 0) {
      $condtion .= "AND state_id ='" . $state_id . "'";
    }
    if ($country_id > 0) {
      $condtion .= "AND country_id ='" . $country_id . "'";
    }

    $condtion_array = array();
    $res_array = $this->location_model->get_city($condtion_array);
    $config['total_rows'] = $this->location_model->total_rec_found;
    $data['heading_title'] = "Manage Districts";
    $data['res'] = $res_array;

    if ($this->input->post('status_action') != '') {
      if($this->input->post('status_action')=='Delete'){
        $arr_ids = $this->input->post('arr_ids');
          if(is_array($arr_ids) && !empty($arr_ids)){
            foreach ($arr_ids as $k => $v) {
              $data = array(
                'status' => '2'
              );
              $where = "id ='".$v."'";
              $this->location_model->safe_update('wps_cities_list', $data, $where, FALSE);
            }

            $this->session->set_userdata(array(
              'msg_type' => 'success'
            ));
            $this->session->set_flashdata('success', lang('deleted'));
            redirect(base_url('sitepanel/location/city'));
        }
      }else{
        $this->update_status('wps_cities_list', 'id');
      }

    }
    if ($this->input->post('set_as') != '') {
      $set_as = $this->input->post('set_as', TRUE);
      $this->set_as('wps_cities_list', 'id', array($set_as => '1'));
    }
    if ($this->input->post('unset_as') != '') {
      $unset_as = $this->input->post('unset_as', TRUE);
      $this->set_as('wps_cities_list', 'id', array($unset_as => '0'));
    }
    $this->load->view('location/city_list_view', $data);
  }

  public function city_add() {

    $data['heading_title'] = "Add District";
    $data['country'] = $this->db->query("SELECT * FROM wps_countries_list WHERE status='1' ORDER BY name ASC")->result_array();
    if ($this->input->post('submit')) {
      $this->form_validation->set_rules('country_id', "Country Name", 'trim|required');
      $this->form_validation->set_rules('state_id', "State Name", "trim|required");
      $this->form_validation->set_rules('city', "City Name", "trim|required|xss_clean|unique[wps_cities_list.city ='".$this->input->post('city')."' AND status!='2' AND state_id='".$this->input->post('state_id')."' AND country_id='".$this->input->post('country_id')."' ]|callback_check_meta_unique_url");
      $this->form_validation->set_rules('image1', 'City Image', "file_allowed_type[image]");
      if ($this->form_validation->run() == TRUE) {

        $uploaded_file = "";
        if (!empty($_FILES) && $_FILES['image1']['name'] != '') {
          $config['max_size'] = '2048';
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('image1', 'location', $this->input->post('city') . rand());
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $uploaded_file = $uploaded_data['upload_data']['file_name'];
          }
        }

        $url_title = seo_url_title($this->input->post('city'));
        $posted_data = array(
            'city' => $this->input->post('city'),
            'temp_title' => $url_title,
            'country_id' => $this->input->post('country_id'),
            'state_id' => $this->input->post('state_id'),
            'image_name' => $uploaded_file,
        );
        $insertId = $this->location_model->safe_insert('wps_cities_list', $posted_data, FALSE);
        if ($insertId > 0) {
          $posted_data_meta = array(
              'is_fixed' => 'L',
              'entity_type' => 'category',
              'entity_id' => $insertId,
              'page_url' => $url_title,
              'meta_title' => $this->input->post('city'),
              'meta_description' => $this->input->post('city'),
              'meta_keyword' => $this->input->post('city'),);
          $this->location_model->safe_insert('wps_meta_tags', $posted_data_meta, FALSE);
        }
        $this->session->set_flashdata('success', lang('success'));
        redirect(base_url('sitepanel/location/city'));
      }
    }

    $this->load->view("location/city_add", $data);
  }

  public function city_edit() {
    $city_id = $this->uri->segment(4, 0);
    $res = $this->db->query("SELECT * FROM wps_cities_list WHERE id=$city_id")->row();
    $data['res'] = $res;
    $page_url = $res->temp_title;

    //Data
    $data['heading_title'] = "Edit District";
    $data['country'] = $this->db->query("SELECT * FROM wps_countries_list WHERE status='1' ORDER BY name ASC")->result_array();
    if($this->input->post('country_id')){
      $country_id=$this->input->post('country_id');
    }else{
      $country_id=$res->country_id;
    }
    $state = $this->db->query("SELECT * FROM wps_states_list WHERE country_id='".$country_id."' AND status='1' ORDER BY name ASC")->result_array();
    $data['states'] = $state;

    if ($this->input->post('update')) {
      $this->form_validation->set_rules('country_id', "Country Name", "trim|required");
      $this->form_validation->set_rules('state_id', "State Name", "trim|required");
      $this->form_validation->set_rules('city', "City Name", "trim|required|unique[wps_cities_list.city ='".$this->input->post('city')."' AND status!='2' AND id!='".$city_id."' AND state_id='".$this->input->post('state_id')."' AND country_id='".$this->input->post('country_id')."' ]|callback_check_meta_unique_url");
      $this->form_validation->set_rules('image1', 'City Image', "file_allowed_type[image]");
      if ($this->form_validation->run() == TRUE) {

        $uploaded_file = $res->image_name;
        $unlink_image = array('source_dir' => "location", 'source_file' => $res->image_name);
        if (!empty($_FILES) && $_FILES['image1']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('image1', 'location', $this->input->post('city') . rand());
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $uploaded_file = $uploaded_data['upload_data']['file_name'];
            removeImage($unlink_image);
          }
        }

        $url_title = seo_url_title($this->input->post('city'));
        $posted_data = array(
            'city' => $this->input->post('city'),
            'temp_title' => $url_title,
            'state_id' => $this->input->post('state_id'),
            'country_id' => $this->input->post('country_id'),
            'image_name' => $uploaded_file,
        );
        //trace($posted_data); die;
        $where = "id=" . $city_id;
        $this->location_model->safe_update('wps_cities_list', $posted_data, $where, FALSE);

        //Update meta table
        $posted_data_meta = array(
            'page_url' => $url_title,
            'meta_title' => $this->input->post('city'),
            'meta_description' => $this->input->post('city'),
            'meta_keyword' => $this->input->post('city'),
        );
        $where_meta = "entity_type = 'category' AND entity_id = " . $res->id . " AND page_url = '" . $page_url . "'";
        $this->location_model->safe_update('wps_meta_tags', $posted_data_meta, $where_meta, FALSE);
        //End
        $this->session->set_flashdata('success', lang('successupdate'));
        redirect(base_url('sitepanel/location/city'));
      }
    }
    $this->load->view("location/city_edit", $data);
  }

  //ajax state calling

  public function ajax_state() {
    $country_id = $this->input->post('country_id');
    $sel_id = $this->input->post('sel');

    $states = $this->db->query("SELECT * FROM wps_states_list WHERE country_id=$country_id AND status='1'")->result_array();
    echo '<option value="">--Select State--</option>';
    foreach ($states as $state) {
      if ($state['id'] == $sel_id) {
        $sel = 'selected="selected"';
      } else {
        $sel = '';
      }
      echo '<option value="'. $state['id'].'"'.$sel.'>'. $state['name'] . '</option>';
    }
  }

  //Blocks
  public function block() {
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));


    $keyword = $this->db->escape_str(trim($this->input->get_post('keyword', TRUE)));
    $country_id = $this->db->escape_str(trim($this->input->get_post('country_id', TRUE)));
    $state_id = $this->db->escape_str(trim($this->input->get_post('state_id', TRUE)));
    $city_id = $this->db->escape_str(trim($this->input->get_post('city_id', TRUE)));


    $condtion = " ";
    if ($keyword != '') {
      $condtion .= "AND name like '%" . $keyword . "%'";
    }
    if ($city_id > 0) {
      $condtion .= "AND city_id ='" . $city_id . "'";
    }
    if ($state_id > 0) {
      $condtion .= "AND state_id ='" . $state_id . "'";
    }
    if ($country_id > 0) {
      $condtion .= "AND country_id ='" . $country_id . "'";
    }

    $condtion_array = array();
    $res_array = $this->location_model->get_blocks($condtion_array);
    $config['total_rows'] = $this->location_model->total_rec_found;
    $data['heading_title'] = "Manage Blocks";
    $data['res'] = $res_array;

    if ($this->input->post('status_action') != '') {

      if($this->input->post('status_action')=='Delete'){
        $arr_ids = $this->input->post('arr_ids');
          if(is_array($arr_ids) && !empty($arr_ids)){
            foreach ($arr_ids as $k => $v) {
              $data = array(
                'status' => '2'
              );
              $where = "id ='".$v."'";
              $this->location_model->safe_update('wps_blocks_list', $data, $where, FALSE);
            }

            $this->session->set_userdata(array(
              'msg_type' => 'success'
            ));
            $this->session->set_flashdata('success', lang('deleted'));
            redirect(base_url('sitepanel/location/block'));
        }
      }else{
        $this->update_status('wps_blocks_list', 'id');
      }

  
    }
    /*
    if ($this->input->post('set_as') != '') {
      $set_as = $this->input->post('set_as', TRUE);
      $this->set_as('wps_blocks_list', 'id', array($set_as => '1'));
    }
    if ($this->input->post('unset_as') != '') {
      $unset_as = $this->input->post('unset_as', TRUE);
      $this->set_as('wps_blocks_list', 'id', array($unset_as => '0'));
    }
    */
    $this->load->view('location/block_list_view', $data);
  }

  public function block_add() {

    $data['heading_title'] = "Add Block";
    $data['country'] = $this->db->query("SELECT id,name FROM wps_countries_list WHERE status='1' ORDER BY name ASC")->result_array();
    $data['states'] = $this->db->query("SELECT id,name FROM wps_states_list WHERE status='1' ORDER BY name ASC")->result_array();
    $data['cities'] = $this->db->query("SELECT id,city FROM wps_cities_list WHERE status='1' ORDER BY city ASC")->result_array();
    if ($this->input->post('submit')) {
      $this->form_validation->set_rules('country_id', "Country Name", 'trim|required');
      $this->form_validation->set_rules('state_id', "State Name", "trim|required");
      $this->form_validation->set_rules('city_id', "District Name", "trim|required");
      //$this->form_validation->set_rules('name', "Block Name", "trim|required|xss_clean|unique[wps_blocks_list.name ='".$this->input->post('name')."' AND status!='2' AND city_id='".$this->input->post('city_id')."' AND state_id='".$this->input->post('state_id')."' AND country_id='".$this->input->post('country_id')."']|callback_check_meta_unique_url");
      $this->form_validation->set_rules('name', "Block Name", "trim|required|xss_clean|unique[wps_blocks_list.name ='".$this->input->post('name')."' AND status!='2' AND city_id='".$this->input->post('city_id')."' AND state_id='".$this->input->post('state_id')."' AND country_id='".$this->input->post('country_id')."']");
      
     // $this->form_validation->set_rules('image1', 'Block Image', "file_allowed_type[image]");
      if ($this->form_validation->run() == TRUE) {

        $uploaded_file = "";
        /*
        if (!empty($_FILES) && $_FILES['image1']['name'] != '') {
          $config['max_size'] = '2048';
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('image1', 'location/block', $this->input->post('name') . rand());
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $uploaded_file = $uploaded_data['upload_data']['file_name'];
          }
        }*/

        $url_title = seo_url_title($this->input->post('name'));
        $posted_data = array(
            'name' => $this->input->post('name'),
            'temp_title' => $url_title,
            'city_id' => $this->input->post('city_id'),
            'state_id' => $this->input->post('state_id'),
            'country_id' => $this->input->post('country_id'),
            'image_name' => $uploaded_file,
        );
        $insertId = $this->location_model->safe_insert('wps_blocks_list', $posted_data, FALSE);
        
        if ($insertId > 0){

          $page_url = seo_url_title($this->input->post('name') . '-' . $insertId);
          //update friendly_url
          $this->db->query("UPDATE wps_blocks_list SET temp_title = '" . $page_url . "' WHERE id = '" . $insertId . "'");

            $posted_data_meta = array(
            'is_fixed' => 'L',
            'entity_type' => 'category',
            'entity_id' => $insertId,
            'page_url' => $page_url,
            'meta_title' => $this->input->post('name'),
            'meta_description' => $this->input->post('name'),
            'meta_keyword' => $this->input->post('name'),
          );
          $this->location_model->safe_insert('wps_meta_tags', $posted_data_meta, FALSE);
        }
        $this->session->set_flashdata('success', lang('success'));
        redirect(base_url('sitepanel/location/block'));
      }
    }

    $this->load->view("location/block_add", $data);
  }

  public function block_edit() {
    $block_id = $this->uri->segment(4, 0);
    $res = $this->db->query("SELECT * FROM wps_blocks_list WHERE id=$block_id")->row();
    $data['res'] = $res;
    $page_url = $res->temp_title;

    //Data
    $data['heading_title'] = "Edit Block";
    $data['country'] = $this->db->query("SELECT id,name FROM wps_countries_list WHERE status='1' ORDER BY name ASC")->result_array();
    if($this->input->post('country_id')){
      $country_id=$this->input->post('country_id');
    }else{
      $country_id=$res->country_id;
    }
    if($this->input->post('state_id')){
      $state_id=$this->input->post('state_id');
    }else{
      $state_id=$res->state_id;
    }
    
    $state = $this->db->query("SELECT id,name FROM wps_states_list WHERE country_id='".$country_id."' AND status='1' ORDER BY name ASC")->result_array();
    $data['states'] = $state;
    $cities = $this->db->query("SELECT id,city FROM wps_cities_list WHERE country_id='".$country_id."' AND state_id='".$state_id."' AND status='1' ORDER BY city ASC")->result_array();
    $data['cities'] = $cities;


    if ($this->input->post('update')) {
      $this->form_validation->set_rules('country_id', "Country Name", "trim|required");
      $this->form_validation->set_rules('state_id', "State Name", "trim|required");
      $this->form_validation->set_rules('city_id', "District Name", "trim|required");
      $this->form_validation->set_rules('name', "Block Name", "trim|required");
      //$this->form_validation->set_rules('name', "Block Name", "trim|required|unique[wps_blocks_list.name ='".$this->input->post('name')."' AND status!='2' AND id!='".$block_id."' AND city_id='".$this->input->post('city_id')."' AND state_id='".$this->input->post('state_id')."' AND country_id='".$this->input->post('country_id')."' ]|callback_check_meta_unique_url");
      $this->form_validation->set_rules('name', "Block Name", "trim|required|unique[wps_blocks_list.name ='".$this->input->post('name')."' AND status!='2' AND id!='".$block_id."' AND city_id='".$this->input->post('city_id')."' AND state_id='".$this->input->post('state_id')."' AND country_id='".$this->input->post('country_id')."' ]");
      //$this->form_validation->set_rules('image1', 'Block Image', "file_allowed_type[image]");
      if ($this->form_validation->run() == TRUE) {

        $uploaded_file = $res->image_name;
        /*
        $unlink_image = array('source_dir' => "location", 'source_file' => $res->image_name);
        if (!empty($_FILES) && $_FILES['image1']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('image1', 'location/block', $this->input->post('name') . rand());
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $uploaded_file = $uploaded_data['upload_data']['file_name'];
            removeImage($unlink_image);
          }
        }*/


        $url_title = seo_url_title($this->input->post('name'). '-' . $block_id);
        $posted_data = array(
            'name' => $this->input->post('name'),
            'temp_title' => $url_title,
            'city_id' => $this->input->post('city_id'),
            'state_id' => $this->input->post('state_id'),
            'country_id' => $this->input->post('country_id'),
            'image_name' => $uploaded_file,
        );
        //trace($posted_data); die;
        $where = "id=" . $block_id;
        $this->location_model->safe_update('wps_blocks_list', $posted_data, $where, FALSE);

        
        //Update meta table
        $posted_data_meta = array(
            'page_url' => $url_title,
            'meta_title' => $this->input->post('name'),
            'meta_description' => $this->input->post('name'),
            'meta_keyword' => $this->input->post('name'),
        );
        $where_meta = "entity_type = 'category' AND entity_id = " . $res->id . " AND page_url = '" . $page_url . "'";
        $this->location_model->safe_update('wps_meta_tags', $posted_data_meta, $where_meta, FALSE);
        

        //End
        $this->session->set_flashdata('success', lang('successupdate'));
        redirect(base_url('sitepanel/location/block'));
      }
    }
    $this->load->view("location/block_edit", $data);
  }

  //ajax city calling
  public function ajax_city() {
    $country_id = $this->input->post('country_id');
    $state_id = $this->input->post('state_id');
    $sel_id = $this->input->post('sel');
 
    $cities = $this->db->query("SELECT * FROM wps_cities_list WHERE country_id='".$country_id."' AND state_id='".$state_id."' AND status='1'")->result_array();
    echo '<option value="">--Select District--</option>';
    foreach ($cities as $city) {
      if ($city['id'] == $sel_id) {
        $sel = 'selected';
      } else {
        $sel = '';
      }
      echo '<option value="'.$city['id'].'"'.$sel.'>'.$city['city'].'</option>';
    }
  }


  //Panchayats
  public function panchayat() {
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));


    $keyword = $this->db->escape_str(trim($this->input->get_post('keyword', TRUE)));
    $country_id = $this->db->escape_str(trim($this->input->get_post('country_id', TRUE)));
    $state_id = $this->db->escape_str(trim($this->input->get_post('state_id', TRUE)));
    $city_id = $this->db->escape_str(trim($this->input->get_post('city_id', TRUE)));
    $block_id = $this->db->escape_str(trim($this->input->get_post('block_id', TRUE)));

    $condtion = " ";
    if ($keyword != '') {
      $condtion .= "AND name like '%" . $keyword . "%'";
    }
    if ($block_id > 0) {
      $condtion .= "AND block_id ='" . $block_id . "'";
    }
    if ($city_id > 0) {
      $condtion .= "AND city_id ='" . $city_id . "'";
    }
    if ($state_id > 0) {
      $condtion .= "AND state_id ='" . $state_id . "'";
    }
    if ($country_id > 0) {
      $condtion .= "AND country_id ='" . $country_id . "'";
    }

    $condtion_array = array();
    $res_array = $this->location_model->get_panchayats($condtion_array);
    $config['total_rows'] = $this->location_model->total_rec_found;
    $data['heading_title'] = "Manage Panchayats";
    $data['res'] = $res_array;

    if ($this->input->post('status_action') != '') {
      if($this->input->post('status_action')=='Delete'){
        $arr_ids = $this->input->post('arr_ids');
          if(is_array($arr_ids) && !empty($arr_ids)){
            foreach ($arr_ids as $k => $v) {
              $data = array(
                'status' => '2'
              );
              $where = "id ='".$v."'";
              $this->location_model->safe_update('wps_panchayats_list', $data, $where, FALSE);
            }

            $this->session->set_userdata(array(
              'msg_type' => 'success'
            ));
            $this->session->set_flashdata('success', lang('deleted'));
            redirect(base_url('sitepanel/location/panchayat'));
        }
      }else{
        $this->update_status('wps_panchayats_list', 'id');
      }
    }
    /*
    if ($this->input->post('set_as') != '') {
      $set_as = $this->input->post('set_as', TRUE);
      $this->set_as('wps_panchayats_list', 'id', array($set_as => '1'));
    }
    if ($this->input->post('unset_as') != '') {
      $unset_as = $this->input->post('unset_as', TRUE);
      $this->set_as('wps_panchayats_list', 'id', array($unset_as => '0'));
    }
    */
    $this->load->view('location/panchayat_list_view', $data);
  }

  public function panchayat_add() {

    $data['heading_title'] = "Add Panchayat";
    $data['country'] = $this->db->query("SELECT id,name FROM wps_countries_list WHERE status='1' ORDER BY name ASC")->result_array();
    $data['states'] = $this->db->query("SELECT id,name FROM wps_states_list WHERE status='1' ORDER BY name ASC")->result_array();
    $data['cities'] = $this->db->query("SELECT id,city FROM wps_cities_list WHERE status='1' ORDER BY city ASC")->result_array();
    $data['blocks'] = $this->db->query("SELECT id,name FROM wps_blocks_list WHERE status='1' ORDER BY name ASC")->result_array();

    if ($this->input->post('submit')) {
      $this->form_validation->set_rules('country_id', "Country Name", 'trim|required');
      $this->form_validation->set_rules('state_id', "State Name", "trim|required");
      $this->form_validation->set_rules('city_id', "District Name", "trim|required");
      $this->form_validation->set_rules('block_id', "Block Name", "trim|required");
      //$this->form_validation->set_rules('name', "Panchayat Name", "trim|required|xss_clean|unique[wps_panchayats_list.name ='".$this->input->post('name')."' AND status!='2' AND block_id='".$this->input->post('block_id')."' AND city_id='".$this->input->post('city_id')."' AND state_id='".$this->input->post('state_id')."' AND country_id='".$this->input->post('country_id')."' ]|callback_check_meta_unique_url");
      $this->form_validation->set_rules('name', "Panchayat Name", "trim|required|xss_clean|unique[wps_panchayats_list.name ='".$this->input->post('name')."' AND status!='2' AND block_id='".$this->input->post('block_id')."' AND city_id='".$this->input->post('city_id')."' AND state_id='".$this->input->post('state_id')."' AND country_id='".$this->input->post('country_id')."' ]");
     // $this->form_validation->set_rules('image1', 'Panchayat Image', "file_allowed_type[image]");
      if ($this->form_validation->run() == TRUE) {

        $uploaded_file = "";
        /*
        if (!empty($_FILES) && $_FILES['image1']['name'] != '') {
          $config['max_size'] = '2048';
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('image1', 'location/panchayat', $this->input->post('name') . rand());
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $uploaded_file = $uploaded_data['upload_data']['file_name'];
          }
        }*/

        $url_title = seo_url_title($this->input->post('name'));
        $posted_data = array(
            'name' => $this->input->post('name'),
            'temp_title' => $url_title,
            'block_id' => $this->input->post('block_id'),
            'city_id' => $this->input->post('city_id'),
            'state_id' => $this->input->post('state_id'),
            'country_id' => $this->input->post('country_id'),
            'image_name' => $uploaded_file,
        );
        $insertId = $this->location_model->safe_insert('wps_panchayats_list', $posted_data, FALSE);
        
        if ($insertId > 0) {
          $page_url = seo_url_title($this->input->post('name') . '-' . $insertId);
          //update friendly_url
          $this->db->query("UPDATE wps_panchayats_list SET temp_title = '" . $page_url . "' WHERE id = '" . $insertId . "'");
          
          $posted_data_meta = array(
              'is_fixed' => 'L',
              'entity_type' => 'category',
              'entity_id' => $insertId,
              'page_url' => $page_url,
              'meta_title' => $this->input->post('name'),
              'meta_description' => $this->input->post('name'),
              'meta_keyword' => $this->input->post('name'),);
          $this->location_model->safe_insert('wps_meta_tags', $posted_data_meta, FALSE);
        }
        $this->session->set_flashdata('success', lang('success'));
        redirect(base_url('sitepanel/location/panchayat'));
      }
    }

    $this->load->view("location/panchayat_add", $data);
  }

  public function panchayat_edit() {
    $panchayat_id = $this->uri->segment(4, 0);
    $res = $this->db->query("SELECT * FROM wps_panchayats_list WHERE id=$panchayat_id")->row();
    $data['res'] = $res;
    $page_url = $res->temp_title;

    //Data
    $data['heading_title'] = "Edit Panchayat";
    $data['country'] = $this->db->query("SELECT id,name FROM wps_countries_list WHERE status='1' ORDER BY name ASC")->result_array();

    if($this->input->post('country_id')){
      $country_id=$this->input->post('country_id');
    }else{
      $country_id=$res->country_id;
    }
    if($this->input->post('state_id')){
      $state_id=$this->input->post('state_id');
    }else{
      $state_id=$res->state_id;
    }
    if($this->input->post('city_id')){
      $city_id=$this->input->post('city_id');
    }else{
      $city_id=$res->city_id;
    }

    $state = $this->db->query("SELECT id,name FROM wps_states_list WHERE country_id='".$country_id."' AND status='1' ORDER BY name ASC")->result_array();
    $data['states'] = $state;
    $cities = $this->db->query("SELECT id,city FROM wps_cities_list WHERE country_id='".$country_id."' AND state_id='".$state_id."' AND status='1' ORDER BY city ASC")->result_array();
    $data['cities'] = $cities;
    $blocks = $this->db->query("SELECT id,name FROM wps_blocks_list WHERE country_id='".$country_id."' AND state_id='".$state_id."' AND city_id='".$city_id."' AND status='1' ORDER BY name ASC")->result_array();
    $data['blocks'] = $blocks;

    if ($this->input->post('update')) {
      $this->form_validation->set_rules('country_id', "Country Name", "trim|required");
      $this->form_validation->set_rules('state_id', "State Name", "trim|required");
      $this->form_validation->set_rules('city_id', "District Name", "trim|required");
      $this->form_validation->set_rules('block_id', "Block Name", "trim|required");
      //$this->form_validation->set_rules('name', "Panchayat Name", "trim|required|xss_clean|unique[wps_panchayats_list.name ='".$this->input->post('name')."' AND status!='2' AND id!='".$panchayat_id."' AND block_id='".$this->input->post('block_id')."' AND city_id='".$this->input->post('city_id')."' AND state_id='".$this->input->post('state_id')."' AND country_id='".$this->input->post('country_id')."']|callback_check_meta_unique_url");
      $this->form_validation->set_rules('name', "Panchayat Name", "trim|required|xss_clean|unique[wps_panchayats_list.name ='".$this->input->post('name')."' AND status!='2' AND id!='".$panchayat_id."' AND block_id='".$this->input->post('block_id')."' AND city_id='".$this->input->post('city_id')."' AND state_id='".$this->input->post('state_id')."' AND country_id='".$this->input->post('country_id')."']");
      //$this->form_validation->set_rules('image1', 'Panchayat Image', "file_allowed_type[image]");
      if ($this->form_validation->run() == TRUE) {

        $uploaded_file = $res->image_name;
        /*
        $unlink_image = array('source_dir' => "location", 'source_file' => $res->image_name);
        if (!empty($_FILES) && $_FILES['image1']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('image1', 'location/panchayat', $this->input->post('name') . rand());
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $uploaded_file = $uploaded_data['upload_data']['file_name'];
            removeImage($unlink_image);
          }
        }*/

        $url_title = seo_url_title($this->input->post('name'). '-' . $panchayat_id);
        $posted_data = array(
            'name' => $this->input->post('name'),
            'temp_title' => $url_title,
            'block_id' => $this->input->post('block_id'),
            'city_id' => $this->input->post('city_id'),
            'state_id' => $this->input->post('state_id'),
            'country_id' => $this->input->post('country_id'),
            'image_name' => $uploaded_file,
        );
        //trace($posted_data); die;
        $where = "id=" . $panchayat_id;
        $this->location_model->safe_update('wps_panchayats_list', $posted_data, $where, FALSE);

        
        //Update meta table
        $posted_data_meta = array(
            'page_url' => $url_title,
            'meta_title' => $this->input->post('name'),
            'meta_description' => $this->input->post('name'),
            'meta_keyword' => $this->input->post('name'),
        );
        $where_meta = "entity_type = 'category' AND entity_id = " . $res->id . " AND page_url = '" . $page_url . "'";
        $this->location_model->safe_update('wps_meta_tags', $posted_data_meta, $where_meta, FALSE);
        

        //End
        $this->session->set_flashdata('success', lang('successupdate'));
        redirect(base_url('sitepanel/location/panchayat'));
      }
    }
    $this->load->view("location/panchayat_edit", $data);
  }

  //ajax block calling
  public function ajax_block() {
    $country_id = $this->input->post('country_id');
    $state_id = $this->input->post('state_id');
    $city_id = $this->input->post('city_id');
    $sel_id = $this->input->post('sel');

    $blocks = $this->db->query("SELECT * FROM wps_blocks_list WHERE country_id='".$country_id."' AND state_id='".$state_id."' AND city_id='".$city_id."' AND status='1'")->result_array();
    echo '<option value="">--Select Block--</option>';
    foreach ($blocks as $block) {
      if ($block['id'] == $sel_id) {
        $sel = 'selected';
      } else {
        $sel = '';
      }
      echo '<option value="'.$block['id'].'"'.$sel.'>'.$block['name'].'</option>';
    }
  }


  //Villages
  public function village() {
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));


    $keyword = $this->db->escape_str(trim($this->input->get_post('keyword', TRUE)));
    $country_id = $this->db->escape_str(trim($this->input->get_post('country_id', TRUE)));
    $state_id = $this->db->escape_str(trim($this->input->get_post('state_id', TRUE)));
    $city_id = $this->db->escape_str(trim($this->input->get_post('city_id', TRUE)));
    $block_id = $this->db->escape_str(trim($this->input->get_post('block_id', TRUE)));
    $panchayat_id = $this->db->escape_str(trim($this->input->get_post('panchayat_id', TRUE)));

    $condtion = " ";
    if ($keyword != '') {
      $condtion .= "AND name like '%" . $keyword . "%'";
    }
    if ($panchayat_id > 0) {
      $condtion .= "AND panchayat_id ='" . $panchayat_id . "'";
    }
    if ($block_id > 0) {
      $condtion .= "AND block_id ='" . $block_id . "'";
    }
    if ($city_id > 0) {
      $condtion .= "AND city_id ='" . $city_id . "'";
    }
    if ($state_id > 0) {
      $condtion .= "AND state_id ='" . $state_id . "'";
    }
    if ($country_id > 0) {
      $condtion .= "AND country_id ='" . $country_id . "'";
    }

    $condtion_array = array();
    $res_array = $this->location_model->get_villages($condtion_array);
    $config['total_rows'] = $this->location_model->total_rec_found;
    $data['heading_title'] = "Manage Villages";
    $data['res'] = $res_array;

    if ($this->input->post('status_action') != '') {
      if($this->input->post('status_action')=='Delete'){
        $arr_ids = $this->input->post('arr_ids');
          if(is_array($arr_ids) && !empty($arr_ids)){
            foreach ($arr_ids as $k => $v) {
              $data = array(
                'status' => '2'
              );
              $where = "id ='".$v."'";
              $this->location_model->safe_update('wps_villages_list', $data, $where, FALSE);
            }

            $this->session->set_userdata(array(
              'msg_type' => 'success'
            ));
            $this->session->set_flashdata('success', lang('deleted'));
            redirect(base_url('sitepanel/location/village'));
        }
      }else{
        $this->update_status('wps_villages_list', 'id');
      }
    }
    /*
    if ($this->input->post('set_as') != '') {
      $set_as = $this->input->post('set_as', TRUE);
      $this->set_as('wps_villages_list', 'id', array($set_as => '1'));
    }
    if ($this->input->post('unset_as') != '') {
      $unset_as = $this->input->post('unset_as', TRUE);
      $this->set_as('wps_villages_list', 'id', array($unset_as => '0'));
    }
    */
    $this->load->view('location/village_list_view', $data);
  }

  public function village_add() {

    $data['heading_title'] = "Add Village";
    $data['country'] = $this->db->query("SELECT id,name FROM wps_countries_list WHERE status='1' ORDER BY name ASC")->result_array();
    $data['states'] = $this->db->query("SELECT id,name FROM wps_states_list WHERE status='1' ORDER BY name ASC")->result_array();
    $data['cities'] = $this->db->query("SELECT id,city FROM wps_cities_list WHERE status='1' ORDER BY city ASC")->result_array();
    $data['blocks'] = $this->db->query("SELECT id,name FROM wps_blocks_list WHERE status='1' ORDER BY name ASC")->result_array();
    $data['panchayats'] = $this->db->query("SELECT id,name FROM wps_panchayats_list WHERE status='1' ORDER BY name ASC")->result_array();

    if ($this->input->post('submit')) {
      $this->form_validation->set_rules('country_id', "Country Name", 'trim|required');
      $this->form_validation->set_rules('state_id', "State Name", "trim|required");
      $this->form_validation->set_rules('city_id', "District Name", "trim|required");
      $this->form_validation->set_rules('block_id', "Block Name", "trim|required");
      $this->form_validation->set_rules('panchayat_id', "Panchayat Name", "trim|required");
      //$this->form_validation->set_rules('name', "Village Name", "trim|required|xss_clean|unique[wps_villages_list.name ='".$this->input->post('name')."' AND status!='2' AND panchayat_id='".$this->input->post('panchayat_id')."' AND block_id='".$this->input->post('block_id')."' AND city_id='".$this->input->post('city_id')."' AND state_id='".$this->input->post('state_id')."' AND country_id='".$this->input->post('country_id')."']|callback_check_meta_unique_url");
      $this->form_validation->set_rules('name', "Village Name", "trim|required|xss_clean|unique[wps_villages_list.name ='".$this->input->post('name')."' AND status!='2' AND panchayat_id='".$this->input->post('panchayat_id')."' AND block_id='".$this->input->post('block_id')."' AND city_id='".$this->input->post('city_id')."' AND state_id='".$this->input->post('state_id')."' AND country_id='".$this->input->post('country_id')."']");
     // $this->form_validation->set_rules('image1', 'Village Image', "file_allowed_type[image]");
      if ($this->form_validation->run() == TRUE) {

        $uploaded_file = "";
        /*
        if (!empty($_FILES) && $_FILES['image1']['name'] != '') {
          $config['max_size'] = '2048';
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('image1', 'location/village', $this->input->post('name') . rand());
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $uploaded_file = $uploaded_data['upload_data']['file_name'];
          }
        }*/

        $url_title = seo_url_title($this->input->post('name'));
        $posted_data = array(
            'name' => $this->input->post('name'),
            'temp_title' => $url_title,
            'panchayat_id' => $this->input->post('panchayat_id'),
            'block_id' => $this->input->post('block_id'),
            'city_id' => $this->input->post('city_id'),
            'state_id' => $this->input->post('state_id'),
            'country_id' => $this->input->post('country_id'),
            'image_name' => $uploaded_file,
        );
        $insertId = $this->location_model->safe_insert('wps_villages_list', $posted_data, FALSE);
        
        if ($insertId > 0) {
          $page_url = seo_url_title($this->input->post('name') . '-' . $insertId);
          //update friendly_url
          $this->db->query("UPDATE wps_villages_list SET temp_title = '" . $page_url . "' WHERE id = '" . $insertId . "'");
          $posted_data_meta = array(
              'is_fixed' => 'L',
              'entity_type' => 'category',
              'entity_id' => $insertId,
              'page_url' => $page_url,
              'meta_title' => $this->input->post('name'),
              'meta_description' => $this->input->post('name'),
              'meta_keyword' => $this->input->post('name'),);
          $this->location_model->safe_insert('wps_meta_tags', $posted_data_meta, FALSE);
        }
        $this->session->set_flashdata('success', lang('success'));
        redirect(base_url('sitepanel/location/village'));
      }
    }

    $this->load->view("location/village_add", $data);
  }

  public function village_edit() {
    $village_id = $this->uri->segment(4, 0);
    $res = $this->db->query("SELECT * FROM wps_villages_list WHERE id=$village_id")->row();
    $data['res'] = $res;
    $page_url = $res->temp_title;

    //Data
    $data['heading_title'] = "Edit Village";
    $data['country'] = $this->db->query("SELECT id,name FROM wps_countries_list WHERE status='1' ORDER BY name ASC")->result_array();
    if($this->input->post('country_id')){
      $country_id=$this->input->post('country_id');
    }else{
      $country_id=$res->country_id;
    }
    if($this->input->post('state_id')){
      $state_id=$this->input->post('state_id');
    }else{
      $state_id=$res->state_id;
    }
    if($this->input->post('city_id')){
      $city_id=$this->input->post('city_id');
    }else{
      $city_id=$res->city_id;
    }
    if($this->input->post('block_id')){
      $block_id=$this->input->post('block_id');
    }else{
      $block_id=$res->block_id;
    }
    
    $state = $this->db->query("SELECT id,name FROM wps_states_list WHERE country_id='$country_id' AND status='1' ORDER BY name ASC")->result_array();
    $data['states'] = $state;
    $cities = $this->db->query("SELECT id,city FROM wps_cities_list WHERE country_id='".$country_id."' AND state_id='".$state_id."' AND status='1' ORDER BY city ASC")->result_array();
    $data['cities'] = $cities;
    $blocks = $this->db->query("SELECT id,name FROM wps_blocks_list WHERE country_id='".$country_id."' AND state_id='".$state_id."' AND city_id='".$city_id."' AND status='1' ORDER BY name ASC")->result_array();
    $data['blocks'] = $blocks;
    $panchayats = $this->db->query("SELECT id,name FROM wps_panchayats_list WHERE country_id='".$country_id."' AND state_id='".$state_id."' AND city_id='".$city_id."' AND block_id='".$block_id."' AND status='1' ORDER BY name ASC")->result_array();
    $data['panchayats'] = $panchayats;

    if ($this->input->post('update')) {
      $this->form_validation->set_rules('country_id', "Country Name", "trim|required");
      $this->form_validation->set_rules('state_id', "State Name", "trim|required");
      $this->form_validation->set_rules('city_id', "District Name", "trim|required");
      $this->form_validation->set_rules('block_id', "Block Name", "trim|required");
      $this->form_validation->set_rules('panchayat_id', "Panchayat Name", "trim|required");
     // $this->form_validation->set_rules('name', "Village Name", "trim|required|xss_clean|unique[wps_villages_list.name ='".$this->input->post('name')."' AND status!='2' AND id!='".$village_id."' AND panchayat_id='".$this->input->post('panchayat_id')."' AND block_id='".$this->input->post('block_id')."' AND city_id='".$this->input->post('city_id')."' AND state_id='".$this->input->post('state_id')."' AND country_id='".$this->input->post('country_id')."' ]|callback_check_meta_unique_url");
      $this->form_validation->set_rules('name', "Village Name", "trim|required|xss_clean|unique[wps_villages_list.name ='".$this->input->post('name')."' AND status!='2' AND id!='".$village_id."' AND panchayat_id='".$this->input->post('panchayat_id')."' AND block_id='".$this->input->post('block_id')."' AND city_id='".$this->input->post('city_id')."' AND state_id='".$this->input->post('state_id')."' AND country_id='".$this->input->post('country_id')."' ]");
      
      //$this->form_validation->set_rules('image1', 'Village Image', "file_allowed_type[image]");
      if ($this->form_validation->run() == TRUE) {

        $uploaded_file = $res->image_name;
        /*
        $unlink_image = array('source_dir' => "location", 'source_file' => $res->image_name);
        if (!empty($_FILES) && $_FILES['image1']['name'] != '') {
          $this->load->library('upload');
          $uploaded_data = $this->upload->my_upload('image1', 'location/village', $this->input->post('name') . rand());
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $uploaded_file = $uploaded_data['upload_data']['file_name'];
            removeImage($unlink_image);
          }
        }*/

        $url_title = seo_url_title($this->input->post('name'). '-' . $village_id);
        $posted_data = array(
            'name' => $this->input->post('name'),
            'temp_title' => $url_title,
            'panchayat_id' => $this->input->post('panchayat_id'),
            'block_id' => $this->input->post('block_id'),
            'city_id' => $this->input->post('city_id'),
            'state_id' => $this->input->post('state_id'),
            'country_id' => $this->input->post('country_id'),
            'image_name' => $uploaded_file,
        );
        //trace($posted_data); die;
        $where = "id=" . $village_id;
        $this->location_model->safe_update('wps_villages_list', $posted_data, $where, FALSE);

        
        //Update meta table
        $posted_data_meta = array(
            'page_url' => $url_title,
            'meta_title' => $this->input->post('name'),
            'meta_description' => $this->input->post('name'),
            'meta_keyword' => $this->input->post('name'),
        );
        $where_meta = "entity_type = 'category' AND entity_id = " . $res->id . " AND page_url = '" . $page_url . "'";
        $this->location_model->safe_update('wps_meta_tags', $posted_data_meta, $where_meta, FALSE);
        

        //End
        $this->session->set_flashdata('success', lang('successupdate'));
        redirect(base_url('sitepanel/location/village'));
      }
    }
    $this->load->view("location/village_edit", $data);
  }

  //ajax panchayat calling
  public function ajax_panchayat() {
    $country_id = $this->input->post('country_id');
    $state_id = $this->input->post('state_id');
    $city_id = $this->input->post('city_id');
    $block_id = $this->input->post('block_id');
    $sel_id = $this->input->post('sel');
    $panchayats = $this->db->query("SELECT * FROM wps_panchayats_list WHERE country_id='".$country_id."' AND state_id='".$state_id."' AND city_id='".$city_id."' AND block_id='".$block_id."' AND status='1'")->result_array();
    echo '<option value="">--Select Panchayat--</option>';
    foreach ($panchayats as $panchayat) {
      if ($panchayat['id'] == $sel_id) {
        $sel = 'selected';
      } else {
        $sel = '';
      }
      echo '<option value="'.$panchayat['id'].'"'.$sel.'>'.$panchayat['name'].'</option>';
    }
  }

  //ajax village calling
  public function ajax_village() {
    $country_id = $this->input->post('country_id');
    $state_id = $this->input->post('state_id');
    $city_id = $this->input->post('city_id');
    $block_id = $this->input->post('block_id');
    $panchayat_id = $this->input->post('panchayat_id');
    $sel_id = $this->input->post('sel');
    $villages = $this->db->query("SELECT * FROM wps_villages_list WHERE country_id='".$country_id."' AND state_id='".$state_id."' AND city_id='".$city_id."' AND block_id='".$block_id."' AND panchayat_id='".$panchayat_id."' AND status='1'")->result_array();
    echo '<option value="">--Select Village--</option>';
    foreach ($villages as $village) {
      if ($village['id'] == $sel_id) {
        $sel = 'selected';
      } else {
        $sel = '';
      }
      echo '<option value="'.$village['id'].'"'.$sel.'>'.$village['name'].'</option>';
    }
  }
  

  public function check_meta_unique_url() {

    $entity_id = $this->uri->segment(4, 0);
    if($entity_id){
      $entities=" AND entity_id!='".$entity_id."'";
    }else{
      $entities="";
    }

    $url_title=''; //

    if($this->input->post('country')){
      $url_title = seo_url_title($this->input->post('country')); //country_id
    }
    if($this->input->post('state')){
      $url_title = seo_url_title($this->input->post('state')); //country_id
    }
    if($this->input->post('city')){
      $url_title = seo_url_title($this->input->post('city')); //country_id,state_id
    }
    if($this->input->post('name')){
      $url_title = seo_url_title($this->input->post('name')); ////country_id,state_id,city_id or block_id,panchayat_id,village_id
    }

    if($url_title){
      $metasCount = $this->db->query("SELECT page_url FROM wps_meta_tags WHERE page_url='".$url_title."' $entities ")->num_rows();
      if ($metasCount) {
        $this->form_validation->set_message('check_meta_unique_url', 'This url already exists in metatag table.');
        return FALSE;
      }else{
        return TRUE;
      }
    }else{
      return TRUE;
    }

  }


}

// End of controller