<?php

class Kisan_sahayak extends Admin_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('kisan_sahayak_model', 'kisan_mitra_model'));
    $this->load->library(array('safe_encrypt'));
    $this->config->set_item('menu_highlight', 'my teams');
    $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");
  }

  public function index() {

    $kisan_mitra_id =  $this->input->get('kisan_mitra_id');

    $condtion = array();
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $status = $this->input->get_post('status', TRUE);

    if($kisan_mitra_id!='' && $kisan_mitra_id>0){
      $condtion['parent_admin_id'] = $kisan_mitra_id;
   }else{
     $condtion['parent_admin_id'] = '';
   }

    if($this->session->userdata('admin_type')=='2'){  //when district head login
      $condtion['district_head_id'] = $this->session->userdata('admin_id');
    }
    if($this->session->userdata('admin_type')=='3'){  //when kisaan mitra login
      $condtion['district_head_id'] = $this->session->userdata('district_head_id');
      $condtion['kisan_mitra_id'] = $this->session->userdata('admin_id');
    }
 
    if ($status != '') {
      $condtion['status'] = $status;
    }
    $condtion['admin_type'] = '4'; //KM Sahyogi //Kisan Sahayak
    
    $res_array = $this->kisan_sahayak_model->get_kisan_sahayaks($config['limit'], $offset, $condtion);
    //echo_sql();
    $total_record = get_found_rows();
    $data['page_links'] = admin_pagination($base_url, $total_record, $config['limit'], $offset);
    $data['heading_title'] = 'Manage Kisaan Mitras'; //Manage KM Sahyogies
    $data['pagelist'] = $res_array;
    $data['total_rec'] = $total_record;

    if ($this->input->post('status_action') != '') {

      if($this->input->post('status_action')=='Delete'){
        $arr_ids = $this->input->post('arr_ids');
          if(is_array($arr_ids) && !empty($arr_ids)){
            foreach ($arr_ids as $k => $v) {
              $data = array(
                'status' => '2'
              );
              $where = "admin_id ='".$v."'";
              $this->kisan_sahayak_model->safe_update('wps_admin', $data, $where, FALSE);
            }

            $this->session->set_userdata(array(
              'msg_type' => 'success'
            ));
            $this->session->set_flashdata('success', lang('deleted'));
            redirect(base_url('sitepanel/kisan_sahayak'));
        }
      }else{
        $this->update_status('wps_admin', 'admin_id');
      }
    }
    /*
    if ($this->input->post('set_as') != '') {
      $set_as = $this->input->post('set_as', TRUE);
      $this->set_as('wps_admin', 'admin_id', array($set_as => '1'));
    }
    if ($this->input->post('unset_as') != '') {
      $unset_as = $this->input->post('unset_as', TRUE);
      $this->set_as('wps_admin', 'admin_id', array($unset_as => '0'));
    }
    if ($this->input->post('action') == 'submit_excel') {
      $this->form_validation->set_rules('excel_file', 'Upload Excel File', 'required|callback_check_upload_excel');
      if ($this->form_validation->run() == TRUE) {
        require_once FCPATH . 'apps/third_party/Excel/reader.php';
        $data = new Spreadsheet_Excel_Reader();
        $data->setOutputEncoding('CP1251');

        //$data->setUTFEncoder('');
        chmod($_FILES["excel_file"]["tmp_name"], 0777);
        $data->read($_FILES["excel_file"]["tmp_name"]);
        $worksheet = $data->sheets[0]['cells'];

        $process_add = $this->kisan_sahayak_model->add_bulk_upload_member($worksheet);

        if ($process_add === TRUE) {
          $this->session->set_userdata(array('msg_type' => 'success'));
          $this->session->set_flashdata('success', 'Excel file inserted successfully!!!');
          redirect('sitepanel/members', '');
        } else {
          $this->form_validation->_error_array['image'] = 'Uploading Failed. Please Try Again';
        }
      }
    }*/

    //trace($this->input->post());
    //print_r("hello");exit;

    $this->load->view('kisan_sahayak/kisan_sahayak_list_view', $data);
  }

  public function add() {
    $admin_username=$this->input->post('admin_username');
    $this->form_validation->set_rules('admin_username', 'User Name', 'trim|required|max_length[15]|unique[wps_admin.admin_username ="'. $admin_username .'"]');
    $this->form_validation->set_rules('admin_password', 'Password', 'trim|required');
    $this->form_validation->set_rules('district_head_id', 'District Head', 'trim|required');
    $this->form_validation->set_rules('kisan_mitra_id', 'Block Head', 'trim|required'); //Kisan Mitra
    $this->form_validation->set_rules('admin_name', 'Name', 'trim|required|max_length[80]');
    $this->form_validation->set_rules('image1', 'Upload Photo', 'file_allowed_type[image]');
    $this->form_validation->set_rules('phone', 'Mobile Number', 'trim|required|max_length[15]');
    $this->form_validation->set_rules('contact_phone', 'Alt Mobile Number', 'trim|max_length[15]');
    $this->form_validation->set_rules('admin_email', 'Personal Email ID', 'trim|required|valid_email');
    $this->form_validation->set_rules('contact_email', 'Official Email ID', 'trim|valid_email');
    $this->form_validation->set_rules('address', 'Address', 'trim|max_length[255]');
    $this->form_validation->set_rules('pincode', 'PIN Code', 'trim|max_length[15]');
    $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
    $this->form_validation->set_rules('state_id', 'State', 'trim|required');
    $this->form_validation->set_rules('city_id', 'District', 'trim|required');
    $this->form_validation->set_rules('block_id', 'Block', 'trim|required');
    $this->form_validation->set_rules('panchayat_id', 'Panchayat', 'trim|required');
    $this->form_validation->set_rules('village_id', 'Village', 'trim|required');
    $this->form_validation->set_rules('aadhar_card', 'Aadhar Card', 'file_allowed_type[image]');
    $this->form_validation->set_rules('pan_card', 'PAN Card', 'file_allowed_type[image]');
    $this->form_validation->set_rules('cancelled_Cheque', 'Cancelled Cheque', 'file_allowed_type[image]');
    $this->form_validation->set_rules('address_proof', 'Address Proof', 'file_allowed_type[image]');
    
    $this->form_validation->set_rules('has_laptop', 'Has Laptop', 'trim');
    $this->form_validation->set_rules('has_smartphone', 'Has Smartphone', 'trim');
    $this->form_validation->set_rules('has_vehicle', 'Has Vehicle', 'trim'); 
    $this->form_validation->set_rules('which_vehicle[]', 'Which Vehicle', 'trim');

    if ($this->form_validation->run() == TRUE) {

      $uploaded_file = "";
      if (!empty($_FILES) && $_FILES['image1']['name'] != '') {
        $config['max_size'] = '2048';
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('image1', 'kisan_sahayak');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
        }
      }

      $aadhar_card = "";
      if (!empty($_FILES) && $_FILES['aadhar_card']['name'] != '') {
        $config['max_size'] = '2048';
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('aadhar_card', 'kisan_sahayak');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $aadhar_card = $uploaded_data['upload_data']['file_name'];
        }
      }
      $pan_card = "";
      if (!empty($_FILES) && $_FILES['pan_card']['name'] != '') {
        $config['max_size'] = '2048';
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('pan_card', 'kisan_sahayak');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $pan_card = $uploaded_data['upload_data']['file_name'];
        }
      }
      $cancelled_Cheque = "";
      if (!empty($_FILES) && $_FILES['cancelled_Cheque']['name'] != '') {
        $config['max_size'] = '2048';
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('cancelled_Cheque', 'kisan_sahayak');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $cancelled_Cheque = $uploaded_data['upload_data']['file_name'];
        }
      }
      $address_proof = "";
      if (!empty($_FILES) && $_FILES['address_proof']['name'] != '') {
        $config['max_size'] = '2048';
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('address_proof', 'kisan_sahayak');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $address_proof = $uploaded_data['upload_data']['file_name'];
        }
      }
      
      $which_vehicle='';
      if(!empty($this->input->post('which_vehicle')) && $this->input->post('has_vehicle')=='Yes'){
        $which_vehicle=implode(",",$this->input->post('which_vehicle'));
      }


          //$password = $this->input->post('admin_password');
          //'password' => $this->safe_encrypt->encode($password),
          $posted_data_customers = array(
          'admin_type' => '4',
          'parent_admin_id' => $this->session->userdata('admin_id'), //parent may be admin or district head or kisan mitra
          'district_head_id' => $this->input->post('district_head_id'),
          'kisan_mitra_id' => $this->input->post('kisan_mitra_id'),
          'admin_username' => $this->input->post('admin_username'),
          'admin_password' => $this->input->post('admin_password'),
          'admin_name' => $this->input->post('admin_name'),
          'admin_image' => $uploaded_file,
          'phone' => $this->input->post('phone'),
          'contact_phone' => $this->input->post('contact_phone'),
          'admin_email' => $this->input->post('admin_email'),
          'contact_email' => $this->input->post('contact_email'),
          'address' => $this->input->post('address'),
          'pincode' => $this->input->post('pincode'),
          'admin_country' => $this->input->post('country_id'),
          'admin_state' => $this->input->post('state_id'),
          'admin_district' => $this->input->post('city_id'),
          'admin_block' => $this->input->post('block_id'),
          'admin_panchayat' => $this->input->post('panchayat_id'),
          'admin_village' => $this->input->post('village_id'),
          'aadhar_card' => $aadhar_card,
          'pan_card' => $pan_card,
          'cancelled_Cheque' => $cancelled_Cheque,
          'address_proof' => $address_proof,
          'has_laptop' => $this->input->post('has_laptop'),
          'has_smartphone' => $this->input->post('has_smartphone'),
          'has_vehicle' => $this->input->post('has_vehicle'),
          'which_vehicle' => $which_vehicle,
          'status' => '1',
          'add_admin_type' => $this->session->userdata('admin_type'),
          'admin_key' => md5($this->input->post('admin_email')),
          'account_created_date' => $this->config->item('config.date.time'),
          'current_login' => $this->config->item('config.date.time'),
          'ip_address' => $this->input->ip_address()
      );
      //trace($posted_data_customers);
      $this->kisan_sahayak_model->safe_insert('wps_admin', $posted_data_customers, FALSE);
      //trace($posted_customer_factsheet);
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', lang('success'));
      redirect('sitepanel/kisan_sahayak', '');
    }

    //$data['cities'] = $this->db->query("SELECT * FROM `wps_cities_list` WHERE status='1' and temp_title IN (SELECT page_url from wps_meta_tags where is_fixed = 'L') order by id asc")->result_array();
    $data['states'] = $this->db->query("SELECT id,name FROM wps_states_list WHERE status='1' ORDER BY name ASC")->result_array();
    $data['cities'] = $this->db->query("SELECT id,city FROM wps_cities_list WHERE status='1' ORDER BY city ASC")->result_array();
    $data['blocks'] = $this->db->query("SELECT id,name FROM `wps_blocks_list` WHERE status='1' order by name asc")->result_array();
    $data['panchayats'] = $this->db->query("SELECT id,name FROM `wps_panchayats_list` WHERE status='1' order by name asc")->result_array();
    $data['villages'] = $this->db->query("SELECT id,name FROM `wps_villages_list` WHERE status='1' order by name asc")->result_array();

    $data['district_heads'] = $this->db->query("SELECT admin_id,admin_name FROM wps_admin WHERE admin_type='2' AND status='1' ORDER BY admin_name ASC")->result_array();
    $data['kisan_mitras'] = $this->db->query("SELECT admin_id,admin_name FROM wps_admin WHERE admin_type='3' AND status='1' ORDER BY admin_name ASC")->result_array();
    
    $data['heading_title'] = 'Add Kisaan Mitra'; //Add KM Sahyogi
    $this->load->view('kisan_sahayak/view_kisan_sahayak_add', $data);
  }

  public function edit(){

    $admin_id = (int) $this->uri->segment(4,0);
    if ($admin_id == '') {
      redirect('sitepanel/kisan_sahayak', '');
    }
    $mres = $this->kisan_sahayak_model->get_kisan_sahayak_row($admin_id);

    $admin_username=$this->input->post('admin_username');
    $this->form_validation->set_rules('admin_username', 'User Name', 'trim|required|max_length[15]|unique[wps_admin.admin_username ="'. $admin_username .'" and admin_id !="'.$mres['admin_id'].'"]');
    $this->form_validation->set_rules('admin_password', 'Password', 'trim|required');
    $this->form_validation->set_rules('district_head_id', 'District Head', 'trim|required');
    $this->form_validation->set_rules('kisan_mitra_id', 'Block Head', 'trim|required'); //Kisan Mitra
    $this->form_validation->set_rules('admin_name', 'Name', 'trim|required|max_length[80]');
    $this->form_validation->set_rules('image1', 'Upload Photo', 'file_allowed_type[image]');
    $this->form_validation->set_rules('phone', 'Mobile Number', 'trim|required|max_length[15]');
    $this->form_validation->set_rules('contact_phone', 'Alt Mobile Number', 'trim|max_length[15]');
    $this->form_validation->set_rules('admin_email', 'Personal Email ID', 'trim|required|valid_email');
    $this->form_validation->set_rules('contact_email', 'Official Email ID', 'trim|valid_email');
    $this->form_validation->set_rules('address', 'Address', 'trim|max_length[255]');
    $this->form_validation->set_rules('pincode', 'PIN Code', 'trim|max_length[15]');
    $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
    $this->form_validation->set_rules('state_id', 'State', 'trim|required');
    $this->form_validation->set_rules('city_id', 'District', 'trim|required');
    $this->form_validation->set_rules('block_id', 'Block', 'trim|required');
    $this->form_validation->set_rules('panchayat_id', 'Panchayat', 'trim|required');
    $this->form_validation->set_rules('village_id', 'Village', 'trim|required');
    $this->form_validation->set_rules('aadhar_card', 'Aadhar Card', 'file_allowed_type[image]');
    $this->form_validation->set_rules('pan_card', 'PAN Card', 'file_allowed_type[image]');
    $this->form_validation->set_rules('cancelled_Cheque', 'Cancelled Cheque', 'file_allowed_type[image]');
    $this->form_validation->set_rules('address_proof', 'Address Proof', 'file_allowed_type[image]');
    
    $this->form_validation->set_rules('has_laptop', 'Has Laptop', 'trim');
    $this->form_validation->set_rules('has_smartphone', 'Has Smartphone', 'trim');
    $this->form_validation->set_rules('has_vehicle', 'Has Vehicle', 'trim'); 
    $this->form_validation->set_rules('which_vehicle[]', 'Which Vehicle', 'trim');

    if ($this->form_validation->run() == TRUE) {

      $uploaded_file = $mres['admin_image'];
      $unlink_image = array('source_dir' => "kisan_sahayak", 'source_file' => $mres['admin_image']);
      if (!empty($_FILES) && $_FILES['image1']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('image1', 'kisan_sahayak');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
          removeImage($unlink_image);
        }
      }

      $aadhar_card = $mres['aadhar_card'];
      $unlink_image = array('source_dir' => "kisan_sahayak", 'source_file' => $mres['aadhar_card']);
      if (!empty($_FILES) && $_FILES['aadhar_card']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('aadhar_card', 'kisan_sahayak');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $aadhar_card = $uploaded_data['upload_data']['file_name'];
          removeImage($unlink_image);
        }
      }

      $pan_card = $mres['pan_card'];
      $unlink_image = array('source_dir' => "kisan_sahayak", 'source_file' => $mres['pan_card']);
      if (!empty($_FILES) && $_FILES['pan_card']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('pan_card', 'kisan_sahayak');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $pan_card = $uploaded_data['upload_data']['file_name'];
          removeImage($unlink_image);
        }
      }

      $cancelled_Cheque = $mres['cancelled_Cheque'];
      $unlink_image = array('source_dir' => "kisan_sahayak", 'source_file' => $mres['cancelled_Cheque']);
      if (!empty($_FILES) && $_FILES['cancelled_Cheque']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('cancelled_Cheque', 'kisan_sahayak');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $cancelled_Cheque = $uploaded_data['upload_data']['file_name'];
          removeImage($unlink_image);
        }
      }

      $address_proof = $mres['address_proof'];
      $unlink_image = array('source_dir' => "kisan_sahayak", 'source_file' => $mres['address_proof']);
      if (!empty($_FILES) && $_FILES['aadhar_card']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('address_proof', 'kisan_sahayak');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $address_proof = $uploaded_data['upload_data']['file_name'];
          removeImage($unlink_image);
        }
      }
      
      $which_vehicle='';
      if(!empty($this->input->post('which_vehicle')) && $this->input->post('has_vehicle')=='Yes'){
        $which_vehicle=implode(",",$this->input->post('which_vehicle'));
      }




      //$password = $this->input->post('password');
      //'password' => $this->safe_encrypt->encode($password),

      $posted_data_customers = array(
          //'admin_type' => '4',
          //'parent_admin_id' => $this->session->userdata('admin_id'), //parent may be admin or district head
          'district_head_id' => $this->input->post('district_head_id'),
          'kisan_mitra_id' => $this->input->post('kisan_mitra_id'),
          'admin_username' => $this->input->post('admin_username'),
          'admin_password' => $this->input->post('admin_password'),
          'admin_name' => $this->input->post('admin_name'),
          'admin_image' => $uploaded_file,
          'phone' => $this->input->post('phone'),
          'contact_phone' => $this->input->post('contact_phone'),
          'admin_email' => $this->input->post('admin_email'),
          'contact_email' => $this->input->post('contact_email'),
          'address' => $this->input->post('address'),
          'pincode' => $this->input->post('pincode'),
          'admin_country' => $this->input->post('country_id'),
          'admin_state' => $this->input->post('state_id'),
          'admin_district' => $this->input->post('city_id'),
          'admin_block' => $this->input->post('block_id'),
          'admin_panchayat' => $this->input->post('panchayat_id'),
          'admin_village' => $this->input->post('village_id'),
          'aadhar_card' => $aadhar_card,
          'pan_card' => $pan_card,
          'cancelled_Cheque' => $cancelled_Cheque,
          'address_proof' => $address_proof,
          'has_laptop' => $this->input->post('has_laptop'),
          'has_smartphone' => $this->input->post('has_smartphone'),
          'has_vehicle' => $this->input->post('has_vehicle'),
          'which_vehicle' => $which_vehicle,
          //'status' => '1',
          'admin_key' => md5($this->input->post('admin_email')),
          //'account_created_date' => $this->config->item('config.date.time'),
          //'current_login' => $this->config->item('config.date.time'),
          'ip_address' => $this->input->ip_address()
      );
      //trace($posted_data_customers);
      $where_ship = "admin_id = '" . $mres['admin_id'] . "'";
      $this->kisan_sahayak_model->safe_update('wps_admin', $posted_data_customers, $where_ship, FALSE);

      // echo_sql();

      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', lang('success'));
      redirect('sitepanel/kisan_sahayak', '');
    }

    if($this->input->post('country_id')){
      $country_id=$this->input->post('country_id');
    }else{
      $country_id=$mres['admin_country'];
    }
    if($this->input->post('state_id')){
      $state_id=$this->input->post('state_id');
    }else{
      $state_id=$mres['admin_state'];
    }

    if($this->input->post('city_id')){
      $city_id=$this->input->post('city_id');
    }else{
      $city_id=$mres['admin_district'];
    }

    if($this->input->post('block_id')){
      $block_id=$this->input->post('block_id');
    }else{
      $block_id=$mres['admin_block'];
    }
    if($this->input->post('panchayat_id')){
      $panchayat_id=$this->input->post('panchayat_id');
    }else{
      $panchayat_id=$mres['admin_panchayat'];
    }

    if($this->input->get_post('district_head_id')){
      $conditions_district_head='AND district_head_id="'.$this->input->get_post('district_head_id').'"';
    }else{
      //$conditions_district_head='';
      $conditions_district_head='AND district_head_id="'.$mres['district_head_id'].'"';
    }


    
    $data['states'] = $this->db->query("SELECT id,name FROM wps_states_list WHERE country_id='".$country_id."' AND status='1' ORDER BY name ASC")->result_array();
    $data['cities'] = $this->db->query("SELECT id,city FROM wps_cities_list WHERE country_id='".$country_id."' AND state_id='".$state_id."' AND status='1' ORDER BY city ASC")->result_array();
    $data['blocks'] = $this->db->query("SELECT id,name FROM `wps_blocks_list` WHERE country_id='".$country_id."' AND state_id='".$state_id."' AND city_id='".$city_id."' AND status='1' order by name asc")->result_array();
    $data['panchayats'] = $this->db->query("SELECT id,name FROM `wps_panchayats_list` WHERE country_id='".$country_id."' AND state_id='".$state_id."' AND city_id='".$city_id."' AND block_id='".$block_id."' AND status='1' order by name asc")->result_array();
    $data['villages'] = $this->db->query("SELECT id,name FROM `wps_villages_list` WHERE country_id='".$country_id."' AND state_id='".$state_id."' AND city_id='".$city_id."' AND block_id='".$block_id."' AND panchayat_id='".$panchayat_id."' AND status='1' order by name asc")->result_array();
    $data['district_heads'] = $this->db->query("SELECT admin_id,admin_name FROM wps_admin WHERE admin_type='2' AND status='1' ORDER BY admin_name ASC")->result_array();
    $data['kisan_mitras'] = $this->db->query("SELECT admin_id,admin_name FROM wps_admin WHERE admin_type='3' AND status='1' $conditions_district_head ORDER BY admin_name ASC")->result_array();

    $data['heading_title'] = 'Edit Kisaan Mitra'; //Edit KM Sahyogi
    $data['mres'] = $mres;
    $this->load->view('kisan_sahayak/view_kisan_sahayak_edit', $data);
  }

  public function details() {
    $admin_id = (int) $this->uri->segment(4);
    //$mres = $this->kisan_sahayak_model->get_kisan_sahayak_row($admin_id);
    //$mres = $this->db->query("select ad.*,c.name as country_name,s.name as state_name,d.city as district_name,b.name as block_name,p.name as panchayat_name from wps_admin as ad join wps_countries_list as c on ad.admin_country=c.id join wps_states_list as s on ad.admin_state=s.id join wps_cities_list as d on ad.admin_district=d.id join wps_blocks_list as b on ad.admin_block=b.id join wps_panchayats_list as p on ad.admin_panchayat=p.id,k.admin_name as kisan_mitra_name where ad.admin_id = '" . $admin_id . "' ")->row_array();

    $mres = $this->db->query("select ad.*,c.name as country_name,s.name as state_name,d.city as district_name,b.name as block_name,p.name as panchayat_name,v.name as village_name,dh.admin_name as district_head_name,ksm.admin_name as kisan_mitra_name from wps_admin as ad join wps_countries_list as c on ad.admin_country=c.id join wps_states_list as s on ad.admin_state=s.id join wps_cities_list as d on ad.admin_district=d.id join wps_blocks_list as b on ad.admin_block=b.id join wps_panchayats_list as p on ad.admin_panchayat=p.id join wps_villages_list as v on ad.admin_village=v.id join wps_admin as dh on ad.district_head_id=dh.admin_id join wps_admin as ksm on ad.kisan_mitra_id=ksm.admin_id where ad.admin_id = '" . $admin_id . "' ")->row_array();
    

    $data['heading_title'] = 'Kisaan Mitra Details'; //KM Sahyogi Details
    $data['mres'] = $mres;
    $this->load->view('kisan_sahayak/view_kisan_sahayak_detail', $data);
  }

  public function ip_details() {

    $admin_id = (int) $this->uri->segment(4);

    $mres = $this->db->query("select * from wps_ip_details where member_id = '" . $admin_id . "' ")->result_array();

    $data['heading_title'] = 'Members Login Details';

    $data['mres'] = $mres;

    $this->load->view('member/view_member_ip_detail', $data);
  }

  //ajax kisan sahayak calling
  public function ajax_kisan_sahayak() {
    $kisan_mitra_id = $this->input->post('kisan_mitra_id');
    $sel_id = $this->input->post('sel');
    $kisan_sahayaks = $this->db->query("SELECT admin_id,admin_name FROM wps_admin WHERE admin_type='4' AND kisan_mitra_id='".$kisan_mitra_id."' AND status='1'")->result_array();
    echo '<option value="">--Select Kisaan Mitra--</option>';
    foreach ($kisan_sahayaks as $kisan_sahayak) {
      if ($kisan_sahayak['admin_id'] == $sel_id) {
        $sel = 'selected';
      } else {
        $sel = '';
      }
      echo '<option value="'.$kisan_sahayak['admin_id'].'"'.$sel.'>'.$kisan_sahayak['admin_name'].'</option>';
    }
  }

  // update for kisan mitra
  public function edit_password() {

    $this->form_validation->set_rules('old_pass', 'Old Password', 'required|max_length[80]');
    $this->form_validation->set_rules('new_pass', 'New Password', 'required|valid_password|max_length[80]');
    $this->form_validation->set_rules('confirm_password', 'Confirm Password', 'required|matches[new_pass]|max_length[80]');
    if ($this->form_validation->run() == TRUE) {
      $this->kisan_mitra_model->update_password($this->input->post('old_pass'),$this->session->userdata('admin_id'));
      redirect('sitepanel/kisan_sahayak/edit_password', '');
    }

    $data['heading_title'] = 'Update Password';
    $data['mres'] = $this->kisan_mitra_model->get_kisan_mitra_row($this->session->userdata('admin_id'));
    $this->load->view('kisan_mitra/edit_password_view', $data);
  }

  // update for kisan mitra

  public function edit_profile() {

    $mres = $this->kisan_mitra_model->get_kisan_mitra_row($this->session->userdata('admin_id'));

    $this->form_validation->set_rules('admin_name', 'Name', 'trim|required|max_length[80]');
    $this->form_validation->set_rules('image1', 'Upload Photo', 'file_allowed_type[image]');
    $this->form_validation->set_rules('phone', 'Mobile Number', 'trim|required|max_length[15]');
    $this->form_validation->set_rules('contact_phone', 'Alt Mobile Number', 'trim|max_length[15]');
    $this->form_validation->set_rules('admin_email', 'Personal Email ID', 'trim|required|valid_email');
    $this->form_validation->set_rules('contact_email', 'Official Email ID', 'trim|valid_email');
    $this->form_validation->set_rules('address', 'Address', 'trim|max_length[255]');
    $this->form_validation->set_rules('pincode', 'PIN Code', 'trim|max_length[15]');
    //$this->form_validation->set_rules('country_id', 'Country', 'trim|required');
    //$this->form_validation->set_rules('state_id', 'State', 'trim|required');
    //$this->form_validation->set_rules('city_id', 'District', 'trim|required');
    //$this->form_validation->set_rules('block_id', 'Block', 'trim|required');
    //$this->form_validation->set_rules('panchayat_id', 'Panchayat', 'trim|required');
    //$this->form_validation->set_rules('village_id', 'Village', 'trim|required');
    $this->form_validation->set_rules('aadhar_card', 'Aadhar Card', 'file_allowed_type[image]');
    $this->form_validation->set_rules('pan_card', 'PAN Card', 'file_allowed_type[image]');
    $this->form_validation->set_rules('cancelled_Cheque', 'Cancelled Cheque', 'file_allowed_type[image]');
    $this->form_validation->set_rules('address_proof', 'Address Proof', 'file_allowed_type[image]');
    
    $this->form_validation->set_rules('has_laptop', 'Has Laptop', 'trim');
    $this->form_validation->set_rules('has_smartphone', 'Has Smartphone', 'trim');
    $this->form_validation->set_rules('has_vehicle', 'Has Vehicle', 'trim'); 
    $this->form_validation->set_rules('which_vehicle[]', 'Which Vehicle', 'trim');

    //$this->form_validation->set_rules('facebook', 'Facebook Link', 'trim|max_lenght[240]');
    //$this->form_validation->set_rules('twitter', 'Twitter Link', 'trim|max_lenght[240]');
    //$this->form_validation->set_rules('linkedin', 'Linkedin Link', 'trim|max_lenght[240]');
    //$this->form_validation->set_rules('youtube', 'Youtube Channel Link', 'trim|max_lenght[240]');
    //$this->form_validation->set_rules('whatsapp', 'WhatsApp Number', 'trim|max_lenght[240]');

    if ($this->form_validation->run() == TRUE) {

      $uploaded_file = $mres['admin_image'];
      $unlink_image = array('source_dir' => "kisan_mitra", 'source_file' => $mres['admin_image']);
      if (!empty($_FILES) && $_FILES['image1']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('image1', 'kisan_mitra');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
          removeImage($unlink_image);
        }
      }

      $aadhar_card = $mres['aadhar_card'];
      $unlink_image = array('source_dir' => "kisan_mitra", 'source_file' => $mres['aadhar_card']);
      if (!empty($_FILES) && $_FILES['aadhar_card']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('aadhar_card', 'kisan_mitra');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $aadhar_card = $uploaded_data['upload_data']['file_name'];
          removeImage($unlink_image);
        }
      }

      $pan_card = $mres['pan_card'];
      $unlink_image = array('source_dir' => "kisan_mitra", 'source_file' => $mres['pan_card']);
      if (!empty($_FILES) && $_FILES['pan_card']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('pan_card', 'kisan_mitra');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $pan_card = $uploaded_data['upload_data']['file_name'];
          removeImage($unlink_image);
        }
      }

      $cancelled_Cheque = $mres['cancelled_Cheque'];
      $unlink_image = array('source_dir' => "kisan_mitra", 'source_file' => $mres['cancelled_Cheque']);
      if (!empty($_FILES) && $_FILES['cancelled_Cheque']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('cancelled_Cheque', 'kisan_mitra');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $cancelled_Cheque = $uploaded_data['upload_data']['file_name'];
          removeImage($unlink_image);
        }
      }

      $address_proof = $mres['address_proof'];
      $unlink_image = array('source_dir' => "kisan_mitra", 'source_file' => $mres['address_proof']);
      if (!empty($_FILES) && $_FILES['aadhar_card']['name'] != '') {
        $this->load->library('upload');
        $uploaded_data = $this->upload->my_upload('address_proof', 'kisan_mitra');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $address_proof = $uploaded_data['upload_data']['file_name'];
          removeImage($unlink_image);
        }
      }
      
      $which_vehicle='';
      if(!empty($this->input->post('which_vehicle')) && $this->input->post('has_vehicle')=='Yes'){
        $which_vehicle=implode(",",$this->input->post('which_vehicle'));
      }
      
      $this->kisan_sahayak_model->update_profile($mres['admin_id'],$uploaded_file,$aadhar_card,$pan_card,$cancelled_Cheque,$address_proof,$which_vehicle);
      redirect('sitepanel/kisan_sahayak/edit_profile', '');
    }
    $data['heading_title'] = 'Edit Profile';
    $data['mres'] = $mres;
    $this->load->view('kisan_mitra/edit_profile_view', $data);
  }
  
  

}

// End of controller