<?php
if (!defined('BASEPATH'))
  exit('No direct script access allowed');

if (!function_exists('CI')) {

  function CI() {
    if (!function_exists('get_instance'))
      return FALSE;
    $CI = & get_instance();
    return $CI;
  }

}

function invoice_content($ordmaster, $orddetail, $dlink = '') {
  $ci = CI();
  $curr_symbol = display_symbol();
  $grandTotal = $ordmaster['total_amount'] + $ordmaster['shipping_amount'] + $ordmaster['cod_amount'];
  $admin_email = get_site_email();
  ?>
  <div class="mt15">
    <div class="inv_box2"> <img src="<?php echo theme_url(); ?>images/logo.png" class="img_responsive" alt=""></div>
    <div class="inv_box1 mt5">
      <p>
        <b>Product</b><br>
        <?php echo nl2br($admin_email->address); ?><br>
        <span class="pt3">Email Us : <b class="red"><a href="#"><?php echo $admin_email->admin_email; ?></a></b></span> Phone : <?php echo $admin_email->phone; ?> 
      </p>
    </div>
    <div class="cb pb10"></div>

    <div class="inv_box3">
      <div class="b fs16 lht-20 bb mb10">Order Summary</div>
      <div class="mt5 lht-20 fs12">
        <b>Invoce No. : <?php echo $ordmaster['invoice_number']; ?></b><br>
        Dated : <?php echo getDateFormat($ordmaster['order_received_date'], 2); ?>
      </div>
      <div class="mt10 fs12 lht-20">
        Subtotal Amount : <?php echo display_price($ordmaster['total_amount']); ?><br>
        Shipping Charge  : <?php echo display_price($ordmaster['shipping_amount']); ?><br>
        <?php
        if ($ordmaster['cod_amount'] > 0) {
          ?>
          COD Charge  : <?php echo display_price($ordmaster['cod_amount']); ?><br>
          <?php
        }
        ?>
        <b class="fs13 lht-30 red">Total Payable Amount : <?php echo display_price($grandTotal); ?> </b>
      </div>
    </div>
    <div class="cb"></div>

    <h3 class="mt20 b bb1 pb5">Book Details</h3>
    <div class="p15 white bg-black ttu fs14 cont_4_address mob_hider b">
      <div class="sec1">S. No.</div>
      <div class="sec2">Book</div>
      <div class="sec3">Amount</div>
      <div class="cb"></div>
    </div>
    <?php
    $i = 1;
    $subtotal = '';
    $total = '';
    //trace($orddetail);
    if (is_array($orddetail) && !empty($orddetail)) {
      foreach ($orddetail as $val) {
        $sql = $ci->db->query("select * from wps_products_media where products_id='" . $val['products_id'] . "'")->row_array();
        if (is_array($sql) && !empty($sql)) {
          $img = $sql['media'];
        } else {
          $img = '';
        }
        $subtotal = ( $val['quantity'] * $val['product_price']);
        $total += $subtotal;
        //trace($val);
        ?> 
        <div class="p15 bb cont_4_address mt15">
          <div class="sec1"><strong>S. No.</strong> <?php echo $i; ?>.</div>
          <div class="sec2">
            <p class="fs16 b"><b class="fl thm_cont mr10"><img src="<?php echo get_image('products', $img, '100', '80', 'R'); ?>" alt="" width="100" height="82"></b><?php echo $val['product_name']; ?>t</p>

            <p class="black fs15 mt2">Price: <b class="gray1 through normal"><span class="WebRupee">Rs.</span>50.00</b> <b class="red"><?php echo display_price($val['product_price']); ?></b></p>
            <div class="cb"></div>
          </div>
          <div class="sec3 b"> <strong>Amount :</strong> <?php echo display_price($subtotal); ?> </div>
          <div class="cb"></div>
        </div>
        <!-- list 1 -->
        <?php
        $i++;
      }
    }

    if ($dlink == '') {
      ?>
      <div class="cb bb1"></div>
      <p class="mob_hider ac"><a href="<?php echo base_url(); ?>cart/print_invoice/<?php echo $ordmaster['order_id']; ?>" class="invoice1 btn2 radius-20b" style="padding:0 30px">Print Invoice</a></p>
      <?php
    } else {
      ?>
      <br /><br />
      <div style="text-align:right; font:bold 14px/18px Arial, Helvetica, sans-serif; color:#333; padding:0 20px 15px 0">Sub Total : <?php echo display_price($grandTotal); ?></div>
      <?php
    }
    ?>
  </div>   
  <?php
}

function invoice_content_print($ordmaster, $orddetail) {
  $ci = CI();
  $ci->load->helper('words');
  $curr_symbol = display_symbol();
  $grandTotal = $ordmaster['total_amount'];
  $wordsAmount = getStringOfAmount($grandTotal);
  $wordsAmount .= ' Only';
  $userDets = get_db_single_row("wps_customers", "customers_id, website, company_name, state, city, locality, address, landmark, locality", "customers_id = '" . $ordmaster['customers_id'] . "'");
  $city = $state = $locality = "";
  if (is_array($userDets) && !empty($userDets)) {
    $city = get_db_field_value("wps_cities_list", "city", "WHERE id = '" . $userDets['city'] . "'");
    $state = get_db_field_value("wps_states_list", "name", "WHERE id = '" . $userDets['state'] . "'");
    $locality = $userDets['locality'];
  }
  ?>
  <!DOCTYPE html>
  <html lang="en">
    <head>
      <title>World Best Local Directory Website template</title>
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1">
    </head>
    <body style="background: #efefef;position: relative;">

      <div style="width: 600px;margin: 0 auto;margin-top: 0px;margin-bottom: 0px;padding: 20px;background: #ffffff;margin-top: 50px;margin-bottom: 50px;">
        <div style="background: #fdfdfd;box-shadow: 0px 10px 24px -10px rgba(0, 0, 0, 0.8);margin-bottom: 50px;
             border-radius: 10px;">
          <div style="width: 100%;background: #006df0 url('https://www.wpsbiz.com/mailer/images/bg.png') repeat;padding: 50px;box-sizing: border-box;border-radius: 5px 5px 0px 0px;">
            <h2 style="color: #fff;font-size: 32px;text-transform: capitalize; margin:0; font-family: 'Poppins', sans-serif;"><img src="https://www.wpsbiz.com/mailer/images/letter.png" style="float: left;padding-right: 25px;width: 100px;"> Payment was Successfully Done</h2>
          </div>
          <div style="padding: 30px;">
            <h3 style="font-size: 24px; margin-bottom: 20px; font-family:'Poppins', sans-serif;">Listing Invoice</h3>
            <div style="position: relative;overflow: hidden;width: 100%;border: 1px solid #eaedef;">
              <div style="padding: 30px 50px 30px 30px; background: #eee; float: left;">
                <img src="https://www.wpsbiz.com/mailer/images/logo.png" alt="" style="margin-bottom:30px;">
                <div style="position: relative;margin-bottom: 20px;">
                  <div style="float: left;width: 100%;margin-bottom: 0px;">
                    <h3 style="font-size: 24px; margin:0 0 5px; font-family:'Poppins', sans-serif; padding: 0;"><?php echo $ordmaster['first_name']; ?> <?php echo $ordmaster['last_name']; ?></h3>
                    <?php
                    if ($userDets['address']) {
                      ?>
                      <p style="color: #636363;font-size: 15px;font-family:'Poppins', sans-serif;font-weight: 400; margin: 0 0 20px;"><?php echo $userDets['address'] . ', ' . $userDets['locality'] . ', Near ' . $userDets['landmark']; ?>, <?php echo $state; ?>, <?php echo $city; ?></p>
                      <?php
                    }
                    ?>
                    <h5 style="font-size: 18px; margin:0 0 5px; font-family:'Poppins', sans-serif; padding: 0;">Bill To</h5>
                    <p style="color: #636363;font-size: 15px;font-family:'Poppins', sans-serif; font-weight: 400; margin: 0 0 20px;">Email: <?php echo $ordmaster['email']; ?></p>
                  </div>
                  <div style="float: left;padding: 10px;background: #fdfae9;border-radius: 4px;display: inline-block;
                       width: 100%; margin-bottom: 20px;">
                    <ul style="margin: 0; padding: 0;">
                      <li style="font-size: 13px;color: #343c42;line-height: 24px;font-weight: 600; list-style: none; font-family:'Poppins', sans-serif;"><span style="float: left;width: 50%;color: #343c42; font-weight: 400;">Invoice Number</span> <?php echo $ordmaster['invoice_number']; ?></li>
                      <li style="font-size: 13px;color: #343c42;line-height: 24px;font-weight: 600; list-style: none; font-family:'Poppins', sans-serif;"><span style="float: left;width: 50%;color: #343c42; font-weight: 400;">Date</span> <?php echo getDateFormat($ordmaster['order_received_date'], 3); ?></li>
                    </ul>
                  </div>
                </div>
                <div style="float: left; width: 100%; margin:0; padding: 10px; background: #01a0d8; border: 1px solid #01a0d8;">
                  <div style="float: left; width: 30%; color: #fff;font-size:15px;font-family:'Poppins', sans-serif; font-weight: 600; margin: 0 0 0px;">Description</div>
                  <div style="float: left; width: 20%; color: #fff;font-size:15px;font-family:'Poppins', sans-serif; font-weight: 600; margin: 0 0 0px;">Price</div>
                  <div style="float: left; width: 25%; color: #fff;font-size:15px;font-family:'Poppins', sans-serif; font-weight: 600; margin: 0 0 0px;">Duration</div>
                  <div style="float: left; width: 25%; color: #fff;font-size:15px;font-family:'Poppins', sans-serif; font-weight: 600; margin: 0 0 0px;">Subtotal</div>
                </div>
                <div style="float: left; width: 100%; margin:0; padding: 0; border: 1px solid #ccc; border-bottom: 0; padding: 10px">
                  <div style="float: left; width: 30%; color: #333;font-size:13px;font-family:'Poppins', sans-serif; font-weight: 400; margin: 0 0 0px;"><?php echo $orddetail[0]['product_name']; ?></div>
                  <div style="float: left; width: 20%; color: #333;font-size:13px;font-family:'Poppins', sans-serif; font-weight: 400; margin: 0 0 0px;">Rs. <?php echo $orddetail[0]['product_price']; ?></div>
                  <div style="float: left; width: 25%; color: #333;font-size:13px;font-family:'Poppins', sans-serif; font-weight: 400; margin: 0 0 0px;">1 Year</div>
                  <div style="float: left; width: 25%; color: #333;font-size:16px;font-family:'Poppins', sans-serif; font-weight: 600; margin: 0 0 0px;">Rs. <?php echo $orddetail[0]['product_price']; ?></div>
                </div>

              </div>
            </div>
          </div>
        </div>

        <div style="text-align: center;">
          <h4 style="text-transform: capitalize; margin:0; font-family: 'Poppins', sans-serif; font-size: 18px; color: #333;">Stay in touch</h4>
          <ul style="position: relative;overflow: hidden;margin: 0 auto; margin-top: 0px;margin-bottom: 0px;display: table;margin-bottom: 18px;margin-top: 25px;">
            <li style="font-size: 13px;color: #343c42;line-height: 24px;font-weight: 600;float: left;display: inline-block;padding: 0px 10px;"><a href="#"><img src="https://www.wpsbiz.com/mailer/images/s1.png" alt=""></a></li>
            <li style="font-size: 13px;color: #343c42;line-height: 24px;font-weight: 600;float: left;display: inline-block;padding: 0px 10px;"><a href="#"><img src="https://www.wpsbiz.com/mailer/images/s2.png" alt=""></a></li>
            <li style="font-size: 13px;color: #343c42;line-height: 24px;font-weight: 600;float: left;display: inline-block;padding: 0px 10px;"><a href="#"><img src="https://www.wpsbiz.com/mailer/images/s3.png" alt=""></a></li>
            <li style="font-size: 13px;color: #343c42;line-height: 24px;font-weight: 600;float: left;display: inline-block;padding: 0px 10px;"><a href="#"><img src="https://www.wpsbiz.com/mailer/images/s4.png" alt=""></a></li>
            <li style="font-size: 13px;color: #343c42;line-height: 24px;font-weight: 600;float: left;display: inline-block;padding: 0px 10px;"><a href="#"><img src="https://www.wpsbiz.com/mailer/images/s5.png" alt=""></a></li>
          </ul>
          <p style="color: #636363;font-size: 15px;font-family:'Poppins', sans-serif;font-weight: 400; margin: 0 0 5px;">Email send by Natural Therapy India</p>
          <p style="color: #636363;font-size: 15px;font-family:'Poppins', sans-serif;font-weight: 400; margin: 0 0 20px;">copyrights © 2019 wpsbiz.com. All rights reserved.</p>
        </div>
      </div>
    </body>
  </html>
  <?php
}

function invoice_content_print_error($ordmaster, $orddetail) {
  $ci = CI();
  $ci->load->helper('words');
  $curr_symbol = display_symbol();
  $grandTotal = $ordmaster['total_amount'];
  $wordsAmount = getStringOfAmount($grandTotal);
  $wordsAmount .= ' Only';
  $userDets = get_db_single_row("wps_customers", "customers_id, website, company_name, state, city, locality, address, landmark, locality", "customers_id = '" . $ordmaster['customers_id'] . "'");
  $city = $state = $locality = "";
  if (is_array($userDets) && !empty($userDets)) {
    $city = get_db_field_value("wps_cities_list", "city", "WHERE id = '" . $userDets['city'] . "'");
    $state = get_db_field_value("wps_states_list", "name", "WHERE id = '" . $userDets['state'] . "'");
    $locality = $userDets['locality'];
  }
  ?>
  <!DOCTYPE html>
  <html lang="en">
    <head>
      <title>World Best Local Directory Website template</title>
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1">
    </head>
    <body style="background: #efefef;position: relative;">

      <div style="width: 600px;margin: 0 auto;margin-top: 0px;margin-bottom: 0px;padding: 20px;background: #ffffff;margin-top: 50px;margin-bottom: 50px;">
        <div style="background: #fdfdfd;box-shadow: 0px 10px 24px -10px rgba(0, 0, 0, 0.8);margin-bottom: 50px;
             border-radius: 10px;">
          <div style="width: 100%;background: #e2574c url('https://www.wpsbiz.com/mailer/images/bg.png') repeat;padding: 50px;box-sizing: border-box;border-radius: 5px 5px 0px 0px;">
            <h2 style="color: #fff;font-size: 32px;text-transform: capitalize; margin:0; font-family: 'Poppins', sans-serif;"><img src="https://www.wpsbiz.com/mailer/images/letter.png" style="float: left;padding-right: 25px;width: 100px;"> Payment was cancelled/declined unsuccessfull</h2>
          </div>
          <div style="padding: 30px;">
            <h3 style="font-size: 24px; margin-bottom: 20px; font-family:'Poppins', sans-serif;">Listing Invoice</h3>
            <div style="position: relative;overflow: hidden;width: 100%;border: 1px solid #eaedef;">
              <div style="padding: 30px 50px 30px 30px; background: #eee; float: left;">
                <img src="https://www.wpsbiz.com/mailer/images/logo.png" alt="" style="margin-bottom:30px;">
                <div style="position: relative;margin-bottom: 20px;">
                  <div style="float: left;width: 100%;margin-bottom: 0px;">
                    <h3 style="font-size: 24px; margin:0 0 5px; font-family:'Poppins', sans-serif; padding: 0;"><?php echo $ordmaster['first_name']; ?> <?php echo $ordmaster['last_name']; ?></h3>
                    <?php
                    if ($userDets['address']) {
                      ?>
                      <p style="color: #636363;font-size: 15px;font-family:'Poppins', sans-serif;font-weight: 400; margin: 0 0 20px;"><?php echo $userDets['address'] . ', ' . $userDets['locality'] . ', Near ' . $userDets['landmark']; ?>, <?php echo $state; ?>, <?php echo $city; ?></p>
                      <?php
                    }
                    ?>
                    <h5 style="font-size: 18px; margin:0 0 5px; font-family:'Poppins', sans-serif; padding: 0;">Bill To</h5>
                    <p style="color: #636363;font-size: 15px;font-family:'Poppins', sans-serif; font-weight: 400; margin: 0 0 20px;">Email: <?php echo $ordmaster['email']; ?></p>
                  </div>
                  <div style="float: left;padding: 10px;background: #fdfae9;border-radius: 4px;display: inline-block;
                       width: 100%; margin-bottom: 20px;">
                    <ul style="margin: 0; padding: 0;">
                      <li style="font-size: 13px;color: #343c42;line-height: 24px;font-weight: 600; list-style: none; font-family:'Poppins', sans-serif;"><span style="float: left;width: 50%;color: #343c42; font-weight: 400;">Invoice Number</span> <?php echo $ordmaster['invoice_number']; ?></li>
                      <li style="font-size: 13px;color: #343c42;line-height: 24px;font-weight: 600; list-style: none; font-family:'Poppins', sans-serif;"><span style="float: left;width: 50%;color: #343c42; font-weight: 400;">Date</span> <?php echo getDateFormat($ordmaster['order_received_date'], 3); ?></li>
                    </ul>
                  </div>
                </div>
                <div style="float: left; width: 100%; margin:0; padding: 10px; background: #01a0d8; border: 1px solid #01a0d8;">
                  <div style="float: left; width: 30%; color: #fff;font-size:15px;font-family:'Poppins', sans-serif; font-weight: 600; margin: 0 0 0px;">Description</div>
                  <div style="float: left; width: 20%; color: #fff;font-size:15px;font-family:'Poppins', sans-serif; font-weight: 600; margin: 0 0 0px;">Price</div>
                  <div style="float: left; width: 25%; color: #fff;font-size:15px;font-family:'Poppins', sans-serif; font-weight: 600; margin: 0 0 0px;">Duration</div>
                  <div style="float: left; width: 25%; color: #fff;font-size:15px;font-family:'Poppins', sans-serif; font-weight: 600; margin: 0 0 0px;">Subtotal</div>
                </div>
                <div style="float: left; width: 100%; margin:0; padding: 0; border: 1px solid #ccc; border-bottom: 0; padding: 10px">
                  <div style="float: left; width: 30%; color: #333;font-size:13px;font-family:'Poppins', sans-serif; font-weight: 400; margin: 0 0 0px;"><?php echo $orddetail[0]['product_name']; ?></div>
                  <div style="float: left; width: 20%; color: #333;font-size:13px;font-family:'Poppins', sans-serif; font-weight: 400; margin: 0 0 0px;">Rs. <?php echo $orddetail[0]['product_price']; ?></div>
                  <div style="float: left; width: 25%; color: #333;font-size:13px;font-family:'Poppins', sans-serif; font-weight: 400; margin: 0 0 0px;">1 Year</div>
                  <div style="float: left; width: 25%; color: #333;font-size:16px;font-family:'Poppins', sans-serif; font-weight: 600; margin: 0 0 0px;">Rs. <?php echo $orddetail[0]['product_price']; ?></div>
                </div>

              </div>
            </div>
          </div>
        </div>

        <div style="text-align: center;">
          <h4 style="text-transform: capitalize; margin:0; font-family: 'Poppins', sans-serif; font-size: 18px; color: #333;">Stay in touch</h4>
          <ul style="position: relative;overflow: hidden;margin: 0 auto; margin-top: 0px;margin-bottom: 0px;display: table;margin-bottom: 18px;margin-top: 25px;">
            <li style="font-size: 13px;color: #343c42;line-height: 24px;font-weight: 600;float: left;display: inline-block;padding: 0px 10px;"><a href="#"><img src="https://www.wpsbiz.com/mailer/images/s1.png" alt=""></a></li>
            <li style="font-size: 13px;color: #343c42;line-height: 24px;font-weight: 600;float: left;display: inline-block;padding: 0px 10px;"><a href="#"><img src="https://www.wpsbiz.com/mailer/images/s2.png" alt=""></a></li>
            <li style="font-size: 13px;color: #343c42;line-height: 24px;font-weight: 600;float: left;display: inline-block;padding: 0px 10px;"><a href="#"><img src="https://www.wpsbiz.com/mailer/images/s3.png" alt=""></a></li>
            <li style="font-size: 13px;color: #343c42;line-height: 24px;font-weight: 600;float: left;display: inline-block;padding: 0px 10px;"><a href="#"><img src="https://www.wpsbiz.com/mailer/images/s4.png" alt=""></a></li>
            <li style="font-size: 13px;color: #343c42;line-height: 24px;font-weight: 600;float: left;display: inline-block;padding: 0px 10px;"><a href="#"><img src="https://www.wpsbiz.com/mailer/images/s5.png" alt=""></a></li>
          </ul>
          <p style="color: #636363;font-size: 15px;font-family:'Poppins', sans-serif;font-weight: 400; margin: 0 0 5px;">Email send by Natural Therapy India</p>
          <p style="color: #636363;font-size: 15px;font-family:'Poppins', sans-serif;font-weight: 400; margin: 0 0 20px;">copyrights © 2019 wpsbiz.com. All rights reserved.</p>
        </div>
      </div>
    </body>
  </html>
  <?php
}
