<?php

class Brands extends Public_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->helper(array('category/category', 'products/product'));
    $this->load->model(array('category/category_model', 'products/product_model', 'brands/brands_model', 'cart/cart_model'));
  }

  public function index() {

    $category_id = (isset($this->meta_info['entity_id']))?(int) $this->meta_info['entity_id']:0;
    $have_sub_cat = get_db_field_value('wps_products', 'products_id', "WHERE brand_id = '$category_id' ");
    if ($category_id > 0) {
      if ($have_sub_cat > 0) {
        $this->products_listing("", $category_id);
      } else {
        $this->products_listing("",$category_id);
      }
    } else {
      $this->brand_listing($category_id);
    }
  }

  public function brand_listing($cid) {
    $data['res'] = $this->db->query("select * from wps_brands where status = '1'")->result_array();
    //desc
    $data['category_description'] = get_db_field_value("wps_cms_pages", "page_description", "WHERE page_id='11'");
    $this->load->view('brands/view_brands', $data);
  }

  public function products_listing($category_id, $brand_id) {
    //echo $brand_id;
    $this->page_section_ct = 'product';
    $condtion = array();
    $cat_res = '';
    $record_per_page = (int) $this->input->post('per_page');
    $category_id = (int) $category_id;
    $page_segment = find_paging_segment();
    $config['per_page'] = ( $record_per_page > 0 ) ? $record_per_page : $this->config->item('per_page');
    //$config['per_page']			= 1;	
    $offset = (int) $this->uri->segment($page_segment, 0);
    $base_url = ( $category_id != '' ) ? "category/products_listing/$category_id/pg/" : "category/products_listing/pg/";
    $condtion['status'] = '1';

    //Sorting
    $sort = $this->input->get_post('sort');
    if ($sort > 0) {
      if ($sort == 1) {
        $condtion['orderby'] = 'newarrival_product DESC';
      }
      if ($sort == 2) {
        $condtion['orderby'] = 'popular_product DESC';
      }
      if ($sort == 3) {
        $condtion['orderby'] = 'products_id DESC';
      }
      if ($sort == 4) {
        $condtion['orderby'] = 'product_price ASC';
      }
      if ($sort == 5) {
        $condtion['orderby'] = 'product_price DESC';
      }
    } else {
      //$condtion['orderby'] = 'products_id asc';
    }


    $page_title = "Product Lists";
    $color = $this->input->post('color');
    $size = $this->input->post('size');
    $price = $this->input->post('price');
    $catIds = $this->input->post('categoryId');

    if ($brand_id > 0) {
      $condtion['brand'] = $brand_id;
    }
    if (!empty($color)) {
      $colors = implode(',', $color);
      $condtion['color'] = $colors;
    }
    if (!empty($size)) {
      $sizes = implode(',', $size);
      $condtion['size'] = $sizes;
    }
    if (!empty($catIds)) {
      $catIds = implode(',', $catIds);
      $condtion['catIds'] = $catIds;
    }
    if (!empty($price)) {
      $condtion['price'] = $price;
    }
    if (!empty($this->input->get_post('min-price')) && !empty($this->input->get_post('max-price'))) {
      $min = $this->input->get_post('min-price');
      $max = $this->input->get_post('max-price');
      $condtion['price'] = $min . '-' . $max;
    }
    $srtQry = "AND parent_id = '1'";
    $data['catid'] = "";
    if ($category_id > 0) {
      $condtion['category_id'] = $category_id;
      $cat_res = get_db_single_row('wps_categories', '*', " category_id='$category_id'");
      $page_title = $cat_res['category_name'];
      $srtQry = "AND parent_id = '" . $cat_res['parent_id'] . "'";
      $data['catid'] = $category_id;
    }
    $res_array = $this->product_model->get_products($config['per_page'], $offset, $condtion);
    //echo_sql();
    $data['total_rows'] = $config['total_rows'] = get_found_rows();
    $data['page_links'] = front_pagination("$base_url", $config['total_rows'], $config['per_page'], $page_segment);
    $data['heading_title'] = $page_title;
    $data['res'] = $res_array;
    $data['cat_res'] = $cat_res;
    $data['brand_id'] = $brand_id;

    /* Global array */
    //Brands
    $data['brands'] = $this->db->query("SELECT * FROM wps_brands WHERE status = '1'")->result_array();

    //special products
    $condPro = array();
    $condPro = array("popular" => 1);
    $proRes = $this->product_model->get_products(1, 0, $condPro);
    //echo_sql();
    $data['proRes'] = $proRes;
    
    

//Desc
    $cat_res = get_db_single_row('wps_cms_pages', '*', " page_id ='11'");
    $category_description = $cat_res['page_description'];
      
    //Category
    $data['catleftRes'] = $this->db->query("SELECT category_id, category_name, friendly_url FROM wps_categories WHERE status='1' GROUP BY category_id")->result_array();

    //banner
    $data['banner'] = get_db_field_value("wps_banners", "banner_image", "WHERE banner_page='product' AND banner_position='Top Banner' ORDER BY RAND()");
    $this->load->view('products/view_product_listing', $data);
  }

}
