<?php
include_once("include/main.inc.php");
$hover = 'blog';

$blog_query = mysqli_query($GLOBALS['dbconn'], "select catImage,catName,blogDname,catDesc,blog_written,blogDate from blog_tbl WHERE status = 'Y'");

$page_metatitle = "Blog | Organic Herbal Products Manufacturers in Ahmadpur East – HR Herbals International";

$page_metakey = "Organic Herbal Products Manufacturers in Ahmadpur East, HR Herbals International Blog, Herbal Industry Trends Ahmadpur East, Organic Herbal Products Manufacturers, Latest Blogs on Herbal Manufacturing";

$page_metadesc = "Explore expert blogs by HR Herbals International on Herbal Products Manufacturers in Ahmadpur East. Stay updated with industry trends, insights, and innovations.";





?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php include "app_top.php"; ?>
</head>

<body>
    <?php include 'app_header.php'; ?>

    <div class="heading_banner" style="background-image: url(<?= site_url; ?>/designer/images/blog-banner.jpg)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Blogs</h1>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>

    <div class="inner_breadcrumb hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?= site_url; ?>" title="Home">Home</a></li>
                        <li class="active">Blogs</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="blog_page">
        <div class="container">
            <h2 class="title_2">Our Blogs</h2>
            <div class="maxWidth">
                <p>Stay informed with the latest blogs covering natural wellness, herbal solutions, and sustainable living. Explore expert insights, industry trends, and health benefits of organic products. From essential oils to eco-friendly innovations, discover valuable knowledge to enhance your lifestyle. Stay updated, stay inspired, and embrace nature’s best with every read. New blogs are posted regularly!</p>
            </div>
            <div class="clearfix"></div>
            <div class="row">
                <?php



                while ($blog_res = mysqli_fetch_array($blog_query)) {

                    if ($blog_res['catImage'] != '') {

                        $blog_img =  getImage($blog_res['catImage'], 416, 280, $blog_res['catName'], "/uploaded-files/blog/images/");
                    } else {

                        $blog_img = NO_IMG_URL;
                    }


                    $blog_shortdesc = str_ireplace('{companyName}', $admin_res['companyName'], $blog_res['catDesc']);

                ?>
                    <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">


                        <div class="homeBlog">
                            <div class="blog-photo clip-home">
                                <a href="<?= site_url; ?>/blog/<?= getValidFileName($blog_res['catName']); ?>.htm" title="<?= $blog_res['blogDname']; ?>">
                                    <img src="<?= $blog_img; ?>" class="bp" alt="<?= $blog_res['blogDname']; ?>" title="<?= $blog_res['blogDname']; ?>">
                                </a>
                                <!-- <div class="date-box">
                                <span>05</span>March
                            </div> -->
                            </div>
                            <div class="detail">
                                <h3 class="blogsTitle"><a href="<?= site_url; ?>/blog/<?= getValidFileName($blog_res['catName']); ?>.htm" title="<?= $blog_res['blogDname']; ?>"><?= $blog_res['blogDname']; ?></a></h3>
                                <p><?= substr($blog_shortdesc, 0, 150); ?></p>
                                <a href="<?= site_url; ?>/blog/<?= getValidFileName($blog_res['catName']); ?>.htm" class="moreBtn2" title="Read More">Read More
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right-circle-fill" viewBox="0 0 16 16">
                                        <path d="M8 0a8 8 0 1 1 0 16A8 8 0 0 1 8 0M4.5 7.5a.5.5 0 0 0 0 1h5.793l-2.147 2.146a.5.5 0 0 0 .708.708l3-3a.5.5 0 0 0 0-.708l-3-3a.5.5 0 1 0-.708.708L10.293 7.5z" />
                                    </svg>
                                </a>
                            </div>
                        </div>

                    </div>
                <?php } ?>

            </div>

        </div>
    </div>
    <?php include 'app_clients.php'; ?>
    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>