<?php 
include_once("include/main.inc.php"); 
$page_metatitle = "Gallery | " . COMPANY_NAME;
$page_metakey = "Product Gallery, Image Gallery, Portfolio, Photo Showcase, Visual Collection";
$page_metadesc = "View the gallery of HHW Care Products showcasing our advanced manufacturing capabilities and premium mobility solutions trusted across India.";
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php include "app_top.php"; ?>
</head>

<body>

    <?php include "app_header.php"; ?>

    <section class="heading_banner" style="background-image: url(<?=site_url;?>/designer/images/gallery-banner.jpg)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Video Gallery - <?=$admin_res['companyName'];?></h1>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </section>

    <div class="inner_breadcrumb hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?=site_url;?>" title="Home">Home</a></li>
                        <li class="active">Video Gallery</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>


    <section class="gallery_page">
        <div class="container">
            <h2 class="title_2">Video <span> Gallery</span></h2>
            <div class="clearfix"></div>
            <div class="row g-3 row-cols-1 row-cols-md-2 row-cols-lg-3">
            <?php $gallery_video = mysqli_query($GLOBALS['dbconn'], "select slink_title,slink_url,id from video_tbl order by id Asc");

while ($video_res = mysqli_fetch_assoc($gallery_video)) {
?>
                <div class="col">
                    <div class="vidBx">
                        <a href="https://www.youtube.com/embed/<?= $video_res['slink_url']; ?>" title="<?= $video_res['slink_title']; ?> in <?=$admin_res['targetlocation'];?>" data-fancybox="" class="imgBx">
                            <img src="https://img.youtube.com/vi/<?= $video_res['slink_url']; ?>/maxresdefault.jpg" alt="<?= $video_res['slink_title']; ?> in <?=$admin_res['targetlocation'];?>" title="<?= $video_res['slink_title']; ?> in <?=$admin_res['targetlocation'];?>">
                            <span class="video-play-icon">
                                <svg version="1.1" viewBox="0 0 68 48" width="50">
                                    <path class="ytp-large-play-button-bg" d="M66.52,7.74c-0.78-2.93-2.49-5.41-5.42-6.19C55.79,.13,34,0,34,0S12.21,.13,6.9,1.55 C3.97,2.33,2.27,4.81,1.48,7.74C0.06,13.05,0,24,0,24s0.06,10.95,1.48,16.26c0.78,2.93,2.49,5.41,5.42,6.19 C12.21,47.87,34,48,34,48s21.79-0.13,27.1-1.55c2.93-0.78,4.64-3.26,5.42-6.19C67.94,34.95,68,24,68,24S67.94,13.05,66.52,7.74z" fill="#f00"></path>
                                    <path d="M 45,24 27,14 27,34" fill="#fff"></path>
                                </svg>
                            </span>
                        </a>
                        <div class="txBx"><?= $video_res['slink_title']; ?></div>
                    </div>
                </div>
                <?php } ?>
                </div>
        </div>
    </section>

    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>