<?php
include_once("include/main.inc.php");
$hover = 'gallery';
$page_metatitle = "Certificates of " . COMPANY_NAME;
$page_metakey = "Certifications, Quality Certifications, Industry Certifications, Authorized Certifications, Official Certificates";
$page_metadesc = "Explore the certifications of HHW Care Products, highlighting our commitment to premium quality as leading manufacturers of mobility solutions in India.";
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php include "app_top.php"; ?>
</head>

<body>
    <?php include "app_header.php"; ?>
    <section class="heading_banner" style="background-image: url(<?= site_url; ?>/designer/images/about/about-us.jpg)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title"> Certificates - <?= $admin_res['companyName']; ?></h1>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </section>

    <div class="inner_breadcrumb hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?= site_url; ?>" title="Home">Home</a></li>
                        <li class="active">Certificates</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="testimonial_page">
        <div class="container">
            <div class="tt-bx mb-4">
                <div class="tt"><span>Certificates</span></div>
                <p>Our certifications speak volumes about our commitment to quality and excellence. Each certificate highlights our dedication to delivering reliable and premium mobility solutions. From adhering to industry standards to ensuring customer trust, our achievements reflect our promise to provide only the best. Explore our certifications and see the standards that drive us forward.</p>
            </div>
            <div class="row g-4 row-cols-1 row-cols-md-2 row-cols-lg-4 justify-content-center">
                <?php $certificate_sql = mysqli_query($GLOBALS['dbconn'], "select * from certificates_tbl order by id ASC");
                if (mysqli_num_rows($certificate_sql) > 0) {
                    while ($certificate_res = mysqli_fetch_assoc($certificate_sql)) {
                        $certificateImg = getImage($certificate_res[gallery_image], 480, 480, $certificate_res[gallery_title] . $certificate_res[id], "/uploaded-files/certificates/");
                        $certificateImg1 = getImage($certificate_res[gallery_image], 1000, 800, $certificate_res[gallery_title] . $certificate_res[id], "/uploaded-files/certificates/");
                        ?>
                        <div class="col">
                            <div class="certificate-bx">
                                <a class="img" href="<?= site_url; ?>/uploaded-files/certificates/<?= $certificate_res['catalog']; ?>" title="<?= $certificate_res['image_name']; ?>" target="_blank">
                                    <img src="<?= site_url; ?>/uploaded-files/certificates/<?= $certificate_res['gallery_image']; ?>" alt="<?= $certificate_res['image_name']; ?>" title="<?= $certificate_res['image_name']; ?>">
                                </a>
                                <div class="tt"><?= $certificate_res['image_name']; ?></div>
                            </div>
                        </div>
                <?php }
                } ?>

            </div>
        </div>
    </div>

    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>