<?php
include_once("include/main.inc.php");

$page_metatitle = "Testimonials of " . COMPANY_NAME;
$page_metakey = "Customer Testimonials, Client Reviews, Customer Feedback, Product Reviews User Experiences";
$page_metadesc = "Read testimonials from satisfied customers about HHW Care Products, leaders in mobility solutions and trusted manufacturers in India since 1998.";
?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    
    
    <?php include "app_top.php"; ?>
</head>

<body>
    <?php include "app_header.php"; ?>
    <section class="heading_banner" style="background-image: url(<?= site_url; ?>/designer/images/clients-banner.jpg)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Testimonials - <?=$admin_res['companyName'];?></h1>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </section>

    <div class="inner_breadcrumb hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?= site_url; ?>" title="Home">Home</a></li>
                        <li class="active">Testimonial</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <section class="testimonial_page">
        <div class="container">
            <div class="tt-bx mb-5">
                <h2 class="tt">What Our <span>Customer Says?</span></h2>
                <p>Hear from those who’ve experienced the difference! Our testimonials showcase real stories of enhanced mobility and independence. From exceptional product quality to outstanding service, our customers share how our solutions have transformed their lives. Explore their journeys and discover why we’re trusted by so many to deliver comfort, reliability, and innovation every step of the way.</p>
            </div>
            <div class="row g-4 row-cols-1 row-cols-md-2 row-cols-lg-3">
            <?php
                $i = 1;
                $testimonial2 = mysqli_query($GLOBALS['dbconn'], "select slno, person_city, title, description, image from safe_business_tbl where status='Y' ORDER BY slno ASC");
                while ($testimonial_res2 = mysqli_fetch_assoc($testimonial2)) {
                    $user_name = $testimonial_res2['title'];
                    $fstchar = substr($user_name, 0, 1);
                    $first_letter = strtoupper(substr($testimonial_res2['title'], 0, 1));
                ?>

                <div class="col mb-2">
                    <div class="review-bx h-100">
                        <div class="qut-icon">
                            <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                                <path fill-rule="evenodd" d="M6 6a2 2 0 0 0-2 2v3a2 2 0 0 0 2 2h3a3 3 0 0 1-3 3H5a1 1 0 1 0 0 2h1a5 5 0 0 0 5-5V8a2 2 0 0 0-2-2H6Zm9 0a2 2 0 0 0-2 2v3a2 2 0 0 0 2 2h3a3 3 0 0 1-3 3h-1a1 1 0 1 0 0 2h1a5 5 0 0 0 5-5V8a2 2 0 0 0-2-2h-3Z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="img-bx">
                            <img src="<?= site_url; ?>/uploaded-files/testimonials/<?= $testimonial_res2['image']; ?>" 
                            alt="<?= $testimonial_res2['title']; ?>"
                            title="<?= $testimonial_res2['title']; ?>">>
                        </div>
                        <div class="body">
                        <?= $testimonial_res2['description']; ?>
                        </div>
                        <div class="name"><?= $testimonial_res2['title']; ?></div>
                        <div class="post"><?= $testimonial_res2['person_city']; ?></div>
                    </div>
                </div>
                <?php } ?>


                <!-- <div class="col mb-2">
                    <div class="review-bx h-100">
                        <div class="qut-icon">
                            <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                                <path fill-rule="evenodd" d="M6 6a2 2 0 0 0-2 2v3a2 2 0 0 0 2 2h3a3 3 0 0 1-3 3H5a1 1 0 1 0 0 2h1a5 5 0 0 0 5-5V8a2 2 0 0 0-2-2H6Zm9 0a2 2 0 0 0-2 2v3a2 2 0 0 0 2 2h3a3 3 0 0 1-3 3h-1a1 1 0 1 0 0 2h1a5 5 0 0 0 5-5V8a2 2 0 0 0-2-2h-3Z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="img-bx">
                            <img src="designer/images/icon/men1.png" alt="Students">
                        </div>
                        <div class="body">
                           Lorem, ipsum dolor sit amet consectetur adipisicing elit. Labore magnam nostrum impedit earum quod, aperiam doloribus amet est ducimus nam, tenetur ut maiores eum quaerat eveniet minima accusantium illo aliquam!
                        </div>
                        <div class="name">Tushar Patil</div>
                        <div class="post">XYZ India Pvt. Ltd.</div>
                    </div>
                </div>
                <div class="col mb-2">
                    <div class="review-bx h-100">
                        <div class="qut-icon">
                            <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                                <path fill-rule="evenodd" d="M6 6a2 2 0 0 0-2 2v3a2 2 0 0 0 2 2h3a3 3 0 0 1-3 3H5a1 1 0 1 0 0 2h1a5 5 0 0 0 5-5V8a2 2 0 0 0-2-2H6Zm9 0a2 2 0 0 0-2 2v3a2 2 0 0 0 2 2h3a3 3 0 0 1-3 3h-1a1 1 0 1 0 0 2h1a5 5 0 0 0 5-5V8a2 2 0 0 0-2-2h-3Z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="img-bx">
                            <img src="designer/images/icon/men1.png" alt="Students">
                        </div>
                        <div class="body">
                           Lorem, ipsum dolor sit amet consectetur adipisicing elit. Labore magnam nostrum impedit earum quod, aperiam doloribus amet est ducimus nam, tenetur ut maiores eum quaerat eveniet minima accusantium illo aliquam!
                        </div>
                        <div class="name">Tushar Patil</div>
                        <div class="post">XYZ India Pvt. Ltd.</div>
                    </div>
                </div>
                <div class="col mb-2">
                    <div class="review-bx h-100">
                        <div class="qut-icon">
                            <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                                <path fill-rule="evenodd" d="M6 6a2 2 0 0 0-2 2v3a2 2 0 0 0 2 2h3a3 3 0 0 1-3 3H5a1 1 0 1 0 0 2h1a5 5 0 0 0 5-5V8a2 2 0 0 0-2-2H6Zm9 0a2 2 0 0 0-2 2v3a2 2 0 0 0 2 2h3a3 3 0 0 1-3 3h-1a1 1 0 1 0 0 2h1a5 5 0 0 0 5-5V8a2 2 0 0 0-2-2h-3Z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="img-bx">
                            <img src="designer/images/icon/men1.png" alt="Students">
                        </div>
                        <div class="body">
                           Lorem, ipsum dolor sit amet consectetur adipisicing elit. Labore magnam nostrum impedit earum quod, aperiam doloribus amet est ducimus nam, tenetur ut maiores eum quaerat eveniet minima accusantium illo aliquam!
                        </div>
                        <div class="name">Tushar Patil</div>
                        <div class="post">XYZ India Pvt. Ltd.</div>
                    </div>
                </div>
                <div class="col mb-2">
                    <div class="review-bx h-100">
                        <div class="qut-icon">
                            <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                                <path fill-rule="evenodd" d="M6 6a2 2 0 0 0-2 2v3a2 2 0 0 0 2 2h3a3 3 0 0 1-3 3H5a1 1 0 1 0 0 2h1a5 5 0 0 0 5-5V8a2 2 0 0 0-2-2H6Zm9 0a2 2 0 0 0-2 2v3a2 2 0 0 0 2 2h3a3 3 0 0 1-3 3h-1a1 1 0 1 0 0 2h1a5 5 0 0 0 5-5V8a2 2 0 0 0-2-2h-3Z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="img-bx">
                            <img src="designer/images/icon/men1.png" alt="Students">
                        </div>
                        <div class="body">
                           Lorem, ipsum dolor sit amet consectetur adipisicing elit. Labore magnam nostrum impedit earum quod, aperiam doloribus amet est ducimus nam, tenetur ut maiores eum quaerat eveniet minima accusantium illo aliquam!
                        </div>
                        <div class="name">Tushar Patil</div>
                        <div class="post">XYZ India Pvt. Ltd.</div>
                    </div>
                </div>
                <div class="col mb-2">
                    <div class="review-bx h-100">
                        <div class="qut-icon">
                            <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                                <path fill-rule="evenodd" d="M6 6a2 2 0 0 0-2 2v3a2 2 0 0 0 2 2h3a3 3 0 0 1-3 3H5a1 1 0 1 0 0 2h1a5 5 0 0 0 5-5V8a2 2 0 0 0-2-2H6Zm9 0a2 2 0 0 0-2 2v3a2 2 0 0 0 2 2h3a3 3 0 0 1-3 3h-1a1 1 0 1 0 0 2h1a5 5 0 0 0 5-5V8a2 2 0 0 0-2-2h-3Z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="img-bx">
                            <img src="designer/images/icon/men1.png" alt="Students">
                        </div>
                        <div class="body">
                           Lorem, ipsum dolor sit amet consectetur adipisicing elit. Labore magnam nostrum impedit earum quod, aperiam doloribus amet est ducimus nam, tenetur ut maiores eum quaerat eveniet minima accusantium illo aliquam!
                        </div>
                        <div class="name">Tushar Patil</div>
                        <div class="post">XYZ India Pvt. Ltd.</div>
                    </div>
                </div> -->

                
            
            
            
            
            </div>
        </div>
    </section>
    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>