<?php 
include_once("include/main.inc.php");
$hover = 'Photo Gallery';
$page_metatitle = "Photo Gallery | Piles & Fistula Treatment Center in Delhi – Goyal Laser Centre";
$page_metakey = "Piles Treatment Center in Delhi, Fistula Treatment in Delhi, Piles and Fistula Specialist in Delhi, Piles Clinic in Delhi, Photo Gallery of Piles Treatment Center, Piles Surgery in Delhi";
$page_metadesc = "Explore the photo gallery of Goyal Laser Centre, a leading Piles & Fistula Treatment Center in Delhi. See our advanced facilities and successful treatments.";

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <?php include "app_top.php"; ?>
</head>

<body>

    <?php include "app_header.php"; ?>


    <div class="heading_banner" style="background-image: url(<?=site_url;?>/designer/images/about-banner.jpg)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Photo Gallery - <?=$admin_res['companyName'];?></h1>
                    <div class="clearfix"></div>
              
                </div>
            </div>
        </div>
    </div>

    <div class="breadcrumbSection hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?=site_url;?>" title="Home">Home</a></li>
                        <li class="active">Photo Gallery</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>


    <div class="gallery_page">
        <div class="container">
            <h2 class="title_2">Photo Gallery</h2>
            <div class="maxWidth">
                <p>Step into moments that capture healing, care, and advanced medical excellence. This gallery highlights modern facilities, patient care experiences, and milestones that reflect dedication and trust. Each photo shares a glimpse into the journey of transformation—where comfort meets technology, and every visit brings someone closer to relief, recovery, and renewed confidence.</p>
            </div>

            <div class="clearfix"></div>
            <div class="row">
            <?php $gallery_award_sql= mysqli_query($GLOBALS['dbconn'], "select title,image,gallery_id,id from photo_tbl order by id DESC"); 
while($gallery_res= mysqli_fetch_assoc($gallery_award_sql)){ 
   $galImg=getImage($gallery_res[image], 380, 380, $gallery_res[title].$gallery_res[id],"/uploaded-files/gallery/photos/");
   $galImg1= getImage($gallery_res[image], 1000, 1000, $gallery_res[title].$gallery_res[id],"/uploaded-files/gallery/photos/") ;
   ?>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                    <div class="gallery_item">
                        <a class="hover_effect h_yellow" data-fancybox="photo-gallery"
                            href="<?=$galImg1;?>" title="<?=$gallery_res['title'];?>">
                            <img src="<?=$galImg;?>" alt="<?=$gallery_res['title'];?>" title="<?=$gallery_res['title'];?>">
                        </a>
                    </div>
                </div>
                <?php } ?>

            </div>
        </div>
    </div>


    <?php include "app_footer.php"; ?>
    <?php include "app_bottom.php"; ?>
</body>

</html>