
(function ($) {
    $('.menuToggle').on('click', function () {
        $('.sidemenu').toggleClass('collapsed');
    });

    /* Notification*/
    $(".notificationBtn").click(function (event) {
        $(".topNotificationDiv").toggle();
        event.stopPropagation();
        $(".userDropdown").hide();
    });

    $(document).click(function (event) {
        if (!$(event.target).closest(".topNotification").length) {
            $(".topNotificationDiv").hide();
        }
    });

    /* User Drop down*/
    $(".userClick").click(function (event) {
        $(".userDropdown").toggle();
        event.stopPropagation();
        $(".topNotificationDiv").hide();
    });

    $(document).click(function (event) {
        if (!$(event.target).closest(".dashboardUser").length) {
            $(".userDropdown").hide();
        }
    });

    /* Menu */
    // Dropdowns

    // if ($(".menu").length) {

    //     $(".menu .submenu > a").append(`
    //       <button class="expander">
    //         <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
    //           <path fill-rule="evenodd" d="M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z"/>
    //         </svg>
    //       </button>
    //     `);


    //     $(".menu").on("click", ".expander", function (e) {
    //         e.preventDefault();
    //         var $dropdown = $(this).closest("li").find(".menuDropdown");
    //         $dropdown.slideToggle();
    //         $(this).toggleClass("rotated");
    //     });
    // }



    $(document).ready(function () {
        if ($(".menu").length) {

            // Append dropdown-expander button to submenu links
            $(".menu .submenu > a").append(`
            <button class="expander">
             <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"></path></svg>
            </button>
          `);

            // Handle dropdown expand/collapse with accordion behavior
            $(".menu").on("click", ".expander", function (e) {
                e.preventDefault();
                e.stopPropagation();
                var $currentDropdown = $(this).closest("li").find(".menuDropdown");
                // Close all open dropdowns except the current
                $(".menu .menuDropdown").not($currentDropdown).slideUp();
                $(".menu .expander").not(this).removeClass("active");
                // Toggle the current dropdown
                $currentDropdown.slideToggle();
                $(this).toggleClass("active");
            });

        }
    });

    $(document).ready(function () {
        var $slimScrolls = $('.slimscroll');

        if ($slimScrolls.length) {
            var setSlimscrollHeight = function () {
                var height = $(window).height() - 60;
                $slimScrolls.add('.sidebar .slimScrollDiv').height(height);
            };

            $slimScrolls.slimScroll({
                height: 'auto',
                width: '100%',
                position: 'right',
                size: '7px',
                color: '#ccc',
                wheelStep: 10,
                touchScrollStep: 100
            });

            setSlimscrollHeight();
            $(window).on('resize', setSlimscrollHeight);
        }
    });


    $('.select-all').on('click', function () {
        const group = $(this).closest('.dashboardTable');
        const checkboxes = group.find('.singleCheck');
        checkboxes.prop('checked', this.checked);
    });
    // Individual checkboxes update "Select All" status
    $('.singleCheck').on('click', function () {
        const group = $(this).closest('.dashboardTable');
        const all = group.find('.singleCheck');
        const allChecked = all.length === all.filter(':checked').length;
        group.find('.select-all').prop('checked', allChecked);
    });

    $('.selectOne').SumoSelect();

    $(document).ready(function () {
        $('.toolTip').hover(function () {
            const tooltipText = $(this).data('tooltip');
            const tooltip = $('<div class="tooltipBox"></div>').text(tooltipText);
            $('body').append(tooltip);

            const offset = $(this).offset();
            const elWidth = $(this).outerWidth();
            const elHeight = $(this).outerHeight();
            const ttWidth = tooltip.outerWidth();
            const ttHeight = tooltip.outerHeight();

            tooltip.css({
                top: offset.top - ttHeight - 5,
                left: offset.left + (elWidth / 2) - (ttWidth / 2)
            }).fadeIn(200);

            $(this).data('tooltipElement', tooltip);
        }, function () {
            const tooltip = $(this).data('tooltipElement');
            tooltip.fadeOut(100, function () {
                $(this).remove();
            });
        });
    });

})(jQuery);
