
<script src="designer/js/bootstrap.min.js"></script>
<script src="designer/js/wow.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<script src="designer/js/jquery.sumoselect.min.js"></script>
<script src="designer/intl-tel-input/js/intlTelInputWithUtils.min.js"></script>
<script src="designer/js/theme.js"></script>
<script>
    $(document).ready(function() {
        const $trendingBox = $('#trendingBox');
        const $searchInput = $('#searchInput');
        const $clearAllBtn = $('#clearAllBtn');
        const $searchWrapper = $('.searchWrapper');
        const $trendList = $('.trend-list');

        // Show on focus
        $searchInput.on('focus', function() {
            $trendingBox.slideDown(150);
        });

        // Hide when clicking anywhere outside the wrapper
        $(document).on('click', function(e) {
            if (!$(e.target).closest('.searchWrapper').length) {
                $trendingBox.slideUp(150);
            }
        });

        // Click on trending search
        $('.trend-list li').on('click', function() {
            const term = $(this).data('term');
            $searchInput.val(term);
            $trendingBox.slideUp(150);
            window.location.href = `https://www.google.com/search?q=${encodeURIComponent(term)}`;
        });

        // Press Enter to search
        $searchInput.on('keydown', function(e) {
            if (e.key === 'Enter') {
                const term = $(this).val().trim();
                if (term !== '') {
                    $trendingBox.slideUp(150);
                    window.location.href = `https://www.google.com/search?q=${encodeURIComponent(term)}`;
                }
            }
        });

        // Delete individual trending item
        $('.delete-btn').on('click', function(e) {
            e.stopPropagation(); // Prevent click event from propagating to the li element
            $(this).parent().remove();

            // Check if the list is empty and hide the "Clear All" button
            if ($trendList.children().length === 0) {
                $clearAllBtn.hide();
                // Hide the trending box and title
                $trendingBox.slideUp(150);
            }
        });

        // Clear all trending items
        $clearAllBtn.on('click', function() {
            $trendList.empty(); // Remove all items
            $(this).hide(); // Hide the Clear All button
            // Hide the trending box and title
            $('.trending-title').html('No Trending Searches');
            $trendingBox.slideUp(150);
        });

        // Show the Clear All button only if there are items in the list
        if ($trendList.children().length > 0) {
            $clearAllBtn.show();
        }
    });
</script>

<script>
    $(document).ready(function() {
        const placeholders = [
            "Search apparel Manufacturer...",
            "Search agriculture manufacturers...",
            "Search building & construction manufacturers...",
            "Search chemicals manufacturers...",
            "Search computer & electronics manufacturers..."
        ];
        let index = 0;
        const input = $("#searchInput");

        setInterval(() => {
            input.attr("placeholder", placeholders[index]);
            index = (index + 1) % placeholders.length;
        }, 2000); // Change every 2 seconds
    });
</script>

<script>
    function packageMobileCountrySection() {
        const inputVacations = document.querySelectorAll(".telePhone");

        inputVacations.forEach(inputVacation => {
            // Remove placeholder text
            inputVacation.removeAttribute('placeholder');
            // or
            // inputVacation.setAttribute('placeholder', ''); // if you prefer to set it as an empty string

            window.intlTelInput(inputVacation, {
                initialCountry: "in",
                allowDropdown: true,
                separateDialCode: true,
                countrySearch: true,
                //autoPlaceholder: "off",
                useFullscreenPopup: false,
            });


            $(inputVacation).siblings('.iti__country-list').on('click', 'li', function() {
                const dialCode = $(".iti__dial-code", this).text();
                const countryName = $(".iti__country-name", this).text();

                $(inputVacation).siblings('.code').val(dialCode);
                $(inputVacation).siblings('.countryName').val(countryName);
            });
        });
    }

    packageMobileCountrySection();
</script>