/*global jQuery, define, module, require, (Y-m-d)*/
/*!
 * jQuery Custom Js v1

  2024-08-07 
 */

(function (factory) {
	if (typeof define === "function" && define.amd) {
		define(["jquery"], factory);
	} else if (typeof module === "object" && module.exports) {
		module.exports = factory(require("jquery"));
	} else {
		factory(jQuery);
	}
}(function ($) {
	$.fn.extend({
		// Read More ===============================================================

		readMore: function (options) {
			let _defaults = {
				'textLength': 50,
				'type': 'toggle', // 'toggle', 'dropdown', 'popover
				'heading': '',
				'endText': '...',
				'readMoreBtn': 'Read more',
				'readLessBtn': 'Read less',
				'btnInNewLine': true,
			}

			return this.each(function () {
				let settings = $.extend({}, _defaults, options);
				let elem = $(this);
				let fullText = elem.text();
				let fullElemHTML = elem.html();
				let textLength = settings.textLength;
				let heading = settings.heading ? `<h5><b>${settings.heading}</b></h5>` : '';
				let newLine = settings.btnInNewLine ? 'd-table' : '';
				if (settings.type == 'dropdown') {
					if (fullText.length > textLength) {
						let read_more = `         
						   <span class="jc_dropdown dropdown-menu p-4 text-body-secondary border" style="max-width: 600px;">
							  ${heading}
							  ${elem.html()}
						   </span>        
						   <span class="jc_rm_dp_btn ${newLine}" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true" role="button">${settings.readMoreBtn}</span>`;
						let text = `<span>${fullText.trim().substring(0, textLength) + settings.endText}</span>`;
						elem.html(text + read_more);
					}
				}

				if (settings.type == 'popover') {
					if (fullText.length > textLength) {
						let read_more = `<span class="${newLine}" data-bs-toggle="popover" data-bs-trigger="hover" title="${settings.heading || ''}" data-bs-content="${fullText}" role="button">${settings.readMoreBtn}</span>`;
						let text = `<span>${fullText.trim().substring(0, textLength) + settings.endText}</span>`;
						elem.html(text + read_more);
						popover();
					}
				}

				if (settings.type == 'toggle') {
					if (fullText.length > textLength) {
						let text = fullText.trim().substring(0, textLength) + settings.endText;
						elem.html(text + less_more_toggle(false));
						elem.on('click', '.jc_rm_btn', _ => elem.html(fullElemHTML + less_more_toggle(true)));
						elem.on('click', '.jc_rl_btn', _ => elem.html(text + less_more_toggle(false)))
					}
				}

				function less_more_toggle(status) {
					let isShow = status;
					let btnText = isShow ? settings.readLessBtn : settings.readMoreBtn;
					let btnClass = isShow ? 'jc_rl_btn' : 'jc_rm_btn';
					return `<span class="${btnClass} ${newLine}" role="button">${btnText}</span>`;
				}
			})
		},

		// Currency ==========================================================

		numToCurrency: function (options) {
			let _defaults = {
				locale: 'hi-IN',
				toFixed: 0,
				style: 'currency',
				currency: 'INR'
			}
			return this.each(function () {
				let settings = $.extend({}, _defaults, options);
				let elem = $(this);

				let num = elem.text().trim();
				if (num.match(/^-?\d+(?:\.\d+)?$/)) {
					let val = Number(num).toLocaleString(settings.locale, {
						maximumFractionDigits: settings.toFixed,
						style: settings.style,
						currency: settings.currency
					});
					elem.html(val);
				}
			})
		},

		// Open Bootstrap Modal  ====================================

		openModal: function (url, placeholder) {
			let _curElem = $(this);
			let _curElemHTML = _curElem.html();

			let _defaults = {
				url: _curElem.attr('data-url'),
				placeholder: '#popupModalPlaceholder'
			}
			let settings = $.extend({}, _defaults);
			placeholder = placeholder || settings.placeholder;
			url = url || settings.url;

			let _curModal = function (modal) {
				return new bootstrap.Modal(modal);
			}
			let _emptyPlaceholder = function () {
				$(placeholder).empty();
			}
			let _done = function (res) {
				$(placeholder).append(res)
				let modal = $(placeholder).find('.modal');
				if (modal.length) {
					_curModal(modal.get(0)).show();
				} else {
					alert('Error, Modal Not Found.');
					_emptyPlaceholder();
				}
				$.jQuery_utils_INIT();
			}
			let _fail = function (err) {
				alert(`Error Code ${err.status}, ${err.statusText}`);
			}
			let _always = function () {
				$.btnLoader(_curElem, _curElemHTML, false);
			}
			$.btnLoader(_curElem, _curElemHTML, true);
			$.get(url, _emptyPlaceholder()).done(_done).fail(_fail).always(_always);
		},

		// Save Form Data ===================================================

		saveFormData: function (status) {
			status = (status !== 'test') ? 'live' : status;
			let _elem = $(this);
			let _form = _elem.closest('form');
			let _props = {};
			let _validateProps = {};

			_props['type'] = 'post';
			_props['contentType'] = false;
			_props['cache'] = false;
			_props['processData'] = false;

			_props['success'] = function (data) {
				status !== 'live' && console.log(data)
				let msg = $.isValidJSON(data) ? JSON.parse(data).msg : data;
				let err = $.isValidJSON(data) && JSON.parse(data).err;
				if (err) {
					alert(err);
				}
				if (msg) {
					alert(msg);
					if (status === 'live') {
						if (_form.data('redirect') != undefined) {
							location.href = _form.data('redirect');
						} else {
							location.reload()
						}
					}
				}
			}
			_props['error'] = function (err) {
				alert(`Error Code ${err.status}, ${err.statusText}`);
				status === 'live' && location.reload();
				status !== 'live' && console.log(err);
			}
			_props['complete'] = function () {
				$('.loading').hide()
			}
			_validateProps['submitHandler'] = function (form) {
				_props['url'] = form.action;
				_props['data'] = new FormData(form);
				status === 'live' && $('.loading').show();
				$.ajax(_props);
			}
			_form.validate(_validateProps);
		}
	})


	$.extend({
		numToCurrency: function (num, options) {
			let _defaults = {
				locale: 'hi-IN',
				toFixed: 0,
				style: 'currency',
				currency: 'INR'
			}
			let settings = $.extend({}, _defaults, options);
			if (num.toString().match(/^-?\d+(?:\.\d+)?$/)) {
				let val = Number(num).toLocaleString(settings.locale, {
					maximumFractionDigits: settings.toFixed,
					style: settings.style,
					currency: settings.currency
				});
				return val;
			}
			return num;
		},

		addGst: function (amount, isTrue) {
			// return amount with gst if (bool) 'isTrue' val is true else return amount
			return isTrue && typeof isTrue === 'boolean' ? Number(amount) * 1.18 : Number(amount);
		},

		getGst: function (amount) {
			return amount > 0 && Number(amount) * 0.18 || 0;
		},

		sumArrayVals: function (arr) {
			return arr.map(Number).reduce((acc, cur) => acc + cur, 0);
		},

		sum: function (...args) {
			// check if only one argument
			if (args.length === 1) {
				// if args[0] is array, sum the values of all items in array
				if (Array.isArray(args[0])) {
					return ($.sumArrayVals(args[0]));
				}
				// return the same argument value
				return args[0];
			}
			// check if it has more than one args.
			if (args.length > 1) {
				return ($.sumArrayVals(args));
			}
			// if no args found return undefined
			return;
		},

		sumInp: function (val) {
			return $(val) ? $.sum($(val).get().map(x => x.value)) : 0;
		},

		isValidJSON: function (str) {
			try {
				JSON.parse(str);
			} catch (e) {
				return false;
			}
			return true;
		},

		formatNumber: function (num) {
			if (num >= 1e9) {
				return (num / 1e9).toFixed(1) + 'B';
			}
			if (num >= 1e6) {
				return (num / 1e6).toFixed(1) + 'M';
			}
			if (num >= 1e3) {
				return (num / 1e3).toFixed(1) + 'K';
			}
			return num;
		},

		btnLoader: function (elem, elem_val, status = true) {
			let _elem = $(elem);
			let spinner = `<span class="spinner-border spinner-border-sm me-2" aria-hidden="true"></span><span role="status">Loading...</span>`;
			if (status === true) {
				_elem.html(spinner);
				_elem.prop('disabled', true)
			}
			if (status === false) {
				_elem.html(elem_val);
				_elem.prop('disabled', false)
			}
		},

		rm_init: function () {
			$("[data-rm]").each((_, elem) => {
				if (elem.classList.contains('box-rm-active')) return;
				let _data = elem.dataset;
				let _props = {};
				let _rm_txt = null;
				let _rl_txt = null;
				let _badge_color = null;
				let _types = ['toggle', 'dropdown', 'popover'];
				if (_data.rm !== undefined) {
					let _vals = _data.rm.split('-');
					_props['textLength'] = Number(_vals[0]);

					if (_props['textLength'] == 0) {
						_props['endText'] = '';
					}
					if (_types.includes(_vals[1])) {
						_props['type'] = _vals[1];
					}
					_badge_color = _vals[2] ?? 'info'
					_props['btnInNewLine'] = _vals[3] != 'inline';
				}
				if (_data.rmBtnText !== undefined) {
					let rm_btn_txt = _data.rmBtnText.split(',');
					_rm_txt = rm_btn_txt[0];
					_rl_txt = rm_btn_txt[1];
				}
				_props['readMoreBtn'] = `<span class="badge badge-${_badge_color}">${_rm_txt ?? 'View More'}</span>`;
				_props['readLessBtn'] = `<span class="badge badge-${_badge_color}">${_rl_txt ?? 'View Less'}</span>`;

				if (_data.rmHeading !== undefined) {
					_props['heading'] = _data.rmHeading.trim();
				}
				if (_props['textLength'] <= elem.textContent.trim().length) {
					elem.classList.add('box-rm-active')
					$(elem).readMore(_props);
				}
			});
		},

		currency_init: function () {
			$("[data-currency]").each((_, elem) => {
				let _data = elem.dataset;
				if (_data.currency == 'INR') {
					$(elem).numToCurrency();
				}
			});
		},

		slc_val_init: function () {
			$("[data-select-val]").each((_, item) => {
				if (item.classList.contains('slc_val_init')) return;
				let _data = item.dataset;
				if (_data.selectVal) {
					item.value = _data.selectVal;
					if (_data.selectChange == 'true') {
						$(item).change();
					}
					item.classList.add('slc_val_init');
				}
			});
		},

		timer_init: function () {
			$("[data-timer]").each((_, item) => {
				if (item.classList.contains('data-timer-init')) return;
				let _data = item.dataset;
				if (_data.timer) {
					let d_val = _data.timer.split('-');
					let t_sec = d_val[0];
					let t_label = d_val[1];
					setInterval(() => {
						t_sec++;
						let seconds = Number(t_sec);
						var d = Math.floor(seconds / (3600 * 24));
						var h = Math.floor(seconds % (3600 * 24) / 3600);
						var m = Math.floor(seconds % 3600 / 60);
						var s = Math.floor(seconds % 60);

						let t_html = '';
						if (t_label && t_label == 'label') {
							t_html += d > 0 ? d + (d == 1 ? " day, " : " days, ") : "";
							t_html += h > 0 ? h + (h == 1 ? " hour, " : " hours, ") : "";
							t_html += m > 0 ? m + (m == 1 ? " minute, " : " minutes, ") : "";
							t_html += s > 0 ? s + (s == 1 ? " second" : " seconds") : "0 second";
						} else {
							t_html += d > 0 ? `<span class="data-timer-field">${d <= 9 ? '0' + d : d}</span> : ` : '';
							t_html += h > 0 ? `<span class="data-timer-field">${h <= 9 ? '0' + h : h}</span> : ` : '';
							t_html += m > 0 ? `<span class="data-timer-field">${m <= 9 ? '0' + m : m}</span> : ` : '';
							t_html += `<span class="data-timer-field">${s <= 9 ? '0' + s : s}</span>`;
						}
						$(item).html(t_html);
					}, 1000);

					item.classList.add('data-timer-init');
				}
			});
		}, 

		openModal: function (url, placeholder) {
			placeholder = placeholder || '#openModalPlaceholder';
			let _curModal = function (modal) {
				return new bootstrap.Modal(modal);
			}
			let _emptyPlaceholder = function () {
				$(placeholder).empty();
			}
			let _done = function (res) {
				if(res !== 'noModal'){
					$(placeholder).append(res);
					let modal = $(placeholder).find('.modal');
					if (modal.length) {
						_curModal(modal.get(0)).show();
					} else {
						alert('Error, Modal Not Found.');
						_emptyPlaceholder();
					}
					$.jQuery_utils_INIT();
				}
			}
			let _fail = function (err) {
				alert(`Error Code ${err.status}, ${err.statusText}`);
			}
			url && $.get(url, _emptyPlaceholder()).done(_done).fail(_fail);
		},

		input_type_init: function () {
			$("[data-input-type]").each((_, item) => {
				if (item.classList.contains('data-inp-type-cls')) return;
				let _data = item.dataset;
				$(item).on('input', function (e) {
					e.preventDefault();
					if (_data.inputType === 'number') {
						item.value = item.value.replace(/[^0-9]/g, '');
					}
					if (_data.inputType === 'number_dot') {
						item.value = item.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1');
					}
				})
				item.classList.add('data-inp-type-cls');
			});
		},

		data_x_init: function () {
			$("[data-x]").each((_, item) => {
				let _elem = $(item);
				let _data = _elem.data('x');
				if (Array.isArray(_data) && _data.length) {
					let inp_selector = _data[0];
					let cond_val = _data[1];
					let target_cls = _data[2].split(',').map(x => x.trim()).filter(Boolean);
					let p_box = _data[3];
					let _elem_box = p_box !== void 0 ? _elem.closest(p_box) : _elem;
					let tagName = _elem_box.find(inp_selector).prop('tagName');
					let inpType = _elem_box.find(inp_selector).prop('type');
					let item_toggle = function (inp) {
						let is_cur_val = !Array.isArray(cond_val) ? inp.value == cond_val : cond_val.includes(inp.value);
						let is_active = inpType == 'radio' ? inp.checked && is_cur_val : is_cur_val;
						target_cls.forEach(cls => _elem_box.find('.x-' + cls).toggle(is_active));
						return is_active;
					}
					if (tagName == "SELECT" || inpType == 'radio') {
						_elem_box.find(inp_selector).each((_, inp) => {
							if (item_toggle(inp)) return false;
						});
						_elem_box.on('change', inp_selector, e => item_toggle(e.target));
					}
				}
			});
		},

		jQuery_utils_INIT: function () {
			$.rm_init();
			$.currency_init();
			$.data_x_init();
			$.slc_val_init();
			$.timer_init();
			$.input_type_init();
		}
	})
}));

