<?php $this->load->view('sitepanel/common/header-new'); ?>
<!-- main-content -->

<div class="content">
    
    <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success">
                <?php echo $this->session->flashdata('success'); ?>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger">
                <?php echo $this->session->flashdata('error'); ?>
            </div>
        <?php endif; ?>
        
        
        <div class="pageTitleSection">
            <div class="pageTitle_1"><button class="backButton" type="button">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0"></path>
                </svg> Back
            </button>
                Company Management
            </div>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?=base_url('sitepanel/dashboard')?>">Dashboard</a></li>
                <li class="breadcrumb-item active">Company Management</li>
            </ol>
            
        </div>

    
            <div class="col-12 col-sm-12">
                <div class="card">
                    
                    
                    
                    <form action="<?= base_url('sitepanel/company/import_csv') ?>" method="post" enctype="multipart/form-data" style="margin:20px">
                        <strong>Import Companies</strong>
                        <table width="100%" align="center" bgcolor="#999999" border="0" cellspacing="1" cellpadding="3" style="border:solid thin #CCC;">
                            <tr bgcolor="#FFFFFF">
                                <td>
                                    <input type="file" name="excel_file" />&nbsp;
                                    <span class="form-error"><?php echo form_error('excel_file'); ?></span>
                                    <input type="hidden" name="action" value="submit_excel" />
                                </td>
                            </tr>
                            <tr bgcolor="#FFFFFF">
                                <td colspan="2"><button type="submit" class="btn btn-primary">Import</button>
                                    <a href="<?php echo base_url() ?>assets/sitepanel/sample/sample_company.csv">Download Sample File</a>
                                </td>
                            </tr>
                        </table>
                    </form>
                            

                   <div class="card-header d-flex justify-content-between align-items-center">
                            <div class="statusSelect">
                                <?php $status = $this->input->get('status'); ?>
                                <select name="status" class="selectOne" onchange="filterByStatus(this)">
                                    <option value="" <?= $status == '' ? 'selected' : '' ?>>All statuses</option>
                                    <option value="active" <?= $status == 'active' ? 'selected' : '' ?>>Active Companies</option>
                                    <option value="inactive" <?= $status == 'inactive' ? 'selected' : '' ?>>Inactive Companies</option>
                                    <option value="new" <?= $status == 'new' ? 'selected' : '' ?>>New Companies</option>
                                </select>

                            </div>



                            <form class="tableSearchReset">
                                <div class="tableSearch">
                                    <input placeholder="Search users..." type="search" name="search" required value="<?= (isset($_GET['search'])) ? $_GET['search'] : '' ?>">
                                    <button type="submit" class="searchBtn"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"></path>
                                        </svg>
                                    </button>
                                </div>

                                <a href="<?= base_url('sitepanel/company') ?>" class="resetBtn" type="reset">Reset</a>
                            </form>
                            
                            <div class="view-all-link">
                                <a class="addCompanyBtn" href="<?= base_url('sitepanel/company/add') ?>">Add New Company</a>
                            </div>
                        </div>

                    <div class="card-body pb-3 example1-table">

                            <?= $this->paginator->dispaly_page_record_ipp(); ?>
                            <form id="bulkActionForm" method="post" action="<?= base_url('sitepanel/company/bulk_action') ?>">
                            <div class="table-responsive dataview">
                            <table class="table dashboardTable" id="my_data">
                                <thead>
                                    <tr>
                                        <th>
                                            <label class="checkboxs">
                                                <input type="checkbox" class="select-all" id="checkAll">
                                                <span class="checkmarks"></span>
                                            </label>
                                        </th>
                                        <th>SN.</th>
                                        <th>Company Details</th>
                                        <th>Contact Person Details</th>
                                        <th>Verify Status</th>
                                        
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    if(!empty($pagelist)){
                                    $i=1;
                                    foreach ($pagelist as $pageVal){ 
                                        
                                        
                                    $gm_business_type = $this->db->get_where('gm_business_type', array( 'id =' => $pageVal['primary_business_type']))->row_array();
                                    ?>
                                        
                                    <tr>
                                        <td>
                                            <label class="checkboxs">
                                                <input type="checkbox" name="company_ids[]" value="<?php echo $pageVal['company_id']; ?>" class="rowCheckbox">
                                                <span class="checkmarks"></span>
                                            </label>
                                        </td>
                                        <td><?= $pages+$i ?></td>
                                        <td><div class="companyName">
                                            
                                            <span><b>Company Name: </b></span><?= $pageVal['company_name'] ?><br>
                                            <span><b>Location: </b> </span><?= $pageVal['district'] ?>, <span></span><?= $pageVal['state'] ?>, <?= $pageVal['country'] ?> <br>
                                            <span><b>Business Type: </b></span><?= (!empty($gm_business_type['business_type'])) ? $gm_business_type['business_type'] : '' ?><br>
                                            <span><b>Address: </b></span><?= $pageVal['address'] ?><br>
                                            
                                
                                        
                                        </td>
                                        <td><div class="companyName">
                                            <span><b>Name: </b></span><?= $pageVal['primary_person_name'] ?><br>
                                            <span><b>Designation: </b></span><?= $pageVal['designation'] ?><br>
                                            <span><b>Mobile: </b></span><?= $pageVal['mobile'] ?><br>
                                            <span><b>Alt. Mobile: </b></span><?= $pageVal['alt_mobile'] ?><br>
                                            </div></td>  
                                            
                                        <td>
                                        
                                        
                                        <?php
                                        if($pageVal['verify_status']  == '0'){ ?>
                                            <span class="badge text-bg-secondary">Unverified</span>
                                            <?php
                                        }
                                        if($pageVal['verify_status']  == '1'){ ?>
                                            <span class="badge text-bg-success">Verified</span>
                                            <?php
                                        }
                                        ?>
                                        </td>
                                        <td><?=getStatusBadge($pageVal['status'])?></td>
                                        
                                        <td class="action-table-data">
                                            <div class="edit-delete-action">
                                                <a class="me-2 p-2 edit toolTip" href="<?= site_url('sitepanel/company/edit/'.$pageVal['company_id']. (!empty($_SERVER['QUERY_STRING']) ? '?' . $_SERVER['QUERY_STRING'] : '')) ?>" data-tooltip="Edit">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                                                        <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z" />
                                                        <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5z" />
                                                    </svg>
                                                 Edit
                                                </a>
   
                                            </div>
                                            <div class="edit-delete-action mt-1"><a href="<?= site_url('sitepanel/company/products/'.$pageVal['company_id']. (!empty($_SERVER['QUERY_STRING']) ? '?' . $_SERVER['QUERY_STRING'] : '')) ?>">Manage Products</a></div>
                                        </td>
                                        
                                    </tr>
                                    <?php $i++; } ?>
                                     <?php } else{?>

                                       <tr><td colspan="6" align="center">No Record found.</td></tr> 
                                     <?php } ?>
                                </tbody>
                            </table>
                            </div>

                            <?php  if(!empty($pagelist)){ ?>
                            <div class="row mt-3 mb-3 mx-1">
                                <div class="col-xxl-8 col-xl-8 col-lg-8 col-md-8 col-sm-8 col-12">
                                    <ul class="actionButtons">
                                        <li><a class="bulk-action-btn" data-action="activate" href="javascript:void(0);">Activate</a></li>
                                        <li><a class="bulk-action-btn" data-action="deactivate" href="javascript:void(0);">Deactivate</a></li>
                                        <!-- <li><a class="bulk-action-btn" data-action="update_order" href="javascript:void(0);">Update Order</a></li>
                                        <li><a class="bulk-action-btn" data-action="delete" href="javascript:void(0);">Delete</a></li> -->
                                    </ul>
                                </div>
                            </div>
                            <input type="hidden" name="bulk_action" id="bulk_action_field">
                            <?php } ?>
                            </form>
                                    
                          
                       
                    </div>
                </div>
            </div>

            <div class="row">
                <?php echo $this->paginator->display_jump_menu_pages(); ?>
            </div>
        
</div>
<!-- /main-content -->
<?php $this->load->view('sitepanel/common/footer-new'); ?>


<script>
    document.getElementById('checkAll').addEventListener('change', function() {
        let checkboxes = document.querySelectorAll('.rowCheckbox');
        for (let checkbox of checkboxes) {
            checkbox.checked = this.checked;
        }
    });
</script>


<script>
    $(document).ready(function () {
        $('.bulk-action-btn').on('click', function () {
            const action = $(this).data('action');
            const form = $('#bulkActionForm');
            const selectedCheckboxes = $('input[name="company_ids[]"]:checked');
    
            // Check for update_order or checkbox selection
            if (action !== 'update_order' && selectedCheckboxes.length === 0) {
                alert('Please select at least one record.');
                return;
            }
    
            $('#bulk_action_field').val(action);
            form.submit();
        });
    });

</script>


 <script>
            
    function filterByStatus(select) {
        var status = select.value;
        var url = new URL(window.location.href);
        var currentStatus = url.searchParams.get('status');
    
        if ((status === "" && currentStatus === null) || status === currentStatus) {
            return; 
        }
        
        if (status) {
            url.searchParams.set('status', status);
        } else {
            url.searchParams.delete('status');
        }
        window.location.href = url.toString();
    }

</script>


    </body>
</html>
l