<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php
    $location_name = ucfirst($location_detail['location_name']); 
    
    $title = str_replace('{location}', $location_name, '{location} Manufacturers Directory, Top Manufacturing Companies in {location}');

    $description = str_replace('{location}', $location_name, "Explore GetManufacturers.com - {location}'s leading manufacturers directory. Find verified suppliers, exporters from {location}, and top manufacturing companies in {location} across industries. Boost your B2B sourcing now!");

    $keywords = str_replace('{location}', $location_name, '{location} manufacturers directory, manufacturing companies in {location}, B2B suppliers {location}, industrial manufacturers in {location}, exporters {location}, top manufacturers in {location}, wholesale suppliers in {location}, factory directory {location}, GetManufacturers.com {location}, Top Manufacturers in {location}, Top Manufacturing Companies in {location}');
    ?>
    <title><?= $title ?></title>
    <meta name="description" content="<?= $description ?>">
    <meta name="keywords" content="<?= $keywords ?>">

    <?php $this->load->view('common/app_top'); ?>
</head>

<body>

    <?php $this->load->view('common/location_app_header'); ?>  

    <div class="innerBanner">
        <div class="container">
            <div class="listingInner">
                <h1>Indian Manufacturers Directory</h1>
                <p>Browse leading Indian Manufacturers Database from various product categories to reach millions of manufacturing companies in India</p>

            </div>
        </div>
    </div>


    <nav class="breadcrumbs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-12">
                    <ul>
                    <?php if (!empty($breadcrumb)) echo $breadcrumb; ?>
                    </ul>
                </div>
            </div>
        </div>
    </nav>

    <div class="listDirectory">
        <div class="listDirectoryTop">
            <div class="container">
                <ul class="catList">
                <?php
                $current_location = $this->uri->segment(1); 
                ?>
                <?php if (!empty($list_loc)) { ?>
                    <?php foreach ($list_loc as $loc) {
                        $is_active = ($loc['location_url'] == $current_location) ? 'active' : '';
                        ?>
                        <li class="<?= $is_active ?>">
                            <a href="<?=base_url($loc['location_url'])?>"><?= $loc['location_name'] ?></a>
                        </li>
                    <?php } ?>
                <?php } ?>

                </ul>
            </div>
        </div>
        <div class="container">
            <div class="listingTitleSection">
                <div class="">
                    <h2 class="listingTitleH1 fs-3">Top B2B Marketplace in India</h2>
                    <div class="image">
                        <img src="<?=base_url('assets/frontend/')?>images/b2b.jpg">
                    </div>
                    <div class="fw-bold mb-2 fs-5 text-dark">What is Getmanufacturers? - India's Fastest Growing B2B Portal for businesses.</div>
                    <p>Getmanufacturers is the fastest growing best b2b portal in India providing a single solution for all your business needs in a single roof from Sourcing - Quotation - Billing - Buying/Selling - Payments - Delivery. Reduce costs by buying from the largest b2b marketplace in india. You are a manufacturers, suppliers, traders or distributors, whether you have a small business or a large manufacturing enterprise, the options at Getmanufacturers allow you to reach more buyers easily.</p>
                    <p>B2B portals are digital solutions that facilitate business interactions within a digital environment. These portals commonly offer e-commerce features, self-service options, and communication tools, serving as a means to effectively manage relationships with suppliers, partners, dealers, and clients.</p>
                </div>
            </div>
        </div>
    </div>

    <div class="directoryPage">
        <div class="container">
            <div class="directoryItem">
                <h3 class="businessTitle2">Food & Beverages in India</h3>
                <p>Lorem ipsum dolor, sit amet consectetur adipisicing elit. Ipsam ea quia unde nesciunt quam labore. Id ex similique, numquam voluptatibus quod necessitatibus vitae cum pariatur nam odio recusandae assumenda dolor.</p>
                <div class="directoryFull">
                    <div class="directoryWrapper">
                        <div class="directoryLeft">
                            <img src="<?=base_url('assets/frontend/')?>images/food-beverages.webp">
                            <div class="overlay">
                                <div>
                                    <ul>
                                        <li><a href="">Doors &amp; Windows</a></li>
                                        <li><a href="">Bricks &amp; Construction Materials</a></li>
                                        <li><a href="">PVC, HDPE, FRP &amp; Plastic Pipes</a></li>
                                        <li><a href="">Steel Plates, Sheets, Bars &amp; Rods</a></li>

                                    </ul>
                                    <a href="" class="view-all">View All</a>
                                </div>
                            </div>

                        </div>
                        <div class="directoryRight">
                            <div class="directoryGrid">
                                <div class="directoryGridItem">
                                    <a class="directoryHeader" href="">
                                        <h4 class="dirInnerTitle">Cereals & Food Grains</h4>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8"></path>
                                        </svg>
                                    </a>
                                    <div class="image">
                                        <a href="">
                                            <img src="<?=base_url('assets/frontend/')?>images/vegetables.webp" alt="Vegetables" width="100" height="100" loading="lazy" decoding="async" fetchpriority="low">
                                        </a>
                                    </div>
                                    <ul class="link2">
                                        <li><a href="">Office Container</a></li>
                                        <li><a href="">Portable Cabins</a></li>
                                        <li><a href="">Mobile Cabins</a></li>
                                        <li><a href="">Security Cabins</a></li>
                                    </ul>
                                </div>

                                <div class="directoryGridItem">
                                    <a class="directoryHeader" href="">
                                        <h4 class="dirInnerTitle">Meat & Poultry Food</h4>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8"></path>
                                        </svg>
                                    </a>
                                    <div class="image">
                                        <a href="">
                                            <img src="<?=base_url('assets/frontend/')?>images/vegetables.webp" alt="Vegetables" width="100" height="100" loading="lazy" decoding="async" fetchpriority="low">
                                        </a>
                                    </div>
                                    <ul class="link2">
                                        <li><a href="">Office Container</a></li>
                                        <li><a href="">Portable Cabins</a></li>
                                        <li><a href="">Mobile Cabins</a></li>
                                        <li><a href="">Security Cabins</a></li>
                                    </ul>
                                </div>


                                <div class="directoryGridItem">
                                    <a class="directoryHeader" href="">
                                        <h4 class="dirInnerTitle">Milk & Dairy Products</h4>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8"></path>
                                        </svg>
                                    </a>
                                    <div class="image">
                                        <a href="">
                                            <img src="<?=base_url('assets/frontend/')?>images/vegetables.webp" alt="Vegetables" width="100" height="100" loading="lazy" decoding="async" fetchpriority="low">
                                        </a>
                                    </div>
                                    <ul class="link2">
                                        <li><a href="">Office Container</a></li>
                                        <li><a href="">Portable Cabins</a></li>
                                        <li><a href="">Mobile Cabins</a></li>
                                        <li><a href="">Security Cabins</a></li>
                                    </ul>
                                </div>


                                <div class="directoryGridItem">
                                    <a class="directoryHeader" href="">
                                        <h4 class="dirInnerTitle">Fresh, Dried & Preserved Vegetables</h4>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8"></path>
                                        </svg>
                                    </a>
                                    <div class="image">
                                        <a href="">
                                            <img src="<?=base_url('assets/frontend/')?>images/vegetables.webp" alt="Vegetables" width="100" height="100" loading="lazy" decoding="async" fetchpriority="low">
                                        </a>
                                    </div>
                                    <ul class="link2">
                                        <li><a href="">Office Container</a></li>
                                        <li><a href="">Portable Cabins</a></li>
                                        <li><a href="">Mobile Cabins</a></li>
                                        <li><a href="">Security Cabins</a></li>
                                    </ul>
                                </div>


                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>

            <div class="directoryItem">
                <h3 class="businessTitle2">Apparel & Garments in India</h3>
                <p>Lorem ipsum dolor, sit amet consectetur adipisicing elit. Ipsam ea quia unde nesciunt quam labore. Id ex similique, numquam voluptatibus quod necessitatibus vitae cum pariatur nam odio recusandae assumenda dolor.</p>
                <div class="directoryFull">
                    <div class="directoryWrapper">
                        <div class="directoryLeft">
                            <img src="<?=base_url('assets/frontend/')?>images/realestate1.webp">
                            <div class="overlay">
                                <div>
                                    <ul>
                                        <li><a href="">Doors &amp; Windows</a></li>
                                        <li><a href="">Bricks &amp; Construction Materials</a></li>
                                        <li><a href="">PVC, HDPE, FRP &amp; Plastic Pipes</a></li>
                                        <li><a href="">Steel Plates, Sheets, Bars &amp; Rods</a></li>

                                    </ul>
                                    <a href="" class="view-all">View All</a>
                                </div>
                            </div>

                        </div>
                        <div class="directoryRight">
                            <div class="directoryGrid">
                                <div class="directoryGridItem">
                                    <a class="directoryHeader" href="">
                                        <h4 class="dirInnerTitle">Prefabricated &amp; Portable Buildings</h4>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8"></path>
                                        </svg>
                                    </a>
                                    <div class="image">
                                        <a href="">
                                            <img src="<?=base_url('assets/frontend/')?>images/Portable-Buildings.jpg" alt="Prefabricated &amp; Portable Buildings" width="100" height="100" loading="lazy" decoding="async" fetchpriority="low">
                                        </a>
                                    </div>
                                    <ul class="link2">
                                        <li><a href="">Office Container</a></li>
                                        <li><a href="">Portable Cabins</a></li>
                                        <li><a href="">Mobile Cabins</a></li>
                                        <li><a href="">Security Cabins</a></li>
                                    </ul>
                                </div>

                                <div class="directoryGridItem">
                                    <a class="directoryHeader" href="">
                                        <h4 class="dirInnerTitle">Prefabricated &amp; Portable Buildings</h4>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8"></path>
                                        </svg>
                                    </a>
                                    <div class="image">
                                        <a href="">
                                            <img src="<?=base_url('assets/frontend/')?>images/Portable-Buildings.jpg" alt="Prefabricated &amp; Portable Buildings" width="100" height="100" loading="lazy" decoding="async" fetchpriority="low">
                                        </a>
                                    </div>
                                    <ul class="link2">
                                        <li><a href="">Office Container</a></li>
                                        <li><a href="">Portable Cabins</a></li>
                                        <li><a href="">Mobile Cabins</a></li>
                                        <li><a href="">Security Cabins</a></li>
                                    </ul>
                                </div>


                                <div class="directoryGridItem">
                                    <a class="directoryHeader" href="">
                                        <h4 class="dirInnerTitle">Prefabricated &amp; Portable Buildings</h4>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8"></path>
                                        </svg>
                                    </a>
                                    <div class="image">
                                        <a href="">
                                            <img src="<?=base_url('assets/frontend/')?>images/Portable-Buildings.jpg" alt="Prefabricated &amp; Portable Buildings" width="100" height="100" loading="lazy" decoding="async" fetchpriority="low">
                                        </a>
                                    </div>
                                    <ul class="link2">
                                        <li><a href="">Office Container</a></li>
                                        <li><a href="">Portable Cabins</a></li>
                                        <li><a href="">Mobile Cabins</a></li>
                                        <li><a href="">Security Cabins</a></li>
                                    </ul>
                                </div>


                                <div class="directoryGridItem">
                                    <a class="directoryHeader" href="">
                                        <h4 class="dirInnerTitle">Prefabricated &amp; Portable Buildings</h4>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8"></path>
                                        </svg>
                                    </a>
                                    <div class="image">
                                        <a href="">
                                            <img src="<?=base_url('assets/frontend/')?>images/Portable-Buildings.jpg" alt="Prefabricated &amp; Portable Buildings" width="100" height="100" loading="lazy" decoding="async" fetchpriority="low">
                                        </a>
                                    </div>
                                    <ul class="link2">
                                        <li><a href="">Office Container</a></li>
                                        <li><a href="">Portable Cabins</a></li>
                                        <li><a href="">Mobile Cabins</a></li>
                                        <li><a href="">Security Cabins</a></li>
                                    </ul>
                                </div>


                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>


            <div class="directoryItem">
                <h3 class="businessTitle2">Realestate, Building &amp; Construction in India</h3>
                <p>Lorem ipsum dolor, sit amet consectetur adipisicing elit. Ipsam ea quia unde nesciunt quam labore. Id ex similique, numquam voluptatibus quod necessitatibus vitae cum pariatur nam odio recusandae assumenda dolor.</p>
                <div class="directoryFull">
                    <div class="directoryWrapper">
                        <div class="directoryLeft">
                            <img src="<?=base_url('assets/frontend/')?>images/realestate1.webp">
                            <div class="overlay">
                                <div>
                                    <ul>
                                        <li><a href="">Doors &amp; Windows</a></li>
                                        <li><a href="">Bricks &amp; Construction Materials</a></li>
                                        <li><a href="">PVC, HDPE, FRP &amp; Plastic Pipes</a></li>
                                        <li><a href="">Steel Plates, Sheets, Bars &amp; Rods</a></li>

                                    </ul>
                                    <a href="" class="view-all">View All</a>
                                </div>
                            </div>

                        </div>
                        <div class="directoryRight">
                            <div class="directoryGrid">
                                <div class="directoryGridItem">
                                    <a class="directoryHeader" href="">
                                        <h4 class="dirInnerTitle">Prefabricated &amp; Portable Buildings</h4>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8"></path>
                                        </svg>
                                    </a>
                                    <div class="image">
                                        <a href="">
                                            <img src="<?=base_url('assets/frontend/')?>images/Portable-Buildings.jpg" alt="Prefabricated &amp; Portable Buildings" width="100" height="100" loading="lazy" decoding="async" fetchpriority="low">
                                        </a>
                                    </div>
                                    <ul class="link2">
                                        <li><a href="">Office Container</a></li>
                                        <li><a href="">Portable Cabins</a></li>
                                        <li><a href="">Mobile Cabins</a></li>
                                        <li><a href="">Security Cabins</a></li>
                                    </ul>
                                </div>

                                <div class="directoryGridItem">
                                    <a class="directoryHeader" href="">
                                        <h4 class="dirInnerTitle">Prefabricated &amp; Portable Buildings</h4>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8"></path>
                                        </svg>
                                    </a>
                                    <div class="image">
                                        <a href="">
                                            <img src="<?=base_url('assets/frontend/')?>images/Portable-Buildings.jpg" alt="Prefabricated &amp; Portable Buildings" width="100" height="100" loading="lazy" decoding="async" fetchpriority="low">
                                        </a>
                                    </div>
                                    <ul class="link2">
                                        <li><a href="">Office Container</a></li>
                                        <li><a href="">Portable Cabins</a></li>
                                        <li><a href="">Mobile Cabins</a></li>
                                        <li><a href="">Security Cabins</a></li>
                                    </ul>
                                </div>


                                <div class="directoryGridItem">
                                    <a class="directoryHeader" href="">
                                        <h4 class="dirInnerTitle">Prefabricated &amp; Portable Buildings</h4>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8"></path>
                                        </svg>
                                    </a>
                                    <div class="image">
                                        <a href="">
                                            <img src="<?=base_url('assets/frontend/')?>images/Portable-Buildings.jpg" alt="Prefabricated &amp; Portable Buildings" width="100" height="100" loading="lazy" decoding="async" fetchpriority="low">
                                        </a>
                                    </div>
                                    <ul class="link2">
                                        <li><a href="">Office Container</a></li>
                                        <li><a href="">Portable Cabins</a></li>
                                        <li><a href="">Mobile Cabins</a></li>
                                        <li><a href="">Security Cabins</a></li>
                                    </ul>
                                </div>


                                <div class="directoryGridItem">
                                    <a class="directoryHeader" href="">
                                        <h4 class="dirInnerTitle">Prefabricated &amp; Portable Buildings</h4>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8"></path>
                                        </svg>
                                    </a>
                                    <div class="image">
                                        <a href="">
                                            <img src="<?=base_url('assets/frontend/')?>images/Portable-Buildings.jpg" alt="Prefabricated &amp; Portable Buildings" width="100" height="100" loading="lazy" decoding="async" fetchpriority="low">
                                        </a>
                                    </div>
                                    <ul class="link2">
                                        <li><a href="">Office Container</a></li>
                                        <li><a href="">Portable Cabins</a></li>
                                        <li><a href="">Mobile Cabins</a></li>
                                        <li><a href="">Security Cabins</a></li>
                                    </ul>
                                </div>


                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>


        </div>
    </div>

  



    <?php $this->load->view('common/app_footer'); ?>
    <?php $this->load->view('common/app_modal'); ?>
    <?php $this->load->view('common/app_bottom'); ?>
    <script>
        $(document).ready(function() {
            var wordLimit = 75;

            $('.listItem p').each(function() {
                var $this = $(this);
                var text = $this.text().trim();
                var words = text.split(/\s+/);

                if (words.length > wordLimit) {
                    var truncated = words.slice(0, wordLimit).join(' ') + '...';
                    $this.text(truncated);
                }
            });
        });
    </script>

    <script>
        $(function() {
            $('.ratingBtn').click(() => $('#ratingsList').toggle());

            $('#ratingsList li:not(.clear-option)').click(function() {
                const text = $(this).text();
                $('#selectedRating').text(text).addClass('selected');
                $('#clearOrClose').text('Clear');
                $('#ratingsList').hide();
            });

            $('#clearOrClose').click(function(e) {
                e.stopPropagation();
                const btn = $('#selectedRating');
                if ($(this).text() === 'Clear') {
                    btn.text('Ratings').removeClass('selected');
                    $(this).text('Closed');
                }
                $('#ratingsList').hide();
            });

            $(document).click(function(e) {
                if (!$(e.target).closest('.itemRating').length) {
                    $('#ratingsList').hide();
                }
            });
        });
    </script>

    <script>
        const videoId = 'Tm7ui3Tv7j8'; // Replace with your YouTube video ID
        const $iframe = $('#youtubeIframe');

        $('#videoModal').on('show.bs.modal', function() {
            const videoUrl = `https://www.youtube.com/embed/${videoId}?autoplay=1`;
            $iframe.attr('src', videoUrl);
        });

        $('#videoModal').on('hidden.bs.modal', function() {
            $iframe.attr('src', ''); // Reset the iframe to stop video
        });
    </script>

    <script>
        $(document).ready(function() {
            $('.inputGroup').each(function() {
                const group = $(this);

                group.find('.unitToggle').on('click', function() {
                    group.find('.unitDropdown').toggle();
                });

                group.find('.unitDropdown li').on('click', function() {
                    const selected = $(this).text();
                    group.find('.unitToggle').text(selected);
                    group.find('.unitInput').val(selected);
                    group.find('.unitDropdown').hide();
                });
            });

            $(document).on('click', function(e) {
                if (!$(e.target).closest('.inputGroup').length) {
                    $('.unitDropdown').hide();
                }
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            let itemsToShow = 2;
            let hiddenItems = $('.listItem.hidden');
            let totalHidden = hiddenItems.length;

            $('.loadMoreBtn').click(function() {
                hiddenItems.slice(0, itemsToShow).removeClass('hidden');
                hiddenItems = $('.listItem.hidden');
                if (hiddenItems.length === 0) {
                    $(this).fadeOut("slow");
                }
            });
        });
    </script>

</body>

</html>