<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

class Members_model extends CI_Model {

    public function get_members($get,$count){
      
        if(!empty($get['search'])){
            $this->db->group_start(); // Start group
            $this->db->like('user_name', $get['search']);
            $this->db->or_like('first_name', $get['search']);
            $this->db->or_like('last_name', $get['search']);
            $this->db->or_like('mobile_number', $get['search']);
            $this->db->or_like('alt_mobile', $get['search']);
            $this->db->or_like('company_name', $get['search']);
            $this->db->or_like('website', $get['search']);
            $this->db->or_like('user_email', $get['search']);
            $this->db->or_like('alt_email', $get['search']);
            $this->db->or_like("CONCAT(first_name, ' ', last_name)", $get['search']); // Full name search
            $this->db->group_end(); // End group
        }

        if(!empty($count)){
            return $count = $this->db->get('gm_members')->num_rows();
        }else{
            $offset = !empty($get['offset']) ? $get['offset'] : 0;
            $limit  = !empty($get['limit']) ? $get['limit'] : 25;
       
            $this->db->limit($limit,$offset);
        
            $this->db->order_by('customers_id','DESC');
            $this->db->select("gm_members.*, CONCAT(first_name, ' ', last_name) AS name");
            $query = $this->db->get('gm_members');
            $result = $query->result_array();
            //echo $this->db->last_query();
            return $result;
        }
        
       
    }

  public function get_member_row($member_id, $condtion = '') {
    $member_id = (int) $member_id;
    $result = $this->db->where('customers_id',$member_id)->get('gm_members')->row_array();
    return $result;
    
  }


  public function add_bulk_upload_users($worksheet) {

    for ($i = 2; $i <= count($worksheet); $i++) {
      $companyName = (!isset($worksheet[$i][1])) ? '' : addslashes(trim($worksheet[$i][1]));
      $title = (!isset($worksheet[$i][2])) ? '' : addslashes(trim($worksheet[$i][2]));
      $firstName = (!isset($worksheet[$i][3])) ? '' : addslashes(trim($worksheet[$i][3]));
      $lastName = (!isset($worksheet[$i][4])) ? '' : addslashes(trim($worksheet[$i][4]));

      $email = (!isset($worksheet[$i][5])) ? '' : addslashes(trim($worksheet[$i][5]));
      $altEmail = (!isset($worksheet[$i][6])) ? '' : addslashes(trim($worksheet[$i][6]));
      $mobile = (!isset($worksheet[$i][7])) ? '' : addslashes(trim($worksheet[$i][7]));
      $altMobile = (!isset($worksheet[$i][8])) ? '' : addslashes(trim($worksheet[$i][8]));
      $phone = (!isset($worksheet[$i][9])) ? '' : addslashes(trim($worksheet[$i][9]));
      $productCategory = (!isset($worksheet[$i][10])) ? '' : addslashes(trim($worksheet[$i][10]));
      $address = (!isset($worksheet[$i][11])) ? '' : addslashes(trim($worksheet[$i][11]));

      $city = (!isset($worksheet[$i][12])) ? '' : addslashes(trim($worksheet[$i][12]));
      $zipcode = (!isset($worksheet[$i][13])) ? '' : addslashes(trim($worksheet[$i][13]));
      $state = (!isset($worksheet[$i][14])) ? '' : addslashes(trim($worksheet[$i][14]));
      $country = (!isset($worksheet[$i][15])) ? '' : addslashes(trim($worksheet[$i][15]));

      //Get Country, State and City Id
      $countryId = get_db_field_value("gm_countries_list", "id", "WHERE LOWER(name) = '" . strtolower($country) . "'");
      if ($countryId <= 0) {
        $dataCountry = array(
            'name' => $country,
            'country_temp_name' => seo_url_title($country),
            'status' => '1',
        );
        $countryId = $this->db->insert('gm_countries_list', $dataCountry, FALSE);
      }
      //State
      $stateId = get_db_field_value("gm_states_list", "id", "WHERE LOWER(name) = '" . strtolower($state) . "'");
      if ($stateId <= 0) {
        $dataState = array(
            'name' => $state,
            'country_id' => $countryId,
            'temp_title' => seo_url_title($state),
            'status' => '1',
        );
        $stateId = $this->db->insert('gm_states_list', $dataState, FALSE);
      }
      //City
      $cityId = get_db_field_value("gm_cities_list", "id", "WHERE LOWER(city) = '" . strtolower($city) . "'");
      if ($cityId <= 0) {
        $dataCity = array(
            'city' => $city,
            'state_id' => $stateId,
            'country_id' => $countryId,
            'temp_title' => seo_url_title($city),
            'status' => '1',
        );
        $cityId = $this->db->insert('gm_cities_list', $dataCity, FALSE);
      }
      //Store Data
      $password = $otp = substr(str_shuffle('bcdfghjklmnprstvwxzaeiou1234567890'), 0, 6);
      $data = array(
          'user_name' => ($mobile) ? $mobile : $email,
          'password' => $this->safe_encrypt->encode($password),
          'company_name' => $companyName,
          'title' => $title,
          'first_name' => $firstName,
          'last_name' => $lastName,
          'user_email' => $email,
          'alt_email' => $altEmail,
          'mobile_number' => $mobile,
          'alt_mobile' => $altMobile,
          'phone_number' => $phone,
          'address' => $address,
          'state' => $stateId ?? NULL,
          'city' => $cityId ?? NULL,
          'country' => $country ?? NULL,
          'zipcode' => $zipcode,
          'status' => '1',
          'is_verified' => '1',
          'account_created_date' => date('Y-m-d H:i:s')
      );
      
      $mem_id = $this->db->insert('gm_members', $data);
    }
    return true;
  }

}
