<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

class Location_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }


    public function get_location($parent_id, $get, $count) {
    
        if (!empty($get['search'])) {
            $this->db->group_start();
            $this->db->like('location_name', $get['search']);
            $this->db->or_like('location_url', $get['search']);
            $this->db->group_end();
        }
        
        
        if (!empty($get['status'])) {
            switch ($get['status']) {
              case 'featured':
                  $this->db->where('is_featured', '1');
                  break;
              case 'inactive':
                  $this->db->where('status', '0');
                  break;
              case 'deleted':
                  $this->db->where('status', '2');
                  break;
              case 'active':
                  $this->db->where('status', '1');
                  break;
              case 'new':
                  $this->db->where('added_date >=', date('Y-m-d 00:00:00'));
                  $this->db->where('added_date <=', date('Y-m-d 23:59:59'));
                  break;
            }
            
        }
    
        /*if (!empty($get['status_search'])) {
            switch ($get['status_search']) {
                case 'featured':
                    $this->db->where('is_featured', '1');
                    break;
                case 'inactive':
                    $this->db->where('status', '0');
                    break;
                case 'deleted':
                    $this->db->where('status', '2');
                    break;
                case 'active':
                    $this->db->where('status', '1');
                    break;
            }
        }*/

        if(empty($get['search']) && empty($get['status'])){
            $this->db->where('parent_id', $parent_id);
        }
       
    
        if (!empty($count)) {
            return $this->db->get('gm_location')->num_rows();
        } else {
            $offset = !empty($get['offset']) ? $get['offset'] : 0;
            $limit  = !empty($get['limit']) ? $get['limit'] : 25;
    
            $this->db->limit($limit, $offset);
            //$this->db->order_by('location_id', 'ASC');
            $this->db->order_by("CASE WHEN location_name = 'India' THEN 0 ELSE 1 END", '', FALSE);
            $this->db->order_by('location_name', 'ASC');
            $query =  $this->db->get('gm_location');
            $result = $query->result_array();
            //echo $this->db->last_query();
            return $result;
        }
    }
    
    
    public function get_location_counts(){
        
     // Total location
    $this->db->from('gm_location');
    $total = $this->db->count_all_results();
    
    // Total countries
    $this->db->from('gm_location');
    $this->db->where(['parent_id' => 0, 'status' => '1']);
    $country = $this->db->count_all_results();
   

    // Total cities
    $this->db->from('gm_location');
    $this->db->where('parent_id >', '0');
    $this->db->where('status', '1');
    $cities = $this->db->count_all_results();
    
    // Total Indian States
    $this->db->from('gm_location');
    $this->db->where('parent_id', '1');
    $this->db->where('status', '1');
    $indian_states = $this->db->count_all_results();

    /*// Inactive location
    $this->db->from('gm_location');
    $this->db->where('status', '0');
    $inactive = $this->db->count_all_results();

    // Deleted location
    $this->db->from('gm_location');
    $this->db->where('status', '2');
    $deleted = $this->db->count_all_results();*/

    return [
        'total'         => $total,
        'country'       => $country,
        'cities' => $cities,
        'indian_states' => $indian_states,
       /* 'inactive'      => $inactive,
        'deleted'       => $deleted,*/
    ];
}
    

}
?>