<?php
if (!defined('BASEPATH'))
  exit('No direct script access allowed');

class Category_model extends CI_Model {

  public function __construct() {
    parent::__construct();
  }


  public function get_category($parent_id,$get,$count){
    
    if (!empty($get['search'])) {
        $this->db->group_start(); // Start group
        $this->db->like('category_name', $get['search']);
        $this->db->or_like('category_alt', $get['search']);
        $this->db->or_like('friendly_url', $get['search']);
        $this->db->group_end(); // End group
    }
    
    if (!empty($get['status'])) {
        switch ($get['status']) {
          case 'featured':
              $this->db->where('is_featured', '1');
              break;
          case 'inactive':
              $this->db->where('status', '0');
              break;
          case 'deleted':
              $this->db->where('status', '2');
              break;
          case 'active':
              $this->db->where('status', '1');
              break;
          case 'new':
              $this->db->where('date_added >=', date('Y-m-d 00:00:00'));
              $this->db->where('date_added <=', date('Y-m-d 23:59:59'));
              break;
        }
        
    }

    /*if (!empty($get['status_search'])) {
      switch ($get['status_search']) {
          case 'featured':
              $this->db->where('is_featured', '1');
              break;
          case 'inactive':
              $this->db->where('status', '0');
              break;
          case 'deleted':
              $this->db->where('status', '2');
              break;
          case 'active':
              $this->db->where('status', '1');
              break;
      }
    }*/
 
    if(empty($get['search']) && empty($get['status'])){
      $this->db->where('parent_id', $parent_id);
    }

    if(!empty($count)){
        return $count = $this->db->where('parent_id',$parent_id)->get('gm_categories')->num_rows();
    }else{
        $offset = !empty($get['offset']) ? $get['offset'] : 0;
        $limit  = !empty($get['limit']) ? $get['limit'] : 25;
   
        $this->db->limit($limit,$offset);
        //$this->db->where('parent_id',$parent_id);
        $this->db->order_by('category_id','DESC');    

        $query = $this->db->get('gm_categories');
        $result = $query->result_array();
        //echo $this->db->last_query();
        return $result;
    }
}


public function inactive_category($parent_id,$get,$count){
    
    if (!empty($get['search'])) {
        $this->db->group_start(); // Start group
        $this->db->like('category_name', $get['search']);
        $this->db->or_like('category_alt', $get['search']);
        $this->db->or_like('friendly_url', $get['search']);
        $this->db->group_end(); // End group
    }
    
    $this->db->where('status','0');

    if(!empty($count)){
        return $count = $this->db->get('gm_categories')->num_rows();
    }else{
        $offset = !empty($get['offset']) ? $get['offset'] : 0;
        $limit  = !empty($get['limit']) ? $get['limit'] : 25;
   
        $this->db->limit($limit,$offset);
        //$this->db->where('parent_id',$parent_id);
        $this->db->order_by('category_id','DESC');    

        $query = $this->db->get('gm_categories');
        $result = $query->result_array();
        //echo $this->db->last_query();
        return $result;
    }
}


public function deleted_category($parent_id,$get,$count){
    
    if (!empty($get['search'])) {
        $this->db->group_start(); // Start group
        $this->db->like('category_name', $get['search']);
        $this->db->or_like('category_alt', $get['search']);
        $this->db->or_like('friendly_url', $get['search']);
        $this->db->group_end(); // End group
    }
    
    $this->db->where('status','2');

    if(!empty($count)){
        return $count = $this->db->get('gm_categories')->num_rows();
    }else{
        $offset = !empty($get['offset']) ? $get['offset'] : 0;
        $limit  = !empty($get['limit']) ? $get['limit'] : 25;
   
        $this->db->limit($limit,$offset);
        //$this->db->where('parent_id',$parent_id);
        $this->db->order_by('category_id','DESC');    

        $query = $this->db->get('gm_categories');
        $result = $query->result_array();
        //echo $this->db->last_query();
        return $result;
    }
}


  public function get_category_by_id($id) {
    $id = applyFilter('NUMERIC_GT_ZERO', $id);

    if ($id > 0) {
      $condtion = "status !='2' AND category_id=$id";
      $fetch_config = array(
          'condition' => $condtion,
          'debug' => FALSE,
          'return_type' => "array"
      );
      $result = $this->find('gm_categories', $fetch_config);
      return $result;
    }
  }
  
  
  public function get_category_counts(){
    // Total active main categories
    $this->db->from('gm_categories');
    $this->db->where(['parent_id' => 0, 'status' => '1']);
    $total = $this->db->count_all_results();
   

    // Total active subcategories
    $this->db->from('gm_categories');
    $this->db->where('parent_id >', '0');
    $this->db->where('status', '1');
    $subcategories = $this->db->count_all_results();

    // Inactive categories
    $this->db->from('gm_categories');
    $this->db->where('status', '0');
    $inactive = $this->db->count_all_results();

    // Deleted categories
    $this->db->from('gm_categories');
    $this->db->where('status', '2');
    $deleted = $this->db->count_all_results();

    return [
        'total'         => $total,
        'subcategories' => $subcategories,
        'inactive'      => $inactive,
        'deleted'       => $deleted,
    ];
}



  /* public function get_featured_category($parent_id, $limit) {
    $condtion = "status = '1'  AND  parent_id='" . $parent_id . "'";
    $fetch_config = array(
        'fields' => 'cat_name,cat_id',
        'condition' => $condtion,
        'order' => "display_order ASC ",
        'limit' => $limit,
        'start' => '0',
        'debug' => FALSE,
        'return_type' => "array"
    );
    $result = $this->findAll('gm_categories', $fetch_config);
    return $result;
  } */

  /* public function get_company_category($opts = array()) {
    $keyword = trim($this->input->get_post('keyword', TRUE));
    $keyword = $this->db->escape_str($keyword);
    $status = $this->db->escape_str($this->input->get_post('status', TRUE));

    if (!array_key_exists('condition', $opts) || $opts['condition'] == '') {
      $opts['condition'] = "status !='2' ";
    } else {
      $opts['condition'] = "status !='2' " . $opts['condition'];
    }

    if ($keyword != '') {
      $opts['condition'] .= " AND category_name like '%" . $keyword . "%'";
    }

    if ($status != '') {
      $opts['condition'] .= " AND status='$status' ";
    }


    $opts['order'] = "category_id asc ";

    $opts['condition'] .= " ";

    $fetch_config = array('condition' => $opts['condition'],
        'order' => $opts['order'],
        'return_type' => "array");

    if (array_key_exists('debug', $opts)) {
      $fetch_config['debug'] = $opts['debug'];
    }


    if (array_key_exists('field', $opts) && $opts['field'] != '') {
      $fetch_config['field'] = $opts['field'];
    }

    if (array_key_exists('limit', $opts) && applyFilter('NUMERIC_GT_ZERO', $opts['limit']) > 0) {

      $fetch_config['limit'] = $opts['limit'];
    }
    if (array_key_exists('offset', $opts) && applyFilter('NUMERIC_WT_ZERO', $opts['offset']) != -1) {
      $fetch_config['start'] = $opts['offset'];
    }

    //trace($fetch_config);exit;
    $result = $this->findAll('wps_company_categories as a', $fetch_config);
    return $result;
  } */

  /* public function get_company_category_by_id($id) {
    $id = applyFilter('NUMERIC_GT_ZERO', $id);

    if ($id > 0) {
      $condtion = "status !='2' AND category_id=$id";
      $fetch_config = array(
          'condition' => $condtion,
          'debug' => FALSE,
          'return_type' => "array"
      );
      $result = $this->find('wps_company_categories', $fetch_config);
      return $result;
    }
  } */

}

// model end here