<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// Global Base Controller
class MY_Controller extends CI_Controller {
    public function __construct() {
        parent::__construct();
        // Common logic for all controllers

    }
}

// Superadmin Controller
class Sitepanel_Controller extends MY_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        if (!$this->session->userdata('admin_id')) {
            redirect('sitepanel/login');
        }

        $admin_id = $this->session->userdata('admin_id');
        if (!empty($admin_id)) {
            $role_id = $this->session->userdata('admin_role_id'); // corrected
            $session_loaded = $this->session->userdata('permission_last_loaded');

            if (!empty($role_id)) {
                $db_last_updated = $this->db->select('permission_last_updated')
                    ->from('gm_admin_roles')
                    ->where('id', $role_id)
                    ->get()
                    ->row('permission_last_updated');

                if (!empty($db_last_updated) && strtotime($db_last_updated) > strtotime($session_loaded)) {
                    $this->reload_permission_session($admin_id);
                }
            }
        }
        
    }


    private function reload_permission_session($admin_id) {
        $this->db->select('au.role_id');
        $this->db->from('gm_admin_users au');
        $this->db->where('au.admin_id', $admin_id);
        $query = $this->db->get();
        $data = $query->row_array();

        if (!empty($data)) {
            $role_id = $data['role_id'];

            if ($role_id == 1) { // Super Admin
                $permissions = ['*'];
                $permission_last_updated = date('Y-m-d H:i:s');
            } else {
                $permissions = $this->db->select('p.permission_key')
                    ->from('gm_admin_role_permissions rp')
                    ->join('gm_admin_permissions p', 'p.id = rp.permission_id')
                    ->where('rp.role_id', $role_id)
                    ->get()->result_array();

                $permissions = array_column($permissions, 'permission_key');

                $permission_last_updated = $this->db->select('permission_last_updated')
                    ->from('gm_admin_roles')
                    ->where('id', $role_id)
                    ->get()
                    ->row('permission_last_updated');
            }

            $this->session->set_userdata('permissions', $permissions);
            $this->session->set_userdata('permission_last_loaded', $permission_last_updated);
            $this->session->set_userdata('admin_role_id', $role_id);
        }
    }
}

// Vendor Controller
class Vendor_Controller extends MY_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        if (!$this->session->userdata('vendor_id')) {
            redirect('vendor/login');
        }
    }
}
