<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Locationcontent extends Sitepanel_Controller {

  public function __construct() {
    parent::__construct();
  }

  public function index($category_id,$parent_id) {
       

    if (!has_permission('locationcontent_view')) {
        redirect('sitepanel/errorpage/error403');
    }
   
    if($category_id == '' || (int) $category_id == 0  || $parent_id == '' || (int) $parent_id < 0){  
      $this->session->set_flashdata('error', 'Invalid record');
      redirect('sitepanel/locationcontent');
      return;
    }
    $query_string = $this->input->post('query_string') ? '?' . ltrim($this->input->post('query_string'), '?') : '';

    if(empty($this->session->userdata('admin_id'))){
        return redirect(base_url());
    }
    
    if(!empty($this->input->post())){
        
        $this->form_validation->set_rules('meta_title', 'Meta Title', 'trim|required');
        $this->form_validation->set_rules('meta_description', 'Meta Descriptions', 'trim|required');
        $this->form_validation->set_rules('meta_keywords', 'Meta Keywords', 'trim|required');
    
        if ($this->form_validation->run() == TRUE) {
            $insert_data = array(
                'category_id'  => $category_id,
                'location_short_desc'  => $this->input->post('location_short_desc', TRUE),
                'location_description' => $this->input->post('location_description', TRUE),
                'meta_title'     => $this->input->post('meta_title', TRUE),
                'meta_description'    => $this->input->post('meta_description', TRUE),
                'meta_keywords'    => $this->input->post('meta_keywords', TRUE),
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            );
            
            
            $edit_id = $this->input->post('edit_id');
            if ($edit_id > 0) {
                $this->db->update('gm_location_content', $insert_data,['id'=>$edit_id]); 
                //redirect('sitepanel/company/edit/'.$company_id . $query_string);
            }else{
               $this->db->insert('gm_location_content', $insert_data); 
            }
    
            
    
            $action = $this->input->post('submit');
            if ($action === 'save') {
                $this->session->set_flashdata('success', 'Saved successfully.');
                redirect('sitepanel/locationcontent/index/'.$category_id.'/'.$parent_id. $query_string);
            }  elseif ($action === 'save_close') {
                $this->session->set_flashdata('success', 'Saved successfully.');
                redirect('sitepanel/category/index/' . $parent_id . $query_string);
            } else {
                redirect('sitepanel/locationcontent/index/'.$category_id.'/'.$parent_id. $query_string);
            }
        }
    
        
    }
    
    
    $data['category'] = $this->db->where('category_id', $category_id)->get('gm_categories')->row_array();
    $data['res'] = $this->db->where('category_id', $category_id)->get('gm_location_content')->row_array();
    $data['category_id'] = $category_id;
    $data['parent_id'] = $parent_id;
    $data['query_string'] = $_SERVER['QUERY_STRING'];
    $data['heading'] = 'Manage Location Content';
    $data['breadcrumb'] = get_category_breadcrumb($parent_id, $this->db);
    
   

    $this->load->view('sitepanel/locationcontent/list_locationcontent_view', $data);
  }
  

}
?>