<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('home_model');
      }

    public function index($param1 = NULL, $param2 = NULL) {
        
        $vendor_id = $this->config->item('vendor_domain_exist');
        
        if ($param1 === NULL) {   
            
            if($vendor_id > 0){
                $vendor_detail = $this->home_model->get_company_by_id($vendor_id);
                $data['company_detail'] = $vendor_detail;
                $this->load->view('company/company_page', $data);
                return;
            }
            
            
            
            $data['category_tree'] = $this->get_category_tree(16);
            $data['category_tree_header'] = $this->get_category_tree(10);
            $data['list_loc'] = $this->db->where(['is_featured'=>'1','status'=>'1'])->limit(8)->get('gm_location')->result_array();
            
            $this->load->view('home/home_page', $data);
            return;
        }

        if ($param2 === NULL) {
            
            if($vendor_id > 0){
                
                
                if ($this->is_company_location($param1)) {
                    if (substr($_SERVER['REQUEST_URI'], -1) !== '/') {
                        redirect(base_url($param1 . '/'), 301);
                        return;
                    }
                    
                    $data['company_location_detail'] = $this->home_model->get_company_location_by_location_url($param1);
                    $data['company_location'] = $param1;
    
                    //$data['company_category_tree_header'] = $this->get_category_tree(10);
                    //$data['comp_list_loc'] = $this->db->where(['is_featured'=>'1','status'=>'1'])->limit(8)->get('gm_location')->result_array();
                    //$data['comp_breadcrumb'] = get_page_breadcrumb($param1, null, $this->db);
                    $this->load->view('company/company_location_home_page', $data);
                    return;
                }
                
                $company_category = $this->home_model->get_company_category_by_slug($param1);
                
                if(!empty($company_category)){
                    $data['company_id'] = $vendor_id;
                    $data['company_categories'] = $company_category;
                    $this->load->view('company/company_category_page', $data);
                    return;
                }else{
                    show_404();
                }
            }
  
            
            if ($this->is_location($param1)) {
                if (substr($_SERVER['REQUEST_URI'], -1) !== '/') {
                    redirect(base_url($param1 . '/'), 301);
                    return;
                }
                
                $data['location_detail'] = $this->home_model->get_location_by_location_url($param1);
                $data['location'] = $param1;

                $data['category_tree_header'] = $this->get_category_tree(10);
                $data['list_loc'] = $this->db->where(['is_featured'=>'1','status'=>'1'])->limit(8)->get('gm_location')->result_array();
                $data['breadcrumb'] = get_page_breadcrumb($param1, null, $this->db);
                $this->load->view('home/location_home_page', $data);
                return;
            }
            
            $entity_type = $this->get_seo_entity_type($param1);
            if ($entity_type === 'category') {
                $data['category'] = $param1;

                if (substr($_SERVER['REQUEST_URI'], -1) === '/') {
                    redirect(base_url(rtrim($param1, '/')), 301);
                    return;
                }

                // Get main category detail
                $category_detail = $this->home_model->get_category_by_page_url($param1);
                $data['category_detail'] = $category_detail;

                $subcategories = [];
                if (!empty($category_detail)) {
                    // First try to get subcategories of this category
                    $subcategories = $this->db->select('c.*, s.page_url')->from('gm_categories c')->join('gm_seo_urls s', "s.entity_id = c.category_id AND s.entity_type = 'category'", 'left')->where(['c.parent_id' => $category_detail['category_id'], 'c.status' => '1'])->limit(10)->get()->result_array();

                    // If no subcategories found, get siblings (categories with same parent)
                    if (empty($subcategories)) {
                        $subcategories = $this->db->select('c.*, s.page_url')->from('gm_categories c')->join('gm_seo_urls s', "s.entity_id = c.category_id AND s.entity_type = 'category'", 'left')->where(['c.parent_id' => $category_detail['parent_id'],'c.status' => '1','c.category_id !=' => $category_detail['category_id']])->limit(10)->get()->result_array();
                    }
                }
                $data['subcategories'] = $subcategories;


                $data['list_loc'] = $this->db->where(['is_featured'=>'1','status'=>'1'])->limit(8)->get('gm_location')->result_array();
                $data['category_tree_header'] = $this->get_category_tree(10);
                $data['breadcrumb'] = get_page_breadcrumb(null, $param1, $this->db);
                $this->load->view('home/category_page', $data);
                return;
            } elseif ($entity_type === 'company') {
                $data['company'] = $param1;
                
                // Get main company detail
                $company_detail = $this->home_model->get_company_by_page_url($param1);
                
                $data['company_detail'] = $company_detail;
                
                $this->load->view('company/company_page', $data);
                return;
            } elseif ($entity_type === 'product') {
                $data['product'] = $param1;
                $this->load->view('home/product_page', $data);
                return;
            } else {
                show_404();
            }
        }
        

        if ($param1 && $param2) {
            // if company has domain
            
            if($vendor_id > 0){
                if ($this->is_company_location($param1)) {
                    
                    $data['company_location'] = $param1;
                    $data['company_category'] = $param2;

                    if (substr($_SERVER['REQUEST_URI'], -1) === '/') {
                        redirect(base_url($param1 . '/' . rtrim($param2, '/')), 301);
                        return;
                    }
                    
                    $data['company_location_detail'] = $this->home_model->get_company_location_by_location_url($param1);
                    $vendor_detail = $this->home_model->get_company_by_id($vendor_id);
                    
                    $company_category = $this->home_model->get_company_category_by_slug($param2);
                    $data['company_detail'] = $vendor_detail;
                    $data['company_category_detail'] = $company_category;
                    $data['company_subcategory'] = '';
                    $this->load->view('company/company_location_category_page', $data);
                    return;
                }
            }
            
            if ($this->is_location($param1)) {
                $entity_type = $this->get_seo_entity_type($param2);
        
                if ($entity_type === 'category') {
                    $data['location'] = $param1;
                    $data['category'] = $param2;

                    if (substr($_SERVER['REQUEST_URI'], -1) === '/') {
                        redirect(base_url($param1 . '/' . rtrim($param2, '/')), 301);
                        return;
                    }

                    $data['location_detail'] = $this->home_model->get_location_by_location_url($param1);
                    //$data['category_detail'] = $this->home_model->get_category_by_page_url($param2);

                    // Get main category detail
                    $category_detail = $this->home_model->get_category_by_page_url($param2);
                    $data['category_detail'] = $category_detail;

                    $subcategories = [];
                    if (!empty($category_detail)) {
                        // First try to get subcategories of this category
                        $subcategories = $this->db->select('c.*, s.page_url')->from('gm_categories c')->join('gm_seo_urls s', "s.entity_id = c.category_id AND s.entity_type = 'category'", 'left')->where(['c.parent_id' => $category_detail['category_id'], 'c.status' => '1'])->limit(10)->get()->result_array();

                        // If no subcategories found, get siblings (categories with same parent)
                        if (empty($subcategories)) {
                            $subcategories = $this->db->select('c.*, s.page_url')->from('gm_categories c')->join('gm_seo_urls s', "s.entity_id = c.category_id AND s.entity_type = 'category'", 'left')->where(['c.parent_id' => $category_detail['parent_id'],'c.status' => '1','c.category_id !=' => $category_detail['category_id']])->limit(10)->get()->result_array();
                        }
                    }
                    $data['subcategories'] = $subcategories;

                    $data['list_loc'] = $this->db->where(['is_featured'=>'1','status'=>'1'])->limit(8)->get('gm_location')->result_array();
                    $data['category_tree_header'] = $this->get_category_tree(10);
                    $data['breadcrumb'] = get_page_breadcrumb($param1, $param2, $this->db);
                    $this->load->view('home/location_category_page', $data);
                    return;
                } elseif ($entity_type === 'product') {
                    $data['location'] = $param1;
                    $data['product'] = $param2;
                    $this->load->view('home/location_product_page', $data);
                    return;
                }
                
            } else if ($this->is_company($param1)) {
                
                 $company_data = $this->is_company($param1);
                 $company_id = $company_data['company_id'];
                 $data['company_id'] = $company_id;
                 
                 $data['product_details'] = $this->home_model->get_product_details($company_id,$param2);
                 $this->load->view('company/company_product_detail_page', $data);
                 return;
             }
            
    
            
            show_404();
        }
        
        show_404(); 
    }

    private function is_location($slug) {
        // You can check against DB or a config array
        $location = $this->home_model->get_location_by_slug($slug);
        return $location;
    }
    
    private function is_company_location($slug) {
        $location = $this->home_model->get_company_location_by_slug($slug);
        return $location;
    }
    
    private function is_company($slug) {
        // You can check against DB or a config array
        $company = $this->home_model->get_company_by_slug($slug);
        return $company;
    }

    private function get_seo_entity_type($slug) {
        $seo = $this->home_model->get_seo_entity_by_slug($slug);
        return $seo ? $seo['entity_type'] : false;
    }



    public function get_category_tree($parent_limit = 16) {
        // Step 1: Fetch parent categories
        $this->db->select('c.category_id, c.category_name, c.category_image, c.category_image_thumb, c.category_icon, s.page_url, s.meta_title, s.meta_description, s.meta_keyword');
        $this->db->from('gm_categories c');
        $this->db->join('gm_seo_urls s', 's.entity_id = c.category_id AND s.entity_type = "category"', 'left');
        $this->db->where('c.is_featured', '1');
        $this->db->where('c.status', '1');
        $this->db->order_by('c.category_name', 'ASC');
        $this->db->order_by('c.category_id', 'DESC');
        $this->db->limit($parent_limit); 
        $parents = $this->db->get()->result_array();
    
        // Step 2: Get children
        $parent_ids = array_column($parents, 'category_id');
        $children = [];
        if (!empty($parent_ids)) {
            $this->db->select('c.category_id, c.category_name, c.category_image, c.category_image_thumb, c.category_icon, c.parent_id, s.page_url');
            $this->db->from('gm_categories c');
            $this->db->join('gm_seo_urls s', 's.entity_id = c.category_id AND s.entity_type = "category"', 'left');
            $this->db->where_in('c.parent_id', $parent_ids);
            $this->db->where('c.status', '1');
            $this->db->order_by('c.sort_order', 'ASC');
            $children = $this->db->get()->result_array();
        }
    
        // Step 3: Get sub-children
        $child_ids = array_column($children, 'category_id');
        $subchildren = [];
        if (!empty($child_ids)) {
            $this->db->select('c.category_id, c.category_name, c.category_image, c.category_image_thumb, c.category_icon, c.parent_id, s.page_url');
            $this->db->from('gm_categories c');
            $this->db->join('gm_seo_urls s', 's.entity_id = c.category_id AND s.entity_type = "category"', 'left');
            $this->db->where_in('c.parent_id', $child_ids);
            $this->db->where('c.status', '1');
            $this->db->order_by('c.sort_order', 'ASC');
            $subchildren = $this->db->get()->result_array();
        }
    
        // Step 4: Group children by parent_id
        $group_by_parent = function($items) {
            $grouped = [];
            foreach ($items as $item) {
                $grouped[$item['parent_id']][] = $item;
            }
            return $grouped;
        };
        $grouped_children = $group_by_parent($children);
        $grouped_subchildren = $group_by_parent($subchildren);
    
        // Step 5: Build tree structure
        foreach ($parents as &$parent) {
            $parent['children'] = isset($grouped_children[$parent['category_id']])
                ? array_slice($grouped_children[$parent['category_id']], 0, 6)
                : [];
    
            foreach ($parent['children'] as &$child) {
                $child['children'] = isset($grouped_subchildren[$child['category_id']])
                    ? array_slice($grouped_subchildren[$child['category_id']], 0, 4)
                    : [];
            }
        }
    
        return $parents;
    }

    Public function gmdirectory(){

        $data['countries'] = $this->db->where(['parent_id' => 0, 'status' => 1, 'location_id!='=>1])->order_by('location_name', 'ASC')->get('gm_location')->result_array();

        $data['indian_states'] = $this->db->where(['parent_id' => 1, 'status' => 1])->order_by('location_name', 'ASC')->get('gm_location')->result_array();

        $states = $this->db->where(['parent_id' => 1, 'status' => 1])->order_by('location_name', 'ASC')->get('gm_location')->result_array();
        $state_cities = [];

        foreach ($states as $state) {
            $cities = $this->db
                ->where(['parent_id' => $state['location_id'], 'status' => 1])
                ->order_by('location_name', 'ASC')
                ->get('gm_location')
                ->result_array();

            $state_cities[] = [
                'state'  => $state['location_name'],
                'state_id' => $state['location_id'],
                'cities' => $cities
            ];
        }

        $data['state_cities'] = $state_cities;
        
        $data['heading'] = 'GM-Directory';
        $data['category_tree_header'] = $this->get_category_tree(10);
        $this->load->view('home/gm_directory_page', $data);
    }


    public function search_categories() {
        $keyword = $this->input->post('keyword');
        $results = $this->home_model->search_category_slug($keyword); 
        ?>
        <ul class="trend-list">
        <?php
        if (!empty($results)) { 
        foreach ($results as $cat) { ?>
            <li data-term="<?=htmlspecialchars($cat['category_name']) ?>"><a href="<?=$cat['page_url']?>">
                <div class="trend-text"><?=htmlspecialchars($cat['category_name']) ?></div> 
                </a> 
            </li>
            <?php } }else{?>
                <li> <div class="trend-text">No result found</div></li>
                <?php } ?>
        </ul>          
      <?php      
    }
    

    public function send_enquiry(){
        
        $recaptcha_response = $this->input->post('g-recaptcha-response');

        $secret_key = RECAPTCHA_SECRETKEY; 
    
        $verify_url = 'https://www.google.com/recaptcha/api/siteverify';
        $verify_response = file_get_contents($verify_url . '?secret=' . $secret_key . '&response=' . $recaptcha_response . '&remoteip=' . $_SERVER['REMOTE_ADDR']);
        $response_data = json_decode($verify_response);
    
        // Check if successful
        if (empty($response_data->success) || !$response_data->success) {
            echo json_encode(['status' => 'error', 'message' => 'reCAPTCHA verification failed.']);
            return;
        }
            
        $name = $this->input->post('name', true);
        $city = $this->input->post('city', true);
        $looking_for = $this->input->post('looking_for', true);
        $mobile = $this->input->post('mobile', true);
        $email = $this->input->post('email', true);
        
        
        if (!preg_match('/^\d{10}$/', $mobile)) {
            echo json_encode(['status' => 'error', 'message' => 'Invalid mobile number']);
            return;
        }
        
        if($this->input->post('formtype') == 'basic'){
            if (empty($name) || empty($mobile) || strlen($mobile) < 10) {
                echo json_encode(['status' => 'error', 'message' => 'Please enter required fields.']);
                return;
            }
            
            
            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                echo json_encode(['status' => 'error', 'message' => 'Invalid email address.']);
                return;
            }
        }
        
        
    
        $smtp_config = array(
            'protocol'  => 'smtp',
            'smtp_host' => 'mail.getmanufacturers.com',
            'smtp_port' => 465,
            'smtp_user' => 'enquiry@getmanufacturers.com',
            'smtp_pass' => 'JoNrZm,64ggI',
            'mailtype'  => 'html',
            'charset'   => 'utf-8',
            'newline'   => "\r\n",
            'smtp_crypto' => 'ssl',
        );
    
        $this->load->library('email');
        $this->email->initialize($smtp_config);
    
        $this->email->from('enquiry@getmanufacturers.com', 'GM');
    
        //$this->email->to('webpulse.phpdev@gmail.com');
        $this->email->to('webpulseindia@gmail.com');
    
        $this->email->subject('Enquiry From Getmanufacturers');
        
        if($this->input->post('formtype') == 'basic'){
            $this->email->message("
                <h3>Enquiry Details</h3>
                <p><strong>Name:</strong> {$name}</p>
                <p><strong>Mobile:</strong> {$mobile}</p>
                <p><strong>City:</strong> {$city}</p>
                <p><strong>Looking For:</strong> {$looking_for}</p>
                <p><strong>Email:</strong><br>{$email}</p>
            ");
        }else{
            $this->email->message("
                <h3>Enquiry Details</h3>
                <p><strong>Name:</strong> {$name}</p>
                <p><strong>Mobile:</strong> {$mobile}</p>
            ");
        }
    
        if ($this->email->send()) {
            echo json_encode(['status' => 'success', 'message' => 'Enquiry submitted successfully.']);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to send email.',
                'debug'  => $this->email->print_debugger(['headers'])
            ]);
        }
    }


    
    

}

