
(function ($) {
    $('.menuToggle').on('click', function () {
        $('.sidemenu').toggleClass('collapsed');
    });

    /* Notification*/
    $(".notificationBtn").click(function (event) {
        $(".topNotificationDiv").toggle();
        event.stopPropagation();
        $(".userDropdown").hide();
    });

    $(document).click(function (event) {
        if (!$(event.target).closest(".topNotification").length) {
            $(".topNotificationDiv").hide();
        }
    });

    /* User Drop down*/
    $(".userClick").click(function (event) {
        $(".userDropdown").toggle();
        event.stopPropagation();
        $(".topNotificationDiv").hide();
    });

    $(document).click(function (event) {
        if (!$(event.target).closest(".dashboardUser").length) {
            $(".userDropdown").hide();
        }
    });

    $(document).ready(function () {
        if ($(".menu").length) {
            // Append dropdown-expander button to submenu links (if not already appended)
            $(".menu .submenu > a").each(function () {
                if (!$(this).find(".expander").length) {
                    $(this).append(`
                    <button class="expander" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                            <path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"/>
                        </svg>
                    </button>
                `);
                }
            });

            // Handle dropdown expand/collapse
            $(".menu").on("click", ".expander", function (e) {
                e.preventDefault();
                e.stopPropagation();

                const $li = $(this).closest("li");
                const $submenu = $li.children(".menuDropdown");

                // If already visible, collapse it
                if ($submenu.is(":visible")) {
                    $submenu.slideUp();
                    $(this).removeClass("active");
                } else {
                    // Collapse only siblings at the same level
                    $li.siblings(".submenu").children(".menuDropdown:visible").slideUp();
                    $li.siblings(".submenu").find(".expander.active").removeClass("active");

                    // Expand the current one
                    $submenu.slideDown();
                    $(this).addClass("active");
                }
            });
        }
    });



    $(document).ready(function () {
        var $slimScrolls = $('.slimscroll');

        if ($slimScrolls.length) {
            var setSlimscrollHeight = function () {
                var height = $(window).height() - 60;
                $slimScrolls.add('.sidebar .slimScrollDiv').height(height);
            };

            $slimScrolls.slimScroll({
                height: 'auto',
                width: '100%',
                position: 'right',
                size: '7px',
                color: '#ccc',
                wheelStep: 10,
                touchScrollStep: 100
            });

            setSlimscrollHeight();
            $(window).on('resize', setSlimscrollHeight);
        }
    });


    $('.select-all').on('click', function () {
        const group = $(this).closest('.dashboardTable');
        const checkboxes = group.find('.singleCheck');
        checkboxes.prop('checked', this.checked);
    });
    // Individual checkboxes update "Select All" status
    $('.singleCheck').on('click', function () {
        const group = $(this).closest('.dashboardTable');
        const all = group.find('.singleCheck');
        const allChecked = all.length === all.filter(':checked').length;
        group.find('.select-all').prop('checked', allChecked);
    });

    $('.backButton').on('click', function () {
        window.history.back();
    });

    $('.selectOne').SumoSelect();

    $('.selectTwo').SumoSelect();

    $(document).ready(function () {
        $('.toolTip').hover(function () {
            const tooltipText = $(this).data('tooltip');
            const tooltip = $('<div class="tooltipBox"></div>').text(tooltipText);
            $('body').append(tooltip);

            const offset = $(this).offset();
            const elWidth = $(this).outerWidth();
            const elHeight = $(this).outerHeight();
            const ttWidth = tooltip.outerWidth();
            const ttHeight = tooltip.outerHeight();

            tooltip.css({
                top: offset.top - ttHeight - 5,
                left: offset.left + (elWidth / 2) - (ttWidth / 2)
            }).fadeIn(200);

            $(this).data('tooltipElement', tooltip);
        }, function () {
            const tooltip = $(this).data('tooltipElement');
            tooltip.fadeOut(100, function () {
                $(this).remove();
            });
        });
    });


    $(".subDropMenu > a").append(`<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"></path></svg>`);
    // $('.companyTab').click(function () {
    //     $('.companyTab').removeClass('active');
    //     $(this).addClass('active');

    //     var selectedTab = $(this).data('tab');
    //     $('.companyTabInfo').removeClass('active');
    //     $('#' + selectedTab).addClass('active');
    // });


    $(document).on('click', '.btnEdit', function () {
        var $group = $(this).closest('.edit_group');
        var $input = $group.find('input.form-control');
        var $div = $group.find('.texteditable');

        // Hide edit button
        $(this).hide();

        if ($input.length) {
            // For input
            $input.data('original-value', $input.val());
            $input.prop('readonly', false).prop('disabled', false).addClass('input_focus');
        } else if ($div.length) {
            // For contenteditable div
            $div.data('original-html', $div.html());
            $div.attr('contenteditable', true).addClass('input_focus').focus();
        }

        $group.find('.append_btns').remove();
        $group.append(`
        <div class="append_btns">
            <button class="edit_save">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                    <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z"/>
                </svg>
            </button>
            <button class="edit_cancel">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                    <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.354 4.646a.5.5 0 1 0-.708.708L7.293 8l-2.647 2.646a.5.5 0 0 0 .708.708L8 8.707l2.646 2.647a.5.5 0 0 0 .708-.708L8.707 8l2.647-2.646a.5.5 0 0 0-.708-.708L8 7.293 5.354 4.646z"/>
                </svg>
            </button>
        </div>
      `);
    });

    $(document).on('click', '.edit_save', function () {
        var $group = $(this).closest('.edit_group');
        var $input = $group.find('input.form-control');
        var $div = $group.find('.texteditable');

        if ($input.length) {
            $input.prop('readonly', true).prop('disabled', true).removeClass('input_focus');
        } else if ($div.length) {
            $div.attr('contenteditable', false).removeClass('input_focus');
        }

        $group.find('.btnEdit').show();
        $group.find('.append_btns').remove();
    });

    $(document).on('click', '.edit_cancel', function () {
        var $group = $(this).closest('.edit_group');
        var $input = $group.find('input.form-control');
        var $div = $group.find('.texteditable');

        if ($input.length) {
            $input.val($input.data('original-value'));
            $input.prop('readonly', true).prop('disabled', true).removeClass('input_focus');
        } else if ($div.length) {
            $div.html($div.data('original-html'));
            $div.attr('contenteditable', false).removeClass('input_focus');
        }

        $group.find('.btnEdit').show();
        $group.find('.append_btns').remove();
    });



})(jQuery);
