<?php $this->load->view('sitepanel/common/header-new'); ?>
<!-- main-content -->
<div class="content">
    
        <div class="pageTitleSection">
            <div class="pageTitle_1">
                <button class="backButton" type="button">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0"></path>
                    </svg> Back
                </button>
                Edit Category
            </div>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?=base_url('sitepanel/dashboard')?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?=base_url('sitepanel/location')?>">Locations</a></li>
                <li class="breadcrumb-item active">Edit Location</li>
            </ol>
        </div>
        
        
        <div class="row">
            <div class="col-12 col-sm-12">
            <?php if ($this->session->flashdata('success')): ?>
                <div class="col-md-12">
                    <div class="alert alert-success">
                    <?php echo $this->session->flashdata('success'); ?>
                    </div>
                </div>
            <?php endif; ?>

            <?php if ($this->session->flashdata('error')): ?>
                <div class="col-md-12">
                    <div class="alert alert-danger">
                    <?php echo $this->session->flashdata('error'); ?>
                    </div>
                </div>
            <?php endif; ?>
            
            </div>

        </div>
    
 

            
            <div class="col-xxl-12 col-xl-12 col-lg-12">
                    <div class="card">
                        <div class="card-body p-4">
                    
                    <form action="<?=base_url('sitepanel/location/edit/'.$rowid.'/'.$parent_id)?>" method="post" enctype="multipart/form-data">  
                        <div class="row">  
                              
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label>Location Name</label>
                                    <input type="text" class="form-control" id="location_name" value="<?php echo set_value('location_name',$res['location_name']); ?>" name="location_name"> 
                                    <?php if(form_error('location_name')){ ?>
                                    <div class="text-danger"><?php echo form_error('location_name') ?></div>
                                    <?php } ?>
                                </div>
                            </div>

                            <div class="col-md-8">
                                <div class="form-group">
                                    <label>Location Url</label>
                                    <input type="text" class="form-control" id="location_url" name="location_url" value="<?php echo set_value('location_url',$res['location_url']); ?>" readonly>
                                    <?php if(form_error('location_url')){ ?>
                                    <div class="text-danger"><?php echo form_error('location_url') ?></div>
                                    <?php } ?>
                                </div>
                            </div>


                            <div class="col-md-12">
                                <div class="mt-3 mb-4" style="border-top: 10px solid #e8e8e8;"></div>
                            </div>


                            <div class="col-md-8">
                                <div class="form-group">
                                    <label>Meta Title</label>
                                    <input type="text" class="form-control" name="meta_title" value="<?php echo set_value('meta_title',$res['meta_title']); ?>">
                                </div>
                            </div>

                            <div class="col-md-8">
                                <div class="form-group">
                                    <label>Meta Description</label>
                                    <textarea class="form-control" name="meta_desc"><?php echo set_value('meta_desc',$res['meta_description']); ?></textarea>
                                </div>
                            </div>

                            <div class="col-md-8">
                                <div class="form-group">
                                    <label>Meta Keywords</label>
                                    <input type="text" class="form-control" name="meta_keyword" value="<?php echo set_value('meta_keyword',$res['meta_keyword']); ?>">
                                </div>
                            </div>
                            
                            <?php 
                            $back_query_string = $_SERVER['QUERY_STRING'] ? '?' . $_SERVER['QUERY_STRING'] : '';
                            ?>
                            <div class="col-md-12">
                            <input type="hidden" name="query_string" value="<?= html_escape($query_string); ?>">
                            <button type="submit" class="btn save_btn">Update</button>
                            <a href="<?=base_url('sitepanel/location/index/'.$parent_id.$back_query_string)?>" class="btn cancel_btn">Cancel</a>
                            </div>

                           
                        </div>

                        </form>
                    </div>
                </div>
            </div>


</div>
<!-- /main-content -->
<?php $this->load->view('sitepanel/common/footer-new'); ?>


<script>
$('#location_name').on('blur', function() {
    let name = $(this).val().trim();
    if (name.length > 0) {
        $.post('<?= base_url("sitepanel/location/generate_slug") ?>', { location_name: name }, function(resp) {
            $('#location_url').val(resp.slug);
        }, 'json');
    }
});


</script>