<?php $this->load->view('sitepanel/common/header-new'); ?>

    <!-- main-content -->
    <div class="content">
        <!-- container -->
        <div class="main-container container-fluid">
            <!-- breadcrumb -->
            <div class="pageTitleSection">
                <div class="pageTitle_1">
                    <button class="backButton" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                            <path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0"></path>
                        </svg> Back
                    </button>
                    Edit Category
                </div>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?=base_url('sitepanel/dashboard')?>">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="<?=base_url('sitepanel/category')?>">Categories</a></li>
                    <li class="breadcrumb-item active">Edit Category</li>
                </ol>
            </div>
            <!-- /breadcrumb -->

        <!-- row  -->
        <div class="row">
            <div class="col-12 col-sm-12">
            <?php if ($this->session->flashdata('success')): ?>
                <div class="col-md-12">
                    <div class="alert alert-success">
                    <?php echo $this->session->flashdata('success'); ?>
                    </div>
                </div>
            <?php endif; ?>

            <?php if ($this->session->flashdata('error')): ?>
                <div class="col-md-12">
                    <div class="alert alert-danger">
                    <?php echo $this->session->flashdata('error'); ?>
                    </div>
                </div>
            <?php endif; ?>
            
            </div>

        </div>
            
                 <div class="col-xxl-12 col-xl-12 col-lg-12">
                     
                <div class="card">
                    <div class="card-body p-4">
                    <!--<div class="row"><div class="col-md-12"><a href="<?=base_url('sitepanel/category/index/'.$parent_id)?>" class="btn btn-sm btn-light" style="float: right;">Back</a></div></div>-->
                    <form action="<?=base_url('sitepanel/category/edit/'.$rowid.'/'.$parent_id)?>" method="post" enctype="multipart/form-data">  
                        <div class="row">  
                              
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label>Category Name*</label>
                                    <input type="text" class="form-control" id="category_name" value="<?php echo set_value('category_name', $res['category_name']); ?>" name="category_name"> 
                                    <?php if(form_error('category_name')){ ?>
                                    <div class="text-danger"><?php echo form_error('category_name') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-label text-dark">Status*</label>
                                    <select class="form-control" name="status"> 
                                        <option value="1" <?= set_select('status', '1', (isset($res['status']) && $res['status'] == '1')) ?>>Active</option>
                                        <option value="0" <?= set_select('status', '0', (isset($res['status']) && $res['status'] == '0')) ?>>Inactive</option>
                                        <option value="2" <?= set_select('status', '2', (isset($res['status']) && $res['status'] == '2')) ?>>Deleted</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-8">
                                <div class="form-group">
                                    <label>Category Url</label>
                                    <input type="text" class="form-control" id="page_url" name="page_url" value="<?php echo set_value('page_url', $res['page_url']); ?>" readonly>
                                    <?php if(form_error('page_url')){ ?>
                                    <div class="text-danger"><?php echo form_error('page_url') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            
                            <div class="metaBox">
                                    <div class="form-group">
                                        <label class="form-label text-dark">Category Meta Title</label>
                                        <input type="text" class="form-control" name="meta_title" value="<?php echo set_value('meta_title', $res['meta_title']); ?>">

                                    </div>
                                    <div class="form-group">
                                        <label class="form-label text-dark">Category Meta Description</label>
                                        <textarea class="form-control" name="meta_desc"><?php echo set_value('meta_desc', $res['meta_description']); ?></textarea>
                                    </div>

                                    <div class="form-group">
                                        <label class="form-label text-dark">Category Meta Keyword</label>
                                        <input type="text" class="form-control" name="meta_keyword" value="<?php echo set_value('meta_keyword', $res['meta_keyword']); ?>">
                                    </div>

                                </div>
                            
                            <div class="form-group">
                                    <label class="form-label text-dark">Category Short Description</label>
                                    <textarea class="form-control" name="category_short_desc"><?php echo set_value('category_short_desc', $res['category_short_desc']); ?></textarea> 
                                </div>
                                
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label>Descriptions</label>
                                    <textarea class="form-control editor" name="category_description"><?php echo set_value('category_description', $res['category_description']);?></textarea>
                                </div>
                            </div>
                            
                            
                            <?php /* ?>

                            <div class="col-md-8">
                                <div class="form-group">
                                    <label>Category Icon</label>
                                    <input type="file" class="form-control" name="category_icon">
                                    <div>(Dimension 100x100 | Max. Size: 100KB)</div>
                                    <?php if(!empty($res['category_icon'])) {?>
                                    <div class="image-wrapper" id="category_icon_wrapper">
                                        <img src="<?=base_url('uploaded-files/category/'.$res['category_icon'])?>" height="50">
                                        <div><a href="javascript:void(0)" class="text-danger remove-image-btn" data-id="<?= $rowid ?>" data-type="category_icon">Remove</a></div>

                                        <input type="hidden" class="form-control" name="hcategory_icon" id="hcategory_icon" value="<?=$res['category_icon']?>">
                                    </div>
                                    <?php } ?>
                                    
                                    <?php if (!empty($category_icon_error)) echo '<div class="text-danger">'.$category_icon_error.'</div>'; ?>
                                </div>
                            </div>

                            <div class="col-md-8">
                                <div class="form-group">
                                    <label>Category Banner</label>
                                    <input type="file" class="form-control" name="category_image">
                                    <div>(Dimension: 3000x3000 | Max. Size: 4MB)</div>
                                    
                                    <?php if(!empty($res['category_image'])) {?>
                                        <div class="image-wrapper" id="category_image_wrapper">
                                        <img src="<?=base_url('uploaded-files/category/'.$res['category_image'])?>" height="150">
                                        <div><a href="javascript:void(0)" class="text-danger remove-image-btn" data-id="<?=$rowid ?>" data-type="category_image">Remove</a></div>

                                        <input type="hidden" class="form-control" name="hcategory_image" id="hcategory_image" value="<?=$res['category_image']?>">

                                        <input type="hidden" class="form-control" name="hcategory_image_thumb" value="<?=$res['category_image_thumb']?>">
                                        </div>
                                    <?php } ?>
                                    
                                    <?php if (!empty($category_image_error)) echo '<div class="text-danger">'.$category_image_error.'</div>'; ?>
                                </div>
                            </div>
                            
                            <?php */ ?>
                            
                            
                            <div class="form-group">
                                    <div class="row">
                                        <div class="col-xxl-2 col-xl-2 col-lg-2 col-md-2 col-sm-6 col-12">
                                            <label class="form-label text-dark"> Category Image</label>
                                            <div class="image_upload_box">
                                                <label class="js--image-preview">
                                                    <span class="imgText">Click to upload image</span>
                                                </label>
                                                <input class="image-upload" type="file" name="category_image">
                                                
                                                <div class="controls hidden">
                                                    <button type="button" class="edit-btn">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil" viewBox="0 0 16 16">
                                                            <path d="M12.146.146a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1 0 .708l-10 10a.5.5 0 0 1-.168.11l-5 2a.5.5 0 0 1-.65-.65l2-5a.5.5 0 0 1 .11-.168zM11.207 2.5 13.5 4.793 14.793 3.5 12.5 1.207zm1.586 3L10.5 3.207 4 9.707V10h.5a.5.5 0 0 1 .5.5v.5h.5a.5.5 0 0 1 .5.5v.5h.293zm-9.761 5.175-.106.106-1.528 3.821 3.821-1.528.106-.106A.5.5 0 0 1 5 12.5V12h-.5a.5.5 0 0 1-.5-.5V11h-.5a.5.5 0 0 1-.468-.325" />
                                                        </svg>
                                                    </button>
                                                    <button type="button" class="delete-btn"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash3" viewBox="0 0 16 16">
                                                            <path d="M6.5 1h3a.5.5 0 0 1 .5.5v1H6v-1a.5.5 0 0 1 .5-.5M11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3A1.5 1.5 0 0 0 5 1.5v1H1.5a.5.5 0 0 0 0 1h.538l.853 10.66A2 2 0 0 0 4.885 16h6.23a2 2 0 0 0 1.994-1.84l.853-10.66h.538a.5.5 0 0 0 0-1zm1.958 1-.846 10.58a1 1 0 0 1-.997.92h-6.23a1 1 0 0 1-.997-.92L3.042 3.5zm-7.487 1a.5.5 0 0 1 .528.47l.5 8.5a.5.5 0 0 1-.998.06L5 5.03a.5.5 0 0 1 .47-.53Zm5.058 0a.5.5 0 0 1 .47.53l-.5 8.5a.5.5 0 1 1-.998-.06l.5-8.5a.5.5 0 0 1 .528-.47M8 4.5a.5.5 0 0 1 .5.5v8.5a.5.5 0 0 1-1 0V5a.5.5 0 0 1 .5-.5" />
                                                        </svg>
                                                    </button>
                                                </div>
                                            </div>
                                            
                                            <?php if(!empty($res['category_image'])) {?>
                                                <div class="image-wrapper" id="category_image_wrapper">
                                                <img src="<?=base_url('uploaded-files/category/'.$res['category_image'])?>" height="150">
                                                <div><a href="javascript:void(0)" class="text-danger remove-image-btn" data-id="<?=$rowid ?>" data-type="category_image">Remove</a></div>
        
                                                <input type="hidden" class="form-control" name="hcategory_image" id="hcategory_image" value="<?=$res['category_image']?>">
        
                                                <input type="hidden" class="form-control" name="hcategory_image_thumb" value="<?=$res['category_image_thumb']?>">
                                                </div>
                                            <?php } ?>
                                            
                                            <?php if (!empty($category_image_error)) echo '<div class="text-danger">'.$category_image_error.'</div>'; ?>
                                        </div>
                                        <div class="col-xxl-2 col-xl-2 col-lg-2 col-md-2 col-sm-6 col-12">
                                            <label class="form-label text-dark"> Category Icon</label>
                                            <div class="image_upload_box">
                                                <label class="js--image-preview">
                                                    <span class="imgText">Click to upload Icon</span>
                                                </label>
                                                <input type="file" class="image-upload" name="category_icon">
                                                
                                                <div class="controls hidden">
                                                    <button type="button" class="edit-btn">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil" viewBox="0 0 16 16">
                                                            <path d="M12.146.146a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1 0 .708l-10 10a.5.5 0 0 1-.168.11l-5 2a.5.5 0 0 1-.65-.65l2-5a.5.5 0 0 1 .11-.168zM11.207 2.5 13.5 4.793 14.793 3.5 12.5 1.207zm1.586 3L10.5 3.207 4 9.707V10h.5a.5.5 0 0 1 .5.5v.5h.5a.5.5 0 0 1 .5.5v.5h.293zm-9.761 5.175-.106.106-1.528 3.821 3.821-1.528.106-.106A.5.5 0 0 1 5 12.5V12h-.5a.5.5 0 0 1-.5-.5V11h-.5a.5.5 0 0 1-.468-.325" />
                                                        </svg>
                                                    </button>
                                                    <button type="button" class="delete-btn"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash3" viewBox="0 0 16 16">
                                                            <path d="M6.5 1h3a.5.5 0 0 1 .5.5v1H6v-1a.5.5 0 0 1 .5-.5M11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3A1.5 1.5 0 0 0 5 1.5v1H1.5a.5.5 0 0 0 0 1h.538l.853 10.66A2 2 0 0 0 4.885 16h6.23a2 2 0 0 0 1.994-1.84l.853-10.66h.538a.5.5 0 0 0 0-1zm1.958 1-.846 10.58a1 1 0 0 1-.997.92h-6.23a1 1 0 0 1-.997-.92L3.042 3.5zm-7.487 1a.5.5 0 0 1 .528.47l.5 8.5a.5.5 0 0 1-.998.06L5 5.03a.5.5 0 0 1 .47-.53Zm5.058 0a.5.5 0 0 1 .47.53l-.5 8.5a.5.5 0 1 1-.998-.06l.5-8.5a.5.5 0 0 1 .528-.47M8 4.5a.5.5 0 0 1 .5.5v8.5a.5.5 0 0 1-1 0V5a.5.5 0 0 1 .5-.5" />
                                                        </svg>
                                                    </button>
                                                </div>
                                            </div>
                                            
                                            <?php if(!empty($res['category_icon'])) {?>
                                            <div class="image-wrapper" id="category_icon_wrapper">
                                                <img src="<?=base_url('uploaded-files/category/'.$res['category_icon'])?>" height="50">
                                                <div><a href="javascript:void(0)" class="text-danger remove-image-btn" data-id="<?= $rowid ?>" data-type="category_icon">Remove</a></div>
        
                                                <input type="hidden" class="form-control" name="hcategory_icon" id="hcategory_icon" value="<?=$res['category_icon']?>">
                                            </div>
                                            <?php } ?>
                                            <?php if (!empty($category_icon_error)) echo '<div class="text-danger">'.$category_icon_error.'</div>'; ?>
                                        </div>

                                    </div>
                                </div>
                            
                            
                            
                           <?php 
                            $back_query_string = $_SERVER['QUERY_STRING'] ? '?' . $_SERVER['QUERY_STRING'] : '';
                            ?>
                            <div class="col-md-12">
                            <input type="hidden" name="query_string" value="<?= html_escape($query_string); ?>">
                            <button type="submit" class="btn save_btn">Update</button>
                            <a href="<?=base_url('sitepanel/category/index/'.$parent_id.$back_query_string)?>" class="btn cancel_btn">Cancel</a>
                            </div>

                           
                        </div>

                        </form>
                    </div>
                </div>
                </div>
            
        <!-- /row closed -->

    </div>
    <!-- /Container -->
    
    
    
</div>
    <!-- /main-content -->


<!-- /main-content -->
<?php $this->load->view('sitepanel/common/footer-new'); ?>



<script>
$('#category_name').on('blur', function() {
    let name = $(this).val().trim();
    if (name.length > 0) {
        $.post('<?= base_url("sitepanel/category/generate_slug") ?>', { category_name: name }, function(resp) {
            $('#page_url').val(resp.slug);
        }, 'json');
    }
});

</script>


<script>
$(document).ready(function () {
  $('.remove-image-btn').on('click', function () {
    let button = $(this);
    let imageType = button.data('type');       // category_image or category_icon
    let categoryId = button.data('id');

    if (!confirm('Are you sure you want to remove this image?')) return;

    $.ajax({
      url: "<?= base_url('sitepanel/category/remove_image') ?>",
      method: "POST",
      data: {
        category_id: categoryId,
        image_type: imageType,
        '<?= $this->security->get_csrf_token_name() ?>': '<?= $this->security->get_csrf_hash() ?>'
      },
      dataType: 'json',
      success: function (res) {
        if (res.status === 'success') {
          // Remove the entire wrapper and clear hidden field
          $('#' + imageType + '_wrapper').remove();
          $('#h' + imageType).val('');
        } else {
          alert('Failed to remove image.');
        }
      }
    });
  });
});
</script>


<script>
    $(document).ready(function() {
        $('.image_upload_box').each(function() {
            const $box = $(this);
            const $preview = $box.find('.js--image-preview');
            const $uploadField = $box.find('.image-upload');
            const $controls = $box.find('.controls');

            $preview.on('click', function(e) {
                const offset = $preview.offset();
                const x = e.pageX - offset.left;
                const y = e.pageY - offset.top;

                const $drop = $('<span class="drop animate"></span>').css({
                    width: Math.max($preview.width(), $preview.height()),
                    height: Math.max($preview.width(), $preview.height()),
                    top: y - $preview.height() / 2,
                    left: x - $preview.width() / 2
                });

                $preview.append($drop);
                setTimeout(() => $drop.remove(), 600);

                $uploadField.click();
            });

            $uploadField.on('change', function() {
                const file = this.files[0];
                if (!file || !file.type.match(/image.*/)) {
                    alert('Please select a valid image file.');
                    return;
                }

                const reader = new FileReader();
                reader.onload = function() {
                    $preview.css('background-image', 'url(' + reader.result + ')');
                    $preview.addClass('js--no-default');
                    $controls.removeClass('hidden');
                };
                reader.readAsDataURL(file);
            });

            $box.find('.edit-btn').on('click', function(e) {
                e.stopPropagation();
                $uploadField.click();
            });

            $box.find('.delete-btn').on('click', function(e) {
                e.stopPropagation();
                $preview.css('background-image', '');
                $preview.removeClass('js--no-default');
                $uploadField.val('');
                $controls.addClass('hidden');
            });
        });
    });
</script>

