<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Login_model extends CI_Model{
	
  public function __construct(){
		  parent::__construct();  	
 } 

 public function check_admin_login($data){
	 
	 $query = $this->db->get_where('gm_admin_users',$data,1);	

	 if ($query->num_rows() > 0) { 
		 $admin_user = $query->row_array();
		 $sess_arr = array(
            'admin_name' => $admin_user['admin_name'],
            'admin_username' => $admin_user['username'],
            'admin_role_id' => $admin_user['role_id'],
            'admin_id' => $admin_user['admin_id'],
            'admin_logged_in' => TRUE
            );
      

      // After successful login
      $role_id = $admin_user['role_id'];
      if ($role_id == 1) { // Super Admin
          $sess_arr['permissions'] = ['*'];
      } else {
            $permissions = $this->db->select('p.permission_key')
              ->from('gm_admin_role_permissions rp')
              ->join('gm_admin_permissions p', 'p.id = rp.permission_id')
              ->where('rp.role_id', $role_id)
              ->get()->result_array();
          
            $sess_arr['permissions'] = array_column($permissions, 'permission_key');


            // Also fetch role permission last updated time
            $permission_last_updated = $this->db->select('permission_last_updated')
                ->from('gm_admin_roles')
                ->where('id', $role_id)
                ->get()->row('permission_last_updated');

            $sess_arr['permission_last_loaded'] = !empty($permission_last_updated) ? $permission_last_updated : date('Y-m-d H:i:s');
      }

	   $this->session->set_userdata($sess_arr);	  
	 } 
 }
 
}
