<?php
if (!defined('BASEPATH'))
  exit('No direct script access allowed');

class Company_model extends CI_Model {

  public function __construct() {
    parent::__construct();
  }


  public function get_company($get,$count){
    
        if (!empty($get['search'])) {
            $this->db->group_start();
            $this->db->like('company_name', $get['search']);
            $this->db->or_like('username', $get['search']);
            $this->db->group_end();
        }
        
        if (!empty($get['status'])) {
            switch ($get['status']) {
              case 'inactive':
                  $this->db->where('status', '0');
                  break;
              case 'active':
                  $this->db->where('status', '1');
                  break;
              case 'new':
                  $this->db->where('created_at >=', date('Y-m-d 00:00:00'));
                  $this->db->where('created_at <=', date('Y-m-d 23:59:59'));
                  break;
            }
            
        }
    

        if(!empty($count)){
            return $count = $this->db->get('gm_companies')->num_rows();
        }else{
            $offset = !empty($get['offset']) ? $get['offset'] : 0;
            $limit  = !empty($get['limit']) ? $get['limit'] : 25;
    
            $this->db->limit($limit,$offset);
            //$this->db->where('parent_id',$parent_id);
            $this->db->order_by('company_id','DESC');    

            $query = $this->db->get('gm_companies');
            $result = $query->result_array();
            //echo $this->db->last_query();
            return $result;
        }
    }
    
    
    
    
    
    public function get_product($get,$count){
    
        if (!empty($get['search'])) {
            $this->db->group_start();
            $this->db->like('product_name', $get['search']);
            $this->db->or_like('username', $get['search']);
            $this->db->group_end();
        }
        
        if (!empty($get['status'])) {
            switch ($get['status']) {
              case 'inactive':
                  $this->db->where('status', '0');
                  break;
              case 'active':
                  $this->db->where('status', '1');
                  break;
              case 'new':
                  $this->db->where('created_at >=', date('Y-m-d 00:00:00'));
                  $this->db->where('created_at <=', date('Y-m-d 23:59:59'));
                  break;
            }
            
        }
    

        if(!empty($count)){
            return $count = $this->db->get('gm_company_products')->num_rows();
        }else{
            $offset = !empty($get['offset']) ? $get['offset'] : 0;
            $limit  = !empty($get['limit']) ? $get['limit'] : 25;
    
            $this->db->limit($limit,$offset);
            //$this->db->where('parent_id',$parent_id);
            $this->db->order_by('product_id','DESC');    

            $query = $this->db->get('gm_company_products');
            $result = $query->result_array();
            //echo $this->db->last_query();
            return $result;
        }
    }
    
}